#--------------------------------------------------------------------------
# Name         : maketex.mak
# Title        : Makefile to build textures
# Author       : PowerVR
# Created      : 14/01/2005
#
# Copyright    : 2005 by Imagination Technologies.  All rights reserved.
#              : No part of this software, either material or conceptual 
#              : may be copied or distributed, transmitted, transcribed,
#              : stored in a retrieval system or translated into any 
#              : human or computer language in any form by any means,
#              : electronic, mechanical, manual or other-wise, or 
#              : disclosed to third parties without the express written
#              : permission of VideoLogic Limited, Unit 8, HomePark
#              : Industrial Estate, King's Langley, Hertfordshire,
#              : WD4 8LZ, U.K.
#
# Description  : Makefile for demos in the PowerVR SDK
#
# Platform     :
#
# $Revision: 1.4 $
#--------------------------------------------------------------------------

#############################################################################
## Instructions
#############################################################################

TEXTURESPATH = ./../Media

all:	Blob.h Crate.h Floor.h LightSource.h Monster1_Tex.h Monster2_Tex.h

Blob.h: $(TEXTURESPATH)/Blob.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Blob.bmp -a$(TEXTURESPATH)/TBlob.bmp -oBlob.h

Crate.h: $(TEXTURESPATH)/Crate.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Crate.bmp -oCrate.h

Floor.h: $(TEXTURESPATH)/Floor.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Floor.bmp -oFloor.h

LightSource.h: $(TEXTURESPATH)/LightSource.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/LightSource.bmp -oLightSource.h

Monster1_Tex.h: $(TEXTURESPATH)/Monster1_Tex.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Monster1_Tex.bmp -oMonster1_Tex.h
	
Monster2_Tex.h: $(TEXTURESPATH)/Monster2_Tex.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Monster2_Tex.bmp -oMonster2_Tex.h

############################################################################
# End of file (maketex.mak)
############################################################################

