#--------------------------------------------------------------------------
# Name         : maketex.mak
# Title        : Makefile to build textures
# Author       : PowerVR
# Created      : 11/01/2005
#
# Copyright    : 2005 by Imagination Technologies.  All rights reserved.
#              : No part of this software, either material or conceptual 
#              : may be copied or distributed, transmitted, transcribed,
#              : stored in a retrieval system or translated into any 
#              : human or computer language in any form by any means,
#              : electronic, mechanical, manual or other-wise, or 
#              : disclosed to third parties without the express written
#              : permission of VideoLogic Limited, Unit 8, HomePark
#              : Industrial Estate, King's Langley, Hertfordshire,
#              : WD4 8LZ, U.K.
#
# Description  : Makefile for demos in the PowerVR SDK
#
# Platform     :
#
# $Revision: 1.4 $
#--------------------------------------------------------------------------

TEXTURESPATH = ./../Media

#############################################################################
## Instructions
#############################################################################

all:	Flora.h BACK.h REFLECT.h

Flora.h: $(TEXTURESPATH)/Flora.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Flora.bmp -a$(TEXTURESPATH)/TFlora.bmp -oFlora.h

BACK.h: $(TEXTURESPATH)/BACK.bmp
	$(PVRTEXTURETOOLPATH)    -h -fOGLPVRTC4 -i$(TEXTURESPATH)/BACK.bmp -oBACK.h

REFLECT.h: $(TEXTURESPATH)/REFLECT.bmp
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/REFLECT.bmp -oREFLECT.h

############################################################################
# End of file (maketex.mak)
############################################################################


