/**********************************************************
 * This file has been created with PowerVR Exporter v3.4
 * Date: 20 December 2004   Time: 16:25
 * Original File: EvilSkull.max 
 *
 * Options: 
 *
 *   Meshes        = ON
 *   Mesh Anim     = OFF
 *   Materials     = OFF
 *   Cameras       = OFF
 *   Camera Anim   = OFF
 *   Lights        = OFF
 *   Paths         = OFF
 *   Bones         = OFF
 *
 *   UVs           = ON
 *   UVs Layer2    = OFF
 *   Normals       = ON
 *   Colors        = OFF
 *   Materials     = OFF
 *   Weights       = OFF
 *
 *   Strips        = OFF
 *   No Face-list  = OFF
 *   DWORD List    = OFF
 *   Packed Format = OFF
 *   OpenGL Format = ON
 *   Transform UVs = OFF
 *   Vertex Format = FLOAT
 *
 *   Patches       = OFF
 *   PatchTriToQuad= OFF
 *   Patch Mesh    = OFF
 *   Patch UVs     = OFF
 *
 **********************************************************/

#define STRUCT_MESH_DEFINED 

typedef struct { unsigned int      nNumVertex;
                 unsigned int      nNumFaces;
                 unsigned int      nNumStrips;
                 unsigned int      nFlags;
                 int               nMaterial;
                 float             fCenter[3];
                 const float             *pVertex;
                 const float             *pUV;
                 const float             *pNormals;
                 const float             *pPackedVertex;
                 const unsigned int      *pVertexColor;
                 const unsigned int      *pVertexMaterial;
                 const unsigned short    *pFaces;
                 const unsigned short    *pStrips;
                 const unsigned short    *pStripLength;
                 struct
                 {
                     unsigned int  nType;
                     unsigned int  nNumPatches;
                     unsigned int  nNumVertices;
                     unsigned int  nNumSubdivisions;
                     const float         *pControlPoints;
                     const float         *pUVs;
                 } Patch;
               }   Struct_Mesh;


/**********************************************************
 * GENERAL DEFINITIONS
 **********************************************************/

#ifndef _NULL_
#define _NULL_ 0
#endif

#define NUM_MESHES     5
#define NUM_BONES	   0
#define NUM_MATERIALS  3
#define NUM_LIGHTS     5
#define NUM_CAMERAS    0
#define NUM_PATHS      0
#define NUM_FRAMES     0

/* MESH FLAGS */

#ifndef MF_MATERIAL
#define MF_MATERIAL        1
#define MF_UV              2
#define MF_NORMALS         4
#define MF_VERTEXCOLOR     8
#define MF_VERTEXMATERIAL  16
#define MF_STRIPS          32
#define MF_NOFACELIST      64
#define MF_UV2             128
#define MF_VERTEXWEIGHTS   256

#define MF_NOPATCH         0
#define MF_RECTPATCH       1
#define MF_TRIPATCH        2
#define MF_MIXPATCH        3

#endif


/* MESHES */
#define M_SKULL5  0
#define M_SKULL4  1
#define M_SKULL3  2
#define M_SKULL6  3
#define M_JAW  4


/**********************************************************
 * MESHES DATA 
 **********************************************************/

/* MESH 0 */

#define skull5_NumVertex  583
#define skull5_NumFaces   838
#define skull5_NumStrips  0
#define skull5_Flags      0x00020006
#define skull5_Material   0

const float skull5_Vertices[] = {
	1.1343f,-30.7901f,-94.2598f, 1.1343f,21.8917f,-125.2642f, -37.5115f,16.9488f,-113.0247f, -24.9007f,-34.4217f,-92.8906f, -54.0616f,-1.6057f,22.5507f, 
	-51.8914f,6.1041f,27.9485f, -43.4180f,9.3742f,29.0199f, -33.0261f,11.4509f,31.1020f, -15.7797f,2.5378f,37.3405f, -12.6008f,-5.9891f,38.7364f, 
	-23.4113f,-13.7772f,38.4699f, -38.1601f,-16.7290f,32.1672f, -47.0850f,-11.7429f,32.0136f, -89.0574f,9.8441f,-48.7063f, -80.1992f,-3.8524f,-33.7001f, 
	-71.1775f,-13.5720f,-81.4691f, -81.4714f,7.1799f,-82.8180f, -67.0305f,63.5996f,-55.7233f, -37.8220f,77.2215f,-74.6966f, -35.8182f,91.1199f,-48.9701f, 
	-72.0865f,70.1446f,-37.5744f, -67.2641f,72.2029f,32.0752f, -64.3090f,52.6419f,40.8719f, -78.1096f,60.6806f,21.2622f, -69.6216f,75.0868f,9.3506f, 
	1.1343f,98.3649f,47.6322f, -32.0975f,90.6309f,55.4710f, -42.1040f,98.7173f,2.2671f, 1.1343f,107.7151f,2.8619f, 1.1343f,65.9923f,-97.9898f, 
	1.1343f,85.0664f,-81.1924f, -37.8220f,77.2215f,-74.6966f, -39.0053f,60.6855f,-93.5268f, -21.7619f,77.2774f,76.4025f, -17.0668f,74.9641f,82.6531f, 
	-32.4097f,76.6465f,80.0004f, -42.0990f,74.9733f,69.0731f, -67.0305f,63.5996f,-55.7233f, -72.0865f,70.1446f,-37.5744f, -85.5974f,54.0933f,-35.6706f, 
	-76.1383f,48.7393f,-69.5018f, -67.7592f,-8.4485f,39.9768f, -63.9890f,6.1989f,35.0980f, -76.2642f,11.3425f,39.3493f, -90.0673f,-7.2150f,35.9750f, 
	-28.1263f,-65.5598f,91.4285f, -25.1124f,-51.2734f,82.9851f, -13.3134f,-53.3318f,96.1666f, -18.6613f,-66.6641f,101.6294f, -42.4276f,-51.5871f,39.6861f, 
	-39.6505f,-42.8894f,37.4171f, -38.0275f,-29.4774f,44.8425f, -45.2045f,-52.9658f,50.1626f, -59.7753f,-35.7219f,-74.1701f, -70.8900f,-58.3772f,-19.2708f, 
	-54.1131f,-42.2233f,-51.4057f, -59.7753f,-35.7219f,-74.1701f, -54.1131f,-42.2233f,-51.4057f, -26.2543f,-45.8518f,-73.3169f, -35.5628f,-39.5563f,-84.6418f, 
	1.1343f,64.8085f,86.1836f, 1.1343f,45.3262f,83.6355f, -10.8740f,35.3279f,89.5096f, -6.8847f,63.3661f,99.7210f, -63.6290f,22.3134f,36.6756f, 
	-72.1345f,43.3299f,25.7325f, -65.5405f,38.7030f,46.7728f, -77.7922f,31.2452f,45.9582f, -92.0578f,32.7660f,-14.5967f, -84.6590f,8.0952f,-3.8219f, 
	-92.7646f,29.6651f,-47.0791f, -81.4714f,7.1799f,-82.8180f, -40.1868f,46.9405f,-101.9148f, -80.1615f,28.1101f,-76.8757f, -27.3727f,-49.6025f,90.2637f, 
	-15.0253f,-50.9719f,101.6883f, -34.7822f,-21.9903f,36.7793f, -40.5806f,-15.8404f,24.5848f, -65.9947f,-10.2918f,20.9087f, -71.1775f,-13.5720f,-81.4691f, 
	1.1343f,75.7031f,77.9977f, -21.7619f,77.2774f,76.4025f, -61.0570f,66.1071f,44.8394f, -57.1265f,53.9684f,54.7959f, -69.4038f,45.9901f,65.6235f, 
	-81.3628f,-7.6320f,59.4137f, -109.8088f,-3.1584f,64.2786f, -95.5260f,-18.3153f,38.8226f, -37.9636f,-31.8156f,54.6278f, -42.6257f,-55.5465f,56.4448f, 
	1.1343f,1.1288f,87.4279f, -7.8811f,2.6093f,82.0584f, -54.1131f,-42.2233f,-51.4057f, -47.7414f,-40.1763f,-35.5617f, -32.5133f,-45.4468f,-48.0729f, 
	-26.2543f,-45.8518f,-73.3169f, 1.1343f,85.0664f,-81.1924f, 1.1343f,99.4302f,-57.3280f, -57.2440f,83.3396f,41.9862f, -67.0305f,63.5996f,-55.7233f, 
	-76.1383f,48.7393f,-69.5018f, 1.1343f,75.7031f,77.9977f, 1.1343f,72.2418f,84.2629f, -42.6790f,-58.0143f,66.9479f, -28.9589f,-34.8087f,67.6042f, 
	-27.1680f,-37.6551f,75.2861f, -38.8486f,-60.6764f,74.6554f, 1.1343f,-43.8196f,-82.4340f, 1.1343f,-41.2261f,-92.6553f, -30.0814f,38.7662f,96.9566f, 
	-35.8436f,69.8334f,95.0695f, 1.1343f,52.2313f,-108.0717f, -33.9295f,-24.9061f,73.5504f, -22.8551f,-21.7753f,83.9082f, -42.0990f,74.9733f,69.0731f, 
	-82.7815f,60.6186f,-13.2798f, -69.6026f,77.3893f,-16.9735f, 1.1343f,105.6022f,-32.3379f, -33.1795f,99.0184f,-25.4028f, -26.7094f,-26.5276f,-2.3928f, 
	-12.4666f,-44.6201f,-11.7630f, -13.5024f,-46.5521f,-23.3803f, -26.2091f,-45.2005f,-34.7183f, -80.1615f,28.1101f,-76.8757f, -76.6058f,-7.2097f,-27.7628f, 
	-90.6410f,-10.1043f,-35.2520f, -44.8680f,-16.9967f,-2.9177f, -45.9374f,-32.1497f,-20.7396f, -52.9548f,-21.0732f,58.6410f, -81.6324f,-8.5110f,15.3926f, 
	-80.7102f,-23.9795f,12.7626f, -91.4930f,-8.4163f,16.9786f, -94.7005f,-18.1911f,16.3202f, -90.4724f,-29.1118f,41.5922f, -91.0120f,-22.7357f,16.0161f, 
	-78.9952f,-9.8938f,-14.6131f, -77.9740f,-24.0348f,-5.1864f, -88.8461f,-10.1644f,-13.2793f, -90.0884f,-22.8992f,-12.6773f, -84.7937f,-23.5171f,-10.0520f, 
	-60.5570f,-20.1807f,0.4519f, -85.8191f,-27.3248f,-30.2517f, -66.2946f,28.5710f,69.2662f, -74.6978f,3.0425f,54.7269f, -90.4724f,-29.1118f,41.5922f, 
	-69.8780f,-63.2630f,62.3312f, -54.0834f,-41.4268f,59.0155f, -52.9548f,-21.0732f,58.6410f, -81.3628f,-7.6320f,59.4137f, -74.6978f,3.0425f,54.7269f, 
	-80.0861f,-25.6569f,80.2562f, -109.8088f,-3.1584f,64.2786f, -62.1434f,-47.1525f,78.6848f, -69.8780f,-63.2630f,62.3312f, -54.4520f,35.0995f,90.8943f, 
	-57.9479f,57.7572f,89.7469f, -44.6680f,53.2451f,66.8333f, -56.9780f,66.7606f,59.2926f, -7.6730f,-18.6613f,97.1052f, 1.1343f,10.6444f,95.2628f, 
	-66.2946f,28.5710f,69.2662f, -69.4038f,45.9901f,65.6235f, -57.1265f,53.9684f,54.7959f, -61.0570f,66.1071f,44.8394f, -74.6978f,3.0425f,54.7269f, 
	-66.2946f,28.5710f,69.2662f, -61.3949f,20.5710f,64.1408f, -66.1337f,3.7362f,58.8145f, -51.8269f,21.9697f,76.9686f, -27.6437f,20.7403f,83.8778f, 
	-13.1520f,2.8142f,75.0002f, -7.7836f,-7.1775f,72.8556f, -10.2177f,-11.8445f,75.2602f, -38.0093f,-16.6790f,74.7995f, -24.9837f,-14.4131f,79.6246f, 
	-57.4479f,-13.9469f,64.3899f, -64.0909f,25.5293f,40.3366f, -69.2350f,3.7580f,32.7278f, -43.1813f,36.2911f,37.4226f, -25.5434f,33.8247f,42.6603f, 
	-5.5056f,11.9054f,51.6990f, 0.5660f,-7.1433f,45.5062f, -6.7616f,-18.2130f,52.8507f, -6.0089f,-19.6000f,47.9704f, -37.5158f,-25.1147f,47.8828f, 
	-64.8051f,-24.5660f,32.1220f, -4.7648f,-23.8559f,102.6399f, -16.0160f,-47.9987f,89.1131f, -8.9871f,-21.5086f,100.0462f, 1.1343f,-2.5037f,97.7963f, 
	-8.9871f,-21.5086f,100.0462f, 1.1343f,-51.7012f,114.0228f, 1.1343f,-57.5566f,109.9392f, -3.2193f,-55.0928f,107.4433f, -5.0625f,-52.0769f,110.9065f, 
	1.1343f,-70.1007f,114.8412f, -10.1366f,-67.4703f,108.5805f, -3.6791f,-19.9995f,86.3394f, -18.1666f,-51.6814f,79.8907f, -7.2698f,-41.1215f,115.0538f, 
	-11.9860f,-44.8299f,101.0660f, -9.0872f,-48.1650f,100.8100f, 1.1343f,-10.3931f,81.2334f, -3.6791f,-19.9995f,86.3394f, -4.7648f,-23.8559f,102.6399f, 
	1.1343f,-17.5548f,101.2982f, -7.2698f,-41.1215f,115.0538f, 1.1343f,-38.3493f,107.3551f, 1.1343f,-47.4108f,116.2879f, 1.1343f,-37.9871f,102.2451f, 
	1.1343f,-45.1302f,94.8821f, -11.5393f,-55.1710f,72.1315f, -18.1666f,-51.6814f,79.8907f, -9.0872f,-48.1650f,100.8100f, 1.1343f,-48.0521f,102.2165f, 
	-16.0160f,-47.9987f,89.1131f, -11.9860f,-44.8299f,101.0660f, -69.6026f,77.3893f,-16.9735f, -33.0089f,-34.3247f,29.7539f, -31.9712f,-25.9328f,29.8637f, 
	-33.0089f,-34.3247f,29.7539f, -42.4276f,-51.5871f,39.6861f, -30.0517f,-51.9099f,40.7906f, -25.1292f,-37.4772f,31.5808f, -19.6647f,-38.4533f,44.8827f, 
	-17.1778f,-23.2891f,36.5290f, -47.7414f,-40.1763f,-35.5617f, -68.4473f,-18.3408f,-23.6385f, -52.9278f,-18.6324f,-1.1867f, -44.8680f,-16.9967f,-2.9177f, 
	-45.9374f,-32.1497f,-20.7396f, -63.5205f,-21.8504f,-16.3413f, -24.2735f,-27.3208f,14.0616f, -10.1609f,-16.1620f,-1.3086f, -31.0199f,-27.5091f,16.1312f, 
	-38.5070f,-25.6792f,17.8935f, -31.0199f,-27.5091f,16.1312f, 1.1343f,-45.1725f,44.8123f, 1.1343f,-16.3926f,27.9097f, 1.1343f,-12.6555f,-0.9586f, 
	1.1343f,-49.4843f,-15.2004f, 1.1343f,-47.8435f,-21.7449f, -62.1434f,-47.1525f,78.6848f, -28.9589f,-34.8087f,67.6042f, -42.6790f,-58.0143f,66.9479f, 
	-85.8191f,-27.3248f,-30.2517f, -90.0884f,-22.8992f,-12.6773f, -84.7937f,-23.5171f,-10.0520f, -77.9740f,-24.0348f,-5.1864f, -60.5570f,-20.1807f,0.4519f, 
	-51.5430f,-13.6912f,13.2625f, -12.0252f,-66.6640f,91.3652f, -22.2940f,-65.0439f,86.6587f, -32.5740f,-52.9658f,50.1626f, -30.0517f,-51.9099f,40.7906f, 
	-29.5907f,-55.5465f,53.4875f, -28.8553f,-60.6764f,71.5251f, -31.4190f,-58.0143f,66.9479f, 1.1343f,-70.1006f,104.1901f, -5.7069f,-67.4702f,101.2010f, 
	-19.1253f,-55.6845f,86.6586f, -12.7726f,-57.2462f,91.3652f, 1.1343f,-43.8447f,91.3652f, 1.1343f,-40.3075f,86.6586f, -19.2517f,-41.3275f,48.7581f, 
	-19.6647f,-38.4533f,44.8827f, -25.6259f,-40.9078f,58.2470f, -24.7086f,-48.4506f,71.5251f, 1.1343f,-34.2192f,71.5251f, 1.1343f,-30.0952f,61.1721f, 
	1.1343f,-51.2723f,101.2010f, -3.5040f,-62.2400f,101.2010f, 1.1343f,-63.5038f,103.2178f, 1.1343f,-40.9517f,51.2569f, -19.6647f,-38.4533f,44.8827f, 
	-25.6259f,-40.9078f,58.2470f, -25.6259f,-40.9078f,58.2470f, -31.4190f,-58.0143f,66.9479f, -29.5907f,-55.5465f,53.4875f, -23.1541f,-44.5665f,-37.7426f, 
	-28.0091f,-44.8941f,-48.7063f, -12.5280f,-45.8573f,-27.6713f, -18.2308f,-45.3863f,-70.0129f, 1.1343f,-44.3998f,-77.1960f, 1.1343f,-43.8196f,-82.4340f, 
	-26.2543f,-45.8518f,-73.3169f, 1.1343f,-47.4886f,-27.0898f, -12.5280f,-45.8573f,-27.6713f, -23.2662f,-49.4382f,-37.8028f, -28.1213f,-51.0347f,-48.7665f, 
	-12.6401f,-50.1544f,-27.7315f, 1.1343f,-53.2475f,-27.1500f, -18.3429f,-50.7612f,-70.0731f, 1.1343f,-49.4528f,-77.2562f, -56.9780f,66.7606f,59.2926f, 
	-67.2641f,72.2029f,32.0752f, -61.0570f,66.1071f,44.8394f, -69.6216f,75.0868f,9.3506f, 27.1693f,-34.4217f,-92.8906f, 39.7801f,16.9488f,-113.0248f, 
	56.3302f,-1.6057f,22.5508f, 49.3536f,-11.7429f,32.0136f, 40.4287f,-16.7290f,32.1672f, 25.6799f,-13.7772f,38.4699f, 14.8694f,-5.9891f,38.7364f, 
	18.0483f,2.5378f,37.3405f, 35.2948f,11.4509f,31.1021f, 45.6866f,9.3742f,29.0199f, 54.1600f,6.1041f,27.9485f, 91.3260f,9.8441f,-48.7063f, 
	83.7400f,7.1798f,-82.8180f, 73.4461f,-13.5720f,-81.4691f, 82.4678f,-3.8524f,-33.7001f, 69.2991f,63.5996f,-55.7233f, 74.3551f,70.1446f,-37.5744f, 
	38.0869f,91.1199f,-48.9701f, 40.0906f,77.2215f,-74.6966f, 69.5328f,72.2029f,32.0752f, 71.8902f,75.0868f,9.3506f, 80.3782f,60.6806f,21.2622f, 
	66.5776f,52.6419f,40.8719f, 44.3726f,98.7173f,2.2671f, 34.3661f,90.6309f,55.4710f, 41.2739f,60.6855f,-93.5268f, 40.0906f,77.2215f,-74.6966f, 
	24.0305f,77.2774f,76.4025f, 44.3676f,74.9733f,69.0731f, 34.6783f,76.6465f,80.0004f, 19.3354f,74.9641f,82.6531f, 69.2991f,63.5996f,-55.7233f, 
	78.4069f,48.7393f,-69.5019f, 87.8660f,54.0933f,-35.6706f, 74.3551f,70.1446f,-37.5744f, 70.0278f,-8.4485f,39.9768f, 92.3359f,-7.2150f,35.9750f, 
	78.5328f,11.3425f,39.3493f, 66.2577f,6.1989f,35.0980f, 30.3949f,-65.5598f,91.4286f, 20.9299f,-66.6641f,101.6295f, 15.5820f,-53.3318f,96.1666f, 
	27.3810f,-51.2734f,82.9852f, 44.6962f,-51.5871f,39.6861f, 47.4731f,-52.9658f,50.1626f, 40.2961f,-29.4775f,44.8425f, 41.9191f,-42.8894f,37.4171f, 
	62.0439f,-35.7219f,-74.1701f, 56.3817f,-42.2233f,-51.4057f, 73.1586f,-58.3773f,-19.2708f, 62.0439f,-35.7219f,-74.1701f, 37.8314f,-39.5563f,-84.6418f, 
	28.5229f,-28.1305f,-73.3169f, 56.3817f,-42.2233f,-51.4057f, 9.1533f,63.3661f,99.7210f, 13.1426f,35.3279f,89.5096f, 65.8976f,22.3134f,36.6756f, 
	80.0608f,31.2452f,45.9582f, 67.8092f,38.7030f,46.7728f, 74.4031f,43.3299f,25.7325f, 94.3265f,32.7660f,-14.5967f, 95.0332f,29.6651f,-47.0791f, 
	86.9276f,8.0952f,-3.8219f, 83.7400f,7.1798f,-82.8180f, 82.4302f,28.1101f,-76.8757f, 42.4554f,46.9405f,-101.9148f, 17.2940f,-50.9719f,101.6883f, 
	29.6413f,-49.6025f,90.2637f, 68.2633f,-10.2918f,20.9087f, 42.8492f,-15.8404f,24.5848f, 37.0508f,-21.9903f,36.7794f, 73.4461f,-13.5720f,-81.4691f, 
	24.0305f,77.2774f,76.4025f, 63.3256f,66.1071f,44.8394f, 69.5328f,72.2029f,32.0752f, 66.5776f,52.6419f,40.8719f, 59.3951f,53.9684f,54.7959f, 
	71.6724f,45.9901f,65.6235f, 83.6314f,-7.6320f,59.4137f, 97.7947f,-18.3153f,38.8226f, 112.0774f,-3.1584f,64.2786f, 40.2323f,-31.8156f,54.6278f, 
	44.8944f,-55.5465f,56.4448f, 10.1498f,2.6093f,82.0584f, 56.3817f,-42.2233f,-51.4057f, 28.5229f,-28.1305f,-73.3169f, 34.7819f,-45.4468f,-48.0729f, 
	50.0100f,-40.1763f,-35.5617f, 59.5126f,83.3396f,41.9862f, 69.2991f,63.5996f,-55.7233f, 78.4069f,48.7393f,-69.5019f, 44.9476f,-58.0143f,66.9479f, 
	41.1172f,-60.6764f,74.6554f, 29.4366f,-37.6551f,75.2862f, 31.2275f,-34.8087f,67.6042f, 32.3500f,38.7662f,96.9566f, 38.1122f,69.8334f,95.0695f, 
	25.1237f,-21.7753f,83.9082f, 36.1981f,-24.9061f,73.5504f, 44.3676f,74.9733f,69.0731f, 74.4031f,43.3299f,25.7325f, 67.8092f,38.7030f,46.7728f, 
	85.0501f,60.6186f,-13.2798f, 70.0278f,-8.4485f,39.9768f, 66.2577f,6.1989f,35.0980f, 86.9276f,8.0952f,-3.8219f, 65.8976f,22.3134f,36.6756f, 
	71.8712f,77.3893f,-16.9735f, 35.4481f,99.0184f,-25.4028f, 28.9780f,-26.5276f,-2.3928f, 28.4777f,-45.2005f,-34.7183f, 15.7710f,-46.5521f,-23.3803f, 
	14.7352f,-44.6201f,-11.7630f, 68.2633f,-10.2918f,20.9087f, 82.4302f,28.1101f,-76.8757f, 92.9096f,-10.1043f,-35.2520f, 78.8744f,-7.2097f,-27.7628f, 
	62.0439f,-35.7219f,-74.1701f, 47.1366f,-16.9968f,-2.9177f, 48.2060f,-32.1497f,-20.7396f, 55.2234f,-21.0732f,58.6411f, 82.9788f,-23.9795f,12.7626f, 
	83.9011f,-8.5110f,15.3926f, 93.7616f,-8.4163f,16.9786f, 96.9691f,-18.1911f,16.3202f, 92.7410f,-29.1118f,41.5922f, 93.2806f,-22.7357f,16.0161f, 
	80.2426f,-24.0348f,-5.1864f, 81.2638f,-9.8938f,-14.6131f, 91.1148f,-10.1644f,-13.2793f, 92.3571f,-22.8992f,-12.6773f, 87.0623f,-23.5171f,-10.0520f, 
	62.8256f,-20.1807f,0.4519f, 88.0877f,-27.3248f,-30.2517f, 80.0608f,31.2452f,45.9582f, 76.9664f,3.0425f,54.7270f, 68.5632f,28.5710f,69.2662f, 
	92.7410f,-29.1118f,41.5922f, 55.2234f,-21.0732f,58.6411f, 56.3520f,-41.4268f,59.0155f, 72.1467f,-63.2630f,62.3312f, 83.6314f,-7.6320f,59.4137f, 
	112.0774f,-3.1584f,64.2786f, 82.3547f,-25.6569f,80.2563f, 76.9664f,3.0425f,54.7270f, 31.2275f,-34.8087f,67.6042f, 36.1981f,-24.9061f,73.5504f, 
	64.4120f,-47.1525f,78.6848f, 72.1467f,-63.2630f,62.3312f, 92.7410f,-29.1118f,41.5922f, 72.1467f,-63.2630f,62.3312f, 60.2165f,57.7572f,89.7470f, 
	56.7206f,35.0995f,90.8943f, 46.9366f,53.2451f,66.8334f, 59.2466f,66.7606f,59.2926f, 9.9417f,-18.6613f,97.1052f, 68.5632f,28.5710f,69.2662f, 
	71.6724f,45.9901f,65.6235f, 59.3951f,53.9684f,54.7959f, 63.3256f,66.1071f,44.8394f, 71.6724f,45.9901f,65.6235f, 76.9664f,3.0425f,54.7270f, 
	68.4023f,3.7362f,58.8145f, 63.6635f,20.5710f,64.1408f, 68.5632f,28.5710f,69.2662f, 54.0955f,21.9697f,76.9686f, 29.9123f,20.7403f,83.8778f, 
	15.4206f,2.8142f,75.0002f, 10.0522f,-7.1775f,72.8556f, 12.4863f,-11.8445f,75.2602f, 27.2523f,-14.4131f,79.6246f, 40.2779f,-16.6790f,74.7995f, 
	59.7165f,-13.9469f,64.3899f, 82.3547f,-25.6569f,80.2563f, 71.5036f,3.7580f,32.7278f, 66.3595f,25.5293f,40.3366f, 45.4499f,36.2911f,37.4226f, 
	27.8120f,33.8247f,42.6603f, 7.7742f,11.9054f,51.6990f, 1.7026f,-7.1433f,45.5062f, 8.2775f,-19.6000f,47.9704f, 9.0302f,-18.2130f,52.8507f, 
	39.7844f,-25.1147f,47.8828f, 67.0737f,-24.5661f,32.1220f, 59.7165f,-13.9469f,64.3899f, 67.0737f,-24.5661f,32.1220f, 71.5036f,3.7580f,32.7278f, 
	68.4023f,3.7362f,58.8145f, 7.0334f,-23.8559f,102.6399f, 11.2557f,-21.5086f,100.0463f, 18.2846f,-47.9988f,89.1131f, 11.2557f,-21.5086f,100.0463f, 
	7.3311f,-52.0769f,110.9066f, 5.4879f,-55.0928f,107.4433f, 12.4052f,-67.4703f,108.5805f, 20.4352f,-51.6814f,79.8907f, 5.9477f,-19.9995f,86.3394f, 
	9.5384f,-41.1215f,115.0538f, 11.3558f,-48.1650f,100.8100f, 14.2546f,-44.8299f,101.0660f, 7.0334f,-23.8559f,102.6399f, 5.9477f,-19.9995f,86.3394f, 
	9.5384f,-41.1215f,115.0538f, 13.8079f,-55.1710f,72.1316f, 20.4352f,-51.6814f,79.8907f, 11.3558f,-48.1650f,100.8100f, 18.2846f,-47.9988f,89.1131f, 
	14.2546f,-44.8299f,101.0660f, 35.4481f,99.0184f,-25.4028f, 38.0869f,91.1199f,-48.9701f, 74.3551f,70.1446f,-37.5744f, 71.8712f,77.3893f,-16.9735f, 
	34.2398f,-25.9328f,29.8637f, 35.2775f,-34.3247f,29.7539f, 35.2775f,-34.3247f,29.7539f, 27.3978f,-37.4772f,31.5808f, 32.3203f,-51.9099f,40.7906f, 
	44.6962f,-51.5871f,39.6861f, 19.4464f,-23.2891f,36.5291f, 21.9333f,-38.4534f,44.8827f, 50.0100f,-40.1763f,-35.5617f, 70.7160f,-18.3408f,-23.6385f, 
	73.1586f,-58.3773f,-19.2708f, 56.3817f,-42.2233f,-51.4057f, 55.1964f,-18.6324f,-1.1866f, 65.7891f,-21.8504f,-16.3413f, 48.2060f,-32.1497f,-20.7396f, 
	47.1366f,-16.9968f,-2.9177f, 12.4295f,-16.1620f,-1.3086f, 26.5421f,-27.3208f,14.0616f, 33.2885f,-27.5091f,16.1312f, 33.2885f,-27.5091f,16.1312f, 
	40.7756f,-25.6793f,17.8935f, 56.3520f,-41.4268f,59.0155f, 64.4120f,-47.1525f,78.6848f, 31.2275f,-34.8087f,67.6042f, 64.4120f,-47.1525f,78.6848f, 
	44.9476f,-58.0143f,66.9479f, 48.2060f,-32.1497f,-20.7396f, 65.7891f,-21.8504f,-16.3413f, 88.0877f,-27.3248f,-30.2517f, 87.0623f,-23.5171f,-10.0520f, 
	92.3571f,-22.8992f,-12.6773f, 80.2426f,-24.0348f,-5.1864f, 62.8256f,-20.1807f,0.4519f, 80.2426f,-24.0348f,-5.1864f, 53.8117f,-13.6912f,13.2625f, 
	82.4678f,-3.8524f,-33.7001f, 78.8744f,-7.2097f,-27.7628f, 14.2938f,-66.6640f,91.3652f, 24.5626f,-65.0439f,86.6587f, 34.8426f,-52.9658f,50.1626f, 
	32.3203f,-51.9099f,40.7906f, 31.8593f,-55.5465f,53.4875f, 31.1240f,-60.6764f,71.5251f, 33.6876f,-58.0143f,66.9479f, 7.9755f,-67.4702f,101.2011f, 
	21.3939f,-55.6845f,86.6586f, 15.0413f,-57.2462f,91.3652f, 21.5203f,-41.3275f,48.7581f, 21.9333f,-38.4534f,44.8827f, 27.8946f,-40.9078f,58.2470f, 
	26.9772f,-48.4506f,71.5251f, 5.7726f,-62.2400f,101.2011f, 21.9333f,-38.4534f,44.8827f, 27.8946f,-40.9078f,58.2470f, 27.8946f,-40.9078f,58.2470f, 
	33.6876f,-58.0143f,66.9479f, 31.8593f,-55.5465f,53.4875f, 25.4227f,-44.5665f,-37.7426f, 30.2777f,-44.8941f,-48.7063f, 14.7966f,-45.8573f,-27.6713f, 
	20.4994f,-45.1763f,-70.0129f, 28.5229f,-28.1305f,-73.3169f, 14.7966f,-45.8573f,-27.6713f, 25.5349f,-49.4382f,-37.8028f, 30.3899f,-51.0348f,-48.7665f, 
	14.9088f,-50.1544f,-27.7315f, 20.6115f,-50.7613f,-70.0731f, 59.2466f,66.7606f,59.2926f, 69.5328f,72.2029f,32.0752f, 63.3256f,66.1071f,44.8394f, 
	71.8902f,75.0868f,9.3506f, 44.3726f,98.7173f,2.2671f, 71.8902f,75.0868f,9.3506f, 
_NULL_ }; /* End of skull5_Vertices */

const float skull5_UV[] = {
	0.8949f,0.4083f,0.9280f,0.3763f,0.8937f,0.4073f,0.8660f,0.4221f,0.8707f,0.6458f,0.8772f,0.6509f,0.8850f,0.6550f,0.8938f,0.6620f,0.9025f,0.6870f,0.8998f,0.6982f,0.8847f,0.6970f,0.8707f,0.6791f,0.8682f,0.6697f,0.8584f,0.5196f,0.8542f,0.5463f,
	0.8521f,0.4636f,0.8606f,0.4653f,0.8977f,0.5078f,0.9203f,0.4809f,0.9260f,0.5167f,0.8976f,0.5319f,0.9011f,0.6205f,0.8945f,0.6399f,0.8904f,0.6087f,0.9009f,0.5917f,0.9515f,0.6421f,0.9281f,0.6481f,0.9246f,0.5810f,0.9534f,0.5843f,0.9436f,0.4413f,
	0.9485f,0.4706f,0.9203f,0.4809f,0.9135f,0.4514f,0.9307f,0.6806f,0.9331f,0.6898f,0.9235f,0.6816f,0.9168f,0.6681f,0.8977f,0.5078f,0.8976f,0.5319f,0.8836f,0.5350f,0.8861f,0.4882f,0.8577f,0.6662f,0.8697f,0.6545f,0.8659f,0.6515f,0.8471f,0.6476f,
	0.8293f,0.7999f,0.8485f,0.7844f,0.8564f,0.8123f,0.8349f,0.8216f,0.8360f,0.7098f,0.8466f,0.7035f,0.8602f,0.7069f,0.8328f,0.7231f,0.8408f,0.4734f,0.8146f,0.5855f,0.8382f,0.5216f,0.8408f,0.4734f,0.8382f,0.5216f,0.8535f,0.4683f,0.8528f,0.4440f,
	0.9433f,0.7055f,0.9372f,0.7179f,0.9235f,0.7276f,0.9368f,0.7178f,0.8796f,0.6490f,0.8857f,0.6224f,0.8872f,0.6530f,0.8764f,0.6503f,0.8699f,0.5662f,0.8596f,0.5893f,0.8679f,0.5206f,0.8606f,0.4653f,0.9069f,0.4358f,0.8735f,0.4764f,0.8486f,0.7883f,
	0.8575f,0.8135f,0.8690f,0.6923f,0.8696f,0.6650f,0.8574f,0.6409f,0.8521f,0.4636f,0.9462f,0.6893f,0.9307f,0.6806f,0.9021f,0.6397f,0.8993f,0.6582f,0.8885f,0.6695f,0.8510f,0.6823f,0.8411f,0.6694f,0.8370f,0.6523f,0.8582f,0.7223f,0.8316f,0.7360f,
	0.9175f,0.7621f,0.9097f,0.7495f,0.8382f,0.5216f,0.8439f,0.5575f,0.8491f,0.5334f,0.8535f,0.4683f,0.9485f,0.4706f,0.9517f,0.5055f,0.9109f,0.6301f,0.8977f,0.5078f,0.8861f,0.4882f,0.9462f,0.6893f,0.9453f,0.6982f,0.8289f,0.7510f,0.8623f,0.7496f,
	0.8611f,0.7628f,0.8282f,0.7662f,0.8823f,0.4345f,0.8850f,0.4061f,0.9103f,0.7242f,0.9189f,0.6995f,0.9395f,0.4208f,0.8672f,0.7446f,0.8789f,0.7630f,0.9168f,0.6681f,0.8880f,0.5641f,0.9018f,0.5581f,0.9530f,0.5391f,0.9299f,0.5471f,0.8716f,0.6326f,
	0.8670f,0.6343f,0.8639f,0.6058f,0.8542f,0.5691f,0.8735f,0.4764f,0.8537f,0.5575f,0.8448f,0.5426f,0.8657f,0.6161f,0.8524f,0.5873f,0.8571f,0.7081f,0.8503f,0.6239f,0.8395f,0.6258f,0.8456f,0.6215f,0.8374f,0.6220f,0.8312f,0.6629f,0.8358f,0.6248f,
	0.8506f,0.5791f,0.8408f,0.5987f,0.8456f,0.5781f,0.8360f,0.5814f,0.8380f,0.5877f,0.8532f,0.6152f,0.8346f,0.5543f,0.8815f,0.6839f,0.8616f,0.6755f,0.8312f,0.6629f,0.8102f,0.7195f,0.8389f,0.7198f,0.8571f,0.7081f,0.8510f,0.6823f,0.8616f,0.6755f,
	0.8386f,0.7156f,0.8411f,0.6694f,0.8292f,0.7393f,0.8102f,0.7195f,0.8921f,0.7090f,0.9005f,0.6932f,0.9067f,0.6769f,0.9048f,0.6570f,0.8955f,0.7858f,0.9227f,0.7609f,0.8815f,0.6839f,0.8885f,0.6695f,0.8993f,0.6582f,0.9021f,0.6397f,0.8616f,0.6755f,
	0.8815f,0.6839f,0.8800f,0.6850f,0.8669f,0.6852f,0.8868f,0.7038f,0.9032f,0.7251f,0.9050f,0.7381f,0.9036f,0.7483f,0.8980f,0.7540f,0.8709f,0.7366f,0.8829f,0.7503f,0.8598f,0.7077f,0.8811f,0.6519f,0.8651f,0.6497f,0.9000f,0.6515f,0.9114f,0.6670f,
	0.9171f,0.7050f,0.9120f,0.7177f,0.8967f,0.7342f,0.8964f,0.7293f,0.8644f,0.7086f,0.8473f,0.6649f,0.8943f,0.7984f,0.8600f,0.7978f,0.8919f,0.7904f,0.9154f,0.7764f,0.8919f,0.7904f,0.8734f,0.8411f,0.8662f,0.8436f,0.8644f,0.8346f,0.8661f,0.8327f,
	0.8484f,0.8587f,0.8410f,0.8383f,0.8985f,0.7792f,0.8539f,0.7890f,0.8759f,0.8237f,0.8672f,0.8106f,0.8664f,0.8164f,0.9104f,0.7671f,0.8985f,0.7792f,0.8943f,0.7984f,0.9055f,0.7951f,0.8759f,0.8237f,0.8878f,0.8222f,0.8784f,0.8386f,0.8882f,0.8174f,
	0.8809f,0.8183f,0.8558f,0.7910f,0.8539f,0.7890f,0.8664f,0.8164f,0.8776f,0.8278f,0.8600f,0.7978f,0.8672f,0.8106f,0.9018f,0.5581f,0.8596f,0.6915f,0.8679f,0.6865f,0.8596f,0.6915f,0.8360f,0.7098f,0.8440f,0.7247f,0.8629f,0.7039f,0.8666f,0.7308f,
	0.8827f,0.7068f,0.8439f,0.5575f,0.8501f,0.5692f,0.8591f,0.6157f,0.8657f,0.6161f,0.8524f,0.5873f,0.8502f,0.5849f,0.8730f,0.6664f,0.8949f,0.6379f,0.8673f,0.6651f,0.8632f,0.6615f,0.8673f,0.6651f,0.8808f,0.7590f,0.9063f,0.6998f,0.9089f,0.6421f,
	0.8760f,0.6410f,0.8779f,0.6217f,0.8292f,0.7393f,0.8623f,0.7496f,0.8289f,0.7510f,0.8346f,0.5543f,0.8360f,0.5814f,0.8380f,0.5877f,0.8408f,0.5987f,0.8532f,0.6152f,0.8637f,0.6387f,0.8404f,0.8204f,0.8342f,0.8018f,0.8411f,0.7366f,0.8440f,0.7247f,
	0.8403f,0.7464f,0.8348f,0.7741f,0.8362f,0.7637f,0.8484f,0.8508f,0.8452f,0.8377f,0.8484f,0.7984f,0.8521f,0.8117f,0.8822f,0.8136f,0.8859f,0.8051f,0.8641f,0.7394f,0.8666f,0.7308f,0.8591f,0.7458f,0.8520f,0.7696f,0.8918f,0.7819f,0.8955f,0.7645f,
	0.8739f,0.8303f,0.8548f,0.8358f,0.8581f,0.8440f,0.8852f,0.7635f,0.8666f,0.7308f,0.8591f,0.7458f,0.8591f,0.7458f,0.8362f,0.7637f,0.8403f,0.7464f,0.8574f,0.5624f,0.8531f,0.5327f,0.8656f,0.5948f,0.8608f,0.4758f,0.8817f,0.4502f,0.8823f,0.4345f,
	0.8535f,0.4683f,0.8783f,0.6063f,0.8656f,0.5948f,0.8521f,0.5638f,0.8465f,0.5335f,0.8607f,0.5969f,0.8716f,0.6103f,0.8548f,0.4749f,0.8761f,0.4482f,0.9048f,0.6570f,0.9011f,0.6205f,0.9021f,0.6397f,0.9009f,0.5917f,0.9260f,0.3970f,0.9658f,0.3864f,
	0.9823f,0.6970f,0.9705f,0.7257f,0.9559f,0.7301f,0.9371f,0.7294f,0.9282f,0.7146f,0.9362f,0.7047f,0.9592f,0.6916f,0.9708f,0.6931f,0.9806f,0.6966f,0.0269f,0.5307f,0.0181f,0.4464f,0.0061f,0.4397f,0.0180f,0.5746f,0.9999f,0.5097f,1.0042f,0.5398f,
	0.9764f,0.5185f,0.9764f,0.4785f,0.0001f,0.6448f,0.0020f,0.6113f,0.0097f,0.6371f,-0.0026f,0.6712f,0.9817f,0.5900f,0.9736f,0.6601f,0.9752f,0.4441f,0.9764f,0.4785f,0.9638f,0.6911f,0.9795f,0.6874f,0.9720f,0.6970f,0.9597f,0.6986f,-0.0001f,0.5097f,
	0.0086f,0.4844f,0.0169f,0.5466f,0.0042f,0.5398f,0.0009f,0.7366f,0.0323f,0.7252f,0.0112f,0.7094f,-0.0040f,0.7093f,0.8991f,0.8704f,0.8805f,0.8691f,0.8903f,0.8430f,0.9112f,0.8399f,0.9438f,0.8040f,0.9487f,0.8231f,0.9498f,0.7696f,0.9446f,0.7821f,
	0.9859f,0.4512f,0.9731f,0.5404f,1.0099f,0.6936f,0.9859f,0.4512f,0.9395f,0.4148f,0.9325f,0.4617f,0.9731f,0.5404f,0.9491f,0.7224f,0.9442f,0.7367f,0.9960f,0.6933f,1.0113f,0.6973f,0.9984f,0.6916f,1.0049f,0.6569f,0.0260f,0.5940f,0.0272f,0.5300f,
	0.0219f,0.6344f,1.0181f,0.4464f,1.0141f,0.4665f,0.9743f,0.4244f,0.8955f,0.8464f,0.9168f,0.8460f,0.9983f,0.7066f,0.9598f,0.7165f,0.9486f,0.7439f,1.0061f,0.4397f,0.9638f,0.6911f,0.9948f,0.6659f,1.0001f,0.6448f,0.9974f,0.6712f,0.9908f,0.6882f,
	1.0022f,0.7090f,0.0203f,0.7620f,0.0439f,0.7436f,0.0563f,0.7532f,0.9484f,0.7872f,0.9410f,0.8339f,0.9276f,0.7596f,0.9731f,0.5404f,0.9325f,0.4617f,0.9297f,0.5515f,0.9614f,0.5981f,0.9922f,0.6503f,0.9999f,0.5097f,1.0086f,0.4844f,0.9390f,0.8499f,
	0.9277f,0.8590f,0.9270f,0.8140f,0.9320f,0.8025f,0.9632f,0.7466f,0.9738f,0.7183f,0.9318f,0.7986f,0.9458f,0.7977f,0.9795f,0.6874f,0.0049f,0.6569f,-0.0016f,0.6916f,0.0139f,0.5830f,1.0009f,0.7366f,0.9960f,0.7093f,1.0219f,0.6344f,-0.0040f,0.6933f,
	0.0020f,0.5708f,0.9754f,0.5514f,0.9342f,0.6686f,0.9191f,0.5975f,0.8982f,0.6271f,0.8987f,0.6572f,-0.0017f,0.7066f,0.0141f,0.4665f,0.0339f,0.5733f,0.0135f,0.5927f,-0.0141f,0.4512f,0.9657f,0.6627f,0.9617f,0.6360f,-0.0230f,0.7810f,0.0227f,0.7098f,
	0.0208f,0.6923f,0.0346f,0.6930f,0.0426f,0.7038f,0.0406f,0.7669f,0.0388f,0.7113f,0.0182f,0.6695f,0.0173f,0.6284f,0.0314f,0.6304f,0.0374f,0.6460f,0.0292f,0.6551f,-0.0106f,0.6780f,0.0321f,0.6023f,0.0113f,0.6973f,0.0099f,0.7421f,-0.0009f,0.7309f,
	1.0406f,0.7669f,0.9770f,0.7810f,0.9733f,0.8163f,1.0079f,0.8658f,0.0203f,0.7620f,0.0563f,0.7532f,0.0220f,0.8136f,0.0099f,0.7421f,-0.0680f,0.8025f,-0.0542f,0.7977f,-0.0111f,0.8494f,0.0079f,0.8658f,0.0406f,0.7669f,0.0079f,0.8658f,0.9917f,0.7252f,
	0.9869f,0.7479f,0.9793f,0.7026f,0.9913f,0.6833f,0.9146f,0.7984f,0.9991f,0.7309f,1.0022f,0.7090f,0.9908f,0.6882f,0.9948f,0.6659f,0.0022f,0.7090f,1.0099f,0.7421f,0.9987f,0.7470f,0.9934f,0.7333f,0.9991f,0.7309f,0.9827f,0.7464f,0.9561f,0.7503f,
	0.9334f,0.7540f,0.9221f,0.7596f,0.9221f,0.7692f,0.9388f,0.7857f,0.9557f,0.7893f,0.9853f,0.7783f,1.0220f,0.8136f,1.0027f,0.7085f,0.9966f,0.6954f,0.9756f,0.6789f,0.9576f,0.6852f,0.9298f,0.7114f,0.9131f,0.7184f,0.9120f,0.7400f,0.9138f,0.7458f,
	0.9512f,0.7670f,0.9961f,0.7488f,-0.0147f,0.7783f,-0.0039f,0.7488f,0.0027f,0.7085f,-0.0013f,0.7470f,0.9074f,0.8073f,0.9141f,0.8052f,0.9003f,0.8328f,0.9141f,0.8052f,0.8805f,0.8452f,0.8745f,0.8438f,0.8664f,0.8652f,0.8995f,0.8309f,0.9090f,0.7863f,
	0.8953f,0.8386f,0.8903f,0.8367f,0.8979f,0.8357f,0.9074f,0.8073f,0.9090f,0.7863f,0.8953f,0.8386f,0.8855f,0.8205f,0.8995f,0.8309f,0.8903f,0.8367f,0.9003f,0.8328f,0.8979f,0.8357f,-0.0246f,0.5514f,-0.0236f,0.5185f,0.0042f,0.5398f,0.0020f,0.5708f,
	0.9423f,0.7366f,0.9388f,0.7502f,0.9388f,0.7502f,0.9240f,0.7526f,0.9193f,0.7956f,0.9438f,0.8040f,0.9232f,0.7348f,0.9149f,0.7707f,-0.0386f,0.5981f,0.0021f,0.6143f,0.0099f,0.6936f,-0.0269f,0.5404f,0.9775f,0.6709f,0.9941f,0.6383f,0.9617f,0.6360f,
	0.9657f,0.6627f,0.9192f,0.6505f,0.9302f,0.7042f,0.9399f,0.7128f,0.9399f,0.7128f,0.9524f,0.7175f,-0.0267f,0.8163f,-0.0111f,0.8494f,0.9320f,0.8025f,0.9889f,0.8494f,0.9390f,0.8499f,-0.0383f,0.6360f,-0.0059f,0.6383f,0.0321f,0.6023f,0.0292f,0.6551f,
	0.0374f,0.6460f,0.0182f,0.6695f,0.9894f,0.6780f,1.0182f,0.6695f,0.9765f,0.6950f,1.0180f,0.5746f,1.0135f,0.5927f,0.8703f,0.8534f,0.8891f,0.8595f,0.9229f,0.8130f,0.9193f,0.7956f,0.9146f,0.8189f,0.9071f,0.8466f,0.9153f,0.8403f,0.8605f,0.8545f,
	0.8963f,0.8436f,0.8846f,0.8431f,0.9117f,0.7802f,0.9149f,0.7707f,0.9219f,0.7978f,0.9135f,0.8239f,0.8654f,0.8465f,0.9149f,0.7707f,0.9219f,0.7978f,0.9219f,0.7978f,0.9153f,0.8403f,0.9146f,0.8189f,0.9147f,0.5850f,0.9224f,0.5476f,0.8975f,0.6127f,
	0.9065f,0.4687f,0.9325f,0.4617f,0.8975f,0.6127f,0.9101f,0.5889f,0.9167f,0.5507f,0.8930f,0.6166f,0.9008f,0.4667f,0.9913f,0.6833f,1.0001f,0.6448f,0.9948f,0.6659f,1.0020f,0.6113f,-0.0183f,0.5900f,0.0020f,0.6113f,
_NULL_ }; /* End of skull5_UV */

const float skull5_Normals[] = {
	-0.0000f,-0.3010f,-0.9536f, -0.0000f,0.0264f,-0.9997f, -0.3854f,-0.0590f,-0.9209f, -0.2043f,-0.5099f,-0.8356f, -0.1815f,-0.0211f,0.9832f, 0.1282f,-0.5928f,0.7951f, -0.2526f,-0.2288f,0.9401f, -0.2328f,0.2136f,0.9488f, -0.2743f,0.1356f,0.9520f, -0.1109f,0.1202f,0.9865f, -0.3319f,0.1957f,0.9228f, -0.2985f,0.2686f,0.9159f, 0.4142f,0.7569f,0.5055f, -0.9334f,-0.3537f,-0.0606f, -0.9961f,-0.0580f,0.0659f, 
	-0.8710f,-0.4824f,-0.0931f, -0.9392f,-0.2461f,-0.2395f, -0.5585f,0.7301f,-0.3938f, -0.4198f,0.8057f,-0.4178f, -0.4211f,0.8450f,-0.3296f, -0.5455f,0.7792f,-0.3087f, -0.8440f,0.2946f,0.4483f, -0.8793f,0.1299f,0.4582f, -0.8998f,0.2352f,0.3675f, -0.7992f,0.5910f,0.1094f, -0.0000f,0.9299f,0.3677f, -0.2831f,0.8576f,0.4293f, -0.4127f,0.9103f,0.0323f, -0.0000f,0.9973f,0.0728f, -0.0000f,0.6462f,-0.7632f, 
	-0.0000f,0.6609f,-0.7505f, -0.4192f,0.6792f,-0.6024f, -0.3925f,0.6104f,-0.6880f, 0.0338f,0.9685f,0.2468f, 0.0911f,0.9162f,0.3902f, -0.3078f,0.9342f,0.1806f, -0.6862f,0.1786f,0.7052f, -0.6897f,0.6424f,-0.3340f, -0.7539f,0.6038f,-0.2590f, -0.8743f,0.4627f,-0.1468f, -0.8193f,0.4620f,-0.3395f, -0.7275f,-0.4429f,-0.5240f, -0.8906f,0.0326f,-0.4535f, -0.7028f,0.2313f,-0.6727f, -0.8172f,0.5745f,-0.0461f, 
	-0.7303f,-0.5184f,0.4449f, -0.7440f,0.1414f,0.6530f, -0.7176f,-0.2931f,0.6317f, -0.6421f,-0.4904f,0.5892f, -0.8249f,-0.4668f,-0.3189f, -0.8931f,0.1756f,-0.4142f, -0.8656f,-0.3310f,-0.3756f, -0.8721f,-0.4866f,-0.0510f, -0.7673f,-0.5469f,-0.3350f, -0.1745f,-0.8007f,0.5731f, 0.3498f,-0.8975f,-0.2686f, -0.3734f,-0.7321f,-0.5697f, -0.2788f,-0.9395f,-0.1990f, -0.1673f,-0.9201f,-0.3543f, -0.3076f,-0.7412f,-0.5967f, 
	-0.0000f,-0.0761f,0.9971f, -0.0000f,-0.1225f,0.9925f, 0.4966f,-0.2315f,0.8366f, 0.4404f,0.2353f,0.8664f, -0.9706f,0.0068f,-0.2406f, -0.8884f,-0.1105f,0.4457f, -0.8604f,0.4773f,-0.1786f, -0.8643f,0.3693f,-0.3413f, -0.9841f,0.0330f,0.1743f, -0.8983f,-0.3416f,0.2765f, -0.9813f,0.1059f,-0.1609f, -0.5300f,-0.0444f,-0.8468f, -0.4124f,0.3997f,-0.8186f, -0.5969f,0.3094f,-0.7403f, -0.5337f,-0.7565f,0.3779f, 
	-0.8094f,-0.2216f,0.5438f, -0.5334f,-0.6284f,-0.5662f, -0.5189f,-0.8548f,0.0087f, -0.7335f,-0.6592f,0.1656f, -0.3496f,-0.2874f,-0.8917f, -0.0000f,0.8205f,0.5716f, -0.0836f,0.8209f,0.5650f, -0.8848f,0.0783f,0.4594f, -0.9175f,0.3739f,0.1354f, -0.9045f,0.4248f,-0.0374f, -0.5518f,0.8339f,0.0068f, -0.7327f,0.3511f,-0.5830f, -0.9611f,0.1896f,-0.2007f, -0.5724f,-0.8142f,-0.0970f, -0.7432f,-0.6635f,-0.0861f, 
	-0.0000f,0.6299f,0.7767f, -0.3614f,0.2457f,0.8995f, -0.1623f,-0.9814f,0.1024f, -0.2072f,-0.9266f,0.3137f, -0.1816f,-0.9803f,0.0779f, -0.0356f,-0.9991f,-0.0210f, -0.0000f,0.8568f,-0.5157f, -0.0000f,0.9218f,-0.3877f, -0.6365f,0.6943f,0.3359f, -0.5500f,0.6961f,-0.4614f, -0.5724f,0.5424f,-0.6149f, -0.0000f,0.8753f,0.4836f, -0.0000f,0.8139f,0.5810f, -0.9189f,-0.2997f,0.2565f, -0.7607f,-0.1274f,0.6365f, 
	-0.8889f,0.0757f,0.4517f, -0.7802f,-0.5487f,0.3003f, 0.0084f,-0.9898f,-0.1423f, -0.0000f,-0.6870f,-0.7267f, -0.0631f,-0.0999f,0.9930f, -0.2644f,0.6067f,0.7497f, -0.0000f,0.5053f,-0.8629f, -0.3278f,-0.4532f,0.8289f, -0.7090f,-0.0399f,0.7041f, -0.5019f,0.7273f,0.4681f, -0.8799f,0.4738f,0.0356f, -0.7823f,0.6224f,-0.0257f, -0.0000f,0.9873f,-0.1590f, -0.3600f,0.9179f,-0.1668f, -0.5555f,-0.8145f,0.1672f, 
	-0.2676f,-0.7955f,0.5437f, -0.3221f,-0.9313f,0.1700f, -0.3083f,-0.8695f,0.3859f, -0.8930f,0.2256f,-0.3895f, -0.8589f,-0.4258f,0.2847f, -0.7518f,0.3816f,-0.5377f, -0.3840f,-0.8781f,0.2853f, -0.0940f,-0.7904f,0.6053f, 0.8353f,0.2816f,-0.4721f, 0.8353f,0.2816f,-0.4721f, 0.8434f,0.1385f,-0.5190f, 0.0672f,0.9954f,-0.0680f, -0.9000f,0.4348f,-0.0306f, -0.8927f,-0.4413f,-0.0912f, -0.1890f,-0.9537f,-0.2338f, 
	0.9953f,0.0448f,0.0854f, 0.9744f,0.1690f,0.1480f, 0.0003f,0.9983f,-0.0577f, -0.9915f,0.0924f,-0.0921f, -0.0829f,-0.9965f,0.0101f, -0.3458f,0.7623f,0.5471f, -0.9635f,0.0820f,-0.2547f, -0.8975f,-0.0172f,0.4407f, -0.8562f,0.3648f,0.3658f, -0.6783f,-0.5839f,-0.4460f, 0.3941f,-0.7263f,-0.5632f, 0.3739f,-0.6497f,-0.6619f, -0.4099f,-0.4754f,-0.7784f, -0.2813f,0.7173f,0.6375f, -0.5734f,0.6020f,0.5557f, 
	-0.4861f,-0.2653f,0.8327f, -0.2037f,0.3354f,0.9198f, -0.2102f,-0.1799f,0.9610f, -0.5924f,-0.4159f,0.6899f, -0.6107f,-0.0542f,0.7900f, -0.7279f,0.4887f,0.4810f, -0.7319f,0.6329f,0.2525f, -0.7688f,-0.1148f,0.6291f, -0.8580f,0.4035f,0.3178f, 0.0000f,0.9883f,0.1523f, -0.8765f,-0.0822f,0.4744f, -0.7737f,0.5714f,0.2735f, -0.7553f,0.3298f,0.5663f, -0.9579f,-0.0853f,0.2742f, -0.3678f,0.6556f,0.6594f, 
	-0.5646f,-0.6618f,0.4933f, 0.0648f,-0.5099f,0.8578f, -0.4137f,-0.1667f,0.8950f, -0.5663f,-0.6503f,0.5064f, -0.1091f,-0.5934f,0.7975f, 0.0508f,-0.4100f,0.9107f, -0.7056f,-0.4892f,0.5127f, -0.9854f,0.0918f,0.1434f, -0.2896f,-0.2825f,0.9145f, -0.2896f,-0.2825f,0.9145f, 0.0849f,0.7400f,0.6673f, 0.9626f,-0.2219f,-0.1552f, 0.9749f,-0.1898f,-0.1161f, 0.4278f,-0.8758f,-0.2236f, 0.0374f,-0.9530f,-0.3006f, 
	-0.7946f,-0.4301f,-0.4286f, -0.8717f,-0.4111f,-0.2666f, -0.9060f,0.3494f,-0.2390f, -0.9060f,0.3494f,-0.2390f, -0.1641f,0.9419f,-0.2930f, 0.3165f,0.8773f,-0.3609f, 0.1598f,-0.5382f,0.8276f, 0.6788f,0.6202f,-0.3933f, -0.8493f,0.5145f,0.1186f, -0.0000f,0.2173f,0.9761f, -0.4847f,0.4353f,0.7587f, -0.0000f,-0.5699f,0.8217f, -0.0000f,0.0022f,1.0000f, -0.5654f,-0.2870f,0.7733f, -0.5383f,-0.5612f,0.6287f, 
	-0.0000f,-0.5312f,0.8473f, -0.5691f,-0.4942f,0.6572f, 0.9116f,-0.4095f,-0.0362f, 0.0429f,0.9244f,-0.3791f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, -0.0000f,-0.6807f,0.7326f, 0.0856f,0.1342f,0.9872f, 0.3303f,-0.0055f,0.9439f, -0.0000f,-0.3700f,0.9290f, -0.6180f,0.4318f,0.6570f, 0.0000f,0.9741f,-0.2262f, -0.0000f,-0.0710f,0.9975f, -0.0000f,-0.0563f,0.9984f, 
	0.0000f,0.4391f,0.8984f, -0.1854f,-0.1220f,0.9751f, 0.5930f,-0.4120f,0.6918f, -0.2794f,0.9116f,-0.3015f, 0.0000f,0.9183f,-0.3959f, -0.3407f,0.9086f,0.2417f, -0.8498f,0.2546f,0.4616f, -0.5739f,0.8104f,-0.1181f, -0.8895f,0.1157f,-0.4420f, -0.9614f,-0.2485f,-0.1177f, -0.1246f,-0.7327f,-0.6691f, 0.0622f,-0.5230f,-0.8500f, 0.3105f,-0.5688f,-0.7617f, 0.5116f,-0.6396f,-0.5738f, 0.4852f,-0.5249f,-0.6993f, 
	0.4107f,-0.7074f,-0.5752f, 0.4381f,-0.7492f,0.4968f, -0.0855f,-0.8749f,0.4768f, 0.0260f,-0.9714f,0.2360f, 0.1718f,-0.9822f,0.0754f, -0.4035f,-0.8051f,0.4347f, -0.2416f,-0.9704f,-0.0067f, 0.3314f,-0.9420f,-0.0524f, 0.4717f,-0.7197f,0.5095f, -0.1862f,-0.9329f,-0.3083f, -0.5149f,-0.8467f,0.1337f, -0.4719f,-0.8757f,-0.1019f, 0.0000f,-0.4858f,-0.8741f, -0.0000f,-0.9052f,-0.4249f, -0.0000f,-0.8891f,0.4576f, 
	-0.0000f,-0.9410f,0.3384f, -0.0000f,-0.9972f,-0.0746f, 0.6490f,-0.7595f,0.0449f, -0.5791f,-0.6942f,0.4274f, -0.7577f,-0.6525f,0.0077f, -0.7434f,-0.6622f,0.0941f, -0.2069f,-0.9595f,0.1914f, 0.0992f,-0.9950f,0.0101f, 0.0979f,-0.9820f,-0.1614f, -0.1158f,-0.9755f,0.1868f, -0.3307f,-0.8936f,0.3034f, 0.4916f,-0.6494f,-0.5802f, 0.2763f,-0.8141f,-0.5107f, 0.3892f,-0.8490f,-0.3574f, 0.3945f,-0.9171f,-0.0565f, 
	0.5157f,-0.6601f,-0.5462f, 0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, 0.0000f,-0.8597f,-0.5108f, 0.2279f,-0.7890f,-0.5706f, 0.6393f,-0.3886f,-0.6635f, 0.6209f,-0.2472f,-0.7439f, -0.0000f,-0.7751f,-0.6318f, -0.0000f,-0.8588f,-0.5123f, 0.7689f,-0.6382f,-0.0384f, 0.7736f,-0.4668f,-0.4286f, 0.7762f,-0.6140f,-0.1435f, 0.7267f,-0.5598f,-0.3982f, -0.0000f,-0.9181f,-0.3963f, -0.0000f,-0.9290f,-0.3701f, 
	0.0000f,-0.5606f,-0.8281f, 0.5027f,-0.2121f,-0.8380f, 0.0000f,-0.1566f,-0.9877f, -0.0517f,-0.8354f,0.5471f, -0.2568f,-0.7892f,-0.5579f, 0.5715f,-0.8196f,-0.0400f, 0.1883f,-0.6623f,0.7252f, 0.4223f,-0.8250f,-0.3755f, 0.5798f,-0.6649f,-0.4710f, 0.1186f,-0.9927f,-0.0229f, 0.1186f,-0.9927f,-0.0229f, -0.0438f,-0.0104f,0.9990f, 0.0617f,-0.9977f,-0.0296f, 0.0054f,-0.9939f,-0.1101f, 0.1235f,-0.9540f,-0.2730f, 
	0.1283f,-0.9906f,0.0477f, -0.0000f,-0.9978f,-0.0663f, -0.0775f,-0.9854f,-0.1517f, -0.9150f,0.0128f,0.4033f, -0.9150f,0.0128f,0.4033f, -0.6876f,0.0069f,0.7260f, -0.0450f,-0.0128f,0.9989f, -0.3467f,0.0112f,-0.9379f, -0.3467f,0.0112f,-0.9379f, -0.6995f,0.5272f,0.4825f, -0.8449f,0.4777f,0.2406f, -0.8972f,-0.3502f,0.2690f, -0.6669f,0.7416f,0.0728f, 0.2043f,-0.5099f,-0.8356f, 0.3854f,-0.0590f,-0.9209f, 
	0.1815f,-0.0211f,0.9832f, -0.4142f,0.7569f,0.5055f, 0.2985f,0.2686f,0.9159f, 0.3319f,0.1957f,0.9228f, 0.1109f,0.1202f,0.9865f, 0.2743f,0.1356f,0.9520f, 0.2328f,0.2136f,0.9488f, 0.2526f,-0.2288f,0.9401f, -0.1282f,-0.5928f,0.7951f, 0.9334f,-0.3537f,-0.0606f, 0.9392f,-0.2461f,-0.2395f, 0.8710f,-0.4824f,-0.0931f, 0.9961f,-0.0580f,0.0659f, 0.5585f,0.7301f,-0.3938f, 0.5455f,0.7792f,-0.3087f, 
	0.4211f,0.8450f,-0.3296f, 0.4198f,0.8057f,-0.4178f, 0.8440f,0.2946f,0.4483f, 0.7992f,0.5910f,0.1094f, 0.8998f,0.2352f,0.3675f, 0.8793f,0.1299f,0.4582f, 0.4127f,0.9103f,0.0323f, 0.2831f,0.8576f,0.4293f, 0.3925f,0.6104f,-0.6880f, 0.4192f,0.6792f,-0.6024f, -0.0338f,0.9685f,0.2468f, 0.6862f,0.1786f,0.7052f, 0.3078f,0.9342f,0.1806f, -0.0911f,0.9162f,0.3902f, 0.6897f,0.6424f,-0.3340f, 
	0.8193f,0.4620f,-0.3395f, 0.8743f,0.4627f,-0.1468f, 0.7539f,0.6038f,-0.2590f, 0.7275f,-0.4429f,-0.5240f, 0.8172f,0.5745f,-0.0461f, 0.7028f,0.2313f,-0.6727f, 0.8906f,0.0326f,-0.4535f, 0.7303f,-0.5184f,0.4449f, 0.6421f,-0.4904f,0.5892f, 0.7176f,-0.2931f,0.6317f, 0.7440f,0.1414f,0.6530f, 0.8249f,-0.4668f,-0.3189f, 0.8721f,-0.4866f,-0.0510f, 0.8656f,-0.3310f,-0.3756f, 0.8931f,0.1756f,-0.4142f, 
	0.7673f,-0.5469f,-0.3350f, -0.3498f,-0.8975f,-0.2686f, 0.1745f,-0.8007f,0.5731f, 0.1349f,-0.8390f,-0.5272f, 0.2686f,-0.9497f,-0.1608f, -0.0364f,-0.8361f,0.5474f, -0.2171f,-0.9230f,-0.3176f, -0.4404f,0.2353f,0.8664f, -0.4966f,-0.2315f,0.8366f, 0.9706f,0.0068f,-0.2406f, 0.8643f,0.3693f,-0.3413f, 0.8604f,0.4773f,-0.1786f, 0.8884f,-0.1105f,0.4457f, 0.9841f,0.0330f,0.1743f, 0.9813f,0.1059f,-0.1609f, 
	0.8983f,-0.3416f,0.2765f, 0.5300f,-0.0444f,-0.8468f, 0.5969f,0.3094f,-0.7403f, 0.4124f,0.3997f,-0.8186f, 0.8094f,-0.2216f,0.5438f, 0.5337f,-0.7565f,0.3779f, 0.7335f,-0.6592f,0.1656f, 0.5189f,-0.8548f,0.0087f, 0.5334f,-0.6284f,-0.5662f, 0.3496f,-0.2874f,-0.8917f, 0.0836f,0.8209f,0.5650f, 0.8848f,0.0783f,0.4594f, 0.8440f,0.2946f,0.4483f, 0.8793f,0.1299f,0.4582f, 0.9175f,0.3739f,0.1354f, 
	0.9045f,0.4248f,-0.0374f, 0.5518f,0.8339f,0.0068f, 0.9611f,0.1896f,-0.2007f, 0.7327f,0.3511f,-0.5830f, 0.5724f,-0.8142f,-0.0970f, 0.7432f,-0.6635f,-0.0861f, 0.3614f,0.2457f,0.8995f, 0.1174f,-0.9761f,-0.1831f, 0.2966f,-0.6120f,-0.7332f, 0.1460f,-0.9757f,-0.1634f, 0.2072f,-0.9266f,0.3137f, 0.6365f,0.6943f,0.3359f, 0.5500f,0.6961f,-0.4614f, 0.5724f,0.5424f,-0.6149f, 0.9189f,-0.2997f,0.2565f, 
	0.7802f,-0.5487f,0.3003f, 0.8889f,0.0757f,0.4517f, 0.7607f,-0.1274f,0.6365f, 0.0631f,-0.0999f,0.9930f, 0.2644f,0.6067f,0.7497f, 0.7090f,-0.0399f,0.7041f, 0.3278f,-0.4532f,0.8289f, 0.5019f,0.7273f,0.4681f, 0.8884f,-0.1105f,0.4457f, 0.8604f,0.4773f,-0.1786f, 0.8799f,0.4738f,0.0356f, 0.7275f,-0.4429f,-0.5240f, 0.8906f,0.0326f,-0.4535f, 0.8983f,-0.3416f,0.2765f, 0.9706f,0.0068f,-0.2406f, 
	0.7823f,0.6224f,-0.0257f, 0.3600f,0.9179f,-0.1668f, 0.5555f,-0.8145f,0.1672f, 0.3083f,-0.8695f,0.3859f, 0.3221f,-0.9313f,0.1700f, 0.2676f,-0.7955f,0.5437f, 0.7335f,-0.6592f,0.1656f, 0.8930f,0.2256f,-0.3895f, 0.7518f,0.3816f,-0.5377f, 0.8589f,-0.4258f,0.2847f, 0.7673f,-0.5469f,-0.3350f, 0.3840f,-0.8781f,0.2853f, 0.0940f,-0.7904f,0.6053f, -0.8434f,0.1385f,-0.5190f, -0.8434f,0.1385f,-0.5190f, 
	-0.8434f,0.1385f,-0.5190f, -0.0084f,0.9999f,-0.0073f, 0.9499f,0.3082f,0.0518f, 0.8927f,-0.4413f,-0.0912f, 0.1890f,-0.9537f,-0.2338f, -0.9744f,0.1690f,0.1480f, -0.9744f,0.1690f,0.1480f, 0.0341f,0.9982f,-0.0490f, 0.9915f,0.0924f,-0.0921f, 0.1168f,-0.9931f,0.0019f, 0.3458f,0.7623f,0.5471f, 0.9657f,-0.2477f,0.0782f, 0.8643f,0.3693f,-0.3413f, 0.8562f,0.3648f,0.3658f, 0.8975f,-0.0172f,0.4407f, 
	0.6783f,-0.5839f,-0.4460f, 0.4099f,-0.4754f,-0.7784f, -0.3739f,-0.6497f,-0.6619f, -0.3941f,-0.7263f,-0.5632f, 0.2813f,0.7173f,0.6375f, 0.2037f,0.3354f,0.9198f, 0.4861f,-0.2653f,0.8327f, 0.5734f,0.6020f,0.5557f, 0.7607f,-0.1274f,0.6365f, 0.3278f,-0.4532f,0.8289f, 0.2102f,-0.1799f,0.9610f, 0.5924f,-0.4159f,0.6899f, 0.6783f,-0.5839f,-0.4460f, -0.3941f,-0.7263f,-0.5632f, 0.7279f,0.4887f,0.4810f, 
	0.6107f,-0.0542f,0.7900f, 0.7319f,0.6329f,0.2525f, 0.7688f,-0.1148f,0.6291f, 0.8580f,0.4035f,0.3178f, 0.8765f,-0.0822f,0.4744f, 0.7737f,0.5714f,0.2735f, 0.7553f,0.3298f,0.5663f, 0.9579f,-0.0853f,0.2742f, 0.9045f,0.4248f,-0.0374f, 0.3678f,0.6556f,0.6594f, 0.4137f,-0.1667f,0.8950f, 0.4137f,-0.1667f,0.8950f, 0.5663f,-0.6503f,0.5064f, 0.5646f,-0.6618f,0.4933f, 0.2218f,-0.7300f,0.6465f, 
	-0.0508f,-0.4100f,0.9107f, 0.7056f,-0.4892f,0.5127f, 0.8964f,0.2989f,-0.3273f, 0.6988f,0.1979f,0.6874f, 0.2896f,-0.2825f,0.9145f, 0.4793f,-0.3593f,0.8008f, 0.4861f,-0.2653f,0.8327f, -0.9749f,-0.1898f,-0.1161f, -0.9749f,-0.1898f,-0.1161f, -0.4197f,-0.8779f,-0.2304f, 0.0284f,-0.9379f,-0.3459f, 0.6577f,-0.7077f,-0.2582f, 0.9141f,-0.1720f,-0.3671f, 0.8732f,0.4083f,-0.2661f, 0.9060f,0.3494f,-0.2390f, 
	0.0547f,0.9525f,-0.2995f, -0.1867f,0.9384f,-0.2907f, 0.4793f,-0.3593f,0.8008f, -0.1867f,0.9384f,-0.2907f, -0.9749f,-0.1898f,-0.1161f, 0.4137f,-0.1667f,0.8950f, 0.5094f,0.0339f,0.8599f, 0.8493f,0.5145f,0.1186f, -0.0429f,0.9244f,-0.3791f, 0.4847f,0.4353f,0.7587f, 0.5383f,-0.5612f,0.6287f, 0.5654f,-0.2870f,0.7733f, 0.5691f,-0.4942f,0.6572f, -0.0429f,0.9244f,-0.3791f, -0.9116f,-0.4095f,-0.0362f, 
	-0.6788f,0.6202f,-0.3933f, -0.4401f,0.8629f,-0.2484f, -0.6788f,0.6202f,-0.3933f, -0.3303f,-0.0055f,0.9439f, -0.0856f,0.1342f,0.9872f, 0.6180f,0.4318f,0.6570f, 0.1854f,-0.1220f,0.9751f, -0.5930f,-0.4120f,0.6918f, 0.2794f,0.9116f,-0.3015f, 0.3407f,0.9086f,0.2417f, 0.8498f,0.2546f,0.4616f, 0.3600f,0.9179f,-0.1668f, 0.4211f,0.8450f,-0.3296f, 0.5455f,0.7792f,-0.3087f, 0.5739f,0.8104f,-0.1181f, 
	0.9614f,-0.2485f,-0.1177f, 0.8895f,0.1157f,-0.4420f, 0.1246f,-0.7327f,-0.6691f, -0.5116f,-0.6396f,-0.5738f, -0.3105f,-0.5688f,-0.7617f, -0.0622f,-0.5230f,-0.8500f, -0.4107f,-0.7074f,-0.5752f, -0.4852f,-0.5249f,-0.6993f, -0.4381f,-0.7492f,0.4968f, 0.0855f,-0.8749f,0.4768f, 0.1745f,-0.8007f,0.5731f, -0.3498f,-0.8975f,-0.2686f, -0.0260f,-0.9714f,0.2360f, 0.2416f,-0.9704f,-0.0067f, 0.4035f,-0.8051f,0.4347f, 
	-0.1718f,-0.9822f,0.0754f, -0.4717f,-0.7197f,0.5095f, -0.3314f,-0.9420f,-0.0524f, 0.1862f,-0.9329f,-0.3083f, 0.4719f,-0.8757f,-0.1019f, 0.5149f,-0.8467f,0.1337f, -0.3739f,-0.6497f,-0.6619f, -0.6490f,-0.7595f,0.0449f, 0.5791f,-0.6942f,0.4274f, -0.6490f,-0.7595f,0.0449f, 0.7577f,-0.6525f,0.0077f, 0.4035f,-0.8051f,0.4347f, 0.2416f,-0.9704f,-0.0067f, 0.7434f,-0.6622f,0.0941f, -0.0992f,-0.9950f,0.0101f, 
	0.2069f,-0.9595f,0.1914f, -0.0979f,-0.9820f,-0.1614f, 0.1158f,-0.9755f,0.1868f, -0.0979f,-0.9820f,-0.1614f, 0.3307f,-0.8936f,0.3034f, 0.9961f,-0.0580f,0.0659f, 0.8589f,-0.4258f,0.2847f, -0.4916f,-0.6494f,-0.5802f, -0.2763f,-0.8141f,-0.5107f, -0.3892f,-0.8490f,-0.3574f, -0.3945f,-0.9171f,-0.0565f, -0.4465f,-0.7346f,-0.5109f, -0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, -0.2279f,-0.7890f,-0.5706f, 
	-0.6393f,-0.3886f,-0.6635f, -0.6209f,-0.2472f,-0.7439f, -0.7689f,-0.6382f,-0.0384f, -0.7736f,-0.4668f,-0.4286f, -0.7762f,-0.6140f,-0.1435f, -0.7267f,-0.5598f,-0.3982f, -0.5027f,-0.2121f,-0.8380f, 0.2568f,-0.7892f,-0.5579f, -0.5019f,-0.7006f,-0.5072f, -0.0120f,-0.9986f,0.0522f, -0.4223f,-0.8250f,-0.3755f, -0.5798f,-0.6649f,-0.4710f, -0.1519f,-0.9870f,-0.0535f, -0.1186f,-0.9927f,-0.0229f, 0.0450f,-0.0128f,0.9989f, 
	0.4527f,-0.4709f,-0.7572f, 0.8123f,-0.4535f,-0.3668f, 0.0775f,-0.9854f,-0.1517f, 0.9144f,0.0161f,0.4044f, 0.9150f,0.0128f,0.4033f, 0.6874f,0.0078f,0.7262f, 0.3483f,0.0171f,-0.9372f, 0.6995f,0.5272f,0.4825f, 0.8449f,0.4777f,0.2406f, 0.8972f,-0.3502f,0.2690f, 0.6669f,0.7416f,0.0728f, 0.4127f,0.9103f,0.0323f, 0.6669f,0.7416f,0.0728f, 
_NULL_ }; /* End of skull5_Normals */

const unsigned short skull5_Faces[] = {
	0, 2, 1, 2, 0, 3, 4, 6, 5, 6, 8, 7, 4, 8, 6, 8, 10, 9, 4, 10, 8, 4, 11, 10, 4, 12, 11, 13, 15, 14, 
	15, 13, 16, 17, 19, 18, 19, 17, 20, 21, 23, 22, 23, 21, 24, 25, 27, 26, 27, 25, 28, 29, 31, 30, 31, 29, 32, 33, 35, 34, 
	35, 33, 36, 37, 39, 38, 39, 37, 40, 41, 43, 42, 43, 41, 44, 45, 47, 46, 47, 45, 48, 49, 51, 50, 51, 49, 52, 53, 55, 54, 
	56, 58, 57, 58, 56, 59, 60, 62, 61, 62, 60, 63, 64, 66, 65, 66, 64, 67, 68, 13, 69, 13, 68, 70, 71, 72, 2, 72, 71, 73, 
	47, 74, 46, 74, 47, 75, 51, 77, 76, 77, 51, 78, 56, 3, 59, 3, 56, 79, 80, 26, 81, 26, 80, 25, 82, 22, 83, 22, 82, 21, 
	66, 67, 84, 85, 87, 86, 87, 85, 44, 88, 52, 89, 52, 88, 51, 71, 3, 79, 3, 71, 2, 61, 91, 90, 91, 61, 62, 92, 94, 93, 
	94, 92, 95, 18, 97, 96, 97, 18, 19, 26, 27, 98, 99, 32, 100, 32, 99, 31, 33, 102, 101, 102, 33, 34, 103, 105, 104, 105, 103, 106, 
	107, 59, 108, 59, 107, 58, 109, 63, 110, 63, 109, 62, 2, 111, 1, 111, 2, 72, 105, 112, 104, 112, 105, 113, 108, 3, 0, 3, 108, 59, 
	26, 114, 81, 102, 63, 60, 63, 102, 34, 34, 110, 63, 110, 34, 35, 83, 66, 84, 66, 83, 22, 22, 65, 66, 65, 22, 23, 115, 70, 68, 
	70, 115, 39, 73, 32, 72, 32, 73, 100, 32, 111, 72, 111, 32, 29, 78, 64, 69, 78, 42, 64, 78, 41, 42, 69, 65, 68, 65, 69, 64, 
	68, 23, 115, 23, 68, 65, 115, 24, 116, 24, 115, 23, 117, 27, 28, 27, 117, 118, 119, 121, 120, 121, 119, 122, 69, 14, 78, 14, 69, 13, 
	116, 39, 115, 39, 116, 38, 16, 70, 123, 70, 16, 13, 14, 125, 124, 14, 53, 125, 14, 15, 53, 126, 122, 119, 122, 126, 127, 70, 40, 123, 
	40, 70, 39, 128, 129, 41, 129, 128, 130, 41, 131, 44, 131, 41, 129, 44, 132, 87, 132, 44, 131, 133, 130, 128, 130, 133, 134, 130, 135, 129, 
	135, 130, 136, 129, 137, 131, 137, 129, 135, 138, 131, 137, 138, 132, 131, 138, 134, 132, 134, 136, 130, 134, 139, 136, 134, 138, 139, 136, 124, 135, 
	124, 136, 140, 135, 125, 137, 125, 135, 124, 137, 141, 138, 141, 137, 125, 42, 67, 64, 67, 42, 43, 67, 143, 142, 143, 67, 43, 144, 146, 145, 
	146, 144, 147, 148, 150, 149, 150, 148, 151, 85, 43, 44, 43, 85, 143, 104, 150, 152, 150, 104, 112, 152, 151, 153, 151, 152, 150, 86, 144, 145, 
	144, 86, 87, 87, 134, 133, 134, 87, 132, 109, 155, 154, 155, 109, 110, 155, 35, 156, 35, 155, 110, 156, 36, 157, 36, 156, 35, 158, 90, 91, 
	90, 158, 159, 160, 155, 161, 155, 160, 154, 161, 156, 162, 156, 161, 155, 162, 157, 163, 157, 162, 156, 84, 67, 142, 164, 166, 165, 166, 164, 167, 
	165, 168, 154, 168, 165, 166, 154, 169, 109, 169, 154, 168, 169, 62, 109, 62, 169, 170, 91, 170, 171, 170, 91, 62, 91, 172, 158, 172, 91, 171, 
	112, 174, 173, 174, 112, 113, 112, 175, 150, 175, 112, 173, 150, 167, 164, 167, 150, 175, 167, 176, 166, 176, 167, 177, 166, 178, 168, 178, 166, 176, 
	168, 179, 169, 179, 168, 178, 169, 180, 170, 180, 169, 179, 170, 181, 171, 181, 170, 180, 171, 182, 172, 171, 183, 182, 171, 181, 183, 184, 182, 183, 
	184, 172, 182, 184, 174, 172, 184, 173, 174, 173, 185, 175, 185, 173, 184, 175, 177, 167, 177, 175, 185, 177, 5, 176, 5, 177, 4, 176, 6, 178, 
	6, 176, 5, 178, 7, 179, 7, 178, 6, 179, 8, 180, 8, 179, 7, 180, 9, 181, 9, 180, 8, 181, 10, 183, 10, 181, 9, 183, 11, 184, 
	11, 183, 10, 184, 12, 185, 12, 184, 11, 185, 4, 177, 4, 185, 12, 172, 113, 158, 113, 172, 174, 113, 46, 158, 46, 113, 105, 46, 106, 45, 
	106, 46, 105, 186, 74, 187, 74, 186, 188, 158, 189, 159, 189, 158, 190, 191, 193, 192, 193, 191, 194, 192, 196, 195, 196, 192, 193, 186, 198, 197, 
	198, 186, 187, 199, 201, 200, 202, 204, 203, 204, 202, 205, 206, 208, 207, 209, 211, 210, 211, 203, 212, 209, 203, 211, 209, 202, 203, 213, 207, 214, 
	207, 213, 206, 205, 190, 204, 190, 205, 189, 74, 158, 46, 158, 74, 188, 215, 75, 216, 75, 215, 74, 194, 208, 206, 208, 194, 191, 118, 20, 217, 
	20, 118, 19, 97, 118, 117, 118, 97, 19, 50, 218, 49, 218, 50, 219, 220, 222, 221, 222, 220, 223, 223, 224, 222, 224, 223, 225, 226, 54, 55, 
	54, 226, 227, 228, 230, 229, 230, 228, 231, 120, 232, 119, 232, 120, 233, 119, 234, 126, 234, 119, 232, 229, 235, 228, 235, 229, 236, 237, 225, 238, 
	225, 237, 224, 233, 240, 239, 240, 233, 120, 120, 241, 240, 241, 120, 121, 145, 146, 242, 146, 243, 242, 243, 146, 88, 88, 244, 243, 244, 88, 89, 
	230, 227, 226, 227, 230, 231, 93, 122, 127, 122, 93, 94, 53, 245, 125, 245, 53, 54, 245, 247, 246, 245, 227, 247, 245, 54, 227, 227, 248, 247, 
	248, 227, 231, 231, 249, 248, 249, 231, 228, 228, 250, 249, 250, 228, 235, 76, 219, 50, 219, 76, 77, 50, 51, 76, 238, 233, 239, 233, 238, 225, 
	225, 232, 233, 232, 225, 223, 223, 234, 232, 234, 223, 220, 236, 219, 235, 219, 236, 218, 235, 77, 250, 77, 235, 219, 78, 250, 77, 78, 249, 250, 
	78, 124, 249, 78, 14, 124, 41, 51, 147, 51, 41, 78, 146, 51, 88, 51, 146, 147, 216, 194, 206, 194, 216, 75, 193, 75, 47, 75, 193, 194, 
	48, 193, 47, 193, 48, 196, 187, 211, 198, 187, 201, 211, 187, 200, 201, 213, 210, 211, 210, 213, 214, 251, 45, 252, 45, 251, 48, 253, 49, 254, 
	49, 253, 52, 255, 52, 253, 52, 255, 89, 256, 103, 257, 103, 256, 106, 252, 106, 256, 106, 252, 45, 258, 196, 259, 196, 258, 195, 257, 89, 255, 
	89, 257, 244, 259, 48, 251, 48, 259, 196, 260, 262, 261, 262, 260, 263, 264, 254, 265, 254, 264, 253, 266, 268, 267, 268, 266, 269, 267, 263, 260, 
	263, 267, 268, 270, 272, 271, 261, 270, 271, 270, 261, 262, 264, 237, 273, 237, 264, 274, 275, 253, 264, 253, 275, 255, 273, 276, 264, 276, 273, 269, 
	277, 267, 256, 267, 278, 266, 277, 278, 267, 260, 256, 267, 256, 260, 252, 251, 260, 261, 260, 251, 252, 259, 261, 271, 261, 259, 251, 272, 259, 271, 
	259, 272, 258, 279, 94, 280, 94, 279, 122, 281, 122, 279, 122, 281, 121, 282, 284, 283, 284, 282, 95, 280, 285, 282, 285, 280, 94, 241, 287, 286, 
	287, 241, 121, 288, 280, 289, 280, 288, 279, 290, 279, 288, 279, 290, 281, 291, 281, 290, 281, 291, 286, 292, 283, 293, 283, 292, 282, 289, 282, 292, 
	282, 289, 280, 26, 294, 114, 294, 26, 98, 295, 294, 98, 294, 295, 296, 297, 98, 27, 98, 297, 295, 27, 217, 297, 217, 27, 118, 0, 299, 298, 
	299, 0, 1, 300, 302, 301, 300, 303, 302, 303, 305, 304, 300, 305, 303, 305, 307, 306, 300, 307, 305, 300, 308, 307, 309, 311, 310, 311, 309, 312, 
	313, 315, 314, 315, 313, 316, 317, 319, 318, 319, 317, 320, 25, 321, 28, 321, 25, 322, 29, 324, 323, 324, 29, 30, 325, 327, 326, 327, 325, 328, 
	329, 331, 330, 331, 329, 332, 333, 335, 334, 335, 333, 336, 337, 339, 338, 339, 337, 340, 341, 343, 342, 343, 341, 344, 345, 347, 346, 348, 350, 349, 
	350, 348, 351, 60, 353, 352, 353, 60, 61, 354, 356, 355, 356, 354, 357, 358, 309, 359, 309, 358, 360, 361, 363, 362, 363, 361, 299, 339, 365, 364, 
	365, 339, 340, 343, 367, 366, 367, 343, 368, 348, 298, 369, 298, 348, 349, 80, 322, 25, 322, 80, 370, 371, 373, 372, 373, 371, 374, 356, 375, 355, 
	376, 377, 334, 377, 376, 378, 379, 342, 343, 342, 379, 380, 361, 298, 299, 298, 361, 369, 61, 381, 353, 381, 61, 90, 382, 384, 383, 384, 382, 385, 
	316, 97, 315, 97, 316, 96, 322, 386, 321, 387, 323, 324, 323, 387, 388, 325, 102, 328, 102, 325, 101, 389, 391, 390, 391, 389, 392, 107, 349, 350, 
	349, 107, 108, 393, 352, 353, 352, 393, 394, 299, 111, 363, 111, 299, 1, 391, 396, 395, 396, 391, 392, 108, 298, 349, 298, 108, 0, 322, 370, 397, 
	102, 352, 328, 352, 102, 60, 328, 394, 327, 394, 328, 352, 374, 356, 373, 356, 374, 375, 320, 398, 319, 398, 320, 399, 400, 359, 331, 359, 400, 358, 
	362, 323, 388, 323, 362, 363, 323, 111, 29, 111, 323, 363, 366, 402, 401, 366, 354, 402, 366, 403, 354, 360, 398, 404, 398, 360, 358, 358, 319, 398, 
	319, 358, 400, 400, 318, 319, 318, 400, 405, 117, 321, 406, 321, 117, 28, 407, 409, 408, 409, 407, 410, 360, 312, 309, 312, 360, 411, 405, 331, 332, 
	331, 405, 400, 310, 359, 309, 359, 310, 412, 413, 312, 414, 312, 415, 311, 413, 415, 312, 416, 408, 417, 408, 416, 407, 359, 330, 331, 330, 359, 412, 
	418, 420, 419, 420, 418, 333, 333, 421, 420, 421, 333, 334, 334, 422, 421, 422, 334, 377, 423, 419, 424, 419, 423, 418, 419, 426, 425, 426, 419, 420, 
	420, 427, 426, 427, 420, 421, 421, 428, 427, 428, 422, 424, 421, 422, 428, 424, 429, 428, 424, 425, 429, 424, 419, 425, 425, 414, 430, 414, 425, 426, 
	426, 413, 414, 413, 426, 427, 427, 431, 413, 431, 427, 428, 336, 432, 335, 432, 336, 404, 432, 433, 335, 433, 432, 434, 435, 437, 436, 437, 435, 438, 
	439, 441, 440, 441, 439, 442, 376, 335, 433, 335, 376, 334, 443, 441, 444, 441, 443, 445, 445, 440, 441, 440, 445, 446, 378, 447, 377, 447, 378, 448, 
	377, 424, 422, 424, 377, 423, 393, 449, 394, 449, 393, 450, 449, 327, 394, 327, 449, 451, 451, 326, 327, 326, 451, 452, 90, 453, 381, 453, 90, 159, 
	454, 449, 450, 449, 454, 455, 455, 451, 449, 451, 455, 456, 456, 452, 451, 452, 456, 457, 458, 434, 432, 459, 461, 460, 461, 459, 462, 462, 463, 461, 
	463, 462, 450, 450, 464, 463, 464, 450, 393, 464, 353, 465, 353, 464, 393, 465, 381, 466, 381, 465, 353, 381, 467, 466, 467, 381, 453, 396, 468, 395, 
	468, 396, 469, 396, 470, 469, 470, 396, 471, 471, 460, 470, 460, 471, 459, 460, 473, 472, 473, 460, 461, 461, 474, 473, 474, 461, 463, 463, 475, 474, 
	475, 463, 464, 464, 476, 475, 476, 464, 465, 465, 477, 476, 477, 465, 466, 466, 478, 477, 466, 479, 478, 466, 467, 479, 480, 468, 469, 480, 467, 468, 
	480, 479, 467, 480, 478, 479, 469, 481, 480, 481, 469, 470, 482, 484, 483, 484, 482, 485, 472, 308, 300, 308, 472, 473, 473, 307, 308, 307, 473, 474, 
	474, 306, 307, 306, 474, 475, 475, 305, 306, 305, 475, 476, 476, 304, 305, 304, 476, 477, 477, 303, 304, 303, 477, 478, 478, 302, 303, 302, 478, 480, 
	480, 301, 302, 301, 480, 481, 481, 300, 301, 300, 481, 472, 467, 395, 468, 395, 467, 453, 395, 340, 391, 340, 395, 453, 340, 390, 391, 390, 340, 337, 
	486, 365, 487, 365, 486, 488, 453, 189, 489, 189, 453, 159, 191, 491, 490, 491, 191, 192, 192, 492, 491, 492, 192, 195, 486, 493, 488, 493, 486, 494, 
	495, 497, 496, 202, 498, 205, 498, 202, 499, 500, 207, 208, 501, 209, 210, 209, 499, 202, 501, 499, 209, 501, 502, 499, 503, 207, 500, 207, 503, 214, 
	205, 489, 189, 489, 205, 498, 365, 453, 487, 453, 365, 340, 504, 364, 365, 364, 504, 505, 490, 208, 191, 208, 490, 500, 506, 508, 507, 508, 506, 509, 
	97, 406, 315, 406, 97, 117, 344, 511, 510, 511, 344, 341, 512, 514, 513, 514, 512, 515, 513, 517, 516, 517, 513, 514, 518, 520, 519, 520, 518, 521, 
	522, 524, 523, 524, 522, 525, 410, 527, 526, 527, 410, 407, 407, 528, 527, 528, 407, 416, 525, 530, 529, 530, 525, 522, 237, 516, 517, 516, 237, 238, 
	526, 240, 410, 240, 526, 239, 410, 241, 409, 241, 410, 240, 448, 532, 531, 437, 533, 379, 533, 437, 534, 379, 535, 380, 535, 379, 533, 536, 519, 537, 
	519, 536, 518, 385, 408, 384, 408, 385, 417, 415, 538, 520, 538, 415, 413, 538, 519, 520, 538, 539, 519, 538, 540, 539, 519, 541, 537, 541, 519, 539, 
	523, 542, 522, 542, 523, 543, 522, 544, 530, 544, 522, 542, 368, 510, 367, 510, 368, 344, 344, 368, 343, 238, 526, 516, 526, 238, 239, 516, 527, 513, 
	527, 516, 526, 513, 528, 512, 528, 513, 527, 529, 510, 511, 510, 529, 530, 530, 367, 510, 367, 530, 544, 544, 366, 367, 366, 546, 545, 366, 542, 546, 
	544, 542, 366, 401, 343, 366, 343, 401, 436, 437, 343, 436, 343, 437, 379, 505, 490, 364, 490, 505, 500, 491, 364, 490, 364, 491, 339, 338, 491, 492, 
	491, 338, 339, 488, 496, 497, 488, 501, 496, 488, 493, 501, 503, 210, 214, 210, 503, 501, 547, 337, 338, 337, 547, 548, 549, 341, 342, 341, 549, 550, 
	551, 342, 380, 342, 551, 549, 552, 389, 390, 389, 552, 553, 548, 390, 337, 390, 548, 552, 258, 492, 195, 492, 258, 554, 553, 380, 535, 380, 553, 551, 
	554, 338, 492, 338, 554, 547, 555, 262, 263, 262, 555, 556, 557, 550, 549, 550, 557, 558, 559, 268, 269, 268, 559, 560, 560, 263, 268, 263, 560, 555, 
	270, 561, 272, 556, 270, 262, 270, 556, 561, 557, 237, 562, 237, 557, 273, 563, 549, 551, 549, 563, 557, 273, 564, 269, 564, 273, 557, 560, 565, 552, 
	560, 566, 565, 560, 559, 566, 555, 552, 548, 552, 555, 560, 547, 555, 548, 555, 547, 556, 554, 556, 547, 556, 554, 561, 272, 554, 258, 554, 272, 561, 
	567, 384, 408, 384, 567, 568, 569, 408, 409, 408, 569, 567, 570, 284, 383, 284, 570, 283, 568, 571, 384, 571, 568, 570, 241, 572, 409, 572, 241, 286, 
	573, 568, 567, 568, 573, 574, 575, 567, 569, 567, 575, 573, 291, 569, 286, 569, 291, 575, 576, 283, 570, 283, 576, 293, 574, 570, 568, 570, 574, 576, 
	322, 577, 386, 577, 322, 397, 578, 577, 579, 577, 578, 386, 580, 386, 578, 386, 580, 321, 581, 509, 506, 509, 581, 582, 
_NULL_ }; /* End of skull5_Faces */


/* MESH 1 */

#define skull4_NumVertex  583
#define skull4_NumFaces   838
#define skull4_NumStrips  0
#define skull4_Flags      0x00020006
#define skull4_Material   0

const float skull4_Vertices[] = {
	1.1359f,-30.7901f,-94.2126f, 1.1359f,21.8917f,-125.2171f, -37.5099f,16.9488f,-112.9776f, -24.8991f,-34.4217f,-92.8435f, -54.0600f,-1.6057f,22.5979f, 
	-51.8899f,4.6925f,27.9956f, -43.4165f,8.3215f,29.0670f, -33.0246f,11.2661f,31.1492f, -15.7781f,2.5378f,37.3877f, -12.5993f,-5.9891f,38.7835f, 
	-23.4098f,-13.7772f,38.5170f, -38.1585f,-16.7290f,32.2143f, -47.0834f,-11.7429f,32.0608f, -89.0558f,9.8441f,-48.6592f, -80.1977f,-3.8524f,-33.6530f, 
	-71.1760f,-13.5720f,-81.4220f, -81.4698f,7.1799f,-82.7709f, -67.0289f,63.5996f,-55.6762f, -37.8204f,77.2215f,-74.6495f, -35.8167f,91.1199f,-48.9229f, 
	-72.0849f,70.1446f,-37.5272f, -67.2626f,72.2029f,32.1224f, -64.3075f,43.2688f,40.9191f, -78.1080f,60.6806f,21.3094f, -69.6200f,75.0868f,9.3977f, 
	1.1359f,98.3649f,47.6794f, -32.0959f,90.6309f,55.5181f, -42.1024f,98.7173f,2.3142f, 1.1359f,107.7151f,2.9091f, 1.1359f,65.9923f,-97.9426f, 
	1.1359f,85.0664f,-81.1452f, -37.8204f,77.2215f,-74.6495f, -39.0037f,60.6855f,-93.4797f, -21.7603f,73.1312f,76.4497f, -17.0652f,47.1028f,82.7002f, 
	-32.4081f,41.8143f,80.0476f, -42.0974f,70.2640f,69.1202f, -67.0289f,63.5996f,-55.6762f, -72.0849f,70.1446f,-37.5272f, -85.5958f,54.0933f,-35.6234f, 
	-76.1367f,48.7393f,-69.4547f, -67.7577f,-10.7725f,40.0239f, -63.9875f,-0.2272f,35.1452f, -76.2627f,0.7303f,39.3964f, -90.0657f,-7.2858f,36.0221f, 
	-28.1248f,-65.5598f,91.4757f, -25.1109f,-51.2734f,83.0323f, -13.3118f,-53.3318f,96.2137f, -18.6598f,-66.6641f,101.6766f, -42.4260f,-51.5871f,39.7332f, 
	-39.6489f,-42.8894f,37.4642f, -38.0260f,-29.4774f,44.8896f, -45.2029f,-52.9658f,50.2097f, -59.7738f,-35.7219f,-74.1229f, -70.8884f,-58.3772f,-19.2237f, 
	-54.1116f,-42.2233f,-51.3585f, -59.7738f,-35.7219f,-74.1229f, -54.1116f,-42.2233f,-51.3585f, -26.2528f,-45.8518f,-73.2698f, -35.5612f,-39.5563f,-84.5946f, 
	1.1359f,17.6575f,86.2308f, 1.1359f,4.0649f,83.6827f, -10.8724f,-2.4242f,89.5567f, -6.8831f,18.4048f,99.7681f, -63.6275f,9.2643f,36.7228f, 
	-72.1330f,40.5582f,25.7796f, -65.5390f,17.2754f,46.8200f, -77.7906f,11.2166f,46.0054f, -92.0563f,32.7660f,-14.5495f, -84.6575f,8.0952f,-3.7748f, 
	-92.7630f,29.6651f,-47.0320f, -81.4698f,7.1799f,-82.7709f, -40.1852f,46.9405f,-101.8677f, -80.1600f,28.1101f,-76.8286f, -27.3711f,-49.6025f,90.3108f, 
	-15.0238f,-50.9719f,101.7354f, -34.7806f,-21.9903f,36.8265f, -40.5791f,-15.8404f,24.6319f, -65.9931f,-10.2918f,20.9559f, -71.1760f,-13.5720f,-81.4220f, 
	1.1359f,74.6659f,78.0448f, -21.7603f,73.1312f,76.4497f, -61.0555f,62.6247f,44.8866f, -57.1250f,38.3637f,54.8431f, -69.4022f,18.2919f,65.6706f, 
	-81.3612f,-14.4392f,59.4608f, -109.8072f,-3.2575f,64.3257f, -95.5245f,-18.3153f,38.8697f, -37.9621f,-31.8156f,54.6750f, -42.6242f,-55.5465f,56.4919f, 
	1.1359f,-2.4392f,87.4751f, -7.8796f,-1.8633f,82.1055f, -54.1116f,-42.2233f,-51.3585f, -47.7398f,-40.1763f,-35.5145f, -32.5118f,-45.4468f,-48.0258f, 
	-26.2528f,-45.8518f,-73.2698f, 1.1359f,85.0664f,-81.1452f, 1.1359f,99.4302f,-57.2808f, -57.2425f,83.3396f,42.0334f, -67.0289f,63.5996f,-55.6762f, 
	-76.1367f,48.7393f,-69.4547f, 1.1359f,74.6659f,78.0448f, 1.1359f,38.9312f,84.3101f, -42.6774f,-58.0143f,66.9951f, -28.9574f,-34.8087f,67.6514f, 
	-27.1664f,-37.6551f,75.3333f, -38.8471f,-60.6764f,74.7026f, 1.1359f,-43.8196f,-82.3869f, 1.1359f,-41.2261f,-92.6081f, -30.0798f,4.9841f,97.0037f, 
	-35.8421f,23.8335f,95.1166f, 1.1359f,52.2313f,-108.0245f, -33.9280f,-24.9061f,73.5976f, -22.8535f,-21.7753f,83.9553f, -42.0974f,70.2640f,69.1202f, 
	-82.7800f,60.6186f,-13.2326f, -69.6010f,77.3893f,-16.9264f, 1.1359f,105.6022f,-32.2907f, -33.1780f,99.0184f,-25.3557f, -26.7079f,-26.5276f,-2.3457f, 
	-12.4650f,-44.6201f,-11.7159f, -13.5009f,-46.5521f,-23.3332f, -26.2075f,-45.2005f,-34.6712f, -80.1600f,28.1101f,-76.8286f, -76.6042f,-7.2097f,-27.7157f, 
	-90.6395f,-10.1043f,-35.2048f, -44.8665f,-16.9967f,-2.8705f, -45.9358f,-32.1497f,-20.6924f, -52.9532f,-21.4432f,58.6882f, -81.6309f,-8.5110f,15.4398f, 
	-80.7087f,-23.9795f,12.8097f, -91.4914f,-8.4163f,17.0258f, -94.6990f,-18.1911f,16.3674f, -90.4708f,-29.1118f,41.6394f, -91.0104f,-22.7357f,16.0632f, 
	-78.9937f,-9.8938f,-14.5659f, -77.9724f,-24.0348f,-5.1393f, -88.8446f,-10.1644f,-13.2322f, -90.0869f,-22.8992f,-12.6302f, -84.7921f,-23.5171f,-10.0048f, 
	-60.5555f,-20.1807f,0.4990f, -85.8176f,-27.3248f,-30.2046f, -66.2930f,-8.1000f,69.3133f, -74.6962f,-12.6728f,54.7741f, -90.4708f,-29.1118f,41.6394f, 
	-69.8765f,-63.2630f,62.3783f, -54.0818f,-41.4268f,59.0626f, -52.9532f,-21.4432f,58.6882f, -81.3612f,-14.4392f,59.4608f, -74.6962f,-12.6728f,54.7741f, 
	-80.0845f,-25.6569f,80.3034f, -109.8072f,-3.2575f,64.3257f, -62.1419f,-47.1525f,78.7320f, -69.8765f,-63.2630f,62.3783f, -54.4505f,7.0827f,90.9414f, 
	-57.9464f,30.5166f,89.7941f, -44.6665f,29.8468f,66.8805f, -56.9764f,59.9583f,59.3397f, -7.6715f,-18.6613f,97.1523f, 1.1359f,3.5665f,95.3100f, 
	-66.2930f,-8.1000f,69.3133f, -69.4022f,18.2919f,65.6706f, -57.1250f,38.3637f,54.8431f, -61.0555f,62.6247f,44.8866f, -74.6962f,-12.6728f,54.7741f, 
	-66.2930f,-8.1000f,69.3133f, -61.3933f,-12.5518f,64.1879f, -66.1322f,-15.5339f,58.8616f, -51.8253f,-7.0497f,77.0157f, -27.6422f,9.2367f,83.9249f, 
	-13.1504f,0.3247f,75.0473f, -7.7820f,-7.3652f,72.9027f, -10.2162f,-11.8445f,75.3073f, -38.0077f,-16.8366f,74.8466f, -24.9821f,-14.4131f,79.6717f, 
	-57.4463f,-18.3690f,64.4370f, -64.0893f,8.4896f,40.3838f, -69.2335f,-0.2811f,32.7750f, -43.1797f,29.2583f,37.4697f, -25.5419f,32.3252f,42.7074f, 
	-5.5040f,11.0810f,51.7461f, 0.5676f,-7.1433f,45.5533f, -6.7600f,-18.2130f,52.8979f, -6.0073f,-19.6000f,48.0176f, -37.5143f,-25.1147f,47.9300f, 
	-64.8036f,-24.5660f,32.1692f, -4.7633f,-23.8559f,102.6871f, -16.0145f,-47.9987f,89.1602f, -8.9855f,-21.5086f,100.0934f, 1.1359f,-4.1509f,97.8434f, 
	-8.9855f,-21.5086f,100.0934f, 1.1359f,-51.7012f,114.0700f, 1.1359f,-57.5566f,109.9863f, -3.2178f,-55.0928f,107.4905f, -5.0610f,-52.0769f,110.9537f, 
	1.1359f,-70.1007f,114.8883f, -10.1350f,-67.4703f,108.6277f, -3.6775f,-19.9995f,86.3865f, -18.1650f,-51.6814f,79.9378f, -7.2682f,-41.1215f,115.1010f, 
	-11.9844f,-44.8299f,101.1131f, -9.0857f,-48.1650f,100.8571f, 1.1359f,-10.5147f,81.2805f, -3.6775f,-19.9995f,86.3865f, -4.7633f,-23.8559f,102.6871f, 
	1.1359f,-17.5548f,101.3453f, -7.2682f,-41.1215f,115.1010f, 1.1359f,-38.3493f,107.4022f, 1.1359f,-47.4108f,116.3350f, 1.1359f,-37.9871f,102.2923f, 
	1.1359f,-45.1302f,94.9293f, -11.5378f,-55.1710f,72.1787f, -18.1650f,-51.6814f,79.9378f, -9.0857f,-48.1650f,100.8571f, 1.1359f,-48.0521f,102.2636f, 
	-16.0145f,-47.9987f,89.1602f, -11.9844f,-44.8299f,101.1131f, -69.6010f,77.3893f,-16.9264f, -33.0073f,-34.3247f,29.8010f, -31.9697f,-25.9328f,29.9109f, 
	-33.0073f,-34.3247f,29.8010f, -42.4260f,-51.5871f,39.7332f, -30.0501f,-51.9099f,40.8377f, -25.1276f,-37.4772f,31.6279f, -19.6631f,-38.4533f,44.9298f, 
	-17.1763f,-23.2891f,36.5762f, -47.7398f,-40.1763f,-35.5145f, -68.4458f,-18.3408f,-23.5914f, -52.9263f,-18.6324f,-1.1395f, -44.8665f,-16.9967f,-2.8705f, 
	-45.9358f,-32.1497f,-20.6924f, -63.5189f,-21.8504f,-16.2942f, -24.2720f,-27.3208f,14.1087f, -10.1593f,-16.1620f,-1.2615f, -31.0184f,-27.5091f,16.1783f, 
	-38.5055f,-25.6792f,17.9406f, -31.0184f,-27.5091f,16.1783f, 1.1359f,-45.1725f,44.8594f, 1.1359f,-16.3926f,27.9568f, 1.1359f,-12.6555f,-0.9114f, 
	1.1359f,-49.4843f,-15.1533f, 1.1359f,-47.8435f,-21.6978f, -62.1419f,-47.1525f,78.7320f, -28.9574f,-34.8087f,67.6514f, -42.6774f,-58.0143f,66.9951f, 
	-85.8176f,-27.3248f,-30.2046f, -90.0869f,-22.8992f,-12.6302f, -84.7921f,-23.5171f,-10.0048f, -77.9724f,-24.0348f,-5.1393f, -60.5555f,-20.1807f,0.4990f, 
	-51.5415f,-13.6912f,13.3096f, -12.0237f,-66.6640f,91.4123f, -22.2924f,-65.0439f,86.7058f, -32.5724f,-52.9658f,50.2097f, -30.0501f,-51.9099f,40.8377f, 
	-29.5892f,-55.5465f,53.5347f, -28.8538f,-60.6764f,71.5723f, -31.4174f,-58.0143f,66.9950f, 1.1359f,-70.1006f,104.2372f, -5.7053f,-67.4702f,101.2482f, 
	-19.1238f,-55.6845f,86.7058f, -12.7711f,-57.2462f,91.4123f, 1.1359f,-43.8447f,91.4123f, 1.1359f,-40.3075f,86.7058f, -19.2501f,-41.3275f,48.8053f, 
	-19.6631f,-38.4533f,44.9298f, -25.6244f,-40.9078f,58.2941f, -24.7071f,-48.4506f,71.5722f, 1.1359f,-34.2192f,71.5722f, 1.1359f,-30.0952f,61.2192f, 
	1.1359f,-51.2723f,101.2482f, -3.5024f,-62.2400f,101.2482f, 1.1359f,-63.5038f,103.2650f, 1.1359f,-40.9517f,51.3041f, -19.6631f,-38.4533f,44.9298f, 
	-25.6244f,-40.9078f,58.2941f, -25.6244f,-40.9078f,58.2941f, -31.4174f,-58.0143f,66.9950f, -29.5892f,-55.5465f,53.5347f, -23.1525f,-44.5665f,-37.6955f, 
	-28.0075f,-44.8941f,-48.6592f, -12.5264f,-45.8573f,-27.6241f, -18.2292f,-45.3863f,-69.9657f, 1.1359f,-44.3998f,-77.1488f, 1.1359f,-43.8196f,-82.3869f, 
	-26.2528f,-45.8518f,-73.2698f, 1.1359f,-47.4886f,-27.0427f, -12.5264f,-45.8573f,-27.6241f, -23.2647f,-49.4382f,-37.7557f, -28.1197f,-51.0347f,-48.7194f, 
	-12.6386f,-50.1544f,-27.6843f, 1.1359f,-53.2475f,-27.1029f, -18.3414f,-50.7612f,-70.0259f, 1.1359f,-49.4528f,-77.2090f, -56.9764f,59.9583f,59.3397f, 
	-67.2626f,72.2029f,32.1224f, -61.0555f,62.6247f,44.8866f, -69.6200f,75.0868f,9.3977f, 27.1708f,-34.4217f,-92.8435f, 39.7817f,16.9488f,-112.9776f, 
	56.3318f,-1.6057f,22.5979f, 49.3551f,-11.7429f,32.0608f, 40.4302f,-16.7290f,32.2143f, 25.6815f,-13.7772f,38.5170f, 14.8710f,-5.9891f,38.7835f, 
	18.0499f,2.5378f,37.3877f, 35.2963f,11.2661f,31.1492f, 45.6882f,8.3215f,29.0670f, 54.1616f,4.6925f,27.9956f, 91.3275f,9.8441f,-48.6592f, 
	83.7416f,7.1798f,-82.7709f, 73.4477f,-13.5720f,-81.4220f, 82.4694f,-3.8524f,-33.6530f, 69.3007f,63.5996f,-55.6762f, 74.3567f,70.1446f,-37.5272f, 
	38.0884f,91.1199f,-48.9229f, 40.0922f,77.2215f,-74.6495f, 69.5343f,72.2029f,32.1224f, 71.8918f,75.0868f,9.3977f, 80.3797f,60.6806f,21.3094f, 
	66.5792f,43.2688f,40.9191f, 44.3742f,98.7173f,2.3142f, 34.3676f,90.6309f,55.5181f, 41.2754f,60.6855f,-93.4797f, 40.0922f,77.2215f,-74.6495f, 
	24.0320f,73.1312f,76.4497f, 44.3691f,70.2640f,69.1202f, 34.6798f,41.8143f,80.0476f, 19.3370f,47.1028f,82.7002f, 69.3007f,63.5996f,-55.6762f, 
	78.4084f,48.7393f,-69.4547f, 87.8676f,54.0933f,-35.6234f, 74.3567f,70.1446f,-37.5272f, 70.0294f,-10.7725f,40.0239f, 92.3374f,-7.2858f,36.0221f, 
	78.5344f,0.7303f,39.3965f, 66.2592f,-0.2272f,35.1452f, 30.3965f,-65.5598f,91.4757f, 20.9315f,-66.6641f,101.6766f, 15.5836f,-53.3318f,96.2137f, 
	27.3826f,-51.2734f,83.0323f, 44.6977f,-51.5871f,39.7332f, 47.4747f,-52.9658f,50.2097f, 40.2977f,-29.4775f,44.8896f, 41.9207f,-42.8894f,37.4642f, 
	62.0455f,-35.7219f,-74.1229f, 56.3833f,-42.2233f,-51.3585f, 73.1601f,-58.3773f,-19.2237f, 62.0455f,-35.7219f,-74.1229f, 37.8330f,-39.5563f,-84.5946f, 
	28.5245f,-45.8518f,-73.2698f, 56.3833f,-42.2233f,-51.3585f, 9.1548f,18.4048f,99.7682f, 13.1441f,-2.4242f,89.5567f, 65.8992f,9.2643f,36.7228f, 
	80.0623f,11.2166f,46.0054f, 67.8107f,17.2754f,46.8200f, 74.4047f,40.5582f,25.7796f, 94.3280f,32.7660f,-14.5495f, 95.0347f,29.6651f,-47.0320f, 
	86.9292f,8.0952f,-3.7748f, 83.7416f,7.1798f,-82.7709f, 82.4317f,28.1101f,-76.8286f, 42.4569f,46.9405f,-101.8677f, 17.2955f,-50.9719f,101.7354f, 
	29.6429f,-49.6025f,90.3108f, 68.2649f,-10.2918f,20.9559f, 42.8508f,-15.8404f,24.6319f, 37.0523f,-21.9903f,36.8265f, 73.4477f,-13.5720f,-81.4220f, 
	24.0320f,73.1312f,76.4497f, 63.3272f,62.6247f,44.8866f, 69.5343f,72.2029f,32.1224f, 66.5792f,43.2688f,40.9191f, 59.3967f,38.3638f,54.8431f, 
	71.6739f,18.2919f,65.6706f, 83.6329f,-14.4392f,59.4608f, 97.7962f,-18.3153f,38.8697f, 112.0789f,-3.2575f,64.3258f, 40.2338f,-31.8156f,54.6750f, 
	44.8959f,-55.5465f,56.4920f, 10.1513f,-1.8633f,82.1055f, 56.3833f,-42.2233f,-51.3585f, 28.5245f,-45.8518f,-73.2698f, 34.7835f,-45.4468f,-48.0258f, 
	50.0115f,-40.1763f,-35.5145f, 59.5142f,83.3396f,42.0334f, 69.3007f,63.5996f,-55.6762f, 78.4084f,48.7393f,-69.4547f, 44.9491f,-58.0143f,66.9951f, 
	41.1188f,-60.6764f,74.7026f, 29.4382f,-37.6551f,75.3333f, 31.2291f,-34.8087f,67.6514f, 32.3515f,4.9841f,97.0038f, 38.1138f,23.8335f,95.1166f, 
	25.1252f,-21.7753f,83.9554f, 36.1997f,-24.9061f,73.5976f, 44.3691f,70.2640f,69.1202f, 74.4047f,40.5582f,25.7796f, 67.8107f,17.2754f,46.8200f, 
	85.0517f,60.6186f,-13.2326f, 70.0294f,-10.7725f,40.0239f, 66.2592f,-0.2272f,35.1452f, 86.9292f,8.0952f,-3.7748f, 65.8992f,9.2643f,36.7228f, 
	71.8727f,77.3893f,-16.9264f, 35.4497f,99.0184f,-25.3557f, 28.9796f,-26.5276f,-2.3457f, 28.4792f,-45.2005f,-34.6712f, 15.7726f,-46.5521f,-23.3332f, 
	14.7368f,-44.6201f,-11.7159f, 68.2649f,-10.2918f,20.9559f, 82.4317f,28.1101f,-76.8286f, 92.9112f,-10.1043f,-35.2048f, 78.8759f,-7.2097f,-27.7157f, 
	62.0455f,-35.7219f,-74.1229f, 47.1382f,-16.9968f,-2.8705f, 48.2075f,-32.1497f,-20.6924f, 55.2250f,-21.4432f,58.6882f, 82.9804f,-23.9795f,12.8097f, 
	83.9026f,-8.5110f,15.4398f, 93.7631f,-8.4163f,17.0258f, 96.9707f,-18.1911f,16.3674f, 92.7425f,-29.1118f,41.6394f, 93.2822f,-22.7357f,16.0632f, 
	80.2441f,-24.0348f,-5.1393f, 81.2654f,-9.8938f,-14.5659f, 91.1163f,-10.1644f,-13.2322f, 92.3586f,-22.8992f,-12.6302f, 87.0638f,-23.5171f,-10.0048f, 
	62.8272f,-20.1807f,0.4990f, 88.0893f,-27.3248f,-30.2046f, 80.0623f,11.2166f,46.0054f, 76.9679f,-12.6728f,54.7741f, 68.5647f,-8.1000f,69.3133f, 
	92.7425f,-29.1118f,41.6394f, 55.2250f,-21.4432f,58.6882f, 56.3536f,-41.4268f,59.0626f, 72.1482f,-63.2630f,62.3783f, 83.6329f,-14.4392f,59.4608f, 
	112.0789f,-3.2575f,64.3258f, 82.3562f,-25.6569f,80.3034f, 76.9679f,-12.6728f,54.7741f, 31.2291f,-34.8087f,67.6514f, 36.1997f,-24.9061f,73.5976f, 
	64.4136f,-47.1525f,78.7320f, 72.1482f,-63.2630f,62.3783f, 92.7425f,-29.1118f,41.6394f, 72.1482f,-63.2630f,62.3783f, 60.2181f,30.5166f,89.7941f, 
	56.7222f,7.0827f,90.9414f, 46.9382f,29.8468f,66.8805f, 59.2482f,59.9583f,59.3397f, 9.9432f,-18.6613f,97.1523f, 68.5647f,-8.1000f,69.3133f, 
	71.6739f,18.2919f,65.6706f, 59.3967f,38.3638f,54.8431f, 63.3272f,62.6247f,44.8866f, 71.6739f,18.2919f,65.6706f, 76.9679f,-12.6728f,54.7741f, 
	68.4039f,-15.5339f,58.8617f, 63.6650f,-12.5517f,64.1879f, 68.5647f,-8.1000f,69.3133f, 54.0970f,-7.0497f,77.0157f, 29.9139f,9.2367f,83.9249f, 
	15.4221f,0.3247f,75.0473f, 10.0537f,-7.3652f,72.9027f, 12.4879f,-11.8445f,75.3073f, 27.2538f,-14.4131f,79.6717f, 40.2794f,-16.8366f,74.8467f, 
	59.7181f,-18.3690f,64.4371f, 82.3562f,-25.6569f,80.3034f, 71.5052f,-0.2811f,32.7750f, 66.3610f,8.4896f,40.3838f, 45.4515f,29.2583f,37.4697f, 
	27.8136f,32.3252f,42.7074f, 7.7758f,11.0810f,51.7461f, 1.7041f,-7.1433f,45.5533f, 8.2790f,-19.6000f,48.0176f, 9.0317f,-18.2130f,52.8979f, 
	39.7860f,-25.1147f,47.9300f, 67.0753f,-24.5661f,32.1692f, 59.7181f,-18.3690f,64.4371f, 67.0753f,-24.5661f,32.1692f, 71.5052f,-0.2811f,32.7750f, 
	68.4039f,-15.5339f,58.8617f, 7.0350f,-23.8559f,102.6871f, 11.2572f,-21.5086f,100.0934f, 18.2862f,-47.9988f,89.1602f, 11.2572f,-21.5086f,100.0934f, 
	7.3327f,-52.0769f,110.9537f, 5.4895f,-55.0928f,107.4905f, 12.4068f,-67.4703f,108.6277f, 20.4367f,-51.6814f,79.9378f, 5.9493f,-19.9995f,86.3865f, 
	9.5400f,-41.1215f,115.1010f, 11.3574f,-48.1650f,100.8572f, 14.2561f,-44.8299f,101.1131f, 7.0350f,-23.8559f,102.6871f, 5.9493f,-19.9995f,86.3865f, 
	9.5400f,-41.1215f,115.1010f, 13.8095f,-55.1710f,72.1787f, 20.4367f,-51.6814f,79.9378f, 11.3574f,-48.1650f,100.8572f, 18.2862f,-47.9988f,89.1602f, 
	14.2561f,-44.8299f,101.1131f, 35.4497f,99.0184f,-25.3557f, 38.0884f,91.1199f,-48.9229f, 74.3567f,70.1446f,-37.5272f, 71.8727f,77.3893f,-16.9264f, 
	34.2414f,-25.9328f,29.9109f, 35.2790f,-34.3247f,29.8010f, 35.2790f,-34.3247f,29.8010f, 27.3993f,-37.4772f,31.6279f, 32.3219f,-51.9099f,40.8377f, 
	44.6977f,-51.5871f,39.7332f, 19.4480f,-23.2891f,36.5762f, 21.9349f,-38.4534f,44.9298f, 50.0115f,-40.1763f,-35.5145f, 70.7175f,-18.3408f,-23.5914f, 
	73.1601f,-58.3773f,-19.2237f, 56.3833f,-42.2233f,-51.3585f, 55.1980f,-18.6324f,-1.1395f, 65.7907f,-21.8504f,-16.2942f, 48.2075f,-32.1497f,-20.6924f, 
	47.1382f,-16.9968f,-2.8705f, 12.4310f,-16.1620f,-1.2615f, 26.5437f,-27.3208f,14.1087f, 33.2901f,-27.5091f,16.1783f, 33.2901f,-27.5091f,16.1783f, 
	40.7772f,-25.6793f,17.9406f, 56.3536f,-41.4268f,59.0626f, 64.4136f,-47.1525f,78.7320f, 31.2291f,-34.8087f,67.6514f, 64.4136f,-47.1525f,78.7320f, 
	44.9491f,-58.0143f,66.9951f, 48.2075f,-32.1497f,-20.6924f, 65.7907f,-21.8504f,-16.2942f, 88.0893f,-27.3248f,-30.2046f, 87.0638f,-23.5171f,-10.0048f, 
	92.3586f,-22.8992f,-12.6302f, 80.2441f,-24.0348f,-5.1393f, 62.8272f,-20.1807f,0.4990f, 80.2441f,-24.0348f,-5.1393f, 53.8132f,-13.6912f,13.3096f, 
	82.4694f,-3.8524f,-33.6530f, 78.8759f,-7.2097f,-27.7157f, 14.2954f,-66.6640f,91.4123f, 24.5641f,-65.0439f,86.7058f, 34.8441f,-52.9658f,50.2097f, 
	32.3219f,-51.9099f,40.8377f, 31.8609f,-55.5465f,53.5347f, 31.1255f,-60.6764f,71.5723f, 33.6891f,-58.0143f,66.9951f, 7.9771f,-67.4702f,101.2482f, 
	21.3955f,-55.6845f,86.7058f, 15.0428f,-57.2462f,91.4123f, 21.5219f,-41.3275f,48.8053f, 21.9349f,-38.4534f,44.9298f, 27.8961f,-40.9078f,58.2941f, 
	26.9788f,-48.4506f,71.5722f, 5.7742f,-62.2400f,101.2482f, 21.9349f,-38.4534f,44.9298f, 27.8961f,-40.9078f,58.2941f, 27.8961f,-40.9078f,58.2941f, 
	33.6891f,-58.0143f,66.9951f, 31.8609f,-55.5465f,53.5347f, 25.4242f,-44.5665f,-37.6955f, 30.2793f,-44.8941f,-48.6592f, 14.7981f,-45.8573f,-27.6241f, 
	20.5009f,-45.3863f,-69.9657f, 28.5245f,-45.8518f,-73.2698f, 14.7981f,-45.8573f,-27.6241f, 25.5364f,-49.4382f,-37.7557f, 30.3914f,-51.0348f,-48.7194f, 
	14.9103f,-50.1544f,-27.6843f, 20.6131f,-50.7613f,-70.0259f, 59.2482f,59.9583f,59.3397f, 69.5343f,72.2029f,32.1224f, 63.3272f,62.6247f,44.8866f, 
	71.8918f,75.0868f,9.3977f, 44.3742f,98.7173f,2.3142f, 71.8918f,75.0868f,9.3977f, 
_NULL_ }; /* End of skull4_Vertices */

const float skull4_UV[] = {
	0.8949f,0.4083f,0.9280f,0.3763f,0.8937f,0.4073f,0.8660f,0.4221f,0.8707f,0.6458f,0.8763f,0.6516f,0.8844f,0.6556f,0.8937f,0.6621f,0.9025f,0.6870f,0.8998f,0.6982f,0.8847f,0.6970f,0.8707f,0.6791f,0.8682f,0.6697f,0.8584f,0.5196f,0.8542f,0.5463f,
	0.8521f,0.4636f,0.8606f,0.4653f,0.8977f,0.5078f,0.9203f,0.4809f,0.9260f,0.5167f,0.8976f,0.5319f,0.9011f,0.6205f,0.8901f,0.6441f,0.8904f,0.6087f,0.9009f,0.5917f,0.9515f,0.6421f,0.9281f,0.6481f,0.9246f,0.5810f,0.9534f,0.5843f,0.9436f,0.4413f,
	0.9485f,0.4706f,0.9203f,0.4809f,0.9135f,0.4514f,0.9294f,0.6831f,0.9235f,0.7089f,0.9100f,0.7035f,0.9151f,0.6707f,0.8977f,0.5078f,0.8976f,0.5319f,0.8836f,0.5350f,0.8861f,0.4882f,0.8561f,0.6674f,0.8655f,0.6577f,0.8593f,0.6562f,0.8470f,0.6476f,
	0.8293f,0.7999f,0.8485f,0.7844f,0.8564f,0.8123f,0.8349f,0.8216f,0.8360f,0.7098f,0.8466f,0.7035f,0.8602f,0.7069f,0.8328f,0.7231f,0.8408f,0.4734f,0.8146f,0.5855f,0.8382f,0.5216f,0.8408f,0.4734f,0.8382f,0.5216f,0.8535f,0.4683f,0.8528f,0.4440f,
	0.9261f,0.7447f,0.9192f,0.7550f,0.9038f,0.7604f,0.9192f,0.7542f,0.8719f,0.6553f,0.8843f,0.6235f,0.8756f,0.6635f,0.8650f,0.6592f,0.8699f,0.5662f,0.8596f,0.5893f,0.8679f,0.5206f,0.8606f,0.4653f,0.9069f,0.4358f,0.8735f,0.4764f,0.8486f,0.7883f,
	0.8575f,0.8135f,0.8690f,0.6923f,0.8696f,0.6650f,0.8574f,0.6409f,0.8521f,0.4636f,0.9460f,0.6900f,0.9294f,0.6831f,0.9007f,0.6412f,0.8920f,0.6663f,0.8739f,0.6837f,0.8462f,0.6854f,0.8410f,0.6695f,0.8370f,0.6523f,0.8582f,0.7223f,0.8316f,0.7360f,
	0.9155f,0.7657f,0.9069f,0.7537f,0.8382f,0.5216f,0.8439f,0.5575f,0.8491f,0.5334f,0.8535f,0.4683f,0.9485f,0.4706f,0.9517f,0.5055f,0.9109f,0.6301f,0.8977f,0.5078f,0.8861f,0.4882f,0.9460f,0.6900f,0.9349f,0.7238f,0.8289f,0.7510f,0.8623f,0.7496f,
	0.8611f,0.7628f,0.8282f,0.7662f,0.8823f,0.4345f,0.8850f,0.4061f,0.8921f,0.7496f,0.8987f,0.7302f,0.9395f,0.4208f,0.8672f,0.7446f,0.8789f,0.7630f,0.9151f,0.6707f,0.8880f,0.5641f,0.9018f,0.5581f,0.9530f,0.5391f,0.9299f,0.5471f,0.8716f,0.6326f,
	0.8670f,0.6343f,0.8639f,0.6058f,0.8542f,0.5691f,0.8735f,0.4764f,0.8537f,0.5575f,0.8448f,0.5426f,0.8657f,0.6161f,0.8524f,0.5873f,0.8568f,0.7084f,0.8503f,0.6239f,0.8395f,0.6258f,0.8456f,0.6215f,0.8374f,0.6220f,0.8312f,0.6629f,0.8358f,0.6248f,
	0.8506f,0.5791f,0.8408f,0.5987f,0.8456f,0.5781f,0.8360f,0.5814f,0.8380f,0.5877f,0.8532f,0.6152f,0.8346f,0.5543f,0.8588f,0.7040f,0.8509f,0.6832f,0.8312f,0.6629f,0.8102f,0.7195f,0.8389f,0.7198f,0.8568f,0.7084f,0.8462f,0.6854f,0.8509f,0.6832f,
	0.8386f,0.7156f,0.8410f,0.6695f,0.8292f,0.7393f,0.8102f,0.7195f,0.8762f,0.7265f,0.8875f,0.7089f,0.8957f,0.6910f,0.9020f,0.6603f,0.8955f,0.7858f,0.9189f,0.7678f,0.8588f,0.7040f,0.8739f,0.6837f,0.8920f,0.6663f,0.9007f,0.6412f,0.8509f,0.6832f,
	0.8588f,0.7040f,0.8585f,0.7038f,0.8535f,0.6955f,0.8684f,0.7222f,0.8967f,0.7340f,0.9034f,0.7404f,0.9035f,0.7485f,0.8980f,0.7540f,0.8707f,0.7367f,0.8829f,0.7503f,0.8565f,0.7103f,0.8711f,0.6604f,0.8625f,0.6516f,0.8964f,0.6554f,0.9106f,0.6680f,
	0.9166f,0.7057f,0.9120f,0.7177f,0.8967f,0.7342f,0.8964f,0.7293f,0.8644f,0.7086f,0.8473f,0.6649f,0.8943f,0.7984f,0.8600f,0.7978f,0.8919f,0.7904f,0.9144f,0.7780f,0.8919f,0.7904f,0.8734f,0.8411f,0.8662f,0.8436f,0.8644f,0.8346f,0.8661f,0.8327f,
	0.8484f,0.8587f,0.8410f,0.8383f,0.8985f,0.7792f,0.8539f,0.7890f,0.8759f,0.8237f,0.8672f,0.8106f,0.8664f,0.8164f,0.9104f,0.7672f,0.8985f,0.7792f,0.8943f,0.7984f,0.9055f,0.7951f,0.8759f,0.8237f,0.8878f,0.8222f,0.8784f,0.8386f,0.8882f,0.8174f,
	0.8809f,0.8183f,0.8558f,0.7910f,0.8539f,0.7890f,0.8664f,0.8164f,0.8776f,0.8278f,0.8600f,0.7978f,0.8672f,0.8106f,0.9018f,0.5581f,0.8596f,0.6915f,0.8679f,0.6865f,0.8596f,0.6915f,0.8360f,0.7098f,0.8440f,0.7247f,0.8629f,0.7039f,0.8666f,0.7308f,
	0.8827f,0.7068f,0.8439f,0.5575f,0.8501f,0.5692f,0.8591f,0.6157f,0.8657f,0.6161f,0.8524f,0.5873f,0.8502f,0.5849f,0.8730f,0.6664f,0.8949f,0.6379f,0.8673f,0.6651f,0.8632f,0.6615f,0.8673f,0.6651f,0.8808f,0.7590f,0.9063f,0.6998f,0.9089f,0.6421f,
	0.8760f,0.6410f,0.8779f,0.6217f,0.8292f,0.7393f,0.8623f,0.7496f,0.8289f,0.7510f,0.8346f,0.5543f,0.8360f,0.5814f,0.8380f,0.5877f,0.8408f,0.5987f,0.8532f,0.6152f,0.8637f,0.6387f,0.8404f,0.8204f,0.8342f,0.8018f,0.8411f,0.7366f,0.8440f,0.7247f,
	0.8403f,0.7464f,0.8348f,0.7741f,0.8362f,0.7637f,0.8484f,0.8508f,0.8452f,0.8377f,0.8484f,0.7984f,0.8521f,0.8117f,0.8822f,0.8136f,0.8859f,0.8051f,0.8641f,0.7394f,0.8666f,0.7308f,0.8591f,0.7458f,0.8520f,0.7696f,0.8918f,0.7819f,0.8955f,0.7645f,
	0.8739f,0.8303f,0.8548f,0.8358f,0.8581f,0.8440f,0.8852f,0.7635f,0.8666f,0.7308f,0.8591f,0.7458f,0.8591f,0.7458f,0.8362f,0.7637f,0.8403f,0.7464f,0.8574f,0.5624f,0.8531f,0.5327f,0.8656f,0.5948f,0.8608f,0.4758f,0.8817f,0.4502f,0.8823f,0.4345f,
	0.8535f,0.4683f,0.8783f,0.6063f,0.8656f,0.5948f,0.8521f,0.5638f,0.8465f,0.5335f,0.8607f,0.5969f,0.8716f,0.6103f,0.8548f,0.4749f,0.8761f,0.4482f,0.9020f,0.6603f,0.9011f,0.6205f,0.9007f,0.6412f,0.9009f,0.5917f,0.9260f,0.3970f,0.9658f,0.3864f,
	0.9823f,0.6970f,0.9705f,0.7257f,0.9559f,0.7301f,0.9371f,0.7294f,0.9282f,0.7146f,0.9362f,0.7047f,0.9591f,0.6918f,0.9706f,0.6942f,0.9804f,0.6982f,0.0269f,0.5307f,0.0181f,0.4464f,0.0061f,0.4397f,0.0180f,0.5746f,0.9999f,0.5097f,1.0042f,0.5398f,
	0.9764f,0.5185f,0.9764f,0.4785f,0.0001f,0.6448f,0.0020f,0.6113f,0.0097f,0.6371f,-0.0028f,0.6792f,0.9817f,0.5900f,0.9736f,0.6601f,0.9752f,0.4441f,0.9764f,0.4785f,0.9630f,0.6941f,0.9790f,0.6910f,0.9661f,0.7262f,0.9533f,0.7208f,-0.0001f,0.5097f,
	0.0086f,0.4844f,0.0169f,0.5466f,0.0042f,0.5398f,0.0009f,0.7400f,0.0323f,0.7253f,0.0121f,0.7225f,-0.0042f,0.7174f,0.8991f,0.8704f,0.8805f,0.8691f,0.8903f,0.8430f,0.9112f,0.8399f,0.9438f,0.8040f,0.9487f,0.8231f,0.9498f,0.7696f,0.9446f,0.7821f,
	0.9859f,0.4512f,0.9731f,0.5404f,1.0099f,0.6936f,0.9859f,0.4512f,0.9395f,0.4148f,0.9185f,0.4545f,0.9731f,0.5404f,0.9341f,0.7616f,0.9282f,0.7746f,0.9956f,0.7080f,1.0130f,0.7192f,0.9981f,0.7138f,1.0050f,0.6592f,0.0260f,0.5940f,0.0272f,0.5300f,
	0.0219f,0.6344f,1.0181f,0.4464f,1.0141f,0.4665f,0.9743f,0.4244f,0.8955f,0.8464f,0.9168f,0.8460f,0.9983f,0.7066f,0.9598f,0.7165f,0.9486f,0.7439f,1.0061f,0.4397f,0.9630f,0.6941f,0.9947f,0.6685f,1.0001f,0.6448f,0.9972f,0.6792f,0.9899f,0.7024f,
	1.0026f,0.7379f,0.0216f,0.7719f,0.0439f,0.7436f,0.0564f,0.7533f,0.9484f,0.7872f,0.9410f,0.8339f,0.9253f,0.7644f,0.9731f,0.5404f,0.9185f,0.4545f,0.9297f,0.5515f,0.9614f,0.5981f,0.9922f,0.6503f,0.9999f,0.5097f,1.0086f,0.4844f,0.9390f,0.8499f,
	0.9277f,0.8590f,0.9270f,0.8140f,0.9320f,0.8025f,0.9536f,0.7822f,0.9656f,0.7611f,0.9318f,0.7986f,0.9458f,0.7977f,0.9790f,0.6910f,0.0050f,0.6592f,-0.0019f,0.7138f,0.0139f,0.5830f,1.0009f,0.7400f,0.9958f,0.7174f,1.0219f,0.6344f,-0.0044f,0.7080f,
	0.0020f,0.5708f,0.9754f,0.5514f,0.9342f,0.6686f,0.9191f,0.5975f,0.8982f,0.6271f,0.8987f,0.6572f,-0.0017f,0.7066f,0.0141f,0.4665f,0.0339f,0.5733f,0.0135f,0.5927f,-0.0141f,0.4512f,0.9657f,0.6627f,0.9617f,0.6360f,-0.0231f,0.7816f,0.0227f,0.7098f,
	0.0208f,0.6923f,0.0346f,0.6930f,0.0426f,0.7038f,0.0406f,0.7669f,0.0388f,0.7113f,0.0182f,0.6695f,0.0173f,0.6284f,0.0314f,0.6304f,0.0374f,0.6460f,0.0292f,0.6551f,-0.0106f,0.6780f,0.0321f,0.6023f,0.0130f,0.7192f,0.0113f,0.7640f,-0.0012f,0.7764f,
	1.0406f,0.7669f,0.9769f,0.7816f,0.9733f,0.8163f,1.0079f,0.8658f,0.0216f,0.7719f,0.0564f,0.7533f,0.0220f,0.8136f,0.0113f,0.7640f,-0.0680f,0.8025f,-0.0542f,0.7977f,-0.0111f,0.8494f,0.0079f,0.8658f,0.0406f,0.7669f,0.0079f,0.8658f,0.9902f,0.7517f,
	0.9840f,0.7794f,0.9761f,0.7248f,0.9910f,0.6888f,0.9146f,0.7984f,0.9988f,0.7764f,1.0026f,0.7379f,0.9899f,0.7024f,0.9947f,0.6685f,0.0026f,0.7379f,1.0113f,0.7640f,0.9985f,0.7742f,0.9914f,0.7763f,0.9988f,0.7764f,0.9783f,0.7824f,0.9523f,0.7629f,
	0.9322f,0.7567f,0.9220f,0.7598f,0.9221f,0.7692f,0.9388f,0.7857f,0.9556f,0.7895f,0.9847f,0.7849f,1.0220f,0.8136f,1.0028f,0.7137f,0.9962f,0.7146f,0.9744f,0.6855f,0.9572f,0.6866f,0.9294f,0.7122f,0.9131f,0.7184f,0.9120f,0.7400f,0.9138f,0.7458f,
	0.9512f,0.7670f,0.9961f,0.7488f,-0.0153f,0.7849f,-0.0039f,0.7488f,0.0028f,0.7137f,-0.0015f,0.7742f,0.9074f,0.8073f,0.9141f,0.8052f,0.9003f,0.8328f,0.9141f,0.8052f,0.8805f,0.8452f,0.8745f,0.8438f,0.8664f,0.8652f,0.8995f,0.8309f,0.9090f,0.7863f,
	0.8953f,0.8386f,0.8903f,0.8367f,0.8979f,0.8357f,0.9074f,0.8073f,0.9090f,0.7863f,0.8953f,0.8386f,0.8855f,0.8205f,0.8995f,0.8309f,0.8903f,0.8367f,0.9003f,0.8328f,0.8979f,0.8357f,-0.0246f,0.5514f,-0.0236f,0.5185f,0.0042f,0.5398f,0.0020f,0.5708f,
	0.9423f,0.7366f,0.9388f,0.7502f,0.9388f,0.7502f,0.9240f,0.7526f,0.9193f,0.7956f,0.9438f,0.8040f,0.9232f,0.7348f,0.9149f,0.7707f,-0.0386f,0.5981f,0.0021f,0.6143f,0.0099f,0.6936f,-0.0269f,0.5404f,0.9775f,0.6709f,0.9941f,0.6383f,0.9617f,0.6360f,
	0.9657f,0.6627f,0.9192f,0.6505f,0.9302f,0.7042f,0.9399f,0.7128f,0.9399f,0.7128f,0.9524f,0.7175f,-0.0267f,0.8163f,-0.0111f,0.8494f,0.9320f,0.8025f,0.9889f,0.8494f,0.9390f,0.8499f,-0.0383f,0.6360f,-0.0059f,0.6383f,0.0321f,0.6023f,0.0292f,0.6551f,
	0.0374f,0.6460f,0.0182f,0.6695f,0.9894f,0.6780f,1.0182f,0.6695f,0.9765f,0.6950f,1.0180f,0.5746f,1.0135f,0.5927f,0.8703f,0.8534f,0.8891f,0.8595f,0.9229f,0.8130f,0.9193f,0.7956f,0.9146f,0.8189f,0.9071f,0.8466f,0.9153f,0.8403f,0.8605f,0.8545f,
	0.8963f,0.8436f,0.8846f,0.8431f,0.9117f,0.7802f,0.9149f,0.7707f,0.9219f,0.7978f,0.9135f,0.8239f,0.8654f,0.8465f,0.9149f,0.7707f,0.9219f,0.7978f,0.9219f,0.7978f,0.9153f,0.8403f,0.9146f,0.8189f,0.9147f,0.5850f,0.9224f,0.5476f,0.8975f,0.6127f,
	0.9063f,0.4686f,0.9185f,0.4545f,0.8975f,0.6127f,0.9101f,0.5889f,0.9167f,0.5507f,0.8930f,0.6166f,0.9008f,0.4667f,0.9910f,0.6888f,1.0001f,0.6448f,0.9947f,0.6685f,1.0020f,0.6113f,-0.0183f,0.5900f,0.0020f,0.6113f,
_NULL_ }; /* End of skull4_UV */

const float skull4_Normals[] = {
	-0.0000f,-0.3010f,-0.9536f, -0.0000f,0.0264f,-0.9997f, -0.3854f,-0.0590f,-0.9209f, -0.2043f,-0.5099f,-0.8356f, -0.1589f,-0.0525f,0.9859f, 0.2001f,-0.6764f,0.7088f, -0.2514f,-0.2522f,0.9345f, -0.2453f,0.1941f,0.9498f, -0.2738f,0.1362f,0.9521f, -0.1109f,0.1202f,0.9865f, -0.3319f,0.1957f,0.9228f, -0.2985f,0.2686f,0.9159f, 0.4142f,0.7569f,0.5055f, -0.9334f,-0.3537f,-0.0606f, -0.9961f,-0.0580f,0.0659f, 
	-0.8710f,-0.4824f,-0.0931f, -0.9392f,-0.2461f,-0.2395f, -0.5585f,0.7301f,-0.3938f, -0.4198f,0.8057f,-0.4178f, -0.4211f,0.8450f,-0.3296f, -0.5455f,0.7792f,-0.3087f, -0.8438f,0.2829f,0.4561f, -0.8703f,0.0731f,0.4871f, -0.8959f,0.2462f,0.3699f, -0.7992f,0.5910f,0.1094f, -0.0000f,0.9267f,0.3758f, -0.3058f,0.8218f,0.4807f, -0.4127f,0.9103f,0.0323f, -0.0000f,0.9973f,0.0728f, -0.0000f,0.6462f,-0.7632f, 
	-0.0000f,0.6609f,-0.7505f, -0.4192f,0.6792f,-0.6024f, -0.3925f,0.6104f,-0.6880f, -0.1980f,0.2055f,0.9584f, -0.0800f,0.3651f,0.9275f, -0.4750f,0.4998f,0.7242f, -0.5075f,0.1034f,0.8554f, -0.6897f,0.6424f,-0.3340f, -0.7539f,0.6038f,-0.2590f, -0.8743f,0.4627f,-0.1468f, -0.8193f,0.4620f,-0.3395f, -0.6749f,-0.5118f,-0.5316f, -0.9028f,0.1030f,-0.4176f, -0.5906f,0.3660f,-0.7192f, -0.6738f,0.7152f,0.1856f, 
	-0.7303f,-0.5184f,0.4449f, -0.7440f,0.1414f,0.6530f, -0.7176f,-0.2931f,0.6317f, -0.6421f,-0.4904f,0.5892f, -0.8249f,-0.4668f,-0.3189f, -0.8931f,0.1756f,-0.4142f, -0.8595f,-0.3425f,-0.3795f, -0.8721f,-0.4866f,-0.0510f, -0.7673f,-0.5469f,-0.3350f, -0.1745f,-0.8007f,0.5731f, 0.3498f,-0.8975f,-0.2686f, -0.3734f,-0.7321f,-0.5697f, -0.2788f,-0.9395f,-0.1990f, -0.1673f,-0.9201f,-0.3543f, -0.3076f,-0.7412f,-0.5967f, 
	-0.0000f,-0.2505f,0.9681f, -0.0000f,-0.0940f,0.9956f, 0.4861f,-0.5399f,0.6872f, 0.4264f,0.0098f,0.9045f, -0.9772f,0.0614f,-0.2035f, -0.8940f,-0.0933f,0.4383f, -0.8663f,0.4816f,-0.1327f, -0.8612f,0.4492f,-0.2380f, -0.9844f,0.0330f,0.1727f, -0.9011f,-0.3423f,0.2662f, -0.9813f,0.1059f,-0.1609f, -0.5300f,-0.0444f,-0.8468f, -0.4124f,0.3997f,-0.8186f, -0.5969f,0.3094f,-0.7403f, -0.5337f,-0.7565f,0.3779f, 
	-0.8094f,-0.2216f,0.5438f, -0.5334f,-0.6284f,-0.5662f, -0.5189f,-0.8548f,0.0087f, -0.7236f,-0.6724f,0.1559f, -0.3496f,-0.2874f,-0.8917f, -0.0000f,0.7692f,0.6391f, -0.1835f,0.7077f,0.6823f, -0.8816f,0.0520f,0.4692f, -0.9222f,0.2079f,0.3262f, -0.9291f,0.3565f,0.0986f, -0.0744f,0.9749f,0.2100f, -0.7207f,0.3807f,-0.5794f, -0.9547f,0.2838f,-0.0892f, -0.5724f,-0.8142f,-0.0970f, -0.7432f,-0.6635f,-0.0861f, 
	-0.0000f,0.7928f,0.6095f, 0.1102f,-0.2628f,0.9585f, -0.1623f,-0.9814f,0.1024f, -0.2072f,-0.9266f,0.3137f, -0.1816f,-0.9803f,0.0779f, -0.0356f,-0.9991f,-0.0210f, -0.0000f,0.8568f,-0.5157f, -0.0000f,0.9218f,-0.3877f, -0.6414f,0.6640f,0.3844f, -0.5500f,0.6961f,-0.4614f, -0.5724f,0.5424f,-0.6149f, -0.0000f,0.1727f,0.9850f, -0.0000f,0.3869f,0.9221f, -0.9189f,-0.2997f,0.2565f, -0.7607f,-0.1274f,0.6365f, 
	-0.8889f,0.0757f,0.4517f, -0.7802f,-0.5487f,0.3003f, -0.0000f,-0.9573f,-0.2892f, -0.0000f,-0.6870f,-0.7267f, -0.0939f,-0.1059f,0.9899f, -0.1450f,0.3189f,0.9366f, -0.0000f,0.5053f,-0.8629f, -0.3278f,-0.4532f,0.8289f, -0.7090f,-0.0399f,0.7041f, -0.5641f,0.6319f,0.5315f, -0.8799f,0.4738f,0.0356f, -0.7823f,0.6224f,-0.0257f, -0.0000f,0.9873f,-0.1590f, -0.3600f,0.9179f,-0.1668f, -0.5555f,-0.8145f,0.1672f, 
	-0.2676f,-0.7955f,0.5437f, -0.3221f,-0.9313f,0.1700f, -0.3083f,-0.8695f,0.3859f, -0.8930f,0.2256f,-0.3895f, -0.8589f,-0.4258f,0.2847f, -0.7518f,0.3816f,-0.5377f, -0.3840f,-0.8781f,0.2853f, -0.0940f,-0.7904f,0.6053f, 0.8169f,0.3898f,-0.4251f, 0.8169f,0.3898f,-0.4251f, 0.8440f,0.1384f,-0.5182f, 0.1665f,0.9835f,-0.0710f, -0.8989f,0.4370f,-0.0306f, -0.8927f,-0.4413f,-0.0912f, -0.1890f,-0.9537f,-0.2338f, 
	0.9953f,0.0448f,0.0854f, 0.9744f,0.1690f,0.1480f, 0.0003f,0.9983f,-0.0577f, -0.9915f,0.0924f,-0.0921f, -0.0829f,-0.9965f,0.0101f, -0.3458f,0.7623f,0.5471f, -0.9635f,0.0820f,-0.2547f, -0.8928f,0.0119f,0.4503f, -0.4805f,0.5301f,0.6986f, -0.6790f,-0.5841f,-0.4447f, 0.3941f,-0.7262f,-0.5634f, 0.3740f,-0.6498f,-0.6618f, -0.3921f,-0.4925f,-0.7770f, 0.2275f,0.8632f,0.4507f, 0.0956f,0.8790f,0.4672f, 
	-0.4290f,-0.2283f,0.8740f, -0.1550f,0.3794f,0.9122f, -0.2098f,-0.1800f,0.9610f, -0.5920f,-0.4163f,0.6901f, -0.6006f,-0.0505f,0.7979f, -0.6056f,0.5831f,0.5415f, -0.6769f,0.6260f,0.3872f, -0.7898f,-0.0483f,0.6114f, -0.8314f,0.4458f,0.3316f, 0.0000f,0.9819f,0.1892f, -0.8731f,-0.0673f,0.4828f, -0.8068f,0.4347f,0.4002f, -0.7020f,0.1400f,0.6983f, -0.9636f,-0.0481f,0.2631f, 0.0732f,0.8826f,0.4644f, 
	-0.2143f,-0.8296f,0.5157f, -0.3048f,-0.8439f,0.4416f, -0.5033f,-0.4816f,0.7174f, -0.2965f,-0.6977f,0.6521f, -0.0048f,-0.9507f,-0.3100f, -0.5535f,-0.8299f,-0.0703f, -0.7190f,-0.5998f,0.3510f, -0.9802f,0.1251f,0.1532f, -0.2856f,-0.2860f,0.9147f, -0.2856f,-0.2860f,0.9147f, 0.0557f,0.8748f,0.4813f, 0.7819f,-0.4205f,-0.4602f, 0.9141f,-0.2932f,-0.2801f, 0.7658f,-0.5483f,-0.3360f, 0.5893f,-0.7173f,-0.3718f, 
	-0.6540f,-0.5820f,-0.4833f, -0.8247f,-0.5044f,-0.2559f, -0.9011f,0.3601f,-0.2413f, -0.9011f,0.3601f,-0.2413f, -0.1641f,0.9419f,-0.2930f, 0.0268f,0.9805f,-0.1944f, 0.1598f,-0.5382f,0.8276f, 0.6788f,0.6202f,-0.3933f, -0.8493f,0.5145f,0.1186f, -0.0000f,0.3247f,0.9458f, -0.4750f,0.4516f,0.7553f, -0.0000f,-0.5699f,0.8217f, -0.0000f,0.0022f,1.0000f, -0.5654f,-0.2870f,0.7733f, -0.5383f,-0.5612f,0.6287f, 
	-0.0000f,-0.5312f,0.8473f, -0.5691f,-0.4942f,0.6572f, 0.9116f,-0.4095f,-0.0362f, 0.0429f,0.9244f,-0.3791f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, -0.0000f,-0.6778f,0.7352f, 0.0936f,0.1318f,0.9868f, 0.3287f,-0.0071f,0.9444f, -0.0000f,-0.3499f,0.9368f, -0.6180f,0.4318f,0.6570f, 0.0000f,0.9741f,-0.2262f, -0.0000f,-0.0710f,0.9975f, -0.0000f,-0.0560f,0.9984f, 
	0.0000f,0.4391f,0.8984f, -0.1854f,-0.1220f,0.9751f, 0.5930f,-0.4120f,0.6918f, -0.2794f,0.9116f,-0.3015f, 0.0000f,0.9183f,-0.3959f, -0.3407f,0.9086f,0.2417f, -0.8498f,0.2546f,0.4616f, -0.5739f,0.8104f,-0.1181f, -0.8895f,0.1157f,-0.4420f, -0.9614f,-0.2485f,-0.1177f, -0.1246f,-0.7327f,-0.6691f, 0.0622f,-0.5230f,-0.8500f, 0.3105f,-0.5688f,-0.7617f, 0.5116f,-0.6396f,-0.5738f, 0.4852f,-0.5249f,-0.6993f, 
	0.4107f,-0.7074f,-0.5752f, 0.4381f,-0.7492f,0.4968f, -0.0855f,-0.8749f,0.4768f, 0.0260f,-0.9714f,0.2360f, 0.1718f,-0.9822f,0.0754f, -0.4035f,-0.8051f,0.4347f, -0.2416f,-0.9704f,-0.0067f, 0.3314f,-0.9420f,-0.0524f, 0.4717f,-0.7197f,0.5095f, -0.1862f,-0.9329f,-0.3083f, -0.5149f,-0.8467f,0.1337f, -0.4719f,-0.8757f,-0.1019f, 0.0000f,-0.4858f,-0.8741f, -0.0000f,-0.9052f,-0.4249f, -0.0000f,-0.8891f,0.4576f, 
	-0.0000f,-0.9410f,0.3384f, -0.0000f,-0.9972f,-0.0746f, 0.6490f,-0.7595f,0.0449f, -0.5791f,-0.6942f,0.4274f, -0.7577f,-0.6525f,0.0077f, -0.7434f,-0.6622f,0.0941f, -0.2069f,-0.9595f,0.1914f, 0.0992f,-0.9950f,0.0101f, 0.0979f,-0.9820f,-0.1614f, -0.1158f,-0.9755f,0.1868f, -0.3307f,-0.8936f,0.3034f, 0.4916f,-0.6494f,-0.5802f, 0.2763f,-0.8141f,-0.5107f, 0.3892f,-0.8490f,-0.3574f, 0.3945f,-0.9171f,-0.0565f, 
	0.5157f,-0.6601f,-0.5462f, 0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, 0.0000f,-0.8597f,-0.5108f, 0.2279f,-0.7890f,-0.5706f, 0.6393f,-0.3886f,-0.6635f, 0.6209f,-0.2472f,-0.7439f, -0.0000f,-0.7751f,-0.6318f, -0.0000f,-0.8588f,-0.5123f, 0.7689f,-0.6382f,-0.0384f, 0.7736f,-0.4668f,-0.4286f, 0.7762f,-0.6140f,-0.1435f, 0.7267f,-0.5598f,-0.3982f, -0.0000f,-0.9181f,-0.3963f, -0.0000f,-0.9290f,-0.3701f, 
	0.0000f,-0.5606f,-0.8281f, 0.5027f,-0.2121f,-0.8380f, 0.0000f,-0.1566f,-0.9877f, -0.0517f,-0.8354f,0.5471f, -0.2568f,-0.7892f,-0.5579f, 0.5715f,-0.8196f,-0.0400f, 0.1883f,-0.6623f,0.7252f, 0.4223f,-0.8250f,-0.3755f, 0.5798f,-0.6649f,-0.4710f, 0.1186f,-0.9927f,-0.0229f, 0.1186f,-0.9927f,-0.0229f, -0.0438f,-0.0104f,0.9990f, 0.0617f,-0.9977f,-0.0296f, -0.0000f,-0.9939f,-0.1101f, -0.0000f,-0.9957f,-0.0926f, 
	0.1283f,-0.9906f,0.0477f, -0.0000f,-0.9978f,-0.0663f, -0.0775f,-0.9854f,-0.1517f, -0.9150f,0.0128f,0.4033f, -0.9150f,0.0128f,0.4033f, -0.6876f,0.0069f,0.7260f, -0.0450f,-0.0128f,0.9989f, -0.3467f,0.0112f,-0.9379f, -0.3467f,0.0112f,-0.9379f, -0.7291f,0.4294f,0.5330f, -0.8462f,0.4600f,0.2688f, -0.9219f,-0.3324f,0.1989f, -0.6669f,0.7416f,0.0728f, 0.2043f,-0.5099f,-0.8356f, 0.3854f,-0.0590f,-0.9209f, 
	0.1589f,-0.0525f,0.9859f, -0.4142f,0.7569f,0.5055f, 0.2985f,0.2686f,0.9159f, 0.3319f,0.1957f,0.9228f, 0.1109f,0.1202f,0.9865f, 0.2738f,0.1362f,0.9521f, 0.2453f,0.1941f,0.9498f, 0.2514f,-0.2522f,0.9345f, -0.2001f,-0.6764f,0.7088f, 0.9334f,-0.3537f,-0.0606f, 0.9392f,-0.2461f,-0.2395f, 0.8710f,-0.4824f,-0.0931f, 0.9961f,-0.0580f,0.0659f, 0.5585f,0.7301f,-0.3938f, 0.5455f,0.7792f,-0.3087f, 
	0.4211f,0.8450f,-0.3296f, 0.4198f,0.8057f,-0.4178f, 0.8438f,0.2829f,0.4561f, 0.7992f,0.5910f,0.1094f, 0.8959f,0.2462f,0.3699f, 0.8703f,0.0731f,0.4871f, 0.4127f,0.9103f,0.0323f, 0.3058f,0.8218f,0.4807f, 0.3925f,0.6104f,-0.6880f, 0.4192f,0.6792f,-0.6024f, 0.1980f,0.2055f,0.9584f, 0.5075f,0.1034f,0.8554f, 0.4750f,0.4998f,0.7242f, 0.0800f,0.3651f,0.9275f, 0.6897f,0.6424f,-0.3340f, 
	0.8193f,0.4620f,-0.3395f, 0.8743f,0.4627f,-0.1468f, 0.7539f,0.6038f,-0.2590f, 0.6749f,-0.5118f,-0.5316f, 0.6738f,0.7152f,0.1856f, 0.5906f,0.3660f,-0.7192f, 0.9028f,0.1030f,-0.4176f, 0.7303f,-0.5184f,0.4449f, 0.6421f,-0.4904f,0.5892f, 0.7176f,-0.2931f,0.6317f, 0.7440f,0.1414f,0.6530f, 0.8249f,-0.4668f,-0.3189f, 0.8721f,-0.4866f,-0.0510f, 0.8595f,-0.3425f,-0.3795f, 0.8931f,0.1756f,-0.4142f, 
	0.7673f,-0.5469f,-0.3350f, -0.3498f,-0.8975f,-0.2686f, 0.1745f,-0.8007f,0.5731f, 0.3734f,-0.7321f,-0.5697f, 0.3076f,-0.7412f,-0.5967f, 0.1673f,-0.9201f,-0.3543f, 0.2788f,-0.9395f,-0.1990f, -0.4264f,0.0098f,0.9045f, -0.4861f,-0.5398f,0.6872f, 0.9772f,0.0614f,-0.2035f, 0.8612f,0.4492f,-0.2380f, 0.8663f,0.4816f,-0.1327f, 0.8940f,-0.0933f,0.4383f, 0.9844f,0.0330f,0.1727f, 0.9813f,0.1059f,-0.1609f, 
	0.9011f,-0.3423f,0.2662f, 0.5300f,-0.0444f,-0.8468f, 0.5969f,0.3094f,-0.7403f, 0.4124f,0.3997f,-0.8186f, 0.8094f,-0.2216f,0.5438f, 0.5337f,-0.7565f,0.3779f, 0.7236f,-0.6724f,0.1559f, 0.5189f,-0.8548f,0.0087f, 0.5334f,-0.6284f,-0.5662f, 0.3496f,-0.2874f,-0.8917f, 0.1835f,0.7077f,0.6823f, 0.8816f,0.0520f,0.4692f, 0.8438f,0.2829f,0.4561f, 0.8703f,0.0731f,0.4871f, 0.9222f,0.2079f,0.3262f, 
	0.9291f,0.3565f,0.0986f, 0.0744f,0.9749f,0.2100f, 0.9547f,0.2838f,-0.0892f, 0.7207f,0.3807f,-0.5794f, 0.5724f,-0.8142f,-0.0970f, 0.7432f,-0.6635f,-0.0861f, -0.1102f,-0.2628f,0.9585f, 0.1623f,-0.9814f,0.1024f, 0.0356f,-0.9991f,-0.0210f, 0.1816f,-0.9803f,0.0779f, 0.2072f,-0.9266f,0.3137f, 0.6414f,0.6640f,0.3844f, 0.5500f,0.6961f,-0.4614f, 0.5724f,0.5424f,-0.6149f, 0.9189f,-0.2997f,0.2565f, 
	0.7802f,-0.5487f,0.3003f, 0.8889f,0.0757f,0.4517f, 0.7607f,-0.1274f,0.6365f, 0.0939f,-0.1059f,0.9899f, 0.1450f,0.3189f,0.9366f, 0.7090f,-0.0399f,0.7041f, 0.3278f,-0.4532f,0.8289f, 0.5641f,0.6319f,0.5315f, 0.8940f,-0.0933f,0.4383f, 0.8663f,0.4816f,-0.1327f, 0.8799f,0.4738f,0.0356f, 0.6749f,-0.5118f,-0.5316f, 0.9028f,0.1030f,-0.4176f, 0.9011f,-0.3423f,0.2662f, 0.9772f,0.0614f,-0.2035f, 
	0.7823f,0.6224f,-0.0257f, 0.3600f,0.9179f,-0.1668f, 0.5555f,-0.8145f,0.1672f, 0.3083f,-0.8695f,0.3859f, 0.3221f,-0.9313f,0.1700f, 0.2676f,-0.7955f,0.5437f, 0.7236f,-0.6724f,0.1559f, 0.8930f,0.2256f,-0.3895f, 0.7518f,0.3816f,-0.5377f, 0.8589f,-0.4258f,0.2847f, 0.7673f,-0.5469f,-0.3350f, 0.3840f,-0.8781f,0.2853f, 0.0940f,-0.7904f,0.6053f, -0.8440f,0.1384f,-0.5182f, -0.8440f,0.1384f,-0.5182f, 
	-0.8440f,0.1384f,-0.5182f, -0.0223f,0.9966f,0.0791f, 0.9499f,0.3081f,0.0530f, 0.8927f,-0.4413f,-0.0912f, 0.1890f,-0.9537f,-0.2338f, -0.9744f,0.1690f,0.1480f, -0.9744f,0.1690f,0.1480f, 0.0341f,0.9982f,-0.0490f, 0.9915f,0.0924f,-0.0921f, 0.1168f,-0.9931f,0.0019f, 0.3458f,0.7623f,0.5471f, 0.9657f,-0.2477f,0.0782f, 0.8612f,0.4492f,-0.2380f, 0.4805f,0.5301f,0.6986f, 0.8928f,0.0119f,0.4503f, 
	0.6790f,-0.5841f,-0.4447f, 0.3921f,-0.4925f,-0.7770f, -0.3740f,-0.6498f,-0.6618f, -0.3941f,-0.7262f,-0.5634f, -0.2275f,0.8632f,0.4507f, 0.1550f,0.3794f,0.9122f, 0.4290f,-0.2283f,0.8740f, -0.0956f,0.8790f,0.4672f, 0.7607f,-0.1274f,0.6365f, 0.3278f,-0.4532f,0.8289f, 0.2098f,-0.1800f,0.9610f, 0.5920f,-0.4163f,0.6901f, 0.6790f,-0.5841f,-0.4447f, -0.3941f,-0.7262f,-0.5634f, 0.6056f,0.5831f,0.5415f, 
	0.6006f,-0.0505f,0.7979f, 0.6769f,0.6260f,0.3872f, 0.7898f,-0.0483f,0.6114f, 0.8314f,0.4458f,0.3316f, 0.8731f,-0.0673f,0.4828f, 0.8068f,0.4347f,0.4002f, 0.7020f,0.1400f,0.6983f, 0.9636f,-0.0481f,0.2631f, 0.9291f,0.3565f,0.0986f, -0.0732f,0.8826f,0.4644f, 0.5033f,-0.4816f,0.7175f, 0.5033f,-0.4816f,0.7175f, 0.2965f,-0.6977f,0.6521f, 0.2143f,-0.8296f,0.5157f, -0.2396f,-0.6585f,0.7134f, 
	0.5535f,-0.8299f,-0.0703f, 0.7190f,-0.5998f,0.3510f, 0.9016f,0.3670f,-0.2290f, 0.6988f,0.1979f,0.6874f, 0.2856f,-0.2860f,0.9147f, 0.4222f,-0.3433f,0.8390f, 0.4290f,-0.2283f,0.8740f, -0.9141f,-0.2932f,-0.2801f, -0.9141f,-0.2932f,-0.2801f, -0.5217f,-0.6090f,-0.5974f, -0.3075f,-0.7335f,-0.6062f, 0.5605f,-0.7100f,-0.4263f, 0.9090f,-0.1742f,-0.3787f, 0.8737f,0.4090f,-0.2634f, 0.9011f,0.3601f,-0.2413f, 
	0.0683f,0.9532f,-0.2944f, -0.1840f,0.9404f,-0.2859f, 0.4222f,-0.3433f,0.8390f, -0.1840f,0.9404f,-0.2859f, -0.9141f,-0.2932f,-0.2801f, 0.5033f,-0.4816f,0.7175f, 0.5094f,0.0339f,0.8599f, 0.8493f,0.5145f,0.1186f, -0.0429f,0.9244f,-0.3791f, 0.4750f,0.4516f,0.7553f, 0.5383f,-0.5612f,0.6287f, 0.5654f,-0.2870f,0.7733f, 0.5691f,-0.4942f,0.6572f, -0.0429f,0.9244f,-0.3791f, -0.9116f,-0.4095f,-0.0362f, 
	-0.6788f,0.6202f,-0.3933f, -0.4401f,0.8629f,-0.2484f, -0.6788f,0.6202f,-0.3933f, -0.3287f,-0.0071f,0.9444f, -0.0936f,0.1318f,0.9868f, 0.6180f,0.4318f,0.6570f, 0.1854f,-0.1220f,0.9751f, -0.5930f,-0.4120f,0.6918f, 0.2794f,0.9116f,-0.3015f, 0.3407f,0.9086f,0.2417f, 0.8498f,0.2546f,0.4616f, 0.3600f,0.9179f,-0.1668f, 0.4211f,0.8450f,-0.3296f, 0.5455f,0.7792f,-0.3087f, 0.5739f,0.8104f,-0.1181f, 
	0.9614f,-0.2485f,-0.1177f, 0.8895f,0.1157f,-0.4420f, 0.1246f,-0.7327f,-0.6691f, -0.5116f,-0.6396f,-0.5738f, -0.3105f,-0.5688f,-0.7617f, -0.0622f,-0.5230f,-0.8500f, -0.4107f,-0.7074f,-0.5752f, -0.4852f,-0.5249f,-0.6993f, -0.4381f,-0.7492f,0.4968f, 0.0855f,-0.8749f,0.4768f, 0.1745f,-0.8007f,0.5731f, -0.3498f,-0.8975f,-0.2686f, -0.0260f,-0.9714f,0.2360f, 0.2416f,-0.9704f,-0.0067f, 0.4035f,-0.8051f,0.4347f, 
	-0.1718f,-0.9822f,0.0754f, -0.4717f,-0.7197f,0.5095f, -0.3314f,-0.9420f,-0.0524f, 0.1862f,-0.9329f,-0.3083f, 0.4719f,-0.8757f,-0.1019f, 0.5149f,-0.8467f,0.1337f, -0.3740f,-0.6498f,-0.6618f, -0.6490f,-0.7595f,0.0449f, 0.5791f,-0.6942f,0.4274f, -0.6490f,-0.7595f,0.0449f, 0.7577f,-0.6525f,0.0077f, 0.4035f,-0.8051f,0.4347f, 0.2416f,-0.9704f,-0.0067f, 0.7434f,-0.6622f,0.0941f, -0.0992f,-0.9950f,0.0101f, 
	0.2069f,-0.9595f,0.1914f, -0.0979f,-0.9820f,-0.1614f, 0.1158f,-0.9755f,0.1868f, -0.0979f,-0.9820f,-0.1614f, 0.3307f,-0.8936f,0.3034f, 0.9961f,-0.0580f,0.0659f, 0.8589f,-0.4258f,0.2847f, -0.4916f,-0.6494f,-0.5802f, -0.2763f,-0.8141f,-0.5107f, -0.3892f,-0.8490f,-0.3574f, -0.3945f,-0.9171f,-0.0565f, -0.4465f,-0.7346f,-0.5109f, -0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, -0.2279f,-0.7890f,-0.5706f, 
	-0.6393f,-0.3886f,-0.6635f, -0.6209f,-0.2472f,-0.7439f, -0.7689f,-0.6382f,-0.0384f, -0.7736f,-0.4668f,-0.4286f, -0.7762f,-0.6140f,-0.1435f, -0.7267f,-0.5598f,-0.3982f, -0.5027f,-0.2121f,-0.8380f, 0.2568f,-0.7892f,-0.5579f, -0.5019f,-0.7006f,-0.5072f, -0.0120f,-0.9986f,0.0522f, -0.4223f,-0.8250f,-0.3755f, -0.5798f,-0.6649f,-0.4710f, -0.1519f,-0.9870f,-0.0535f, -0.1186f,-0.9927f,-0.0229f, 0.0450f,-0.0128f,0.9989f, 
	-0.0617f,-0.9977f,-0.0296f, -0.0407f,-0.9983f,0.0418f, 0.0775f,-0.9854f,-0.1517f, 0.9144f,0.0161f,0.4044f, 0.9150f,0.0128f,0.4033f, 0.6874f,0.0078f,0.7262f, 0.3485f,0.0178f,-0.9371f, 0.7291f,0.4294f,0.5330f, 0.8462f,0.4600f,0.2688f, 0.9219f,-0.3324f,0.1989f, 0.6669f,0.7416f,0.0728f, 0.4127f,0.9103f,0.0323f, 0.6669f,0.7416f,0.0728f, 
_NULL_ }; /* End of skull4_Normals */

const unsigned short skull4_Faces[] = {
	0, 2, 1, 2, 0, 3, 4, 6, 5, 6, 8, 7, 4, 8, 6, 8, 10, 9, 4, 10, 8, 4, 11, 10, 4, 12, 11, 13, 15, 14, 
	15, 13, 16, 17, 19, 18, 19, 17, 20, 21, 23, 22, 23, 21, 24, 25, 27, 26, 27, 25, 28, 29, 31, 30, 31, 29, 32, 33, 35, 34, 
	35, 33, 36, 37, 39, 38, 39, 37, 40, 41, 43, 42, 43, 41, 44, 45, 47, 46, 47, 45, 48, 49, 51, 50, 51, 49, 52, 53, 55, 54, 
	56, 58, 57, 58, 56, 59, 60, 62, 61, 62, 60, 63, 64, 66, 65, 66, 64, 67, 68, 13, 69, 13, 68, 70, 71, 72, 2, 72, 71, 73, 
	47, 74, 46, 74, 47, 75, 51, 77, 76, 77, 51, 78, 56, 3, 59, 3, 56, 79, 80, 26, 81, 26, 80, 25, 82, 22, 83, 22, 82, 21, 
	66, 67, 84, 85, 87, 86, 87, 85, 44, 88, 52, 89, 52, 88, 51, 71, 3, 79, 3, 71, 2, 61, 91, 90, 91, 61, 62, 92, 94, 93, 
	94, 92, 95, 18, 97, 96, 97, 18, 19, 26, 27, 98, 99, 32, 100, 32, 99, 31, 33, 102, 101, 102, 33, 34, 103, 105, 104, 105, 103, 106, 
	107, 59, 108, 59, 107, 58, 109, 63, 110, 63, 109, 62, 2, 111, 1, 111, 2, 72, 105, 112, 104, 112, 105, 113, 108, 3, 0, 3, 108, 59, 
	26, 114, 81, 102, 63, 60, 63, 102, 34, 34, 110, 63, 110, 34, 35, 83, 66, 84, 66, 83, 22, 22, 65, 66, 65, 22, 23, 115, 70, 68, 
	70, 115, 39, 73, 32, 72, 32, 73, 100, 32, 111, 72, 111, 32, 29, 78, 64, 69, 78, 42, 64, 78, 41, 42, 69, 65, 68, 65, 69, 64, 
	68, 23, 115, 23, 68, 65, 115, 24, 116, 24, 115, 23, 117, 27, 28, 27, 117, 118, 119, 121, 120, 121, 119, 122, 69, 14, 78, 14, 69, 13, 
	116, 39, 115, 39, 116, 38, 16, 70, 123, 70, 16, 13, 14, 125, 124, 14, 53, 125, 14, 15, 53, 126, 122, 119, 122, 126, 127, 70, 40, 123, 
	40, 70, 39, 128, 129, 41, 129, 128, 130, 41, 131, 44, 131, 41, 129, 44, 132, 87, 132, 44, 131, 133, 130, 128, 130, 133, 134, 130, 135, 129, 
	135, 130, 136, 129, 137, 131, 137, 129, 135, 138, 131, 137, 138, 132, 131, 138, 134, 132, 134, 136, 130, 134, 139, 136, 134, 138, 139, 136, 124, 135, 
	124, 136, 140, 135, 125, 137, 125, 135, 124, 137, 141, 138, 141, 137, 125, 42, 67, 64, 67, 42, 43, 67, 143, 142, 143, 67, 43, 144, 146, 145, 
	146, 144, 147, 148, 150, 149, 150, 148, 151, 85, 43, 44, 43, 85, 143, 104, 150, 152, 150, 104, 112, 152, 151, 153, 151, 152, 150, 86, 144, 145, 
	144, 86, 87, 87, 134, 133, 134, 87, 132, 109, 155, 154, 155, 109, 110, 155, 35, 156, 35, 155, 110, 156, 36, 157, 36, 156, 35, 158, 90, 91, 
	90, 158, 159, 160, 155, 161, 155, 160, 154, 161, 156, 162, 156, 161, 155, 162, 157, 163, 157, 162, 156, 84, 67, 142, 164, 166, 165, 166, 164, 167, 
	165, 168, 154, 168, 165, 166, 154, 169, 109, 169, 154, 168, 169, 62, 109, 62, 169, 170, 91, 170, 171, 170, 91, 62, 91, 172, 158, 172, 91, 171, 
	112, 174, 173, 174, 112, 113, 112, 175, 150, 175, 112, 173, 150, 167, 164, 167, 150, 175, 167, 176, 166, 176, 167, 177, 166, 178, 168, 178, 166, 176, 
	168, 179, 169, 179, 168, 178, 169, 180, 170, 180, 169, 179, 170, 181, 171, 181, 170, 180, 171, 182, 172, 171, 183, 182, 171, 181, 183, 184, 182, 183, 
	184, 172, 182, 184, 174, 172, 184, 173, 174, 173, 185, 175, 185, 173, 184, 175, 177, 167, 177, 175, 185, 177, 5, 176, 5, 177, 4, 176, 6, 178, 
	6, 176, 5, 178, 7, 179, 7, 178, 6, 179, 8, 180, 8, 179, 7, 180, 9, 181, 9, 180, 8, 181, 10, 183, 10, 181, 9, 183, 11, 184, 
	11, 183, 10, 184, 12, 185, 12, 184, 11, 185, 4, 177, 4, 185, 12, 172, 113, 158, 113, 172, 174, 113, 46, 158, 46, 113, 105, 46, 106, 45, 
	106, 46, 105, 186, 74, 187, 74, 186, 188, 158, 189, 159, 189, 158, 190, 191, 193, 192, 193, 191, 194, 192, 196, 195, 196, 192, 193, 186, 198, 197, 
	198, 186, 187, 199, 201, 200, 202, 204, 203, 204, 202, 205, 206, 208, 207, 209, 211, 210, 211, 203, 212, 209, 203, 211, 209, 202, 203, 213, 207, 214, 
	207, 213, 206, 205, 190, 204, 190, 205, 189, 74, 158, 46, 158, 74, 188, 215, 75, 216, 75, 215, 74, 194, 208, 206, 208, 194, 191, 118, 20, 217, 
	20, 118, 19, 97, 118, 117, 118, 97, 19, 50, 218, 49, 218, 50, 219, 220, 222, 221, 222, 220, 223, 223, 224, 222, 224, 223, 225, 226, 54, 55, 
	54, 226, 227, 228, 230, 229, 230, 228, 231, 120, 232, 119, 232, 120, 233, 119, 234, 126, 234, 119, 232, 229, 235, 228, 235, 229, 236, 237, 225, 238, 
	225, 237, 224, 233, 240, 239, 240, 233, 120, 120, 241, 240, 241, 120, 121, 145, 146, 242, 146, 243, 242, 243, 146, 88, 88, 244, 243, 244, 88, 89, 
	230, 227, 226, 227, 230, 231, 93, 122, 127, 122, 93, 94, 53, 245, 125, 245, 53, 54, 245, 247, 246, 245, 227, 247, 245, 54, 227, 227, 248, 247, 
	248, 227, 231, 231, 249, 248, 249, 231, 228, 228, 250, 249, 250, 228, 235, 76, 219, 50, 219, 76, 77, 50, 51, 76, 238, 233, 239, 233, 238, 225, 
	225, 232, 233, 232, 225, 223, 223, 234, 232, 234, 223, 220, 236, 219, 235, 219, 236, 218, 235, 77, 250, 77, 235, 219, 78, 250, 77, 78, 249, 250, 
	78, 124, 249, 78, 14, 124, 41, 51, 147, 51, 41, 78, 146, 51, 88, 51, 146, 147, 216, 194, 206, 194, 216, 75, 193, 75, 47, 75, 193, 194, 
	48, 193, 47, 193, 48, 196, 187, 211, 198, 187, 201, 211, 187, 200, 201, 213, 210, 211, 210, 213, 214, 251, 45, 252, 45, 251, 48, 253, 49, 254, 
	49, 253, 52, 255, 52, 253, 52, 255, 89, 256, 103, 257, 103, 256, 106, 252, 106, 256, 106, 252, 45, 258, 196, 259, 196, 258, 195, 257, 89, 255, 
	89, 257, 244, 259, 48, 251, 48, 259, 196, 260, 262, 261, 262, 260, 263, 264, 254, 265, 254, 264, 253, 266, 268, 267, 268, 266, 269, 267, 263, 260, 
	263, 267, 268, 270, 272, 271, 261, 270, 271, 270, 261, 262, 264, 237, 273, 237, 264, 274, 275, 253, 264, 253, 275, 255, 273, 276, 264, 276, 273, 269, 
	277, 267, 256, 267, 278, 266, 277, 278, 267, 260, 256, 267, 256, 260, 252, 251, 260, 261, 260, 251, 252, 259, 261, 271, 261, 259, 251, 272, 259, 271, 
	259, 272, 258, 279, 94, 280, 94, 279, 122, 281, 122, 279, 122, 281, 121, 282, 284, 283, 284, 282, 95, 280, 285, 282, 285, 280, 94, 241, 287, 286, 
	287, 241, 121, 288, 280, 289, 280, 288, 279, 290, 279, 288, 279, 290, 281, 291, 281, 290, 281, 291, 286, 292, 283, 293, 283, 292, 282, 289, 282, 292, 
	282, 289, 280, 26, 294, 114, 294, 26, 98, 295, 294, 98, 294, 295, 296, 297, 98, 27, 98, 297, 295, 27, 217, 297, 217, 27, 118, 0, 299, 298, 
	299, 0, 1, 300, 302, 301, 300, 303, 302, 303, 305, 304, 300, 305, 303, 305, 307, 306, 300, 307, 305, 300, 308, 307, 309, 311, 310, 311, 309, 312, 
	313, 315, 314, 315, 313, 316, 317, 319, 318, 319, 317, 320, 25, 321, 28, 321, 25, 322, 29, 324, 323, 324, 29, 30, 325, 327, 326, 327, 325, 328, 
	329, 331, 330, 331, 329, 332, 333, 335, 334, 335, 333, 336, 337, 339, 338, 339, 337, 340, 341, 343, 342, 343, 341, 344, 345, 347, 346, 348, 350, 349, 
	350, 348, 351, 60, 353, 352, 353, 60, 61, 354, 356, 355, 356, 354, 357, 358, 309, 359, 309, 358, 360, 361, 363, 362, 363, 361, 299, 339, 365, 364, 
	365, 339, 340, 343, 367, 366, 367, 343, 368, 348, 298, 369, 298, 348, 349, 80, 322, 25, 322, 80, 370, 371, 373, 372, 373, 371, 374, 356, 375, 355, 
	376, 377, 334, 377, 376, 378, 379, 342, 343, 342, 379, 380, 361, 298, 299, 298, 361, 369, 61, 381, 353, 381, 61, 90, 382, 384, 383, 384, 382, 385, 
	316, 97, 315, 97, 316, 96, 322, 386, 321, 387, 323, 324, 323, 387, 388, 325, 102, 328, 102, 325, 101, 389, 391, 390, 391, 389, 392, 107, 349, 350, 
	349, 107, 108, 393, 352, 353, 352, 393, 394, 299, 111, 363, 111, 299, 1, 391, 396, 395, 396, 391, 392, 108, 298, 349, 298, 108, 0, 322, 370, 397, 
	102, 352, 328, 352, 102, 60, 328, 394, 327, 394, 328, 352, 374, 356, 373, 356, 374, 375, 320, 398, 319, 398, 320, 399, 400, 359, 331, 359, 400, 358, 
	362, 323, 388, 323, 362, 363, 323, 111, 29, 111, 323, 363, 366, 402, 401, 366, 354, 402, 366, 403, 354, 360, 398, 404, 398, 360, 358, 358, 319, 398, 
	319, 358, 400, 400, 318, 319, 318, 400, 405, 117, 321, 406, 321, 117, 28, 407, 409, 408, 409, 407, 410, 360, 312, 309, 312, 360, 411, 405, 331, 332, 
	331, 405, 400, 310, 359, 309, 359, 310, 412, 413, 312, 414, 312, 415, 311, 413, 415, 312, 416, 408, 417, 408, 416, 407, 359, 330, 331, 330, 359, 412, 
	418, 420, 419, 420, 418, 333, 333, 421, 420, 421, 333, 334, 334, 422, 421, 422, 334, 377, 423, 419, 424, 419, 423, 418, 419, 426, 425, 426, 419, 420, 
	420, 427, 426, 427, 420, 421, 421, 428, 427, 428, 422, 424, 421, 422, 428, 424, 429, 428, 424, 425, 429, 424, 419, 425, 425, 414, 430, 414, 425, 426, 
	426, 413, 414, 413, 426, 427, 427, 431, 413, 431, 427, 428, 336, 432, 335, 432, 336, 404, 432, 433, 335, 433, 432, 434, 435, 437, 436, 437, 435, 438, 
	439, 441, 440, 441, 439, 442, 376, 335, 433, 335, 376, 334, 443, 441, 444, 441, 443, 445, 445, 440, 441, 440, 445, 446, 378, 447, 377, 447, 378, 448, 
	377, 424, 422, 424, 377, 423, 393, 449, 394, 449, 393, 450, 449, 327, 394, 327, 449, 451, 451, 326, 327, 326, 451, 452, 90, 453, 381, 453, 90, 159, 
	454, 449, 450, 449, 454, 455, 455, 451, 449, 451, 455, 456, 456, 452, 451, 452, 456, 457, 458, 434, 432, 459, 461, 460, 461, 459, 462, 462, 463, 461, 
	463, 462, 450, 450, 464, 463, 464, 450, 393, 464, 353, 465, 353, 464, 393, 465, 381, 466, 381, 465, 353, 381, 467, 466, 467, 381, 453, 396, 468, 395, 
	468, 396, 469, 396, 470, 469, 470, 396, 471, 471, 460, 470, 460, 471, 459, 460, 473, 472, 473, 460, 461, 461, 474, 473, 474, 461, 463, 463, 475, 474, 
	475, 463, 464, 464, 476, 475, 476, 464, 465, 465, 477, 476, 477, 465, 466, 466, 478, 477, 466, 479, 478, 466, 467, 479, 480, 468, 469, 480, 467, 468, 
	480, 479, 467, 480, 478, 479, 469, 481, 480, 481, 469, 470, 482, 484, 483, 484, 482, 485, 472, 308, 300, 308, 472, 473, 473, 307, 308, 307, 473, 474, 
	474, 306, 307, 306, 474, 475, 475, 305, 306, 305, 475, 476, 476, 304, 305, 304, 476, 477, 477, 303, 304, 303, 477, 478, 478, 302, 303, 302, 478, 480, 
	480, 301, 302, 301, 480, 481, 481, 300, 301, 300, 481, 472, 467, 395, 468, 395, 467, 453, 395, 340, 391, 340, 395, 453, 340, 390, 391, 390, 340, 337, 
	486, 365, 487, 365, 486, 488, 453, 189, 489, 189, 453, 159, 191, 491, 490, 491, 191, 192, 192, 492, 491, 492, 192, 195, 486, 493, 488, 493, 486, 494, 
	495, 497, 496, 202, 498, 205, 498, 202, 499, 500, 207, 208, 501, 209, 210, 209, 499, 202, 501, 499, 209, 501, 502, 499, 503, 207, 500, 207, 503, 214, 
	205, 489, 189, 489, 205, 498, 365, 453, 487, 453, 365, 340, 504, 364, 365, 364, 504, 505, 490, 208, 191, 208, 490, 500, 506, 508, 507, 508, 506, 509, 
	97, 406, 315, 406, 97, 117, 344, 511, 510, 511, 344, 341, 512, 514, 513, 514, 512, 515, 513, 517, 516, 517, 513, 514, 518, 520, 519, 520, 518, 521, 
	522, 524, 523, 524, 522, 525, 410, 527, 526, 527, 410, 407, 407, 528, 527, 528, 407, 416, 525, 530, 529, 530, 525, 522, 237, 516, 517, 516, 237, 238, 
	526, 240, 410, 240, 526, 239, 410, 241, 409, 241, 410, 240, 448, 532, 531, 437, 533, 379, 533, 437, 534, 379, 535, 380, 535, 379, 533, 536, 519, 537, 
	519, 536, 518, 385, 408, 384, 408, 385, 417, 415, 538, 520, 538, 415, 413, 538, 519, 520, 538, 539, 519, 538, 540, 539, 519, 541, 537, 541, 519, 539, 
	523, 542, 522, 542, 523, 543, 522, 544, 530, 544, 522, 542, 368, 510, 367, 510, 368, 344, 344, 368, 343, 238, 526, 516, 526, 238, 239, 516, 527, 513, 
	527, 516, 526, 513, 528, 512, 528, 513, 527, 529, 510, 511, 510, 529, 530, 530, 367, 510, 367, 530, 544, 544, 366, 367, 366, 546, 545, 366, 542, 546, 
	544, 542, 366, 401, 343, 366, 343, 401, 436, 437, 343, 436, 343, 437, 379, 505, 490, 364, 490, 505, 500, 491, 364, 490, 364, 491, 339, 338, 491, 492, 
	491, 338, 339, 488, 496, 497, 488, 501, 496, 488, 493, 501, 503, 210, 214, 210, 503, 501, 547, 337, 338, 337, 547, 548, 549, 341, 342, 341, 549, 550, 
	551, 342, 380, 342, 551, 549, 552, 389, 390, 389, 552, 553, 548, 390, 337, 390, 548, 552, 258, 492, 195, 492, 258, 554, 553, 380, 535, 380, 553, 551, 
	554, 338, 492, 338, 554, 547, 555, 262, 263, 262, 555, 556, 557, 550, 549, 550, 557, 558, 559, 268, 269, 268, 559, 560, 560, 263, 268, 263, 560, 555, 
	270, 561, 272, 556, 270, 262, 270, 556, 561, 557, 237, 562, 237, 557, 273, 563, 549, 551, 549, 563, 557, 273, 564, 269, 564, 273, 557, 560, 565, 552, 
	560, 566, 565, 560, 559, 566, 555, 552, 548, 552, 555, 560, 547, 555, 548, 555, 547, 556, 554, 556, 547, 556, 554, 561, 272, 554, 258, 554, 272, 561, 
	567, 384, 408, 384, 567, 568, 569, 408, 409, 408, 569, 567, 570, 284, 383, 284, 570, 283, 568, 571, 384, 571, 568, 570, 241, 572, 409, 572, 241, 286, 
	573, 568, 567, 568, 573, 574, 575, 567, 569, 567, 575, 573, 291, 569, 286, 569, 291, 575, 576, 283, 570, 283, 576, 293, 574, 570, 568, 570, 574, 576, 
	322, 577, 386, 577, 322, 397, 578, 577, 579, 577, 578, 386, 580, 386, 578, 386, 580, 321, 581, 509, 506, 509, 581, 582, 
_NULL_ }; /* End of skull4_Faces */


/* MESH 2 */

#define skull3_NumVertex  583
#define skull3_NumFaces   838
#define skull3_NumStrips  0
#define skull3_Flags      0x00020006
#define skull3_Material   0

const float skull3_Vertices[] = {
	1.1341f,-30.7901f,-94.2593f, 1.1341f,21.8917f,-125.2637f, -37.5117f,16.9488f,-113.0243f, -24.9009f,-34.4217f,-92.8902f, -54.0618f,-1.6057f,22.5512f, 
	-51.8917f,6.1041f,27.9489f, -43.4183f,9.3742f,29.0203f, -33.0264f,11.4509f,31.1025f, -15.7799f,2.5378f,37.3410f, -12.6011f,-5.9891f,38.7368f, 
	-23.4116f,-13.7772f,38.4704f, -38.1603f,-16.7290f,32.1676f, -47.0852f,-11.7429f,32.0141f, -89.0576f,9.8441f,-48.7059f, -80.1995f,-3.8524f,-33.6996f, 
	-71.1778f,-13.5720f,-81.4686f, -81.4716f,7.1799f,-82.8176f, -67.0307f,63.5996f,-55.7228f, -37.8222f,77.2215f,-74.6962f, -35.8185f,91.1199f,-48.9696f, 
	-72.0867f,70.1446f,-37.5739f, -67.2644f,72.2029f,32.0757f, -64.3092f,52.6419f,40.8724f, -78.1098f,60.6806f,21.2627f, -69.6218f,75.0868f,9.3510f, 
	1.1341f,98.3649f,47.6327f, -32.0977f,90.6309f,55.4714f, -42.1042f,98.7173f,2.2675f, 1.1341f,107.7151f,2.8624f, 1.1341f,65.9923f,-97.9893f, 
	1.1341f,85.0664f,-81.1919f, -37.8222f,77.2215f,-74.6962f, -39.0055f,60.6855f,-93.5264f, -21.7621f,73.1312f,76.4030f, -17.0670f,73.7650f,82.6535f, 
	-32.4099f,76.3074f,80.0009f, -42.0992f,71.5845f,69.0735f, -67.0307f,63.5996f,-55.7228f, -72.0867f,70.1446f,-37.5739f, -85.5976f,54.0933f,-35.6701f, 
	-76.1385f,48.7393f,-69.5014f, -67.7594f,-8.4485f,39.9772f, -63.9893f,6.1989f,35.0985f, -76.2645f,11.3425f,39.3498f, -90.0675f,-7.2150f,35.9754f, 
	-28.1266f,-65.5598f,91.4290f, -25.1127f,-51.2734f,82.9856f, -13.3136f,-53.3318f,96.1670f, -18.6616f,-66.6641f,101.6299f, -42.4278f,-51.5871f,39.6865f, 
	-39.6507f,-42.8894f,37.4175f, -38.0278f,-29.4774f,44.8429f, -45.2047f,-52.9658f,50.1630f, -59.7756f,-35.7219f,-74.1696f, -70.8902f,-58.3772f,-19.2704f, 
	-54.1134f,-42.2233f,-51.4052f, -59.7756f,-35.7219f,-74.1696f, -54.1134f,-42.2233f,-51.4052f, -26.2545f,-45.8518f,-73.3164f, -35.5630f,-39.5563f,-84.6413f, 
	1.1341f,17.6575f,86.1841f, 1.1341f,4.0649f,83.6360f, -10.8742f,24.1667f,89.5100f, -6.8849f,44.9957f,99.7215f, -63.6292f,22.3134f,36.6761f, 
	-72.1348f,43.3299f,25.7329f, -65.5408f,38.7030f,46.7733f, -77.7924f,31.2452f,45.9587f, -92.0581f,32.7660f,-14.5962f, -84.6593f,8.0952f,-3.8214f, 
	-92.7648f,29.6651f,-47.0787f, -81.4716f,7.1799f,-82.8176f, -40.1870f,46.9405f,-101.9144f, -80.1618f,28.1101f,-76.8753f, -27.3729f,-49.6025f,90.2641f, 
	-15.0256f,-50.9719f,101.6887f, -34.7824f,-21.9903f,36.7798f, -40.5808f,-15.8404f,24.5853f, -65.9949f,-10.2918f,20.9092f, -71.1778f,-13.5720f,-81.4686f, 
	1.1341f,83.2713f,77.9981f, -21.7621f,73.1312f,76.4030f, -61.0573f,66.1071f,44.8399f, -57.1268f,53.9467f,54.7964f, -69.4040f,45.9051f,65.6239f, 
	-81.3630f,-7.6320f,59.4141f, -109.8090f,-3.1584f,64.2791f, -95.5263f,-18.3153f,38.8230f, -37.9639f,-31.8156f,54.6283f, -42.6260f,-55.5465f,56.4453f, 
	1.1341f,-2.4392f,87.4284f, -7.8814f,-1.8633f,82.0588f, -54.1134f,-42.2233f,-51.4052f, -47.7416f,-40.1763f,-35.5612f, -32.5136f,-45.4468f,-48.0724f, 
	-26.2545f,-45.8518f,-73.3164f, 1.1341f,85.0664f,-81.1919f, 1.1341f,99.4302f,-57.3275f, -57.2443f,83.3396f,41.9867f, -67.0307f,63.5996f,-55.7228f, 
	-76.1385f,48.7393f,-69.5014f, 1.1341f,83.2713f,77.9981f, 1.1341f,44.3090f,84.2634f, -42.6792f,-58.0143f,66.9484f, -28.9592f,-34.8087f,67.6047f, 
	-27.1682f,-37.6551f,75.2866f, -38.8489f,-60.6764f,74.6559f, 1.1341f,-43.8196f,-82.4335f, 1.1341f,-41.2261f,-92.6548f, -30.0816f,33.6834f,96.9571f, 
	-35.8438f,58.8960f,95.0699f, 1.1341f,52.2313f,-108.0712f, -33.9297f,-24.9061f,73.5509f, -22.8553f,-21.7753f,83.9086f, -42.0992f,71.5845f,69.0735f, 
	-82.7818f,60.6186f,-13.2793f, -69.6028f,77.3893f,-16.9730f, 1.1341f,105.6022f,-32.3374f, -33.1798f,99.0184f,-25.4024f, -26.7096f,-26.5276f,-2.3923f, 
	-12.4668f,-44.6201f,-11.7626f, -13.5027f,-46.5521f,-23.3799f, -26.2093f,-45.2005f,-34.7179f, -80.1618f,28.1101f,-76.8753f, -76.6060f,-7.2097f,-27.7624f, 
	-90.6413f,-10.1043f,-35.2515f, -44.8682f,-16.9967f,-2.9172f, -45.9376f,-32.1497f,-20.7391f, -52.9550f,-21.0732f,58.6415f, -81.6327f,-8.5110f,15.3931f, 
	-80.7105f,-23.9795f,12.7630f, -91.4932f,-8.4163f,16.9791f, -94.7007f,-18.1911f,16.3207f, -90.4726f,-29.1118f,41.5927f, -91.0122f,-22.7357f,16.0165f, 
	-78.9955f,-9.8938f,-14.6126f, -77.9742f,-24.0348f,-5.1860f, -88.8464f,-10.1644f,-13.2789f, -90.0887f,-22.8992f,-12.6769f, -84.7939f,-23.5171f,-10.0515f, 
	-60.5573f,-20.1807f,0.4523f, -85.8194f,-27.3248f,-30.2513f, -66.2948f,28.5255f,69.2666f, -74.6980f,3.0425f,54.7274f, -90.4726f,-29.1118f,41.5927f, 
	-69.8783f,-63.2630f,62.3316f, -54.0836f,-41.4268f,59.0159f, -52.9550f,-21.0732f,58.6415f, -81.3630f,-7.6320f,59.4141f, -74.6980f,3.0425f,54.7274f, 
	-80.0863f,-25.6569f,80.2567f, -109.8090f,-3.1584f,64.2791f, -62.1436f,-47.1525f,78.6853f, -69.8783f,-63.2630f,62.3316f, -54.4523f,28.5514f,90.8947f, 
	-57.9481f,47.5507f,89.7474f, -44.6683f,47.3032f,66.8338f, -56.9782f,66.6703f,59.2930f, -7.6733f,-18.6613f,97.1056f, 1.1341f,3.5665f,95.2633f, 
	-66.2948f,28.5255f,69.2666f, -69.4040f,45.9051f,65.6239f, -57.1268f,53.9467f,54.7964f, -61.0573f,66.1071f,44.8399f, -74.6980f,3.0425f,54.7274f, 
	-66.2948f,28.5255f,69.2666f, -61.3951f,20.5710f,64.1412f, -66.1340f,3.7362f,58.8149f, -51.8271f,20.2901f,76.9690f, -27.6440f,13.4392f,83.8782f, 
	-13.1522f,0.3247f,75.0006f, -7.7838f,-7.3652f,72.8560f, -10.2180f,-11.8445f,75.2606f, -38.0095f,-16.6790f,74.8000f, -24.9839f,-14.4131f,79.6250f, 
	-57.4481f,-13.9469f,64.3904f, -64.0911f,25.5293f,40.3371f, -69.2352f,3.7580f,32.7283f, -43.1815f,36.2911f,37.4231f, -25.5436f,33.8247f,42.6607f, 
	-5.5058f,11.0810f,51.6994f, 0.5658f,-7.1433f,45.5066f, -6.7618f,-18.2130f,52.8512f, -6.0091f,-19.6000f,47.9709f, -37.5161f,-25.1147f,47.8833f, 
	-64.8054f,-24.5660f,32.1225f, -4.7651f,-23.8559f,102.6404f, -16.0163f,-47.9987f,89.1135f, -8.9873f,-21.5086f,100.0467f, 1.1341f,-4.1509f,97.7967f, 
	-8.9873f,-21.5086f,100.0467f, 1.1341f,-51.7012f,114.0233f, 1.1341f,-57.5566f,109.9396f, -3.2196f,-55.0928f,107.4438f, -5.0628f,-52.0769f,110.9070f, 
	1.1341f,-70.1007f,114.8416f, -10.1368f,-67.4703f,108.5810f, -3.6793f,-19.9995f,86.3398f, -18.1668f,-51.6814f,79.8911f, -7.2700f,-41.1215f,115.0543f, 
	-11.9862f,-44.8299f,101.0664f, -9.0875f,-48.1650f,100.8104f, 1.1341f,-10.5147f,81.2339f, -3.6793f,-19.9995f,86.3398f, -4.7651f,-23.8559f,102.6404f, 
	1.1341f,-17.5548f,101.2986f, -7.2700f,-41.1215f,115.0543f, 1.1341f,-38.3493f,107.3555f, 1.1341f,-47.4108f,116.2884f, 1.1341f,-37.9871f,102.2456f, 
	1.1341f,-45.1302f,94.8826f, -11.5396f,-55.1710f,72.1320f, -18.1668f,-51.6814f,79.8911f, -9.0875f,-48.1650f,100.8104f, 1.1341f,-48.0521f,102.2169f, 
	-16.0163f,-47.9987f,89.1135f, -11.9862f,-44.8299f,101.0664f, -69.6028f,77.3893f,-16.9730f, -33.0091f,-34.3247f,29.7543f, -31.9715f,-25.9328f,29.8642f, 
	-33.0091f,-34.3247f,29.7543f, -42.4278f,-51.5871f,39.6865f, -30.0519f,-51.9099f,40.7910f, -25.1294f,-37.4772f,31.5812f, -19.6649f,-38.4533f,44.8831f, 
	-17.1781f,-23.2891f,36.5295f, -47.7416f,-40.1763f,-35.5612f, -68.4476f,-18.3408f,-23.6381f, -52.9281f,-18.6324f,-1.1862f, -44.8682f,-16.9967f,-2.9172f, 
	-45.9376f,-32.1497f,-20.7391f, -63.5207f,-21.8504f,-16.3409f, -24.2737f,-27.3208f,14.0620f, -10.1611f,-16.1620f,-1.3082f, -31.0201f,-27.5091f,16.1316f, 
	-38.5073f,-25.6792f,17.8939f, -31.0201f,-27.5091f,16.1316f, 1.1341f,-45.1725f,44.8127f, 1.1341f,-16.3926f,27.9101f, 1.1341f,-12.6555f,-0.9581f, 
	1.1341f,-49.4843f,-15.2000f, 1.1341f,-47.8435f,-21.7445f, -62.1436f,-47.1525f,78.6853f, -28.9592f,-34.8087f,67.6047f, -42.6792f,-58.0143f,66.9484f, 
	-85.8194f,-27.3248f,-30.2513f, -90.0887f,-22.8992f,-12.6769f, -84.7939f,-23.5171f,-10.0515f, -77.9742f,-24.0348f,-5.1860f, -60.5573f,-20.1807f,0.4523f, 
	-51.5433f,-13.6912f,13.2629f, -12.0255f,-66.6640f,91.3656f, -22.2942f,-65.0439f,86.6591f, -32.5742f,-52.9658f,50.1630f, -30.0519f,-51.9099f,40.7910f, 
	-29.5909f,-55.5465f,53.4880f, -28.8556f,-60.6764f,71.5256f, -31.4192f,-58.0143f,66.9483f, 1.1341f,-70.1006f,104.1905f, -5.7071f,-67.4702f,101.2015f, 
	-19.1256f,-55.6845f,86.6591f, -12.7729f,-57.2462f,91.3656f, 1.1341f,-43.8447f,91.3656f, 1.1341f,-40.3075f,86.6591f, -19.2519f,-41.3275f,48.7586f, 
	-19.6649f,-38.4533f,44.8831f, -25.6262f,-40.9078f,58.2474f, -24.7089f,-48.4506f,71.5255f, 1.1341f,-34.2192f,71.5256f, 1.1341f,-30.0952f,61.1725f, 
	1.1341f,-51.2723f,101.2015f, -3.5042f,-62.2400f,101.2015f, 1.1341f,-63.5038f,103.2183f, 1.1341f,-40.9517f,51.2574f, -19.6649f,-38.4533f,44.8831f, 
	-25.6262f,-40.9078f,58.2474f, -25.6262f,-40.9078f,58.2474f, -31.4192f,-58.0143f,66.9483f, -29.5909f,-55.5465f,53.4880f, -23.1543f,-44.5665f,-37.7422f, 
	-28.0093f,-44.8941f,-48.7059f, -12.5282f,-45.8573f,-27.6708f, -18.2310f,-45.3863f,-70.0124f, 1.1341f,-44.3998f,-77.1955f, 1.1341f,-43.8196f,-82.4335f, 
	-26.2545f,-45.8518f,-73.3164f, 1.1341f,-47.4886f,-27.0894f, -12.5282f,-45.8573f,-27.6708f, -23.2665f,-49.4382f,-37.8024f, -28.1215f,-51.0347f,-48.7661f, 
	-12.6404f,-50.1544f,-27.7310f, 1.1341f,-53.2475f,-27.1496f, -18.3432f,-50.7612f,-70.0726f, 1.1341f,-49.4528f,-77.2557f, -56.9782f,66.6703f,59.2930f, 
	-67.2644f,72.2029f,32.0757f, -61.0573f,66.1071f,44.8399f, -69.6218f,75.0868f,9.3510f, 27.1690f,-34.4217f,-92.8902f, 39.7799f,16.9488f,-113.0243f, 
	56.3300f,-1.6057f,22.5512f, 49.3533f,-11.7429f,32.0141f, 40.4284f,-16.7290f,32.1676f, 25.6797f,-13.7772f,38.4704f, 14.8692f,-5.9891f,38.7368f, 
	18.0481f,2.5378f,37.3410f, 35.2945f,11.4509f,31.1025f, 45.6864f,9.3742f,29.0203f, 54.1598f,6.1041f,27.9489f, 91.3257f,9.8441f,-48.7059f, 
	83.7398f,7.1798f,-82.8176f, 73.4459f,-13.5720f,-81.4686f, 82.4676f,-3.8524f,-33.6996f, 69.2989f,63.5996f,-55.7228f, 74.3549f,70.1446f,-37.5739f, 
	38.0866f,91.1199f,-48.9696f, 40.0904f,77.2215f,-74.6962f, 69.5325f,72.2029f,32.0757f, 71.8900f,75.0868f,9.3510f, 80.3780f,60.6806f,21.2627f, 
	66.5774f,52.6419f,40.8724f, 44.3724f,98.7173f,2.2675f, 34.3658f,90.6309f,55.4714f, 41.2736f,60.6855f,-93.5264f, 40.0904f,77.2215f,-74.6962f, 
	24.0302f,73.1312f,76.4030f, 44.3673f,71.5845f,69.0735f, 34.6780f,48.3726f,80.0009f, 19.3352f,47.1742f,82.6535f, 69.2989f,63.5996f,-55.7228f, 
	78.4066f,48.7393f,-69.5014f, 87.8658f,54.0933f,-35.6701f, 74.3549f,70.1446f,-37.5739f, 70.0276f,-8.4485f,39.9772f, 92.3356f,-7.2150f,35.9754f, 
	78.5326f,11.3425f,39.3498f, 66.2574f,6.1989f,35.0985f, 30.3947f,-65.5598f,91.4290f, 20.9297f,-66.6641f,101.6299f, 15.5818f,-53.3318f,96.1671f, 
	27.3808f,-51.2734f,82.9856f, 44.6960f,-51.5871f,39.6865f, 47.4729f,-52.9658f,50.1630f, 40.2959f,-29.4775f,44.8430f, 41.9189f,-42.8894f,37.4175f, 
	62.0437f,-35.7219f,-74.1696f, 56.3815f,-42.2233f,-51.4052f, 73.1584f,-58.3773f,-19.2704f, 62.0437f,-35.7219f,-74.1696f, 37.8312f,-39.5563f,-84.6413f, 
	28.5227f,-45.8518f,-73.3164f, 56.3815f,-42.2233f,-51.4052f, 9.1530f,18.4048f,99.7215f, 13.1423f,-2.4242f,89.5100f, 65.8974f,22.3134f,36.6761f, 
	80.0606f,31.2452f,45.9587f, 67.8089f,38.7030f,46.7733f, 74.4029f,43.3299f,25.7329f, 94.3262f,32.7660f,-14.5962f, 95.0330f,29.6651f,-47.0787f, 
	86.9274f,8.0952f,-3.8214f, 83.7398f,7.1798f,-82.8176f, 82.4299f,28.1101f,-76.8753f, 42.4551f,46.9405f,-101.9144f, 17.2937f,-50.9719f,101.6887f, 
	29.6411f,-49.6025f,90.2641f, 68.2631f,-10.2918f,20.9092f, 42.8490f,-15.8404f,24.5853f, 37.0505f,-21.9903f,36.7798f, 73.4459f,-13.5720f,-81.4686f, 
	24.0302f,73.1312f,76.4030f, 63.3254f,66.1071f,44.8399f, 69.5325f,72.2029f,32.0757f, 66.5774f,52.6419f,40.8724f, 59.3949f,53.9467f,54.7964f, 
	71.6721f,45.9051f,65.6239f, 83.6312f,-7.6320f,59.4141f, 97.7944f,-18.3153f,38.8230f, 112.0771f,-3.1584f,64.2791f, 40.2320f,-31.8156f,54.6283f, 
	44.8941f,-55.5465f,56.4453f, 10.1495f,-1.8633f,82.0588f, 56.3815f,-42.2233f,-51.4052f, 28.5227f,-45.8518f,-73.3164f, 34.7817f,-45.4468f,-48.0724f, 
	50.0098f,-40.1763f,-35.5612f, 59.5124f,83.3396f,41.9867f, 69.2989f,63.5996f,-55.7228f, 78.4066f,48.7393f,-69.5014f, 44.9473f,-58.0143f,66.9484f, 
	41.1170f,-60.6764f,74.6559f, 29.4364f,-37.6551f,75.2866f, 31.2273f,-34.8087f,67.6047f, 32.3498f,5.7486f,96.9571f, 38.1120f,30.9612f,95.0699f, 
	25.1234f,-21.7753f,83.9087f, 36.1979f,-24.9061f,73.5509f, 44.3673f,71.5845f,69.0735f, 74.4029f,43.3299f,25.7329f, 67.8089f,38.7030f,46.7733f, 
	85.0499f,60.6186f,-13.2793f, 70.0276f,-8.4485f,39.9772f, 66.2574f,6.1989f,35.0985f, 86.9274f,8.0952f,-3.8214f, 65.8974f,22.3134f,36.6761f, 
	71.8709f,77.3893f,-16.9730f, 35.4479f,99.0184f,-25.4024f, 28.9778f,-26.5276f,-2.3923f, 28.4774f,-45.2005f,-34.7179f, 15.7708f,-46.5521f,-23.3799f, 
	14.7350f,-44.6201f,-11.7626f, 68.2631f,-10.2918f,20.9092f, 82.4299f,28.1101f,-76.8753f, 92.9094f,-10.1043f,-35.2515f, 78.8741f,-7.2097f,-27.7624f, 
	62.0437f,-35.7219f,-74.1696f, 47.1364f,-16.9968f,-2.9172f, 48.2057f,-32.1497f,-20.7391f, 55.2232f,-21.0732f,58.6415f, 82.9786f,-23.9795f,12.7630f, 
	83.9008f,-8.5110f,15.3931f, 93.7613f,-8.4163f,16.9791f, 96.9689f,-18.1911f,16.3207f, 92.7407f,-29.1118f,41.5927f, 93.2804f,-22.7357f,16.0165f, 
	80.2424f,-24.0348f,-5.1860f, 81.2636f,-9.8938f,-14.6126f, 91.1145f,-10.1644f,-13.2789f, 92.3568f,-22.8992f,-12.6769f, 87.0620f,-23.5171f,-10.0515f, 
	62.8254f,-20.1807f,0.4523f, 88.0875f,-27.3248f,-30.2513f, 80.0606f,31.2452f,45.9587f, 76.9661f,3.0425f,54.7274f, 68.5629f,28.5255f,69.2666f, 
	92.7407f,-29.1118f,41.5927f, 55.2232f,-21.0732f,58.6415f, 56.3518f,-41.4268f,59.0159f, 72.1464f,-63.2630f,62.3317f, 83.6312f,-7.6320f,59.4141f, 
	112.0771f,-3.1584f,64.2791f, 82.3544f,-25.6569f,80.2567f, 76.9661f,3.0425f,54.7274f, 31.2273f,-34.8087f,67.6047f, 36.1979f,-24.9061f,73.5509f, 
	64.4118f,-47.1525f,78.6853f, 72.1464f,-63.2630f,62.3317f, 92.7407f,-29.1118f,41.5927f, 72.1464f,-63.2630f,62.3317f, 60.2163f,47.5507f,89.7474f, 
	56.7204f,28.5514f,90.8947f, 46.9364f,47.3032f,66.8338f, 59.2464f,66.6703f,59.2931f, 9.9414f,-18.6613f,97.1056f, 68.5629f,28.5255f,69.2666f, 
	71.6721f,45.9051f,65.6239f, 59.3949f,53.9467f,54.7964f, 63.3254f,66.1071f,44.8399f, 71.6721f,45.9051f,65.6239f, 76.9661f,3.0425f,54.7274f, 
	68.4021f,3.7362f,58.8150f, 63.6633f,20.5710f,64.1412f, 68.5629f,28.5255f,69.2666f, 54.0952f,20.2901f,76.9690f, 29.9121f,13.4392f,83.8783f, 
	15.4203f,0.3247f,75.0007f, 10.0520f,-7.3652f,72.8560f, 12.4861f,-11.8445f,75.2606f, 27.2521f,-14.4131f,79.6250f, 40.2776f,-16.6790f,74.8000f, 
	59.7163f,-13.9469f,64.3904f, 82.3544f,-25.6569f,80.2567f, 71.5034f,3.7580f,32.7283f, 66.3593f,25.5293f,40.3371f, 45.4497f,36.2911f,37.4231f, 
	27.8118f,33.8247f,42.6607f, 7.7740f,11.0810f,51.6995f, 1.7024f,-7.1433f,45.5066f, 8.2772f,-19.6000f,47.9709f, 9.0299f,-18.2130f,52.8512f, 
	39.7842f,-25.1147f,47.8833f, 67.0735f,-24.5661f,32.1225f, 59.7163f,-13.9469f,64.3904f, 67.0735f,-24.5661f,32.1225f, 71.5034f,3.7580f,32.7283f, 
	68.4021f,3.7362f,58.8150f, 7.0332f,-23.8559f,102.6404f, 11.2554f,-21.5086f,100.0467f, 18.2844f,-47.9988f,89.1135f, 11.2554f,-21.5086f,100.0467f, 
	7.3309f,-52.0769f,110.9070f, 5.4877f,-55.0928f,107.4438f, 12.4050f,-67.4703f,108.5810f, 20.4350f,-51.6814f,79.8911f, 5.9475f,-19.9995f,86.3398f, 
	9.5382f,-41.1215f,115.0543f, 11.3556f,-48.1650f,100.8105f, 14.2543f,-44.8299f,101.0664f, 7.0332f,-23.8559f,102.6404f, 5.9475f,-19.9995f,86.3398f, 
	9.5382f,-41.1215f,115.0543f, 13.8077f,-55.1710f,72.1320f, 20.4350f,-51.6814f,79.8911f, 11.3556f,-48.1650f,100.8105f, 18.2844f,-47.9988f,89.1135f, 
	14.2543f,-44.8299f,101.0664f, 35.4479f,99.0184f,-25.4024f, 38.0866f,91.1199f,-48.9696f, 74.3549f,70.1446f,-37.5739f, 71.8709f,77.3893f,-16.9730f, 
	34.2396f,-25.9328f,29.8642f, 35.2773f,-34.3247f,29.7544f, 35.2773f,-34.3247f,29.7544f, 27.3975f,-37.4772f,31.5812f, 32.3201f,-51.9099f,40.7911f, 
	44.6960f,-51.5871f,39.6865f, 19.4462f,-23.2891f,36.5295f, 21.9331f,-38.4534f,44.8831f, 50.0098f,-40.1763f,-35.5612f, 70.7157f,-18.3408f,-23.6381f, 
	73.1584f,-58.3773f,-19.2704f, 56.3815f,-42.2233f,-51.4052f, 55.1962f,-18.6324f,-1.1862f, 65.7889f,-21.8504f,-16.3408f, 48.2057f,-32.1497f,-20.7391f, 
	47.1364f,-16.9968f,-2.9172f, 12.4293f,-16.1620f,-1.3082f, 26.5419f,-27.3208f,14.0620f, 33.2883f,-27.5091f,16.1316f, 33.2883f,-27.5091f,16.1316f, 
	40.7754f,-25.6793f,17.8939f, 56.3518f,-41.4268f,59.0159f, 64.4118f,-47.1525f,78.6853f, 31.2273f,-34.8087f,67.6047f, 64.4118f,-47.1525f,78.6853f, 
	44.9473f,-58.0143f,66.9484f, 48.2057f,-32.1497f,-20.7391f, 65.7889f,-21.8504f,-16.3408f, 88.0875f,-27.3248f,-30.2513f, 87.0620f,-23.5171f,-10.0515f, 
	92.3568f,-22.8992f,-12.6769f, 80.2424f,-24.0348f,-5.1860f, 62.8254f,-20.1807f,0.4523f, 80.2424f,-24.0348f,-5.1860f, 53.8114f,-13.6912f,13.2629f, 
	82.4676f,-3.8524f,-33.6996f, 78.8741f,-7.2097f,-27.7624f, 14.2936f,-66.6640f,91.3657f, 24.5623f,-65.0439f,86.6591f, 34.8423f,-52.9658f,50.1630f, 
	32.3201f,-51.9099f,40.7911f, 31.8591f,-55.5465f,53.4880f, 31.1237f,-60.6764f,71.5256f, 33.6873f,-58.0143f,66.9484f, 7.9753f,-67.4702f,101.2015f, 
	21.3937f,-55.6845f,86.6591f, 15.0410f,-57.2462f,91.3656f, 21.5201f,-41.3275f,48.7586f, 21.9331f,-38.4534f,44.8831f, 27.8943f,-40.9078f,58.2474f, 
	26.9770f,-48.4506f,71.5256f, 5.7724f,-62.2400f,101.2015f, 21.9331f,-38.4534f,44.8831f, 27.8943f,-40.9078f,58.2474f, 27.8943f,-40.9078f,58.2474f, 
	33.6873f,-58.0143f,66.9484f, 31.8591f,-55.5465f,53.4880f, 25.4224f,-44.5665f,-37.7422f, 30.2775f,-44.8941f,-48.7059f, 14.7963f,-45.8573f,-27.6708f, 
	20.4991f,-45.3863f,-70.0124f, 28.5227f,-45.8518f,-73.3164f, 14.7963f,-45.8573f,-27.6708f, 25.5346f,-49.4382f,-37.8024f, 30.3896f,-51.0348f,-48.7661f, 
	14.9085f,-50.1544f,-27.7310f, 20.6113f,-50.7613f,-70.0726f, 59.2464f,66.6703f,59.2931f, 69.5325f,72.2029f,32.0757f, 63.3254f,66.1071f,44.8399f, 
	71.8900f,75.0868f,9.3510f, 44.3724f,98.7173f,2.2675f, 71.8900f,75.0868f,9.3510f, 
_NULL_ }; /* End of skull3_Vertices */

const float skull3_UV[] = {
	0.8949f,0.4083f,0.9280f,0.3763f,0.8937f,0.4073f,0.8660f,0.4221f,0.8707f,0.6458f,0.8772f,0.6509f,0.8850f,0.6550f,0.8938f,0.6620f,0.9025f,0.6870f,0.8998f,0.6982f,0.8847f,0.6970f,0.8707f,0.6791f,0.8682f,0.6697f,0.8584f,0.5196f,0.8542f,0.5463f,
	0.8521f,0.4636f,0.8606f,0.4653f,0.8977f,0.5078f,0.9203f,0.4809f,0.9260f,0.5167f,0.8976f,0.5319f,0.9011f,0.6205f,0.8945f,0.6399f,0.8904f,0.6087f,0.9009f,0.5917f,0.9515f,0.6421f,0.9281f,0.6481f,0.9246f,0.5810f,0.9534f,0.5843f,0.9436f,0.4413f,
	0.9485f,0.4706f,0.9203f,0.4809f,0.9135f,0.4514f,0.9294f,0.6831f,0.9328f,0.6906f,0.9234f,0.6818f,0.9156f,0.6700f,0.8977f,0.5078f,0.8976f,0.5319f,0.8836f,0.5350f,0.8861f,0.4882f,0.8577f,0.6662f,0.8697f,0.6545f,0.8659f,0.6515f,0.8471f,0.6476f,
	0.8293f,0.7999f,0.8485f,0.7844f,0.8564f,0.8123f,0.8349f,0.8216f,0.8360f,0.7098f,0.8466f,0.7035f,0.8602f,0.7069f,0.8328f,0.7231f,0.8408f,0.4734f,0.8146f,0.5855f,0.8382f,0.5216f,0.8408f,0.4734f,0.8382f,0.5216f,0.8535f,0.4683f,0.8528f,0.4440f,
	0.9261f,0.7447f,0.9192f,0.7550f,0.9185f,0.7368f,0.9306f,0.7318f,0.8796f,0.6490f,0.8857f,0.6224f,0.8872f,0.6530f,0.8764f,0.6503f,0.8699f,0.5662f,0.8596f,0.5893f,0.8679f,0.5206f,0.8606f,0.4653f,0.9069f,0.4358f,0.8735f,0.4764f,0.8486f,0.7883f,
	0.8575f,0.8135f,0.8690f,0.6923f,0.8696f,0.6650f,0.8574f,0.6409f,0.8521f,0.4636f,0.9481f,0.6843f,0.9294f,0.6831f,0.9021f,0.6397f,0.8993f,0.6582f,0.8885f,0.6696f,0.8510f,0.6823f,0.8411f,0.6694f,0.8370f,0.6523f,0.8582f,0.7223f,0.8316f,0.7360f,
	0.9155f,0.7657f,0.9069f,0.7537f,0.8382f,0.5216f,0.8439f,0.5575f,0.8491f,0.5334f,0.8535f,0.4683f,0.9485f,0.4706f,0.9517f,0.5055f,0.9109f,0.6301f,0.8977f,0.5078f,0.8861f,0.4882f,0.9481f,0.6843f,0.9369f,0.7194f,0.8289f,0.7510f,0.8623f,0.7496f,
	0.8611f,0.7628f,0.8282f,0.7662f,0.8823f,0.4345f,0.8850f,0.4061f,0.9079f,0.7279f,0.9148f,0.7064f,0.9395f,0.4208f,0.8672f,0.7446f,0.8789f,0.7630f,0.9156f,0.6700f,0.8880f,0.5641f,0.9018f,0.5581f,0.9530f,0.5391f,0.9299f,0.5471f,0.8716f,0.6326f,
	0.8670f,0.6343f,0.8639f,0.6058f,0.8542f,0.5691f,0.8735f,0.4764f,0.8537f,0.5575f,0.8448f,0.5426f,0.8657f,0.6161f,0.8524f,0.5873f,0.8571f,0.7081f,0.8503f,0.6239f,0.8395f,0.6258f,0.8456f,0.6215f,0.8374f,0.6220f,0.8312f,0.6629f,0.8358f,0.6248f,
	0.8506f,0.5791f,0.8408f,0.5987f,0.8456f,0.5781f,0.8360f,0.5814f,0.8380f,0.5877f,0.8532f,0.6152f,0.8346f,0.5543f,0.8814f,0.6840f,0.8616f,0.6755f,0.8312f,0.6629f,0.8102f,0.7195f,0.8389f,0.7198f,0.8571f,0.7081f,0.8510f,0.6823f,0.8616f,0.6755f,
	0.8386f,0.7156f,0.8411f,0.6694f,0.8292f,0.7393f,0.8102f,0.7195f,0.8887f,0.7131f,0.8959f,0.6989f,0.9041f,0.6804f,0.9047f,0.6570f,0.8955f,0.7858f,0.9189f,0.7678f,0.8814f,0.6840f,0.8885f,0.6696f,0.8993f,0.6582f,0.9021f,0.6397f,0.8616f,0.6755f,
	0.8814f,0.6840f,0.8800f,0.6850f,0.8669f,0.6852f,0.8858f,0.7048f,0.8991f,0.7307f,0.9034f,0.7404f,0.9035f,0.7485f,0.8980f,0.7540f,0.8709f,0.7366f,0.8829f,0.7503f,0.8598f,0.7077f,0.8811f,0.6519f,0.8651f,0.6497f,0.9000f,0.6515f,0.9114f,0.6670f,
	0.9166f,0.7057f,0.9120f,0.7177f,0.8967f,0.7342f,0.8964f,0.7293f,0.8644f,0.7086f,0.8473f,0.6649f,0.8943f,0.7984f,0.8600f,0.7978f,0.8919f,0.7904f,0.9144f,0.7780f,0.8919f,0.7904f,0.8734f,0.8411f,0.8662f,0.8436f,0.8644f,0.8346f,0.8661f,0.8327f,
	0.8484f,0.8587f,0.8410f,0.8383f,0.8985f,0.7792f,0.8539f,0.7890f,0.8759f,0.8237f,0.8672f,0.8106f,0.8664f,0.8164f,0.9104f,0.7672f,0.8985f,0.7792f,0.8943f,0.7984f,0.9055f,0.7951f,0.8759f,0.8237f,0.8878f,0.8222f,0.8784f,0.8386f,0.8882f,0.8174f,
	0.8809f,0.8183f,0.8558f,0.7910f,0.8539f,0.7890f,0.8664f,0.8164f,0.8776f,0.8278f,0.8600f,0.7978f,0.8672f,0.8106f,0.9018f,0.5581f,0.8596f,0.6915f,0.8679f,0.6865f,0.8596f,0.6915f,0.8360f,0.7098f,0.8440f,0.7247f,0.8629f,0.7039f,0.8666f,0.7308f,
	0.8827f,0.7068f,0.8439f,0.5575f,0.8501f,0.5692f,0.8591f,0.6157f,0.8657f,0.6161f,0.8524f,0.5873f,0.8502f,0.5849f,0.8730f,0.6664f,0.8949f,0.6379f,0.8673f,0.6651f,0.8632f,0.6615f,0.8673f,0.6651f,0.8808f,0.7590f,0.9063f,0.6998f,0.9089f,0.6421f,
	0.8760f,0.6410f,0.8779f,0.6217f,0.8292f,0.7393f,0.8623f,0.7496f,0.8289f,0.7510f,0.8346f,0.5543f,0.8360f,0.5814f,0.8380f,0.5877f,0.8408f,0.5987f,0.8532f,0.6152f,0.8637f,0.6387f,0.8404f,0.8204f,0.8342f,0.8018f,0.8411f,0.7366f,0.8440f,0.7247f,
	0.8403f,0.7464f,0.8348f,0.7741f,0.8362f,0.7637f,0.8484f,0.8508f,0.8452f,0.8377f,0.8484f,0.7984f,0.8521f,0.8117f,0.8822f,0.8136f,0.8859f,0.8051f,0.8641f,0.7394f,0.8666f,0.7308f,0.8591f,0.7458f,0.8520f,0.7696f,0.8918f,0.7819f,0.8955f,0.7645f,
	0.8739f,0.8303f,0.8548f,0.8358f,0.8581f,0.8440f,0.8852f,0.7635f,0.8666f,0.7308f,0.8591f,0.7458f,0.8591f,0.7458f,0.8362f,0.7637f,0.8403f,0.7464f,0.8574f,0.5624f,0.8531f,0.5327f,0.8656f,0.5948f,0.8608f,0.4758f,0.8817f,0.4502f,0.8823f,0.4345f,
	0.8535f,0.4683f,0.8783f,0.6063f,0.8656f,0.5948f,0.8521f,0.5638f,0.8465f,0.5335f,0.8607f,0.5969f,0.8716f,0.6103f,0.8548f,0.4749f,0.8761f,0.4482f,0.9047f,0.6570f,0.9011f,0.6205f,0.9021f,0.6397f,0.9009f,0.5917f,0.9260f,0.3970f,0.9658f,0.3864f,
	0.9823f,0.6970f,0.9705f,0.7257f,0.9559f,0.7301f,0.9371f,0.7294f,0.9282f,0.7146f,0.9362f,0.7047f,0.9592f,0.6916f,0.9708f,0.6931f,0.9806f,0.6966f,0.0269f,0.5307f,0.0181f,0.4464f,0.0061f,0.4397f,0.0180f,0.5746f,0.9999f,0.5097f,1.0042f,0.5398f,
	0.9764f,0.5185f,0.9764f,0.4785f,0.0001f,0.6448f,0.0020f,0.6113f,0.0097f,0.6371f,-0.0026f,0.6712f,0.9817f,0.5900f,0.9736f,0.6601f,0.9752f,0.4441f,0.9764f,0.4785f,0.9630f,0.6941f,0.9792f,0.6900f,0.9674f,0.7202f,0.9533f,0.7207f,-0.0001f,0.5097f,
	0.0086f,0.4844f,0.0169f,0.5466f,0.0042f,0.5398f,0.0009f,0.7366f,0.0323f,0.7252f,0.0112f,0.7094f,-0.0040f,0.7093f,0.8991f,0.8704f,0.8805f,0.8691f,0.8903f,0.8430f,0.9112f,0.8399f,0.9438f,0.8040f,0.9487f,0.8231f,0.9498f,0.7696f,0.9446f,0.7821f,
	0.9859f,0.4512f,0.9731f,0.5404f,1.0099f,0.6936f,0.9859f,0.4512f,0.9395f,0.4148f,0.9185f,0.4545f,0.9731f,0.5404f,0.9341f,0.7616f,0.9282f,0.7746f,0.9960f,0.6933f,1.0113f,0.6973f,0.9984f,0.6916f,1.0049f,0.6569f,0.0260f,0.5940f,0.0272f,0.5300f,
	0.0219f,0.6344f,1.0181f,0.4464f,1.0141f,0.4665f,0.9743f,0.4244f,0.8955f,0.8464f,0.9168f,0.8460f,0.9983f,0.7066f,0.9598f,0.7165f,0.9486f,0.7439f,1.0061f,0.4397f,0.9630f,0.6941f,0.9948f,0.6659f,1.0001f,0.6448f,0.9974f,0.6712f,0.9908f,0.6882f,
	1.0022f,0.7091f,0.0203f,0.7620f,0.0439f,0.7436f,0.0563f,0.7532f,0.9484f,0.7872f,0.9410f,0.8339f,0.9253f,0.7644f,0.9731f,0.5404f,0.9185f,0.4545f,0.9297f,0.5515f,0.9614f,0.5981f,0.9922f,0.6503f,0.9999f,0.5097f,1.0086f,0.4844f,0.9390f,0.8499f,
	0.9277f,0.8590f,0.9270f,0.8140f,0.9320f,0.8025f,0.9539f,0.7814f,0.9672f,0.7536f,0.9318f,0.7986f,0.9458f,0.7977f,0.9792f,0.6900f,0.0049f,0.6569f,-0.0016f,0.6916f,0.0139f,0.5830f,1.0009f,0.7366f,0.9960f,0.7093f,1.0219f,0.6344f,-0.0040f,0.6933f,
	0.0020f,0.5708f,0.9754f,0.5514f,0.9342f,0.6686f,0.9191f,0.5975f,0.8982f,0.6271f,0.8987f,0.6572f,-0.0017f,0.7066f,0.0141f,0.4665f,0.0339f,0.5733f,0.0135f,0.5927f,-0.0141f,0.4512f,0.9657f,0.6627f,0.9617f,0.6360f,-0.0230f,0.7810f,0.0227f,0.7098f,
	0.0208f,0.6923f,0.0346f,0.6930f,0.0426f,0.7038f,0.0406f,0.7669f,0.0388f,0.7113f,0.0182f,0.6695f,0.0173f,0.6284f,0.0314f,0.6304f,0.0374f,0.6460f,0.0292f,0.6551f,-0.0106f,0.6780f,0.0321f,0.6023f,0.0113f,0.6973f,0.0099f,0.7421f,-0.0009f,0.7310f,
	1.0406f,0.7669f,0.9770f,0.7810f,0.9733f,0.8163f,1.0079f,0.8658f,0.0203f,0.7620f,0.0563f,0.7532f,0.0220f,0.8136f,0.0099f,0.7421f,-0.0680f,0.8025f,-0.0542f,0.7977f,-0.0111f,0.8494f,0.0079f,0.8658f,0.0406f,0.7669f,0.0079f,0.8658f,0.9912f,0.7346f,
	0.9863f,0.7547f,0.9786f,0.7079f,0.9913f,0.6834f,0.9146f,0.7984f,0.9991f,0.7310f,1.0022f,0.7091f,0.9908f,0.6882f,0.9948f,0.6659f,0.0022f,0.7091f,1.0099f,0.7421f,0.9987f,0.7470f,0.9934f,0.7333f,0.9991f,0.7310f,0.9825f,0.7483f,0.9538f,0.7582f,
	0.9322f,0.7567f,0.9220f,0.7598f,0.9221f,0.7692f,0.9388f,0.7857f,0.9557f,0.7893f,0.9853f,0.7783f,1.0220f,0.8136f,1.0027f,0.7085f,0.9966f,0.6954f,0.9756f,0.6789f,0.9576f,0.6852f,0.9294f,0.7122f,0.9131f,0.7184f,0.9120f,0.7400f,0.9138f,0.7458f,
	0.9512f,0.7670f,0.9961f,0.7488f,-0.0147f,0.7783f,-0.0039f,0.7488f,0.0027f,0.7085f,-0.0013f,0.7470f,0.9074f,0.8073f,0.9141f,0.8052f,0.9003f,0.8328f,0.9141f,0.8052f,0.8805f,0.8452f,0.8745f,0.8438f,0.8664f,0.8652f,0.8995f,0.8309f,0.9090f,0.7863f,
	0.8953f,0.8386f,0.8903f,0.8367f,0.8979f,0.8357f,0.9074f,0.8073f,0.9090f,0.7863f,0.8953f,0.8386f,0.8855f,0.8205f,0.8995f,0.8309f,0.8903f,0.8367f,0.9003f,0.8328f,0.8979f,0.8357f,-0.0246f,0.5514f,-0.0236f,0.5185f,0.0042f,0.5398f,0.0020f,0.5708f,
	0.9423f,0.7366f,0.9388f,0.7502f,0.9388f,0.7502f,0.9240f,0.7526f,0.9193f,0.7956f,0.9438f,0.8040f,0.9232f,0.7348f,0.9149f,0.7707f,-0.0386f,0.5981f,0.0021f,0.6143f,0.0099f,0.6936f,-0.0269f,0.5404f,0.9775f,0.6709f,0.9941f,0.6383f,0.9617f,0.6360f,
	0.9657f,0.6627f,0.9192f,0.6505f,0.9302f,0.7042f,0.9399f,0.7128f,0.9399f,0.7128f,0.9524f,0.7175f,-0.0267f,0.8163f,-0.0111f,0.8494f,0.9320f,0.8025f,0.9889f,0.8494f,0.9390f,0.8499f,-0.0383f,0.6360f,-0.0059f,0.6383f,0.0321f,0.6023f,0.0292f,0.6551f,
	0.0374f,0.6460f,0.0182f,0.6695f,0.9894f,0.6780f,1.0182f,0.6695f,0.9765f,0.6950f,1.0180f,0.5746f,1.0135f,0.5927f,0.8703f,0.8534f,0.8891f,0.8595f,0.9229f,0.8130f,0.9193f,0.7956f,0.9146f,0.8189f,0.9071f,0.8466f,0.9153f,0.8403f,0.8605f,0.8545f,
	0.8963f,0.8436f,0.8846f,0.8431f,0.9117f,0.7802f,0.9149f,0.7707f,0.9219f,0.7978f,0.9135f,0.8239f,0.8654f,0.8465f,0.9149f,0.7707f,0.9219f,0.7978f,0.9219f,0.7978f,0.9153f,0.8403f,0.9146f,0.8189f,0.9147f,0.5850f,0.9224f,0.5476f,0.8975f,0.6127f,
	0.9063f,0.4686f,0.9185f,0.4545f,0.8975f,0.6127f,0.9101f,0.5889f,0.9167f,0.5507f,0.8930f,0.6166f,0.9008f,0.4667f,0.9913f,0.6834f,1.0001f,0.6448f,0.9948f,0.6659f,1.0020f,0.6113f,-0.0183f,0.5900f,0.0020f,0.6113f,
_NULL_ }; /* End of skull3_UV */

const float skull3_Normals[] = {
	-0.0000f,-0.3010f,-0.9536f, -0.0000f,0.0264f,-0.9997f, -0.3854f,-0.0590f,-0.9209f, -0.2043f,-0.5099f,-0.8356f, -0.1815f,-0.0211f,0.9832f, 0.1282f,-0.5928f,0.7951f, -0.2526f,-0.2288f,0.9401f, -0.2328f,0.2136f,0.9488f, -0.2743f,0.1356f,0.9520f, -0.1109f,0.1202f,0.9865f, -0.3319f,0.1957f,0.9228f, -0.2985f,0.2686f,0.9159f, 0.4142f,0.7569f,0.5055f, -0.9334f,-0.3537f,-0.0606f, -0.9961f,-0.0580f,0.0659f, 
	-0.8710f,-0.4824f,-0.0931f, -0.9392f,-0.2461f,-0.2395f, -0.5585f,0.7301f,-0.3938f, -0.4198f,0.8057f,-0.4178f, -0.4211f,0.8450f,-0.3296f, -0.5455f,0.7792f,-0.3087f, -0.8440f,0.2946f,0.4483f, -0.8793f,0.1299f,0.4583f, -0.8998f,0.2352f,0.3675f, -0.7992f,0.5910f,0.1094f, -0.0000f,0.9542f,0.2992f, -0.3181f,0.8358f,0.4475f, -0.4127f,0.9103f,0.0323f, -0.0000f,0.9973f,0.0728f, -0.0000f,0.6462f,-0.7632f, 
	-0.0000f,0.6609f,-0.7505f, -0.4192f,0.6792f,-0.6024f, -0.3925f,0.6104f,-0.6880f, 0.0258f,0.9817f,-0.1887f, 0.0211f,0.7646f,0.6442f, -0.2731f,0.9473f,0.1674f, -0.7052f,0.1657f,0.6894f, -0.6897f,0.6424f,-0.3340f, -0.7539f,0.6038f,-0.2590f, -0.8743f,0.4627f,-0.1468f, -0.8193f,0.4620f,-0.3395f, -0.7275f,-0.4429f,-0.5240f, -0.8906f,0.0326f,-0.4535f, -0.7028f,0.2313f,-0.6727f, -0.8172f,0.5745f,-0.0461f, 
	-0.7303f,-0.5184f,0.4449f, -0.7440f,0.1414f,0.6530f, -0.7176f,-0.2931f,0.6317f, -0.6421f,-0.4904f,0.5892f, -0.8249f,-0.4668f,-0.3189f, -0.8931f,0.1756f,-0.4142f, -0.8656f,-0.3310f,-0.3756f, -0.8721f,-0.4866f,-0.0510f, -0.7673f,-0.5469f,-0.3350f, -0.1745f,-0.8007f,0.5731f, 0.3498f,-0.8975f,-0.2686f, -0.3734f,-0.7321f,-0.5697f, -0.2788f,-0.9395f,-0.1990f, -0.1673f,-0.9201f,-0.3543f, -0.3076f,-0.7412f,-0.5967f, 
	-0.3277f,-0.2269f,0.9171f, -0.2006f,-0.0466f,0.9786f, 0.0619f,-0.3983f,0.9152f, 0.4671f,0.1272f,0.8750f, -0.9706f,0.0068f,-0.2406f, -0.8884f,-0.1105f,0.4457f, -0.8606f,0.4774f,-0.1771f, -0.8642f,0.3698f,-0.3411f, -0.9841f,0.0330f,0.1743f, -0.8983f,-0.3416f,0.2765f, -0.9813f,0.1059f,-0.1609f, -0.5300f,-0.0444f,-0.8468f, -0.4124f,0.3997f,-0.8186f, -0.5969f,0.3094f,-0.7403f, -0.5337f,-0.7565f,0.3779f, 
	-0.8094f,-0.2216f,0.5438f, -0.5334f,-0.6284f,-0.5662f, -0.5189f,-0.8548f,0.0087f, -0.7335f,-0.6592f,0.1656f, -0.3496f,-0.2874f,-0.8917f, -0.0000f,0.8125f,0.5830f, -0.3193f,0.6435f,0.6957f, -0.8847f,0.0783f,0.4595f, -0.9174f,0.3736f,0.1370f, -0.9048f,0.4244f,-0.0351f, -0.5518f,0.8339f,0.0068f, -0.7327f,0.3511f,-0.5830f, -0.9611f,0.1896f,-0.2007f, -0.5724f,-0.8142f,-0.0970f, -0.7432f,-0.6635f,-0.0861f, 
	-0.0000f,0.7928f,0.6095f, -0.2798f,0.2852f,0.9167f, -0.1623f,-0.9814f,0.1024f, -0.2072f,-0.9266f,0.3137f, -0.1816f,-0.9803f,0.0779f, -0.0356f,-0.9991f,-0.0210f, -0.0000f,0.8568f,-0.5157f, -0.0000f,0.9218f,-0.3877f, -0.6366f,0.6938f,0.3367f, -0.5500f,0.6961f,-0.4614f, -0.5724f,0.5424f,-0.6149f, 0.0941f,0.2613f,0.9607f, 0.3955f,0.3390f,0.8536f, -0.9189f,-0.2997f,0.2565f, -0.7607f,-0.1274f,0.6365f, 
	-0.8889f,0.0757f,0.4517f, -0.7802f,-0.5487f,0.3003f, -0.0000f,-0.9573f,-0.2892f, -0.0000f,-0.6870f,-0.7267f, -0.1182f,-0.0997f,0.9880f, -0.2177f,0.4220f,0.8801f, -0.0000f,0.5053f,-0.8629f, -0.3278f,-0.4532f,0.8289f, -0.7090f,-0.0399f,0.7041f, -0.4516f,0.6633f,0.5967f, -0.8799f,0.4738f,0.0356f, -0.7823f,0.6224f,-0.0257f, -0.0000f,0.9873f,-0.1590f, -0.3600f,0.9179f,-0.1668f, -0.5555f,-0.8145f,0.1672f, 
	-0.2676f,-0.7955f,0.5437f, -0.3221f,-0.9313f,0.1700f, -0.3083f,-0.8695f,0.3859f, -0.8930f,0.2256f,-0.3895f, -0.8589f,-0.4258f,0.2847f, -0.7518f,0.3816f,-0.5377f, -0.3840f,-0.8781f,0.2853f, -0.0940f,-0.7904f,0.6053f, 0.8353f,0.2816f,-0.4721f, 0.8353f,0.2816f,-0.4721f, 0.8434f,0.1385f,-0.5190f, 0.0672f,0.9954f,-0.0680f, -0.9000f,0.4348f,-0.0306f, -0.8927f,-0.4413f,-0.0912f, -0.1890f,-0.9537f,-0.2338f, 
	0.9953f,0.0448f,0.0854f, 0.9744f,0.1690f,0.1480f, 0.0003f,0.9983f,-0.0577f, -0.9915f,0.0924f,-0.0921f, -0.0829f,-0.9965f,0.0101f, -0.3458f,0.7623f,0.5471f, -0.9635f,0.0820f,-0.2547f, -0.8975f,-0.0172f,0.4407f, -0.8562f,0.3648f,0.3658f, -0.6783f,-0.5839f,-0.4460f, 0.3941f,-0.7263f,-0.5632f, 0.3739f,-0.6497f,-0.6619f, -0.4099f,-0.4754f,-0.7784f, -0.2813f,0.7173f,0.6375f, -0.5734f,0.6020f,0.5557f, 
	-0.4861f,-0.2653f,0.8327f, -0.2037f,0.3354f,0.9198f, -0.2102f,-0.1799f,0.9610f, -0.5924f,-0.4159f,0.6899f, -0.5942f,-0.0609f,0.8020f, -0.7088f,0.4063f,0.5766f, -0.6675f,0.6765f,0.3111f, -0.7868f,-0.1016f,0.6088f, -0.8314f,0.4458f,0.3316f, 0.0000f,0.9819f,0.1892f, -0.8883f,-0.0942f,0.4495f, -0.5692f,0.7067f,0.4203f, -0.7146f,0.2383f,0.6578f, -0.9580f,-0.0855f,0.2737f, -0.3678f,0.6556f,0.6594f, 
	-0.6096f,-0.6592f,0.4403f, 0.0669f,-0.5110f,0.8570f, -0.4137f,-0.1667f,0.8950f, -0.5926f,-0.7368f,0.3254f, -0.0914f,-0.5481f,0.8314f, 0.0485f,-0.5226f,0.8512f, -0.7190f,-0.5998f,0.3510f, -0.9802f,0.1251f,0.1532f, -0.2896f,-0.2825f,0.9145f, -0.2896f,-0.2825f,0.9145f, 0.0849f,0.7400f,0.6673f, 0.9626f,-0.2219f,-0.1552f, 0.9749f,-0.1898f,-0.1161f, 0.3537f,-0.8914f,-0.2833f, -0.1241f,-0.8869f,-0.4450f, 
	-0.7332f,-0.4932f,-0.4682f, -0.8247f,-0.5044f,-0.2559f, -0.9011f,0.3601f,-0.2413f, -0.9011f,0.3601f,-0.2413f, -0.1641f,0.9419f,-0.2930f, 0.3165f,0.8773f,-0.3609f, 0.1598f,-0.5382f,0.8276f, 0.6788f,0.6202f,-0.3933f, -0.8493f,0.5145f,0.1186f, -0.0000f,0.3247f,0.9458f, -0.4750f,0.4516f,0.7553f, -0.0000f,-0.5699f,0.8217f, -0.0000f,0.0022f,1.0000f, -0.5654f,-0.2870f,0.7733f, -0.5383f,-0.5612f,0.6287f, 
	-0.0000f,-0.5312f,0.8473f, -0.5691f,-0.4942f,0.6572f, 0.9116f,-0.4095f,-0.0362f, 0.0429f,0.9244f,-0.3791f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, -0.0000f,-0.6778f,0.7352f, 0.0936f,0.1318f,0.9868f, 0.3287f,-0.0071f,0.9444f, -0.0000f,-0.3499f,0.9368f, -0.6180f,0.4318f,0.6570f, 0.0000f,0.9741f,-0.2262f, -0.0000f,-0.0710f,0.9975f, -0.0000f,-0.0560f,0.9984f, 
	0.0000f,0.4391f,0.8984f, -0.1854f,-0.1220f,0.9751f, 0.5930f,-0.4120f,0.6918f, -0.2794f,0.9116f,-0.3015f, 0.0000f,0.9183f,-0.3959f, -0.3407f,0.9086f,0.2417f, -0.8498f,0.2546f,0.4616f, -0.5739f,0.8104f,-0.1181f, -0.8895f,0.1157f,-0.4420f, -0.9614f,-0.2485f,-0.1177f, -0.1246f,-0.7327f,-0.6691f, 0.0622f,-0.5230f,-0.8500f, 0.3105f,-0.5688f,-0.7617f, 0.5116f,-0.6396f,-0.5738f, 0.4852f,-0.5249f,-0.6993f, 
	0.4107f,-0.7074f,-0.5752f, 0.4381f,-0.7492f,0.4968f, -0.0855f,-0.8749f,0.4768f, 0.0260f,-0.9714f,0.2360f, 0.1718f,-0.9822f,0.0754f, -0.4035f,-0.8051f,0.4347f, -0.2416f,-0.9704f,-0.0067f, 0.3314f,-0.9420f,-0.0524f, 0.4717f,-0.7197f,0.5095f, -0.1862f,-0.9329f,-0.3083f, -0.5149f,-0.8467f,0.1337f, -0.4719f,-0.8757f,-0.1019f, 0.0000f,-0.4858f,-0.8741f, -0.0000f,-0.9052f,-0.4249f, -0.0000f,-0.8891f,0.4576f, 
	-0.0000f,-0.9410f,0.3384f, -0.0000f,-0.9972f,-0.0746f, 0.6490f,-0.7595f,0.0449f, -0.5791f,-0.6942f,0.4274f, -0.7577f,-0.6525f,0.0077f, -0.7434f,-0.6622f,0.0941f, -0.2069f,-0.9595f,0.1914f, 0.0992f,-0.9950f,0.0101f, 0.0979f,-0.9820f,-0.1614f, -0.1158f,-0.9755f,0.1868f, -0.3307f,-0.8936f,0.3034f, 0.4916f,-0.6494f,-0.5802f, 0.2763f,-0.8141f,-0.5107f, 0.3892f,-0.8490f,-0.3574f, 0.3945f,-0.9171f,-0.0565f, 
	0.5157f,-0.6601f,-0.5462f, 0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, 0.0000f,-0.8597f,-0.5108f, 0.2279f,-0.7890f,-0.5706f, 0.6393f,-0.3886f,-0.6635f, 0.6209f,-0.2472f,-0.7439f, -0.0000f,-0.7751f,-0.6318f, -0.0000f,-0.8588f,-0.5123f, 0.7689f,-0.6382f,-0.0384f, 0.7736f,-0.4668f,-0.4286f, 0.7762f,-0.6140f,-0.1435f, 0.7267f,-0.5598f,-0.3982f, -0.0000f,-0.9181f,-0.3963f, -0.0000f,-0.9290f,-0.3701f, 
	0.0000f,-0.5606f,-0.8281f, 0.5027f,-0.2121f,-0.8380f, 0.0000f,-0.1566f,-0.9877f, -0.0517f,-0.8354f,0.5471f, -0.2568f,-0.7892f,-0.5579f, 0.5715f,-0.8196f,-0.0400f, 0.1883f,-0.6623f,0.7252f, 0.4223f,-0.8250f,-0.3755f, 0.5798f,-0.6649f,-0.4710f, 0.1186f,-0.9927f,-0.0229f, 0.1186f,-0.9927f,-0.0229f, -0.0438f,-0.0104f,0.9990f, 0.0617f,-0.9977f,-0.0296f, -0.0000f,-0.9939f,-0.1101f, -0.0000f,-0.9957f,-0.0926f, 
	0.1283f,-0.9906f,0.0477f, -0.0000f,-0.9978f,-0.0663f, -0.0775f,-0.9854f,-0.1517f, -0.9150f,0.0128f,0.4033f, -0.9150f,0.0128f,0.4033f, -0.6876f,0.0069f,0.7260f, -0.0450f,-0.0128f,0.9989f, -0.3467f,0.0112f,-0.9379f, -0.3467f,0.0112f,-0.9379f, -0.6733f,0.5189f,0.5266f, -0.8448f,0.4778f,0.2409f, -0.8963f,-0.3541f,0.2668f, -0.6669f,0.7416f,0.0728f, 0.2043f,-0.5099f,-0.8356f, 0.3854f,-0.0590f,-0.9209f, 
	0.1815f,-0.0211f,0.9832f, -0.4142f,0.7569f,0.5055f, 0.2985f,0.2686f,0.9159f, 0.3319f,0.1957f,0.9228f, 0.1109f,0.1202f,0.9865f, 0.2743f,0.1356f,0.9520f, 0.2328f,0.2136f,0.9488f, 0.2526f,-0.2288f,0.9401f, -0.1282f,-0.5928f,0.7951f, 0.9334f,-0.3537f,-0.0606f, 0.9392f,-0.2461f,-0.2395f, 0.8710f,-0.4824f,-0.0931f, 0.9961f,-0.0580f,0.0659f, 0.5585f,0.7301f,-0.3938f, 0.5455f,0.7792f,-0.3087f, 
	0.4211f,0.8450f,-0.3296f, 0.4198f,0.8057f,-0.4178f, 0.8440f,0.2946f,0.4483f, 0.7992f,0.5910f,0.1094f, 0.8998f,0.2352f,0.3675f, 0.8793f,0.1299f,0.4583f, 0.4127f,0.9103f,0.0323f, 0.3181f,0.8358f,0.4475f, 0.3925f,0.6104f,-0.6880f, 0.4192f,0.6792f,-0.6024f, 0.1980f,0.2162f,0.9561f, 0.5246f,0.1048f,0.8449f, 0.1893f,0.5782f,0.7936f, 0.0425f,0.3991f,0.9159f, 0.6897f,0.6424f,-0.3340f, 
	0.8193f,0.4620f,-0.3395f, 0.8743f,0.4627f,-0.1468f, 0.7539f,0.6038f,-0.2590f, 0.7275f,-0.4429f,-0.5240f, 0.8172f,0.5745f,-0.0461f, 0.7028f,0.2313f,-0.6727f, 0.8906f,0.0326f,-0.4535f, 0.7303f,-0.5184f,0.4449f, 0.6421f,-0.4904f,0.5892f, 0.7176f,-0.2931f,0.6317f, 0.7440f,0.1414f,0.6530f, 0.8249f,-0.4668f,-0.3189f, 0.8721f,-0.4866f,-0.0510f, 0.8656f,-0.3310f,-0.3756f, 0.8931f,0.1756f,-0.4142f, 
	0.7673f,-0.5469f,-0.3350f, -0.3498f,-0.8975f,-0.2686f, 0.1745f,-0.8007f,0.5731f, 0.3734f,-0.7321f,-0.5697f, 0.3076f,-0.7412f,-0.5967f, 0.1673f,-0.9201f,-0.3543f, 0.2788f,-0.9395f,-0.1990f, -0.4363f,-0.0187f,0.8996f, -0.4833f,-0.5411f,0.6882f, 0.9706f,0.0068f,-0.2406f, 0.8642f,0.3698f,-0.3411f, 0.8606f,0.4774f,-0.1771f, 0.8884f,-0.1105f,0.4457f, 0.9841f,0.0330f,0.1743f, 0.9813f,0.1059f,-0.1609f, 
	0.8983f,-0.3416f,0.2765f, 0.5300f,-0.0444f,-0.8468f, 0.5969f,0.3094f,-0.7403f, 0.4124f,0.3997f,-0.8186f, 0.8094f,-0.2216f,0.5438f, 0.5337f,-0.7565f,0.3779f, 0.7335f,-0.6592f,0.1656f, 0.5189f,-0.8548f,0.0087f, 0.5334f,-0.6284f,-0.5662f, 0.3496f,-0.2874f,-0.8917f, 0.3193f,0.6435f,0.6957f, 0.8847f,0.0783f,0.4595f, 0.8440f,0.2946f,0.4483f, 0.8793f,0.1299f,0.4583f, 0.9174f,0.3736f,0.1370f, 
	0.9048f,0.4244f,-0.0351f, 0.5518f,0.8339f,0.0068f, 0.9611f,0.1896f,-0.2007f, 0.7327f,0.3511f,-0.5830f, 0.5724f,-0.8142f,-0.0970f, 0.7432f,-0.6635f,-0.0861f, -0.1102f,-0.2628f,0.9585f, 0.1623f,-0.9814f,0.1024f, 0.0356f,-0.9991f,-0.0210f, 0.1816f,-0.9803f,0.0779f, 0.2072f,-0.9266f,0.3137f, 0.6366f,0.6938f,0.3367f, 0.5500f,0.6961f,-0.4614f, 0.5724f,0.5424f,-0.6149f, 0.9189f,-0.2997f,0.2565f, 
	0.7802f,-0.5487f,0.3003f, 0.8889f,0.0757f,0.4517f, 0.7607f,-0.1274f,0.6365f, 0.0618f,-0.1394f,0.9883f, 0.0491f,0.3071f,0.9504f, 0.7090f,-0.0399f,0.7041f, 0.3278f,-0.4532f,0.8289f, 0.4516f,0.6633f,0.5967f, 0.8884f,-0.1105f,0.4457f, 0.8606f,0.4774f,-0.1771f, 0.8799f,0.4738f,0.0356f, 0.7275f,-0.4429f,-0.5240f, 0.8906f,0.0326f,-0.4535f, 0.8983f,-0.3416f,0.2765f, 0.9706f,0.0068f,-0.2406f, 
	0.7823f,0.6224f,-0.0257f, 0.3600f,0.9179f,-0.1668f, 0.5555f,-0.8145f,0.1672f, 0.3083f,-0.8695f,0.3859f, 0.3221f,-0.9313f,0.1700f, 0.2676f,-0.7955f,0.5437f, 0.7335f,-0.6592f,0.1656f, 0.8930f,0.2256f,-0.3895f, 0.7518f,0.3816f,-0.5377f, 0.8589f,-0.4258f,0.2847f, 0.7673f,-0.5469f,-0.3350f, 0.3840f,-0.8781f,0.2853f, 0.0940f,-0.7904f,0.6053f, -0.8434f,0.1385f,-0.5190f, -0.8434f,0.1385f,-0.5190f, 
	-0.8434f,0.1385f,-0.5190f, -0.0084f,0.9999f,-0.0073f, 0.9499f,0.3082f,0.0518f, 0.8927f,-0.4413f,-0.0912f, 0.1890f,-0.9537f,-0.2338f, -0.9744f,0.1690f,0.1480f, -0.9744f,0.1690f,0.1480f, 0.0341f,0.9982f,-0.0490f, 0.9915f,0.0924f,-0.0921f, 0.1168f,-0.9931f,0.0019f, 0.3458f,0.7623f,0.5471f, 0.9657f,-0.2477f,0.0782f, 0.8642f,0.3698f,-0.3411f, 0.8562f,0.3648f,0.3658f, 0.8975f,-0.0172f,0.4407f, 
	0.6783f,-0.5839f,-0.4460f, 0.4099f,-0.4754f,-0.7784f, -0.3739f,-0.6497f,-0.6619f, -0.3941f,-0.7263f,-0.5632f, 0.2813f,0.7173f,0.6375f, 0.2037f,0.3354f,0.9198f, 0.4861f,-0.2653f,0.8327f, 0.5734f,0.6020f,0.5557f, 0.7607f,-0.1274f,0.6365f, 0.3278f,-0.4532f,0.8289f, 0.2102f,-0.1799f,0.9610f, 0.5924f,-0.4159f,0.6899f, 0.6783f,-0.5839f,-0.4460f, -0.3941f,-0.7263f,-0.5632f, 0.4535f,0.6201f,0.6401f, 
	0.5021f,-0.0402f,0.8639f, 0.4797f,0.6888f,0.5435f, 0.7868f,-0.1016f,0.6088f, 0.8314f,0.4458f,0.3316f, 0.8883f,-0.0942f,0.4495f, 0.5692f,0.7067f,0.4203f, 0.7146f,0.2383f,0.6578f, 0.9580f,-0.0855f,0.2737f, 0.9048f,0.4244f,-0.0351f, 0.3678f,0.6556f,0.6594f, 0.4137f,-0.1667f,0.8950f, 0.4137f,-0.1667f,0.8950f, 0.5926f,-0.7368f,0.3254f, 0.6096f,-0.6592f,0.4403f, 0.3572f,-0.8313f,0.4258f, 
	0.6812f,-0.7314f,-0.0316f, 0.7190f,-0.5998f,0.3510f, 0.9016f,0.3670f,-0.2290f, 0.6988f,0.1979f,0.6874f, 0.2896f,-0.2825f,0.9145f, 0.4793f,-0.3593f,0.8008f, 0.4861f,-0.2653f,0.8327f, -0.9749f,-0.1898f,-0.1161f, -0.9749f,-0.1898f,-0.1161f, -0.4197f,-0.8779f,-0.2304f, 0.0171f,-0.9256f,-0.3782f, 0.6172f,-0.6923f,-0.3739f, 0.9090f,-0.1742f,-0.3787f, 0.8737f,0.4090f,-0.2634f, 0.9011f,0.3601f,-0.2413f, 
	0.0547f,0.9525f,-0.2995f, -0.1867f,0.9384f,-0.2907f, 0.4793f,-0.3593f,0.8008f, -0.1867f,0.9384f,-0.2907f, -0.9749f,-0.1898f,-0.1161f, 0.4137f,-0.1667f,0.8950f, 0.5094f,0.0339f,0.8599f, 0.8493f,0.5145f,0.1186f, -0.0429f,0.9244f,-0.3791f, 0.4750f,0.4516f,0.7553f, 0.5383f,-0.5612f,0.6287f, 0.5654f,-0.2870f,0.7733f, 0.5691f,-0.4942f,0.6572f, -0.0429f,0.9244f,-0.3791f, -0.9116f,-0.4095f,-0.0362f, 
	-0.6788f,0.6202f,-0.3933f, -0.4401f,0.8629f,-0.2484f, -0.6788f,0.6202f,-0.3933f, -0.3287f,-0.0071f,0.9444f, -0.0936f,0.1318f,0.9868f, 0.6180f,0.4318f,0.6570f, 0.1854f,-0.1220f,0.9751f, -0.5930f,-0.4120f,0.6918f, 0.2794f,0.9116f,-0.3015f, 0.3407f,0.9086f,0.2417f, 0.8498f,0.2546f,0.4616f, 0.3600f,0.9179f,-0.1668f, 0.4211f,0.8450f,-0.3296f, 0.5455f,0.7792f,-0.3087f, 0.5739f,0.8104f,-0.1181f, 
	0.9614f,-0.2485f,-0.1177f, 0.8895f,0.1157f,-0.4420f, 0.1246f,-0.7327f,-0.6691f, -0.5116f,-0.6396f,-0.5738f, -0.3105f,-0.5688f,-0.7617f, -0.0622f,-0.5230f,-0.8500f, -0.4107f,-0.7074f,-0.5752f, -0.4852f,-0.5249f,-0.6993f, -0.4381f,-0.7492f,0.4968f, 0.0855f,-0.8749f,0.4768f, 0.1745f,-0.8007f,0.5731f, -0.3498f,-0.8975f,-0.2686f, -0.0260f,-0.9714f,0.2360f, 0.2416f,-0.9704f,-0.0067f, 0.4035f,-0.8051f,0.4347f, 
	-0.1718f,-0.9822f,0.0754f, -0.4717f,-0.7197f,0.5095f, -0.3314f,-0.9420f,-0.0524f, 0.1862f,-0.9329f,-0.3083f, 0.4719f,-0.8757f,-0.1019f, 0.5149f,-0.8467f,0.1337f, -0.3739f,-0.6497f,-0.6619f, -0.6490f,-0.7595f,0.0449f, 0.5791f,-0.6942f,0.4274f, -0.6490f,-0.7595f,0.0449f, 0.7577f,-0.6525f,0.0077f, 0.4035f,-0.8051f,0.4347f, 0.2416f,-0.9704f,-0.0067f, 0.7434f,-0.6622f,0.0941f, -0.0992f,-0.9950f,0.0101f, 
	0.2069f,-0.9595f,0.1914f, -0.0979f,-0.9820f,-0.1614f, 0.1158f,-0.9755f,0.1868f, -0.0979f,-0.9820f,-0.1614f, 0.3307f,-0.8936f,0.3034f, 0.9961f,-0.0580f,0.0659f, 0.8589f,-0.4258f,0.2847f, -0.4916f,-0.6494f,-0.5802f, -0.2763f,-0.8141f,-0.5107f, -0.3892f,-0.8490f,-0.3574f, -0.3945f,-0.9171f,-0.0565f, -0.4465f,-0.7346f,-0.5109f, -0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, -0.2279f,-0.7890f,-0.5706f, 
	-0.6393f,-0.3886f,-0.6635f, -0.6209f,-0.2472f,-0.7439f, -0.7689f,-0.6382f,-0.0384f, -0.7736f,-0.4668f,-0.4286f, -0.7762f,-0.6140f,-0.1435f, -0.7267f,-0.5598f,-0.3982f, -0.5027f,-0.2121f,-0.8380f, 0.2568f,-0.7892f,-0.5579f, -0.5019f,-0.7006f,-0.5072f, -0.0120f,-0.9986f,0.0522f, -0.4223f,-0.8250f,-0.3755f, -0.5798f,-0.6649f,-0.4710f, -0.1519f,-0.9870f,-0.0535f, -0.1186f,-0.9927f,-0.0229f, 0.0450f,-0.0128f,0.9989f, 
	-0.0617f,-0.9977f,-0.0296f, -0.0407f,-0.9983f,0.0418f, 0.0775f,-0.9854f,-0.1517f, 0.9144f,0.0161f,0.4044f, 0.9150f,0.0128f,0.4033f, 0.6874f,0.0078f,0.7262f, 0.3485f,0.0178f,-0.9371f, 0.6733f,0.5189f,0.5266f, 0.8448f,0.4778f,0.2409f, 0.8963f,-0.3541f,0.2668f, 0.6669f,0.7416f,0.0728f, 0.4127f,0.9103f,0.0323f, 0.6669f,0.7416f,0.0728f, 
_NULL_ }; /* End of skull3_Normals */

const unsigned short skull3_Faces[] = {
	0, 2, 1, 2, 0, 3, 4, 6, 5, 6, 8, 7, 4, 8, 6, 8, 10, 9, 4, 10, 8, 4, 11, 10, 4, 12, 11, 13, 15, 14, 
	15, 13, 16, 17, 19, 18, 19, 17, 20, 21, 23, 22, 23, 21, 24, 25, 27, 26, 27, 25, 28, 29, 31, 30, 31, 29, 32, 33, 35, 34, 
	35, 33, 36, 37, 39, 38, 39, 37, 40, 41, 43, 42, 43, 41, 44, 45, 47, 46, 47, 45, 48, 49, 51, 50, 51, 49, 52, 53, 55, 54, 
	56, 58, 57, 58, 56, 59, 60, 62, 61, 62, 60, 63, 64, 66, 65, 66, 64, 67, 68, 13, 69, 13, 68, 70, 71, 72, 2, 72, 71, 73, 
	47, 74, 46, 74, 47, 75, 51, 77, 76, 77, 51, 78, 56, 3, 59, 3, 56, 79, 80, 26, 81, 26, 80, 25, 82, 22, 83, 22, 82, 21, 
	66, 67, 84, 85, 87, 86, 87, 85, 44, 88, 52, 89, 52, 88, 51, 71, 3, 79, 3, 71, 2, 61, 91, 90, 91, 61, 62, 92, 94, 93, 
	94, 92, 95, 18, 97, 96, 97, 18, 19, 26, 27, 98, 99, 32, 100, 32, 99, 31, 101, 34, 102, 34, 101, 33, 103, 105, 104, 105, 103, 106, 
	107, 59, 108, 59, 107, 58, 109, 63, 110, 63, 109, 62, 2, 111, 1, 111, 2, 72, 105, 112, 104, 112, 105, 113, 108, 3, 0, 3, 108, 59, 
	26, 114, 81, 102, 63, 60, 63, 102, 34, 34, 110, 63, 110, 34, 35, 83, 66, 84, 66, 83, 22, 22, 65, 66, 65, 22, 23, 115, 70, 68, 
	70, 115, 39, 73, 32, 72, 32, 73, 100, 32, 111, 72, 111, 32, 29, 78, 64, 69, 78, 42, 64, 78, 41, 42, 69, 65, 68, 65, 69, 64, 
	68, 23, 115, 23, 68, 65, 115, 24, 116, 24, 115, 23, 117, 27, 28, 27, 117, 118, 119, 121, 120, 121, 119, 122, 69, 14, 78, 14, 69, 13, 
	116, 39, 115, 39, 116, 38, 16, 70, 123, 70, 16, 13, 14, 125, 124, 14, 53, 125, 14, 15, 53, 126, 122, 119, 122, 126, 127, 70, 40, 123, 
	40, 70, 39, 128, 129, 41, 129, 128, 130, 41, 131, 44, 131, 41, 129, 44, 132, 87, 132, 44, 131, 133, 130, 128, 130, 133, 134, 130, 135, 129, 
	135, 130, 136, 129, 137, 131, 137, 129, 135, 138, 131, 137, 138, 132, 131, 138, 134, 132, 134, 136, 130, 134, 139, 136, 134, 138, 139, 136, 124, 135, 
	124, 136, 140, 135, 125, 137, 125, 135, 124, 137, 141, 138, 141, 137, 125, 42, 67, 64, 67, 42, 43, 67, 143, 142, 143, 67, 43, 144, 146, 145, 
	146, 144, 147, 148, 150, 149, 150, 148, 151, 85, 43, 44, 43, 85, 143, 104, 150, 152, 150, 104, 112, 152, 151, 153, 151, 152, 150, 86, 144, 145, 
	144, 86, 87, 87, 134, 133, 134, 87, 132, 109, 155, 154, 155, 109, 110, 155, 35, 156, 35, 155, 110, 156, 36, 157, 36, 156, 35, 158, 90, 91, 
	90, 158, 159, 160, 155, 161, 155, 160, 154, 161, 156, 162, 156, 161, 155, 162, 157, 163, 157, 162, 156, 84, 67, 142, 164, 166, 165, 166, 164, 167, 
	165, 168, 154, 168, 165, 166, 154, 169, 109, 169, 154, 168, 169, 62, 109, 62, 169, 170, 91, 170, 171, 170, 91, 62, 91, 172, 158, 172, 91, 171, 
	112, 174, 173, 174, 112, 113, 112, 175, 150, 175, 112, 173, 150, 167, 164, 167, 150, 175, 167, 176, 166, 176, 167, 177, 166, 178, 168, 178, 166, 176, 
	168, 179, 169, 179, 168, 178, 169, 180, 170, 180, 169, 179, 170, 181, 171, 181, 170, 180, 171, 182, 172, 171, 183, 182, 171, 181, 183, 184, 182, 183, 
	184, 172, 182, 184, 174, 172, 184, 173, 174, 173, 185, 175, 185, 173, 184, 175, 177, 167, 177, 175, 185, 177, 5, 176, 5, 177, 4, 176, 6, 178, 
	6, 176, 5, 178, 7, 179, 7, 178, 6, 179, 8, 180, 8, 179, 7, 180, 9, 181, 9, 180, 8, 181, 10, 183, 10, 181, 9, 183, 11, 184, 
	11, 183, 10, 184, 12, 185, 12, 184, 11, 185, 4, 177, 4, 185, 12, 172, 113, 158, 113, 172, 174, 113, 46, 158, 46, 113, 105, 46, 106, 45, 
	106, 46, 105, 186, 74, 187, 74, 186, 188, 158, 189, 159, 189, 158, 190, 191, 193, 192, 193, 191, 194, 192, 196, 195, 196, 192, 193, 186, 198, 197, 
	198, 186, 187, 199, 201, 200, 202, 204, 203, 204, 202, 205, 206, 208, 207, 209, 211, 210, 211, 203, 212, 209, 203, 211, 209, 202, 203, 213, 207, 214, 
	207, 213, 206, 205, 190, 204, 190, 205, 189, 74, 158, 46, 158, 74, 188, 215, 75, 216, 75, 215, 74, 194, 208, 206, 208, 194, 191, 118, 20, 217, 
	20, 118, 19, 97, 118, 117, 118, 97, 19, 50, 218, 49, 218, 50, 219, 220, 222, 221, 222, 220, 223, 223, 224, 222, 224, 223, 225, 226, 54, 55, 
	54, 226, 227, 228, 230, 229, 230, 228, 231, 120, 232, 119, 232, 120, 233, 119, 234, 126, 234, 119, 232, 229, 235, 228, 235, 229, 236, 237, 225, 238, 
	225, 237, 224, 233, 240, 239, 240, 233, 120, 120, 241, 240, 241, 120, 121, 145, 146, 242, 146, 243, 242, 243, 146, 88, 88, 244, 243, 244, 88, 89, 
	230, 227, 226, 227, 230, 231, 93, 122, 127, 122, 93, 94, 53, 245, 125, 245, 53, 54, 245, 247, 246, 245, 227, 247, 245, 54, 227, 227, 248, 247, 
	248, 227, 231, 231, 249, 248, 249, 231, 228, 228, 250, 249, 250, 228, 235, 76, 219, 50, 219, 76, 77, 50, 51, 76, 238, 233, 239, 233, 238, 225, 
	225, 232, 233, 232, 225, 223, 223, 234, 232, 234, 223, 220, 236, 219, 235, 219, 236, 218, 235, 77, 250, 77, 235, 219, 78, 250, 77, 78, 249, 250, 
	78, 124, 249, 78, 14, 124, 41, 51, 147, 51, 41, 78, 146, 51, 88, 51, 146, 147, 216, 194, 206, 194, 216, 75, 193, 75, 47, 75, 193, 194, 
	48, 193, 47, 193, 48, 196, 187, 211, 198, 187, 201, 211, 187, 200, 201, 213, 210, 211, 210, 213, 214, 251, 45, 252, 45, 251, 48, 253, 49, 254, 
	49, 253, 52, 255, 52, 253, 52, 255, 89, 256, 103, 257, 103, 256, 106, 252, 106, 256, 106, 252, 45, 258, 196, 259, 196, 258, 195, 257, 89, 255, 
	89, 257, 244, 259, 48, 251, 48, 259, 196, 260, 262, 261, 262, 260, 263, 264, 254, 265, 254, 264, 253, 266, 268, 267, 268, 266, 269, 267, 263, 260, 
	263, 267, 268, 270, 272, 271, 261, 270, 271, 270, 261, 262, 264, 237, 273, 237, 264, 274, 275, 253, 264, 253, 275, 255, 273, 276, 264, 276, 273, 269, 
	277, 267, 256, 267, 278, 266, 277, 278, 267, 260, 256, 267, 256, 260, 252, 251, 260, 261, 260, 251, 252, 259, 261, 271, 261, 259, 251, 272, 259, 271, 
	259, 272, 258, 279, 94, 280, 94, 279, 122, 281, 122, 279, 122, 281, 121, 282, 284, 283, 284, 282, 95, 280, 285, 282, 285, 280, 94, 241, 287, 286, 
	287, 241, 121, 288, 280, 289, 280, 288, 279, 290, 279, 288, 279, 290, 281, 291, 281, 290, 281, 291, 286, 292, 283, 293, 283, 292, 282, 289, 282, 292, 
	282, 289, 280, 26, 294, 114, 294, 26, 98, 295, 294, 98, 294, 295, 296, 297, 98, 27, 98, 297, 295, 27, 217, 297, 217, 27, 118, 0, 299, 298, 
	299, 0, 1, 300, 302, 301, 300, 303, 302, 303, 305, 304, 300, 305, 303, 305, 307, 306, 300, 307, 305, 300, 308, 307, 309, 311, 310, 311, 309, 312, 
	313, 315, 314, 315, 313, 316, 317, 319, 318, 319, 317, 320, 25, 321, 28, 321, 25, 322, 29, 324, 323, 324, 29, 30, 325, 327, 326, 327, 325, 328, 
	329, 331, 330, 331, 329, 332, 333, 335, 334, 335, 333, 336, 337, 339, 338, 339, 337, 340, 341, 343, 342, 343, 341, 344, 345, 347, 346, 348, 350, 349, 
	350, 348, 351, 60, 353, 352, 353, 60, 61, 354, 356, 355, 356, 354, 357, 358, 309, 359, 309, 358, 360, 361, 363, 362, 363, 361, 299, 339, 365, 364, 
	365, 339, 340, 343, 367, 366, 367, 343, 368, 348, 298, 369, 298, 348, 349, 80, 322, 25, 322, 80, 370, 371, 373, 372, 373, 371, 374, 356, 375, 355, 
	376, 377, 334, 377, 376, 378, 379, 342, 343, 342, 379, 380, 361, 298, 299, 298, 361, 369, 61, 381, 353, 381, 61, 90, 382, 384, 383, 384, 382, 385, 
	316, 97, 315, 97, 316, 96, 322, 386, 321, 387, 323, 324, 323, 387, 388, 325, 102, 328, 102, 325, 101, 389, 391, 390, 391, 389, 392, 107, 349, 350, 
	349, 107, 108, 393, 352, 353, 352, 393, 394, 299, 111, 363, 111, 299, 1, 391, 396, 395, 396, 391, 392, 108, 298, 349, 298, 108, 0, 322, 370, 397, 
	102, 352, 328, 352, 102, 60, 328, 394, 327, 394, 328, 352, 374, 356, 373, 356, 374, 375, 320, 398, 319, 398, 320, 399, 400, 359, 331, 359, 400, 358, 
	362, 323, 388, 323, 362, 363, 323, 111, 29, 111, 323, 363, 366, 402, 401, 366, 354, 402, 366, 403, 354, 360, 398, 404, 398, 360, 358, 358, 319, 398, 
	319, 358, 400, 400, 318, 319, 318, 400, 405, 117, 321, 406, 321, 117, 28, 407, 409, 408, 409, 407, 410, 360, 312, 309, 312, 360, 411, 405, 331, 332, 
	331, 405, 400, 310, 359, 309, 359, 310, 412, 413, 312, 414, 312, 415, 311, 413, 415, 312, 416, 408, 417, 408, 416, 407, 359, 330, 331, 330, 359, 412, 
	418, 420, 419, 420, 418, 333, 333, 421, 420, 421, 333, 334, 334, 422, 421, 422, 334, 377, 423, 419, 424, 419, 423, 418, 419, 426, 425, 426, 419, 420, 
	420, 427, 426, 427, 420, 421, 421, 428, 427, 428, 422, 424, 421, 422, 428, 424, 429, 428, 424, 425, 429, 424, 419, 425, 425, 414, 430, 414, 425, 426, 
	426, 413, 414, 413, 426, 427, 427, 431, 413, 431, 427, 428, 336, 432, 335, 432, 336, 404, 432, 433, 335, 433, 432, 434, 435, 437, 436, 437, 435, 438, 
	439, 441, 440, 441, 439, 442, 376, 335, 433, 335, 376, 334, 443, 441, 444, 441, 443, 445, 445, 440, 441, 440, 445, 446, 378, 447, 377, 447, 378, 448, 
	377, 424, 422, 424, 377, 423, 393, 449, 394, 449, 393, 450, 449, 327, 394, 327, 449, 451, 451, 326, 327, 326, 451, 452, 90, 453, 381, 453, 90, 159, 
	454, 449, 450, 449, 454, 455, 455, 451, 449, 451, 455, 456, 456, 452, 451, 452, 456, 457, 458, 434, 432, 459, 461, 460, 461, 459, 462, 462, 463, 461, 
	463, 462, 450, 450, 464, 463, 464, 450, 393, 464, 353, 465, 353, 464, 393, 465, 381, 466, 381, 465, 353, 381, 467, 466, 467, 381, 453, 396, 468, 395, 
	468, 396, 469, 396, 470, 469, 470, 396, 471, 471, 460, 470, 460, 471, 459, 460, 473, 472, 473, 460, 461, 461, 474, 473, 474, 461, 463, 463, 475, 474, 
	475, 463, 464, 464, 476, 475, 476, 464, 465, 465, 477, 476, 477, 465, 466, 466, 478, 477, 466, 479, 478, 466, 467, 479, 480, 468, 469, 480, 467, 468, 
	480, 479, 467, 480, 478, 479, 469, 481, 480, 481, 469, 470, 482, 484, 483, 484, 482, 485, 472, 308, 300, 308, 472, 473, 473, 307, 308, 307, 473, 474, 
	474, 306, 307, 306, 474, 475, 475, 305, 306, 305, 475, 476, 476, 304, 305, 304, 476, 477, 477, 303, 304, 303, 477, 478, 478, 302, 303, 302, 478, 480, 
	480, 301, 302, 301, 480, 481, 481, 300, 301, 300, 481, 472, 467, 395, 468, 395, 467, 453, 395, 340, 391, 340, 395, 453, 340, 390, 391, 390, 340, 337, 
	486, 365, 487, 365, 486, 488, 453, 189, 489, 189, 453, 159, 191, 491, 490, 491, 191, 192, 192, 492, 491, 492, 192, 195, 486, 493, 488, 493, 486, 494, 
	495, 497, 496, 202, 498, 205, 498, 202, 499, 500, 207, 208, 501, 209, 210, 209, 499, 202, 501, 499, 209, 501, 502, 499, 503, 207, 500, 207, 503, 214, 
	205, 489, 189, 489, 205, 498, 365, 453, 487, 453, 365, 340, 504, 364, 365, 364, 504, 505, 490, 208, 191, 208, 490, 500, 506, 508, 507, 508, 506, 509, 
	97, 406, 315, 406, 97, 117, 344, 511, 510, 511, 344, 341, 512, 514, 513, 514, 512, 515, 513, 517, 516, 517, 513, 514, 518, 520, 519, 520, 518, 521, 
	522, 524, 523, 524, 522, 525, 410, 527, 526, 527, 410, 407, 407, 528, 527, 528, 407, 416, 525, 530, 529, 530, 525, 522, 237, 516, 517, 516, 237, 238, 
	526, 240, 410, 240, 526, 239, 410, 241, 409, 241, 410, 240, 448, 532, 531, 437, 533, 379, 533, 437, 534, 379, 535, 380, 535, 379, 533, 536, 519, 537, 
	519, 536, 518, 385, 408, 384, 408, 385, 417, 415, 538, 520, 538, 415, 413, 538, 519, 520, 538, 539, 519, 538, 540, 539, 519, 541, 537, 541, 519, 539, 
	523, 542, 522, 542, 523, 543, 522, 544, 530, 544, 522, 542, 368, 510, 367, 510, 368, 344, 344, 368, 343, 238, 526, 516, 526, 238, 239, 516, 527, 513, 
	527, 516, 526, 513, 528, 512, 528, 513, 527, 529, 510, 511, 510, 529, 530, 530, 367, 510, 367, 530, 544, 544, 366, 367, 366, 546, 545, 366, 542, 546, 
	544, 542, 366, 401, 343, 366, 343, 401, 436, 437, 343, 436, 343, 437, 379, 505, 490, 364, 490, 505, 500, 491, 364, 490, 364, 491, 339, 338, 491, 492, 
	491, 338, 339, 488, 496, 497, 488, 501, 496, 488, 493, 501, 503, 210, 214, 210, 503, 501, 547, 337, 338, 337, 547, 548, 549, 341, 342, 341, 549, 550, 
	551, 342, 380, 342, 551, 549, 552, 389, 390, 389, 552, 553, 548, 390, 337, 390, 548, 552, 258, 492, 195, 492, 258, 554, 553, 380, 535, 380, 553, 551, 
	554, 338, 492, 338, 554, 547, 555, 262, 263, 262, 555, 556, 557, 550, 549, 550, 557, 558, 559, 268, 269, 268, 559, 560, 560, 263, 268, 263, 560, 555, 
	270, 561, 272, 556, 270, 262, 270, 556, 561, 557, 237, 562, 237, 557, 273, 563, 549, 551, 549, 563, 557, 273, 564, 269, 564, 273, 557, 560, 565, 552, 
	560, 566, 565, 560, 559, 566, 555, 552, 548, 552, 555, 560, 547, 555, 548, 555, 547, 556, 554, 556, 547, 556, 554, 561, 272, 554, 258, 554, 272, 561, 
	567, 384, 408, 384, 567, 568, 569, 408, 409, 408, 569, 567, 570, 284, 383, 284, 570, 283, 568, 571, 384, 571, 568, 570, 241, 572, 409, 572, 241, 286, 
	573, 568, 567, 568, 573, 574, 575, 567, 569, 567, 575, 573, 291, 569, 286, 569, 291, 575, 576, 283, 570, 283, 576, 293, 574, 570, 568, 570, 574, 576, 
	322, 577, 386, 577, 322, 397, 578, 577, 579, 577, 578, 386, 580, 386, 578, 386, 580, 321, 581, 509, 506, 509, 581, 582, 
_NULL_ }; /* End of skull3_Faces */


/* MESH 3 */

#define skull6_NumVertex  583
#define skull6_NumFaces   838
#define skull6_NumStrips  0
#define skull6_Flags      0x00020006
#define skull6_Material   0

const float skull6_Vertices[] = {
	1.1337f,-30.7901f,-94.2595f, 1.1337f,21.8917f,-125.2639f, -37.5121f,16.9488f,-113.0244f, -24.9012f,-34.4217f,-92.8903f, -54.0622f,-1.6057f,22.5511f, 
	-51.8920f,6.1041f,27.9488f, -43.4186f,9.3742f,29.0202f, -33.0267f,11.4509f,31.1024f, -15.7803f,2.5378f,37.3409f, -12.6014f,-5.9891f,38.7367f, 
	-23.4119f,-13.7772f,38.4702f, -38.1606f,-16.7290f,32.1675f, -47.0855f,-11.7429f,32.0139f, -89.0579f,9.8441f,-48.7060f, -80.1998f,-3.8524f,-33.6998f, 
	-71.1781f,-13.5720f,-81.4688f, -81.4720f,7.1799f,-82.8177f, -67.0311f,63.5996f,-55.7230f, -37.8226f,77.2215f,-74.6963f, -35.8188f,91.1199f,-48.9697f, 
	-72.0871f,70.1446f,-37.5740f, -67.2647f,72.2028f,32.0756f, -64.3096f,52.6419f,40.8723f, -78.1101f,60.6806f,21.2626f, -69.6222f,75.0868f,9.3509f, 
	1.1337f,98.3649f,47.6326f, -32.0980f,90.6309f,55.4713f, -42.1046f,98.7173f,2.2674f, 1.1337f,107.7151f,2.8623f, 1.1337f,65.9923f,-97.9894f, 
	1.1337f,85.0664f,-81.1920f, -37.8226f,77.2215f,-74.6963f, -39.0058f,60.6855f,-93.5265f, -21.7624f,73.1312f,76.4029f, -17.0674f,47.1741f,82.6534f, 
	-32.4102f,48.3726f,80.0008f, -42.0995f,71.5844f,69.0734f, -67.0311f,63.5996f,-55.7230f, -72.0871f,70.1446f,-37.5740f, -85.5980f,54.0933f,-35.6702f, 
	-76.1388f,48.7393f,-69.5015f, -67.7598f,-8.4485f,39.9771f, -63.9896f,6.1989f,35.0984f, -76.2648f,11.3425f,39.3496f, -90.0678f,-7.2150f,35.9753f, 
	-28.1269f,-65.5598f,91.4289f, -25.1130f,-51.2734f,82.9855f, -13.3140f,-53.3318f,96.1669f, -18.6619f,-66.6641f,101.6298f, -42.4282f,-51.5871f,39.6864f, 
	-39.6511f,-42.8894f,37.4174f, -38.0281f,-29.4775f,44.8428f, -45.2051f,-52.9658f,50.1629f, -59.7759f,-35.7219f,-74.1697f, -70.8905f,-58.3773f,-19.2705f, 
	-54.1137f,-42.2233f,-51.4053f, -59.7759f,-35.7219f,-74.1697f, -54.1137f,-42.2233f,-51.4053f, -26.2549f,-45.8518f,-73.3166f, -35.5634f,-39.5563f,-84.6414f, 
	1.1337f,17.6574f,86.1839f, 1.1337f,-0.9721f,83.6359f, -10.8745f,-10.1353f,89.5099f, -6.8852f,10.6937f,99.7213f, -63.6296f,22.3134f,36.6760f, 
	-72.1351f,43.3299f,25.7328f, -65.5411f,38.7030f,46.7732f, -77.7927f,31.2452f,45.9586f, -92.0584f,32.7660f,-14.5963f, -84.6596f,8.0952f,-3.8216f, 
	-92.7651f,29.6651f,-47.0788f, -81.4720f,7.1799f,-82.8177f, -40.1873f,46.9405f,-101.9145f, -80.1621f,28.1101f,-76.8754f, -27.3733f,-49.6025f,90.2640f, 
	-15.0259f,-50.9719f,101.6886f, -34.7827f,-21.9903f,36.7797f, -40.5812f,-15.8404f,24.5851f, -65.9953f,-10.2918f,20.9091f, -71.1781f,-13.5720f,-81.4688f, 
	1.1337f,74.6659f,77.9980f, -21.7624f,73.1312f,76.4029f, -61.0576f,66.1071f,44.8398f, -57.1271f,53.9467f,54.7963f, -69.4043f,45.9051f,65.6238f, 
	-81.3633f,-7.6320f,59.4140f, -109.8093f,-3.1584f,64.2789f, -95.5266f,-18.3153f,38.8229f, -37.9642f,-31.8156f,54.6281f, -42.6263f,-55.5465f,56.4451f, 
	1.1337f,-7.4762f,87.4283f, -7.8817f,-1.8633f,82.0587f, -54.1137f,-42.2233f,-51.4053f, -47.7420f,-40.1763f,-35.5613f, -32.5139f,-45.4468f,-48.0726f, 
	-26.2549f,-45.8518f,-73.3166f, 1.1337f,85.0664f,-81.1920f, 1.1337f,99.4302f,-57.3276f, -57.2446f,83.3396f,41.9866f, -67.0311f,63.5996f,-55.7230f, 
	-76.1388f,48.7393f,-69.5015f, 1.1337f,74.6659f,77.9980f, 1.1337f,38.9312f,84.2632f, -42.6795f,-58.0143f,66.9482f, -28.9595f,-34.8087f,67.6045f, 
	-27.1686f,-37.6551f,75.2865f, -38.8492f,-60.6764f,74.6558f, 1.1337f,-43.8196f,-82.4337f, 1.1337f,-41.2261f,-92.6549f, -30.0820f,-5.6489f,96.9569f, 
	-35.8442f,19.5637f,95.0698f, 1.1337f,52.2313f,-108.0713f, -33.9301f,-24.9061f,73.5508f, -22.8556f,-21.7753f,83.9085f, -42.0995f,71.5844f,69.0734f, 
	-82.7821f,60.6186f,-13.2794f, -69.6031f,77.3893f,-16.9732f, 1.1337f,105.6022f,-32.3375f, -33.1801f,99.0184f,-25.4025f, -26.7100f,-26.5276f,-2.3925f, 
	-12.4672f,-44.6201f,-11.7627f, -13.5030f,-46.5521f,-23.3800f, -26.2096f,-45.2005f,-34.7180f, -80.1621f,28.1101f,-76.8754f, -76.6063f,-7.2097f,-27.7625f, 
	-90.6416f,-10.1043f,-35.2516f, -44.8686f,-16.9968f,-2.9173f, -45.9379f,-32.1497f,-20.7392f, -52.9554f,-21.0732f,58.6414f, -81.6330f,-8.5110f,15.3930f, 
	-80.7108f,-23.9795f,12.7629f, -91.4935f,-8.4163f,16.9790f, -94.7011f,-18.1911f,16.3205f, -90.4729f,-29.1118f,41.5926f, -91.0126f,-22.7357f,16.0164f, 
	-78.9958f,-9.8938f,-14.6127f, -77.9746f,-24.0348f,-5.1861f, -88.8467f,-10.1644f,-13.2790f, -90.0890f,-22.8992f,-12.6770f, -84.7942f,-23.5171f,-10.0516f, 
	-60.5576f,-20.1807f,0.4522f, -85.8197f,-27.3248f,-30.2514f, -66.2951f,28.5255f,69.2665f, -74.6983f,3.0425f,54.7273f, -90.4729f,-29.1118f,41.5926f, 
	-69.8786f,-63.2630f,62.3315f, -54.0840f,-41.4268f,59.0158f, -52.9554f,-21.0732f,58.6414f, -81.3633f,-7.6320f,59.4140f, -74.6983f,3.0425f,54.7273f, 
	-80.0866f,-25.6569f,80.2566f, -109.8093f,-3.1584f,64.2789f, -62.1440f,-47.1525f,78.6852f, -69.8786f,-63.2630f,62.3315f, -54.4526f,28.5514f,90.8946f, 
	-57.9485f,47.5507f,89.7473f, -44.6686f,47.3032f,66.8337f, -56.9786f,66.6703f,59.2929f, -7.6736f,-18.6613f,97.1055f, 1.1337f,3.5665f,95.2632f, 
	-66.2951f,28.5255f,69.2665f, -69.4043f,45.9051f,65.6238f, -57.1271f,53.9467f,54.7963f, -61.0576f,66.1071f,44.8398f, -74.6983f,3.0425f,54.7273f, 
	-66.2951f,28.5255f,69.2665f, -61.3955f,20.5710f,64.1411f, -66.1343f,3.7361f,58.8148f, -51.8274f,20.2901f,76.9689f, -27.6443f,13.4391f,83.8781f, 
	-13.1525f,0.3246f,75.0005f, -7.7841f,-7.3652f,72.8559f, -10.2183f,-11.8445f,75.2605f, -38.0098f,-16.6790f,74.7998f, -24.9843f,-14.4131f,79.6249f, 
	-57.4485f,-13.9469f,64.3902f, -64.0914f,25.5293f,40.3369f, -69.2356f,3.7580f,32.7282f, -43.1819f,36.2911f,37.4229f, -25.5440f,33.8247f,42.6606f, 
	-5.5062f,11.0810f,51.6993f, 0.5654f,-7.1433f,45.5065f, -6.7621f,-18.2130f,52.8511f, -6.0094f,-19.6000f,47.9708f, -37.5164f,-25.1148f,47.8831f, 
	-64.8057f,-24.5661f,32.1224f, -4.7654f,-23.8559f,102.6403f, -16.0166f,-47.9988f,89.1134f, -8.9876f,-21.5087f,100.0466f, 1.1337f,-4.1509f,97.7966f, 
	-8.9876f,-21.5087f,100.0466f, 1.1337f,-51.7012f,114.0232f, 1.1337f,-57.5566f,109.9395f, -3.2199f,-55.0928f,107.4436f, -5.0631f,-52.0769f,110.9069f, 
	1.1337f,-70.1007f,114.8415f, -10.1372f,-67.4703f,108.5808f, -3.6797f,-19.9995f,86.3397f, -18.1671f,-51.6814f,79.8910f, -7.2704f,-41.1215f,115.0542f, 
	-11.9865f,-44.8299f,101.0663f, -9.0878f,-48.1650f,100.8103f, 1.1337f,-10.5147f,81.2337f, -3.6797f,-19.9995f,86.3397f, -4.7654f,-23.8559f,102.6403f, 
	1.1337f,-17.5548f,101.2985f, -7.2704f,-41.1215f,115.0542f, 1.1337f,-38.3493f,107.3554f, 1.1337f,-47.4108f,116.2882f, 1.1337f,-37.9871f,102.2455f, 
	1.1337f,-45.1302f,94.8825f, -11.5399f,-55.1711f,72.1319f, -18.1671f,-51.6814f,79.8910f, -9.0878f,-48.1650f,100.8103f, 1.1337f,-48.0521f,102.2168f, 
	-16.0166f,-47.9988f,89.1134f, -11.9865f,-44.8299f,101.0663f, -69.6031f,77.3893f,-16.9732f, -33.0095f,-34.3247f,29.7542f, -31.9718f,-25.9328f,29.8641f, 
	-33.0095f,-34.3247f,29.7542f, -42.4282f,-51.5871f,39.6864f, -30.0523f,-51.9099f,40.7909f, -25.1297f,-37.4772f,31.5811f, -19.6653f,-38.4534f,44.8830f, 
	-17.1784f,-23.2891f,36.5294f, -47.7420f,-40.1763f,-35.5613f, -68.4479f,-18.3408f,-23.6382f, -52.9284f,-18.6324f,-1.1863f, -44.8686f,-16.9968f,-2.9173f, 
	-45.9379f,-32.1497f,-20.7392f, -63.5211f,-21.8504f,-16.3410f, -24.2741f,-27.3208f,14.0619f, -10.1614f,-16.1620f,-1.3083f, -31.0205f,-27.5091f,16.1315f, 
	-38.5076f,-25.6793f,17.8938f, -31.0205f,-27.5091f,16.1315f, 1.1337f,-45.1725f,44.8126f, 1.1337f,-16.3926f,27.9100f, 1.1337f,-12.6555f,-0.9582f, 
	1.1337f,-49.4843f,-15.2001f, 1.1337f,-47.8436f,-21.7446f, -62.1440f,-47.1525f,78.6852f, -28.9595f,-34.8087f,67.6045f, -42.6795f,-58.0143f,66.9482f, 
	-85.8197f,-27.3248f,-30.2514f, -90.0890f,-22.8992f,-12.6770f, -84.7942f,-23.5171f,-10.0516f, -77.9746f,-24.0348f,-5.1861f, -60.5576f,-20.1807f,0.4522f, 
	-51.5436f,-13.6912f,13.2628f, -12.0258f,-66.6640f,91.3655f, -22.2945f,-65.0439f,86.6590f, -32.5745f,-52.9658f,50.1629f, -30.0523f,-51.9099f,40.7909f, 
	-29.5913f,-55.5465f,53.4879f, -28.8559f,-60.6764f,71.5255f, -31.4195f,-58.0143f,66.9482f, 1.1337f,-70.1007f,104.1904f, -5.7075f,-67.4702f,101.2014f, 
	-19.1259f,-55.6845f,86.6590f, -12.7732f,-57.2462f,91.3655f, 1.1337f,-43.8447f,91.3655f, 1.1337f,-40.3075f,86.6590f, -19.2523f,-41.3275f,48.7585f, 
	-19.6653f,-38.4534f,44.8830f, -25.6265f,-40.9078f,58.2473f, -24.7092f,-48.4506f,71.5254f, 1.1337f,-34.2192f,71.5254f, 1.1337f,-30.0953f,61.1724f, 
	1.1337f,-51.2723f,101.2013f, -3.5046f,-62.2401f,101.2014f, 1.1337f,-63.5038f,103.2182f, 1.1337f,-40.9517f,51.2573f, -19.6653f,-38.4534f,44.8830f, 
	-25.6265f,-40.9078f,58.2473f, -25.6265f,-40.9078f,58.2473f, -31.4195f,-58.0143f,66.9482f, -29.5913f,-55.5465f,53.4879f, -23.1546f,-44.5665f,-37.7423f, 
	-28.0097f,-44.8941f,-48.7060f, -12.5285f,-45.8573f,-27.6709f, -18.2313f,-45.3863f,-70.0125f, 1.1337f,-44.3998f,-77.1956f, 1.1337f,-43.8196f,-82.4337f, 
	-26.2549f,-45.8518f,-73.3166f, 1.1337f,-47.4886f,-27.0895f, -12.5285f,-45.8573f,-27.6709f, -23.2668f,-49.4382f,-37.8025f, -28.1218f,-51.0347f,-48.7662f, 
	-12.6407f,-50.1544f,-27.7311f, 1.1337f,-53.2475f,-27.1497f, -18.3435f,-50.7612f,-70.0727f, 1.1337f,-49.4528f,-77.2558f, -56.9786f,66.6703f,59.2929f, 
	-67.2647f,72.2028f,32.0756f, -61.0576f,66.1071f,44.8398f, -69.6222f,75.0868f,9.3509f, 27.1687f,-34.4217f,-92.8903f, 39.7795f,16.9488f,-113.0244f, 
	56.3296f,-1.6057f,22.5511f, 49.3530f,-11.7429f,32.0140f, 40.4281f,-16.7290f,32.1675f, 25.6794f,-13.7772f,38.4702f, 14.8689f,-5.9891f,38.7367f, 
	18.0477f,2.5378f,37.3409f, 35.2942f,11.4509f,31.1024f, 45.6861f,9.3742f,29.0202f, 54.1595f,6.1041f,27.9488f, 91.3254f,9.8441f,-48.7060f, 
	83.7394f,7.1798f,-82.8177f, 73.4456f,-13.5720f,-81.4688f, 82.4673f,-3.8524f,-33.6998f, 69.2986f,63.5996f,-55.7230f, 74.3545f,70.1446f,-37.5740f, 
	38.0863f,91.1199f,-48.9697f, 40.0900f,77.2215f,-74.6963f, 69.5322f,72.2029f,32.0756f, 71.8896f,75.0868f,9.3509f, 80.3776f,60.6806f,21.2626f, 
	66.5770f,52.6419f,40.8723f, 44.3720f,98.7173f,2.2674f, 34.3655f,90.6309f,55.4713f, 41.2733f,60.6855f,-93.5265f, 40.0900f,77.2215f,-74.6963f, 
	24.0299f,73.1312f,76.4029f, 44.3670f,71.5845f,69.0734f, 34.6777f,48.3726f,80.0008f, 19.3348f,47.1742f,82.6534f, 69.2986f,63.5996f,-55.7230f, 
	78.4063f,48.7393f,-69.5015f, 87.8654f,54.0933f,-35.6702f, 74.3545f,70.1446f,-37.5740f, 70.0273f,-8.4485f,39.9771f, 92.3353f,-7.2150f,35.9753f, 
	78.5323f,11.3425f,39.3496f, 66.2571f,6.1989f,35.0984f, 30.3944f,-65.5598f,91.4289f, 20.9294f,-66.6641f,101.6298f, 15.5814f,-53.3318f,96.1669f, 
	27.3805f,-51.2734f,82.9855f, 44.6956f,-51.5871f,39.6864f, 47.4725f,-52.9658f,50.1629f, 40.2956f,-29.4775f,44.8428f, 41.9185f,-42.8894f,37.4174f, 
	62.0434f,-35.7219f,-74.1697f, 56.3812f,-42.2233f,-51.4053f, 73.1580f,-58.3773f,-19.2705f, 62.0434f,-35.7219f,-74.1697f, 37.8308f,-39.5563f,-84.6414f, 
	28.5224f,-45.8518f,-73.3166f, 56.3812f,-42.2233f,-51.4053f, 9.1527f,10.6937f,99.7213f, 13.1420f,-10.1353f,89.5099f, 65.8970f,22.3134f,36.6760f, 
	80.0602f,31.2452f,45.9586f, 67.8086f,38.7030f,46.7732f, 74.4026f,43.3299f,25.7328f, 94.3259f,32.7660f,-14.5963f, 95.0326f,29.6651f,-47.0788f, 
	86.9271f,8.0952f,-3.8216f, 83.7394f,7.1798f,-82.8177f, 82.4296f,28.1101f,-76.8754f, 42.4548f,46.9405f,-101.9145f, 17.2934f,-50.9719f,101.6886f, 
	29.6407f,-49.6025f,90.2640f, 68.2627f,-10.2918f,20.9091f, 42.8487f,-15.8404f,24.5851f, 37.0502f,-21.9904f,36.7797f, 73.4456f,-13.5720f,-81.4688f, 
	24.0299f,73.1312f,76.4029f, 63.3251f,66.1071f,44.8398f, 69.5322f,72.2029f,32.0756f, 66.5770f,52.6419f,40.8723f, 59.3946f,53.9467f,54.7963f, 
	71.6718f,45.9051f,65.6238f, 83.6308f,-7.6320f,59.4140f, 97.7941f,-18.3153f,38.8229f, 112.0768f,-3.1584f,64.2790f, 40.2317f,-31.8156f,54.6282f, 
	44.8938f,-55.5465f,56.4451f, 10.1492f,-1.8633f,82.0587f, 56.3812f,-42.2233f,-51.4053f, 28.5224f,-45.8518f,-73.3166f, 34.7814f,-45.4468f,-48.0726f, 
	50.0094f,-40.1763f,-35.5613f, 59.5121f,83.3396f,41.9866f, 69.2986f,63.5996f,-55.7230f, 78.4063f,48.7393f,-69.5015f, 44.9470f,-58.0143f,66.9482f, 
	41.1167f,-60.6764f,74.6558f, 29.4360f,-37.6551f,75.2865f, 31.2270f,-34.8087f,67.6046f, 32.3494f,-5.6489f,96.9570f, 38.1116f,19.5637f,95.0698f, 
	25.1231f,-21.7753f,83.9085f, 36.1975f,-24.9061f,73.5508f, 44.3670f,71.5845f,69.0734f, 74.4026f,43.3299f,25.7328f, 67.8086f,38.7030f,46.7732f, 
	85.0496f,60.6186f,-13.2794f, 70.0273f,-8.4485f,39.9771f, 66.2571f,6.1989f,35.0984f, 86.9271f,8.0952f,-3.8216f, 65.8970f,22.3134f,36.6760f, 
	71.8706f,77.3893f,-16.9732f, 35.4476f,99.0184f,-25.4025f, 28.9774f,-26.5276f,-2.3925f, 28.4771f,-45.2005f,-34.7180f, 15.7705f,-46.5521f,-23.3800f, 
	14.7346f,-44.6201f,-11.7627f, 68.2627f,-10.2918f,20.9091f, 82.4296f,28.1101f,-76.8754f, 92.9091f,-10.1043f,-35.2516f, 78.8738f,-7.2097f,-27.7625f, 
	62.0434f,-35.7219f,-74.1697f, 47.1360f,-16.9968f,-2.9173f, 48.2054f,-32.1497f,-20.7392f, 55.2228f,-21.0732f,58.6414f, 82.9783f,-23.9795f,12.7629f, 
	83.9005f,-8.5110f,15.3930f, 93.7610f,-8.4163f,16.9790f, 96.9685f,-18.1911f,16.3206f, 92.7404f,-29.1118f,41.5926f, 93.2800f,-22.7357f,16.0164f, 
	80.2420f,-24.0348f,-5.1861f, 81.2633f,-9.8938f,-14.6127f, 91.1142f,-10.1645f,-13.2790f, 92.3565f,-22.8992f,-12.6770f, 87.0617f,-23.5171f,-10.0516f, 
	62.8251f,-20.1807f,0.4522f, 88.0872f,-27.3248f,-30.2514f, 80.0602f,31.2452f,45.9586f, 76.9658f,3.0425f,54.7273f, 68.5626f,28.5255f,69.2665f, 
	92.7404f,-29.1118f,41.5926f, 55.2228f,-21.0732f,58.6414f, 56.3514f,-41.4268f,59.0158f, 72.1461f,-63.2630f,62.3315f, 83.6308f,-7.6320f,59.4140f, 
	112.0768f,-3.1584f,64.2790f, 82.3541f,-25.6569f,80.2566f, 76.9658f,3.0425f,54.7273f, 31.2270f,-34.8087f,67.6046f, 36.1975f,-24.9061f,73.5508f, 
	64.4114f,-47.1525f,78.6852f, 72.1461f,-63.2630f,62.3315f, 92.7404f,-29.1118f,41.5926f, 72.1461f,-63.2630f,62.3315f, 60.2160f,47.5507f,89.7473f, 
	56.7201f,28.5514f,90.8946f, 46.9361f,47.3032f,66.8337f, 59.2460f,66.6703f,59.2929f, 9.9411f,-18.6613f,97.1055f, 68.5626f,28.5255f,69.2665f, 
	71.6718f,45.9051f,65.6238f, 59.3946f,53.9467f,54.7963f, 63.3251f,66.1071f,44.8398f, 71.6718f,45.9051f,65.6238f, 76.9658f,3.0425f,54.7273f, 
	68.4018f,3.7361f,58.8148f, 63.6629f,20.5710f,64.1411f, 68.5626f,28.5255f,69.2665f, 54.0949f,20.2901f,76.9689f, 29.9118f,13.4392f,83.8781f, 
	15.4200f,0.3246f,75.0005f, 10.0516f,-7.3652f,72.8559f, 12.4858f,-11.8445f,75.2605f, 27.2517f,-14.4131f,79.6249f, 40.2773f,-16.6790f,74.7999f, 
	59.7159f,-13.9469f,64.3903f, 82.3541f,-25.6569f,80.2566f, 71.5031f,3.7580f,32.7282f, 66.3589f,25.5293f,40.3370f, 45.4493f,36.2911f,37.4229f, 
	27.8115f,33.8247f,42.6606f, 7.7736f,11.0810f,51.6993f, 1.7020f,-7.1433f,45.5065f, 8.2769f,-19.6000f,47.9708f, 9.0296f,-18.2130f,52.8511f, 
	39.7839f,-25.1148f,47.8832f, 67.0732f,-24.5661f,32.1224f, 59.7159f,-13.9469f,64.3903f, 67.0732f,-24.5661f,32.1224f, 71.5031f,3.7580f,32.7282f, 
	68.4018f,3.7361f,58.8148f, 7.0329f,-23.8559f,102.6403f, 11.2551f,-21.5087f,100.0466f, 18.2841f,-47.9988f,89.1134f, 11.2551f,-21.5087f,100.0466f, 
	7.3306f,-52.0769f,110.9069f, 5.4874f,-55.0928f,107.4437f, 12.4046f,-67.4703f,108.5809f, 20.4346f,-51.6814f,79.8910f, 5.9471f,-19.9995f,86.3397f, 
	9.5378f,-41.1215f,115.0542f, 11.3553f,-48.1650f,100.8104f, 14.2540f,-44.8299f,101.0663f, 7.0329f,-23.8559f,102.6403f, 5.9471f,-19.9995f,86.3397f, 
	9.5378f,-41.1215f,115.0542f, 13.8074f,-55.1711f,72.1319f, 20.4346f,-51.6814f,79.8910f, 11.3553f,-48.1650f,100.8104f, 18.2841f,-47.9988f,89.1134f, 
	14.2540f,-44.8299f,101.0663f, 35.4476f,99.0184f,-25.4025f, 38.0863f,91.1199f,-48.9697f, 74.3545f,70.1446f,-37.5740f, 71.8706f,77.3893f,-16.9732f, 
	34.2393f,-25.9328f,29.8641f, 35.2769f,-34.3247f,29.7542f, 35.2769f,-34.3247f,29.7542f, 27.3972f,-37.4772f,31.5811f, 32.3197f,-51.9099f,40.7909f, 
	44.6956f,-51.5871f,39.6864f, 19.4459f,-23.2892f,36.5294f, 21.9327f,-38.4534f,44.8830f, 50.0094f,-40.1763f,-35.5613f, 70.7154f,-18.3408f,-23.6382f, 
	73.1580f,-58.3773f,-19.2705f, 56.3812f,-42.2233f,-51.4053f, 55.1959f,-18.6324f,-1.1863f, 65.7885f,-21.8504f,-16.3410f, 48.2054f,-32.1497f,-20.7392f, 
	47.1360f,-16.9968f,-2.9173f, 12.4289f,-16.1620f,-1.3083f, 26.5416f,-27.3208f,14.0619f, 33.2880f,-27.5091f,16.1315f, 33.2880f,-27.5091f,16.1315f, 
	40.7751f,-25.6793f,17.8938f, 56.3514f,-41.4268f,59.0158f, 64.4114f,-47.1525f,78.6852f, 31.2270f,-34.8087f,67.6046f, 64.4114f,-47.1525f,78.6852f, 
	44.9470f,-58.0143f,66.9482f, 48.2054f,-32.1497f,-20.7392f, 65.7885f,-21.8504f,-16.3410f, 88.0872f,-27.3248f,-30.2514f, 87.0617f,-23.5171f,-10.0516f, 
	92.3565f,-22.8992f,-12.6770f, 80.2420f,-24.0348f,-5.1861f, 62.8251f,-20.1807f,0.4522f, 80.2420f,-24.0348f,-5.1861f, 53.8111f,-13.6912f,13.2628f, 
	82.4673f,-3.8524f,-33.6998f, 78.8738f,-7.2097f,-27.7625f, 14.2933f,-66.6641f,91.3655f, 24.5620f,-65.0439f,86.6590f, 34.8420f,-52.9658f,50.1629f, 
	32.3197f,-51.9099f,40.7909f, 31.8587f,-55.5465f,53.4879f, 31.1234f,-60.6764f,71.5255f, 33.6870f,-58.0143f,66.9482f, 7.9749f,-67.4702f,101.2014f, 
	21.3934f,-55.6845f,86.6590f, 15.0407f,-57.2462f,91.3655f, 21.5197f,-41.3275f,48.7585f, 21.9327f,-38.4534f,44.8830f, 27.8940f,-40.9078f,58.2473f, 
	26.9767f,-48.4506f,71.5254f, 5.7720f,-62.2401f,101.2014f, 21.9327f,-38.4534f,44.8830f, 27.8940f,-40.9078f,58.2473f, 27.8940f,-40.9078f,58.2473f, 
	33.6870f,-58.0143f,66.9482f, 31.8587f,-55.5465f,53.4879f, 25.4221f,-44.5665f,-37.7423f, 30.2771f,-44.8941f,-48.7060f, 14.7960f,-45.8573f,-27.6709f, 
	20.4988f,-45.3863f,-70.0125f, 28.5224f,-45.8518f,-73.3166f, 14.7960f,-45.8573f,-27.6709f, 25.5343f,-49.4382f,-37.8025f, 30.3893f,-51.0348f,-48.7662f, 
	14.9082f,-50.1544f,-27.7311f, 20.6110f,-50.7613f,-70.0727f, 59.2460f,66.6703f,59.2929f, 69.5322f,72.2029f,32.0756f, 63.3251f,66.1071f,44.8398f, 
	71.8896f,75.0868f,9.3509f, 44.3720f,98.7173f,2.2674f, 71.8896f,75.0868f,9.3509f, 
_NULL_ }; /* End of skull6_Vertices */

const float skull6_UV[] = {
	0.8949f,0.4083f,0.9280f,0.3763f,0.8937f,0.4073f,0.8660f,0.4221f,0.8707f,0.6458f,0.8772f,0.6509f,0.8850f,0.6550f,0.8938f,0.6620f,0.9025f,0.6870f,0.8998f,0.6982f,0.8847f,0.6970f,0.8707f,0.6791f,0.8682f,0.6697f,0.8584f,0.5196f,0.8542f,0.5463f,
	0.8521f,0.4636f,0.8606f,0.4653f,0.8977f,0.5078f,0.9203f,0.4809f,0.9260f,0.5167f,0.8976f,0.5319f,0.9011f,0.6205f,0.8945f,0.6399f,0.8904f,0.6087f,0.9009f,0.5917f,0.9515f,0.6421f,0.9281f,0.6481f,0.9246f,0.5810f,0.9534f,0.5843f,0.9436f,0.4413f,
	0.9485f,0.4706f,0.9203f,0.4809f,0.9135f,0.4514f,0.9294f,0.6831f,0.9235f,0.7088f,0.9129f,0.6991f,0.9156f,0.6700f,0.8977f,0.5078f,0.8976f,0.5319f,0.8836f,0.5350f,0.8861f,0.4882f,0.8577f,0.6662f,0.8697f,0.6545f,0.8659f,0.6515f,0.8471f,0.6476f,
	0.8293f,0.7999f,0.8485f,0.7844f,0.8564f,0.8123f,0.8349f,0.8216f,0.8360f,0.7098f,0.8466f,0.7035f,0.8602f,0.7069f,0.8328f,0.7231f,0.8408f,0.4734f,0.8146f,0.5855f,0.8382f,0.5216f,0.8408f,0.4734f,0.8382f,0.5216f,0.8535f,0.4683f,0.8528f,0.4440f,
	0.9261f,0.7447f,0.9163f,0.7601f,0.8986f,0.7676f,0.9152f,0.7611f,0.8796f,0.6490f,0.8857f,0.6224f,0.8872f,0.6530f,0.8764f,0.6503f,0.8699f,0.5662f,0.8596f,0.5893f,0.8679f,0.5206f,0.8606f,0.4653f,0.9069f,0.4358f,0.8735f,0.4764f,0.8486f,0.7883f,
	0.8575f,0.8135f,0.8690f,0.6923f,0.8696f,0.6650f,0.8574f,0.6409f,0.8521f,0.4636f,0.9460f,0.6900f,0.9294f,0.6831f,0.9021f,0.6397f,0.8993f,0.6582f,0.8885f,0.6696f,0.8510f,0.6823f,0.8411f,0.6694f,0.8370f,0.6523f,0.8582f,0.7223f,0.8316f,0.7360f,
	0.9123f,0.7708f,0.9069f,0.7537f,0.8382f,0.5216f,0.8439f,0.5575f,0.8491f,0.5334f,0.8535f,0.4683f,0.9485f,0.4706f,0.9517f,0.5055f,0.9109f,0.6301f,0.8977f,0.5078f,0.8861f,0.4882f,0.9460f,0.6900f,0.9349f,0.7238f,0.8289f,0.7510f,0.8623f,0.7496f,
	0.8611f,0.7628f,0.8282f,0.7662f,0.8823f,0.4345f,0.8850f,0.4061f,0.8851f,0.7579f,0.8964f,0.7333f,0.9395f,0.4208f,0.8672f,0.7446f,0.8789f,0.7630f,0.9156f,0.6700f,0.8880f,0.5641f,0.9018f,0.5581f,0.9530f,0.5391f,0.9299f,0.5471f,0.8716f,0.6326f,
	0.8670f,0.6343f,0.8639f,0.6058f,0.8542f,0.5691f,0.8735f,0.4764f,0.8537f,0.5575f,0.8448f,0.5426f,0.8657f,0.6161f,0.8524f,0.5873f,0.8571f,0.7081f,0.8503f,0.6239f,0.8395f,0.6258f,0.8456f,0.6215f,0.8374f,0.6220f,0.8312f,0.6629f,0.8358f,0.6248f,
	0.8506f,0.5791f,0.8408f,0.5987f,0.8456f,0.5781f,0.8360f,0.5814f,0.8380f,0.5877f,0.8532f,0.6152f,0.8346f,0.5543f,0.8814f,0.6840f,0.8616f,0.6755f,0.8312f,0.6629f,0.8102f,0.7195f,0.8389f,0.7198f,0.8571f,0.7081f,0.8510f,0.6823f,0.8616f,0.6755f,
	0.8386f,0.7156f,0.8411f,0.6694f,0.8292f,0.7393f,0.8102f,0.7195f,0.8887f,0.7131f,0.8959f,0.6989f,0.9041f,0.6804f,0.9047f,0.6570f,0.8955f,0.7858f,0.9189f,0.7678f,0.8814f,0.6840f,0.8885f,0.6696f,0.8993f,0.6582f,0.9021f,0.6397f,0.8616f,0.6755f,
	0.8814f,0.6840f,0.8800f,0.6850f,0.8669f,0.6852f,0.8858f,0.7048f,0.8991f,0.7307f,0.9034f,0.7404f,0.9035f,0.7485f,0.8980f,0.7540f,0.8709f,0.7366f,0.8829f,0.7503f,0.8598f,0.7077f,0.8811f,0.6519f,0.8651f,0.6497f,0.9000f,0.6515f,0.9114f,0.6670f,
	0.9166f,0.7057f,0.9120f,0.7177f,0.8967f,0.7342f,0.8964f,0.7293f,0.8644f,0.7086f,0.8473f,0.6649f,0.8943f,0.7984f,0.8600f,0.7978f,0.8919f,0.7904f,0.9144f,0.7780f,0.8919f,0.7904f,0.8734f,0.8411f,0.8662f,0.8436f,0.8644f,0.8346f,0.8661f,0.8327f,
	0.8484f,0.8587f,0.8410f,0.8383f,0.8985f,0.7792f,0.8539f,0.7890f,0.8759f,0.8237f,0.8672f,0.8106f,0.8664f,0.8164f,0.9104f,0.7672f,0.8985f,0.7792f,0.8943f,0.7984f,0.9055f,0.7951f,0.8759f,0.8237f,0.8878f,0.8222f,0.8784f,0.8386f,0.8882f,0.8174f,
	0.8809f,0.8183f,0.8558f,0.7910f,0.8539f,0.7890f,0.8664f,0.8164f,0.8776f,0.8278f,0.8600f,0.7978f,0.8672f,0.8106f,0.9018f,0.5581f,0.8596f,0.6915f,0.8679f,0.6865f,0.8596f,0.6915f,0.8360f,0.7098f,0.8440f,0.7247f,0.8629f,0.7039f,0.8666f,0.7308f,
	0.8827f,0.7068f,0.8439f,0.5575f,0.8501f,0.5692f,0.8591f,0.6157f,0.8657f,0.6161f,0.8524f,0.5873f,0.8502f,0.5849f,0.8730f,0.6664f,0.8949f,0.6379f,0.8673f,0.6651f,0.8632f,0.6615f,0.8673f,0.6651f,0.8808f,0.7590f,0.9063f,0.6998f,0.9089f,0.6421f,
	0.8760f,0.6410f,0.8779f,0.6217f,0.8292f,0.7393f,0.8623f,0.7496f,0.8289f,0.7510f,0.8346f,0.5543f,0.8360f,0.5814f,0.8380f,0.5877f,0.8408f,0.5987f,0.8532f,0.6152f,0.8637f,0.6387f,0.8404f,0.8204f,0.8342f,0.8018f,0.8411f,0.7366f,0.8440f,0.7247f,
	0.8403f,0.7464f,0.8348f,0.7741f,0.8362f,0.7637f,0.8484f,0.8508f,0.8452f,0.8377f,0.8484f,0.7984f,0.8521f,0.8117f,0.8822f,0.8136f,0.8859f,0.8051f,0.8641f,0.7394f,0.8666f,0.7308f,0.8591f,0.7458f,0.8520f,0.7696f,0.8918f,0.7819f,0.8955f,0.7645f,
	0.8739f,0.8303f,0.8548f,0.8358f,0.8581f,0.8440f,0.8852f,0.7635f,0.8666f,0.7308f,0.8591f,0.7458f,0.8591f,0.7458f,0.8362f,0.7637f,0.8403f,0.7464f,0.8574f,0.5624f,0.8531f,0.5327f,0.8656f,0.5948f,0.8608f,0.4758f,0.8817f,0.4502f,0.8823f,0.4345f,
	0.8535f,0.4683f,0.8783f,0.6063f,0.8656f,0.5948f,0.8521f,0.5638f,0.8465f,0.5335f,0.8607f,0.5969f,0.8716f,0.6103f,0.8548f,0.4749f,0.8761f,0.4482f,0.9047f,0.6570f,0.9011f,0.6205f,0.9021f,0.6397f,0.9009f,0.5917f,0.9260f,0.3970f,0.9658f,0.3864f,
	0.9823f,0.6970f,0.9705f,0.7257f,0.9559f,0.7301f,0.9371f,0.7294f,0.9282f,0.7146f,0.9362f,0.7047f,0.9592f,0.6916f,0.9708f,0.6931f,0.9806f,0.6966f,0.0269f,0.5307f,0.0181f,0.4464f,0.0061f,0.4397f,0.0180f,0.5746f,0.9999f,0.5097f,1.0042f,0.5398f,
	0.9764f,0.5185f,0.9764f,0.4785f,0.0001f,0.6448f,0.0020f,0.6113f,0.0097f,0.6371f,-0.0026f,0.6712f,0.9817f,0.5900f,0.9736f,0.6601f,0.9752f,0.4441f,0.9764f,0.4785f,0.9630f,0.6941f,0.9792f,0.6900f,0.9674f,0.7202f,0.9533f,0.7207f,-0.0001f,0.5097f,
	0.0086f,0.4844f,0.0169f,0.5466f,0.0042f,0.5398f,0.0009f,0.7366f,0.0323f,0.7252f,0.0112f,0.7094f,-0.0040f,0.7093f,0.8991f,0.8704f,0.8805f,0.8691f,0.8903f,0.8430f,0.9112f,0.8399f,0.9438f,0.8040f,0.9487f,0.8231f,0.9498f,0.7696f,0.9446f,0.7821f,
	0.9859f,0.4512f,0.9731f,0.5404f,1.0099f,0.6936f,0.9859f,0.4512f,0.9395f,0.4148f,0.9185f,0.4545f,0.9731f,0.5404f,0.9306f,0.7692f,0.9239f,0.7832f,0.9960f,0.6933f,1.0113f,0.6973f,0.9984f,0.6916f,1.0049f,0.6569f,0.0260f,0.5940f,0.0272f,0.5300f,
	0.0219f,0.6344f,1.0181f,0.4464f,1.0141f,0.4665f,0.9743f,0.4244f,0.8955f,0.8464f,0.9168f,0.8460f,0.9983f,0.7066f,0.9598f,0.7165f,0.9486f,0.7439f,1.0061f,0.4397f,0.9630f,0.6941f,0.9948f,0.6659f,1.0001f,0.6448f,0.9974f,0.6712f,0.9908f,0.6882f,
	1.0022f,0.7091f,0.0203f,0.7620f,0.0439f,0.7436f,0.0563f,0.7532f,0.9484f,0.7872f,0.9410f,0.8339f,0.9253f,0.7644f,0.9731f,0.5404f,0.9185f,0.4545f,0.9297f,0.5515f,0.9614f,0.5981f,0.9922f,0.6503f,0.9999f,0.5097f,1.0086f,0.4844f,0.9390f,0.8499f,
	0.9277f,0.8590f,0.9270f,0.8140f,0.9320f,0.8025f,0.9496f,0.7949f,0.9646f,0.7657f,0.9318f,0.7986f,0.9458f,0.7977f,0.9792f,0.6900f,0.0049f,0.6569f,-0.0016f,0.6916f,0.0139f,0.5830f,1.0009f,0.7366f,0.9960f,0.7093f,1.0219f,0.6344f,-0.0040f,0.6933f,
	0.0020f,0.5708f,0.9754f,0.5514f,0.9342f,0.6686f,0.9191f,0.5975f,0.8982f,0.6271f,0.8987f,0.6572f,-0.0017f,0.7066f,0.0141f,0.4665f,0.0339f,0.5733f,0.0135f,0.5927f,-0.0141f,0.4512f,0.9657f,0.6627f,0.9617f,0.6360f,-0.0230f,0.7810f,0.0227f,0.7098f,
	0.0208f,0.6923f,0.0346f,0.6930f,0.0426f,0.7038f,0.0406f,0.7669f,0.0388f,0.7113f,0.0182f,0.6695f,0.0173f,0.6284f,0.0314f,0.6304f,0.0374f,0.6460f,0.0292f,0.6551f,-0.0106f,0.6780f,0.0321f,0.6023f,0.0113f,0.6973f,0.0099f,0.7421f,-0.0009f,0.7310f,
	1.0406f,0.7669f,0.9770f,0.7810f,0.9733f,0.8163f,1.0079f,0.8658f,0.0203f,0.7620f,0.0563f,0.7532f,0.0220f,0.8136f,0.0099f,0.7421f,-0.0680f,0.8025f,-0.0542f,0.7977f,-0.0111f,0.8494f,0.0079f,0.8658f,0.0406f,0.7669f,0.0079f,0.8658f,0.9912f,0.7346f,
	0.9863f,0.7547f,0.9786f,0.7079f,0.9913f,0.6834f,0.9146f,0.7984f,0.9991f,0.7310f,1.0022f,0.7091f,0.9908f,0.6882f,0.9948f,0.6659f,0.0022f,0.7091f,1.0099f,0.7421f,0.9987f,0.7470f,0.9934f,0.7333f,0.9991f,0.7310f,0.9825f,0.7483f,0.9538f,0.7582f,
	0.9322f,0.7567f,0.9220f,0.7598f,0.9221f,0.7692f,0.9388f,0.7857f,0.9557f,0.7893f,0.9853f,0.7783f,1.0220f,0.8136f,1.0027f,0.7085f,0.9966f,0.6954f,0.9756f,0.6789f,0.9576f,0.6852f,0.9294f,0.7122f,0.9131f,0.7184f,0.9120f,0.7400f,0.9138f,0.7458f,
	0.9512f,0.7670f,0.9961f,0.7488f,-0.0147f,0.7783f,-0.0039f,0.7488f,0.0027f,0.7085f,-0.0013f,0.7470f,0.9074f,0.8073f,0.9141f,0.8052f,0.9003f,0.8328f,0.9141f,0.8052f,0.8805f,0.8452f,0.8745f,0.8438f,0.8664f,0.8652f,0.8995f,0.8309f,0.9090f,0.7863f,
	0.8953f,0.8386f,0.8903f,0.8367f,0.8979f,0.8357f,0.9074f,0.8073f,0.9090f,0.7863f,0.8953f,0.8386f,0.8855f,0.8205f,0.8995f,0.8309f,0.8903f,0.8367f,0.9003f,0.8328f,0.8979f,0.8357f,-0.0246f,0.5514f,-0.0236f,0.5185f,0.0042f,0.5398f,0.0020f,0.5708f,
	0.9423f,0.7366f,0.9388f,0.7502f,0.9388f,0.7502f,0.9240f,0.7526f,0.9193f,0.7956f,0.9438f,0.8040f,0.9232f,0.7348f,0.9149f,0.7707f,-0.0386f,0.5981f,0.0021f,0.6143f,0.0099f,0.6936f,-0.0269f,0.5404f,0.9775f,0.6709f,0.9941f,0.6383f,0.9617f,0.6360f,
	0.9657f,0.6627f,0.9192f,0.6505f,0.9302f,0.7042f,0.9399f,0.7128f,0.9399f,0.7128f,0.9524f,0.7175f,-0.0267f,0.8163f,-0.0111f,0.8494f,0.9320f,0.8025f,0.9889f,0.8494f,0.9390f,0.8499f,-0.0383f,0.6360f,-0.0059f,0.6383f,0.0321f,0.6023f,0.0292f,0.6551f,
	0.0374f,0.6460f,0.0182f,0.6695f,0.9894f,0.6780f,1.0182f,0.6695f,0.9765f,0.6950f,1.0180f,0.5746f,1.0135f,0.5927f,0.8703f,0.8534f,0.8891f,0.8595f,0.9229f,0.8130f,0.9193f,0.7956f,0.9146f,0.8189f,0.9071f,0.8466f,0.9153f,0.8403f,0.8605f,0.8545f,
	0.8963f,0.8436f,0.8846f,0.8431f,0.9117f,0.7802f,0.9149f,0.7707f,0.9219f,0.7978f,0.9135f,0.8239f,0.8654f,0.8465f,0.9149f,0.7707f,0.9219f,0.7978f,0.9219f,0.7978f,0.9153f,0.8403f,0.9146f,0.8189f,0.9147f,0.5850f,0.9224f,0.5476f,0.8975f,0.6127f,
	0.9063f,0.4686f,0.9185f,0.4545f,0.8975f,0.6127f,0.9101f,0.5889f,0.9167f,0.5507f,0.8930f,0.6166f,0.9008f,0.4667f,0.9913f,0.6834f,1.0001f,0.6448f,0.9948f,0.6659f,1.0020f,0.6113f,-0.0183f,0.5900f,0.0020f,0.6113f,
_NULL_ }; /* End of skull6_UV */

const float skull6_Normals[] = {
	-0.0000f,-0.3010f,-0.9536f, -0.0000f,0.0264f,-0.9997f, -0.3854f,-0.0590f,-0.9209f, -0.2043f,-0.5099f,-0.8356f, -0.1815f,-0.0211f,0.9832f, 0.1282f,-0.5928f,0.7951f, -0.2526f,-0.2288f,0.9401f, -0.2328f,0.2136f,0.9488f, -0.2743f,0.1356f,0.9520f, -0.1109f,0.1202f,0.9865f, -0.3319f,0.1957f,0.9228f, -0.2985f,0.2686f,0.9159f, 0.4142f,0.7569f,0.5055f, -0.9334f,-0.3537f,-0.0606f, -0.9961f,-0.0580f,0.0659f, 
	-0.8710f,-0.4824f,-0.0931f, -0.9392f,-0.2461f,-0.2395f, -0.5585f,0.7301f,-0.3938f, -0.4198f,0.8057f,-0.4178f, -0.4211f,0.8450f,-0.3296f, -0.5455f,0.7792f,-0.3087f, -0.8440f,0.2946f,0.4483f, -0.8793f,0.1299f,0.4583f, -0.8998f,0.2352f,0.3675f, -0.7992f,0.5910f,0.1094f, -0.0000f,0.9267f,0.3758f, -0.2832f,0.8357f,0.4705f, -0.4127f,0.9103f,0.0323f, -0.0000f,0.9973f,0.0728f, -0.0000f,0.6462f,-0.7632f, 
	-0.0000f,0.6609f,-0.7505f, -0.4192f,0.6792f,-0.6024f, -0.3925f,0.6104f,-0.6880f, -0.1788f,0.2279f,0.9571f, -0.0287f,0.3312f,0.9431f, -0.1821f,0.4917f,0.8515f, -0.5246f,0.1048f,0.8449f, -0.6897f,0.6424f,-0.3340f, -0.7539f,0.6038f,-0.2590f, -0.8743f,0.4627f,-0.1468f, -0.8193f,0.4620f,-0.3395f, -0.7275f,-0.4429f,-0.5240f, -0.8906f,0.0326f,-0.4535f, -0.7028f,0.2313f,-0.6727f, -0.8172f,0.5745f,-0.0461f, 
	-0.7303f,-0.5184f,0.4449f, -0.7440f,0.1414f,0.6530f, -0.7176f,-0.2931f,0.6317f, -0.6421f,-0.4904f,0.5892f, -0.8249f,-0.4668f,-0.3189f, -0.8931f,0.1756f,-0.4142f, -0.8656f,-0.3310f,-0.3756f, -0.8721f,-0.4866f,-0.0510f, -0.7673f,-0.5469f,-0.3350f, -0.1745f,-0.8007f,0.5731f, 0.3498f,-0.8975f,-0.2686f, -0.3734f,-0.7321f,-0.5697f, -0.2788f,-0.9395f,-0.1990f, -0.1673f,-0.9201f,-0.3543f, -0.3076f,-0.7412f,-0.5967f, 
	-0.0000f,-0.1395f,0.9902f, 0.0382f,0.0335f,0.9987f, 0.4938f,-0.5854f,0.6430f, 0.4748f,-0.0540f,0.8784f, -0.9706f,0.0068f,-0.2406f, -0.8884f,-0.1105f,0.4457f, -0.8606f,0.4774f,-0.1771f, -0.8642f,0.3698f,-0.3411f, -0.9841f,0.0330f,0.1743f, -0.8983f,-0.3416f,0.2765f, -0.9813f,0.1059f,-0.1609f, -0.5300f,-0.0444f,-0.8468f, -0.4124f,0.3997f,-0.8186f, -0.5969f,0.3094f,-0.7403f, -0.5337f,-0.7565f,0.3779f, 
	-0.8094f,-0.2216f,0.5438f, -0.5334f,-0.6284f,-0.5662f, -0.5189f,-0.8548f,0.0087f, -0.7335f,-0.6592f,0.1656f, -0.3496f,-0.2874f,-0.8917f, -0.0000f,0.7692f,0.6391f, -0.1667f,0.7144f,0.6796f, -0.8847f,0.0783f,0.4595f, -0.9174f,0.3736f,0.1370f, -0.9048f,0.4244f,-0.0351f, -0.5518f,0.8339f,0.0068f, -0.7327f,0.3511f,-0.5830f, -0.9611f,0.1896f,-0.2007f, -0.5724f,-0.8142f,-0.0970f, -0.7432f,-0.6635f,-0.0861f, 
	0.0539f,0.8346f,0.5482f, -0.0024f,-0.6933f,-0.7206f, -0.1623f,-0.9814f,0.1024f, -0.2072f,-0.9266f,0.3137f, -0.1816f,-0.9803f,0.0779f, -0.0356f,-0.9991f,-0.0210f, -0.0000f,0.8568f,-0.5157f, -0.0000f,0.9218f,-0.3877f, -0.6366f,0.6938f,0.3367f, -0.5500f,0.6961f,-0.4614f, -0.5724f,0.5424f,-0.6149f, -0.0000f,0.1727f,0.9850f, -0.0000f,0.3362f,0.9418f, -0.9189f,-0.2997f,0.2565f, -0.7607f,-0.1274f,0.6365f, 
	-0.8889f,0.0757f,0.4517f, -0.7802f,-0.5487f,0.3003f, -0.0000f,-0.9573f,-0.2892f, -0.0000f,-0.6870f,-0.7267f, -0.0185f,-0.1577f,0.9873f, -0.0840f,0.2004f,0.9761f, -0.0000f,0.5053f,-0.8629f, -0.3278f,-0.4532f,0.8289f, -0.7090f,-0.0399f,0.7041f, -0.4516f,0.6633f,0.5967f, -0.8799f,0.4738f,0.0356f, -0.7823f,0.6224f,-0.0257f, -0.0000f,0.9873f,-0.1590f, -0.3600f,0.9179f,-0.1668f, -0.5555f,-0.8145f,0.1672f, 
	-0.2676f,-0.7955f,0.5437f, -0.3221f,-0.9313f,0.1700f, -0.3083f,-0.8695f,0.3859f, -0.8930f,0.2256f,-0.3895f, -0.8589f,-0.4258f,0.2847f, -0.7518f,0.3816f,-0.5377f, -0.3840f,-0.8781f,0.2853f, -0.0940f,-0.7904f,0.6053f, 0.8353f,0.2816f,-0.4721f, 0.8353f,0.2816f,-0.4721f, 0.8434f,0.1385f,-0.5190f, 0.0672f,0.9954f,-0.0680f, -0.9000f,0.4348f,-0.0306f, -0.8927f,-0.4413f,-0.0912f, -0.1890f,-0.9537f,-0.2338f, 
	0.9953f,0.0448f,0.0854f, 0.9744f,0.1690f,0.1480f, 0.0003f,0.9983f,-0.0577f, -0.9915f,0.0924f,-0.0921f, -0.0829f,-0.9965f,0.0101f, -0.3458f,0.7623f,0.5471f, -0.9635f,0.0820f,-0.2547f, -0.8975f,-0.0172f,0.4407f, -0.8562f,0.3648f,0.3658f, -0.6783f,-0.5839f,-0.4460f, 0.3941f,-0.7263f,-0.5632f, 0.3739f,-0.6497f,-0.6619f, -0.4099f,-0.4754f,-0.7784f, -0.2813f,0.7173f,0.6375f, -0.5734f,0.6020f,0.5557f, 
	-0.4861f,-0.2653f,0.8327f, -0.2037f,0.3354f,0.9198f, -0.2102f,-0.1799f,0.9610f, -0.5924f,-0.4159f,0.6899f, -0.4824f,-0.0359f,0.8752f, -0.4205f,0.6164f,0.6658f, -0.4797f,0.6888f,0.5435f, -0.7868f,-0.1016f,0.6088f, -0.8222f,0.4741f,0.3150f, 0.0000f,0.9968f,0.0798f, -0.8883f,-0.0942f,0.4495f, -0.5692f,0.7067f,0.4203f, -0.7146f,0.2383f,0.6578f, -0.9580f,-0.0855f,0.2737f, -0.3678f,0.6556f,0.6594f, 
	-0.6096f,-0.6592f,0.4403f, 0.0669f,-0.5110f,0.8570f, -0.4137f,-0.1667f,0.8950f, -0.5926f,-0.7368f,0.3254f, -0.4589f,-0.4616f,-0.7592f, -0.7357f,-0.5989f,-0.3162f, -0.7190f,-0.5998f,0.3510f, -0.9802f,0.1251f,0.1532f, -0.2896f,-0.2825f,0.9145f, -0.2896f,-0.2825f,0.9145f, 0.0849f,0.7400f,0.6673f, 0.9626f,-0.2219f,-0.1552f, 0.9749f,-0.1898f,-0.1161f, 0.3537f,-0.8914f,-0.2833f, -0.1241f,-0.8869f,-0.4450f, 
	-0.7332f,-0.4932f,-0.4682f, -0.8247f,-0.5044f,-0.2559f, -0.9011f,0.3601f,-0.2413f, -0.9011f,0.3601f,-0.2413f, -0.1641f,0.9419f,-0.2930f, 0.3165f,0.8773f,-0.3609f, 0.1598f,-0.5382f,0.8276f, 0.6788f,0.6202f,-0.3933f, -0.8493f,0.5145f,0.1186f, -0.0000f,0.3247f,0.9458f, -0.4750f,0.4516f,0.7553f, -0.0000f,-0.5699f,0.8217f, -0.0000f,0.0022f,1.0000f, -0.5654f,-0.2870f,0.7733f, -0.5383f,-0.5612f,0.6287f, 
	-0.0000f,-0.5312f,0.8473f, -0.5691f,-0.4942f,0.6572f, 0.9116f,-0.4095f,-0.0362f, 0.0429f,0.9244f,-0.3791f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, 0.6788f,0.6202f,-0.3933f, -0.0000f,-0.6778f,0.7352f, 0.0936f,0.1318f,0.9868f, 0.3287f,-0.0071f,0.9444f, -0.0000f,-0.3499f,0.9368f, -0.6180f,0.4318f,0.6570f, 0.0000f,0.9741f,-0.2262f, -0.0000f,-0.0710f,0.9975f, -0.0000f,-0.0560f,0.9984f, 
	0.0000f,0.4391f,0.8984f, -0.1854f,-0.1220f,0.9751f, 0.5930f,-0.4120f,0.6918f, -0.2794f,0.9116f,-0.3015f, 0.0000f,0.9183f,-0.3959f, -0.3407f,0.9086f,0.2417f, -0.8498f,0.2546f,0.4616f, -0.5739f,0.8104f,-0.1181f, -0.8895f,0.1157f,-0.4420f, -0.9614f,-0.2485f,-0.1177f, -0.1246f,-0.7327f,-0.6691f, 0.0622f,-0.5230f,-0.8500f, 0.3105f,-0.5688f,-0.7617f, 0.5116f,-0.6396f,-0.5738f, 0.4852f,-0.5249f,-0.6993f, 
	0.4107f,-0.7074f,-0.5752f, 0.4381f,-0.7492f,0.4968f, -0.0855f,-0.8749f,0.4768f, 0.0260f,-0.9714f,0.2360f, 0.1718f,-0.9822f,0.0754f, -0.4035f,-0.8051f,0.4347f, -0.2416f,-0.9704f,-0.0067f, 0.3314f,-0.9420f,-0.0524f, 0.4717f,-0.7197f,0.5095f, -0.1862f,-0.9329f,-0.3083f, -0.5149f,-0.8467f,0.1337f, -0.4719f,-0.8757f,-0.1019f, 0.0000f,-0.4858f,-0.8741f, -0.0000f,-0.9052f,-0.4249f, -0.0000f,-0.8891f,0.4576f, 
	-0.0000f,-0.9410f,0.3384f, -0.0000f,-0.9972f,-0.0746f, 0.6490f,-0.7595f,0.0449f, -0.5791f,-0.6942f,0.4274f, -0.7577f,-0.6525f,0.0077f, -0.7434f,-0.6622f,0.0941f, -0.2069f,-0.9595f,0.1914f, 0.0992f,-0.9950f,0.0101f, 0.0979f,-0.9820f,-0.1614f, -0.1158f,-0.9755f,0.1868f, -0.3307f,-0.8936f,0.3034f, 0.4916f,-0.6494f,-0.5802f, 0.2763f,-0.8141f,-0.5107f, 0.3892f,-0.8490f,-0.3574f, 0.3945f,-0.9171f,-0.0565f, 
	0.5157f,-0.6601f,-0.5462f, 0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, 0.0000f,-0.8597f,-0.5108f, 0.2279f,-0.7890f,-0.5706f, 0.6393f,-0.3886f,-0.6635f, 0.6209f,-0.2472f,-0.7439f, -0.0000f,-0.7751f,-0.6318f, -0.0000f,-0.8588f,-0.5123f, 0.7689f,-0.6382f,-0.0384f, 0.7736f,-0.4668f,-0.4286f, 0.7762f,-0.6140f,-0.1435f, 0.7267f,-0.5598f,-0.3982f, -0.0000f,-0.9181f,-0.3963f, -0.0000f,-0.9290f,-0.3701f, 
	0.0000f,-0.5606f,-0.8281f, 0.5027f,-0.2121f,-0.8380f, 0.0000f,-0.1566f,-0.9877f, -0.0517f,-0.8354f,0.5471f, -0.2568f,-0.7892f,-0.5579f, 0.5715f,-0.8196f,-0.0400f, 0.1883f,-0.6623f,0.7252f, 0.4223f,-0.8250f,-0.3755f, 0.5798f,-0.6649f,-0.4710f, 0.1186f,-0.9927f,-0.0229f, 0.1186f,-0.9927f,-0.0229f, -0.0438f,-0.0104f,0.9990f, 0.0617f,-0.9977f,-0.0296f, -0.0000f,-0.9939f,-0.1101f, -0.0000f,-0.9957f,-0.0926f, 
	0.1283f,-0.9906f,0.0477f, -0.0000f,-0.9978f,-0.0663f, -0.0775f,-0.9854f,-0.1517f, -0.9150f,0.0128f,0.4033f, -0.9150f,0.0128f,0.4033f, -0.6876f,0.0069f,0.7260f, -0.0450f,-0.0128f,0.9989f, -0.3467f,0.0112f,-0.9379f, -0.3467f,0.0112f,-0.9379f, -0.6733f,0.5189f,0.5266f, -0.8448f,0.4778f,0.2409f, -0.8963f,-0.3541f,0.2668f, -0.6669f,0.7416f,0.0728f, 0.2043f,-0.5099f,-0.8356f, 0.3854f,-0.0590f,-0.9209f, 
	0.1815f,-0.0211f,0.9832f, -0.4142f,0.7569f,0.5055f, 0.2985f,0.2686f,0.9159f, 0.3319f,0.1957f,0.9228f, 0.1109f,0.1202f,0.9865f, 0.2743f,0.1356f,0.9520f, 0.2328f,0.2136f,0.9488f, 0.2526f,-0.2288f,0.9401f, -0.1282f,-0.5928f,0.7951f, 0.9334f,-0.3537f,-0.0606f, 0.9392f,-0.2461f,-0.2395f, 0.8710f,-0.4824f,-0.0931f, 0.9961f,-0.0580f,0.0659f, 0.5585f,0.7301f,-0.3938f, 0.5455f,0.7792f,-0.3087f, 
	0.4211f,0.8450f,-0.3296f, 0.4198f,0.8057f,-0.4178f, 0.8440f,0.2946f,0.4483f, 0.7992f,0.5910f,0.1094f, 0.8998f,0.2352f,0.3675f, 0.8793f,0.1299f,0.4583f, 0.4127f,0.9103f,0.0323f, 0.2832f,0.8357f,0.4705f, 0.3925f,0.6104f,-0.6880f, 0.4192f,0.6792f,-0.6024f, 0.1788f,0.2279f,0.9571f, 0.5246f,0.1048f,0.8449f, 0.1821f,0.4917f,0.8515f, 0.0287f,0.3312f,0.9431f, 0.6897f,0.6424f,-0.3340f, 
	0.8193f,0.4620f,-0.3395f, 0.8743f,0.4627f,-0.1468f, 0.7539f,0.6038f,-0.2590f, 0.7275f,-0.4429f,-0.5240f, 0.8172f,0.5745f,-0.0461f, 0.7028f,0.2313f,-0.6727f, 0.8906f,0.0326f,-0.4535f, 0.7303f,-0.5184f,0.4449f, 0.6421f,-0.4904f,0.5892f, 0.7176f,-0.2931f,0.6317f, 0.7440f,0.1414f,0.6530f, 0.8249f,-0.4668f,-0.3189f, 0.8721f,-0.4866f,-0.0510f, 0.8656f,-0.3310f,-0.3756f, 0.8931f,0.1756f,-0.4142f, 
	0.7673f,-0.5469f,-0.3350f, -0.3498f,-0.8975f,-0.2686f, 0.1745f,-0.8007f,0.5731f, 0.3734f,-0.7321f,-0.5697f, 0.3076f,-0.7412f,-0.5967f, 0.1673f,-0.9201f,-0.3543f, 0.2788f,-0.9395f,-0.1990f, -0.4748f,-0.0540f,0.8784f, -0.5298f,-0.5673f,0.6304f, 0.9706f,0.0068f,-0.2406f, 0.8642f,0.3698f,-0.3411f, 0.8606f,0.4774f,-0.1771f, 0.8884f,-0.1105f,0.4457f, 0.9841f,0.0330f,0.1743f, 0.9813f,0.1059f,-0.1609f, 
	0.8983f,-0.3416f,0.2765f, 0.5300f,-0.0444f,-0.8468f, 0.5969f,0.3094f,-0.7403f, 0.4124f,0.3997f,-0.8186f, 0.8094f,-0.2216f,0.5438f, 0.5337f,-0.7565f,0.3779f, 0.7335f,-0.6592f,0.1656f, 0.5189f,-0.8548f,0.0087f, 0.5334f,-0.6284f,-0.5662f, 0.3496f,-0.2874f,-0.8917f, 0.1667f,0.7144f,0.6796f, 0.8847f,0.0783f,0.4595f, 0.8440f,0.2946f,0.4483f, 0.8793f,0.1299f,0.4583f, 0.9174f,0.3736f,0.1370f, 
	0.9048f,0.4244f,-0.0351f, 0.5518f,0.8339f,0.0068f, 0.9611f,0.1896f,-0.2007f, 0.7327f,0.3511f,-0.5830f, 0.5724f,-0.8142f,-0.0970f, 0.7432f,-0.6635f,-0.0861f, -0.4739f,-0.8779f,-0.0681f, 0.1623f,-0.9814f,0.1024f, 0.0356f,-0.9991f,-0.0210f, 0.1816f,-0.9803f,0.0779f, 0.2072f,-0.9266f,0.3137f, 0.6366f,0.6938f,0.3367f, 0.5500f,0.6961f,-0.4614f, 0.5724f,0.5424f,-0.6149f, 0.9189f,-0.2997f,0.2565f, 
	0.7802f,-0.5487f,0.3003f, 0.8889f,0.0757f,0.4517f, 0.7607f,-0.1274f,0.6365f, 0.0185f,-0.1577f,0.9873f, 0.0840f,0.2004f,0.9761f, 0.7090f,-0.0399f,0.7041f, 0.3278f,-0.4532f,0.8289f, 0.4516f,0.6633f,0.5967f, 0.8884f,-0.1105f,0.4457f, 0.8606f,0.4774f,-0.1771f, 0.8799f,0.4738f,0.0356f, 0.7275f,-0.4429f,-0.5240f, 0.8906f,0.0326f,-0.4535f, 0.8983f,-0.3416f,0.2765f, 0.9706f,0.0068f,-0.2406f, 
	0.7823f,0.6224f,-0.0257f, 0.3600f,0.9179f,-0.1668f, 0.5555f,-0.8145f,0.1672f, 0.3083f,-0.8695f,0.3859f, 0.3221f,-0.9313f,0.1700f, 0.2676f,-0.7955f,0.5437f, 0.7335f,-0.6592f,0.1656f, 0.8930f,0.2256f,-0.3895f, 0.7518f,0.3816f,-0.5377f, 0.8589f,-0.4258f,0.2847f, 0.7673f,-0.5469f,-0.3350f, 0.3840f,-0.8781f,0.2853f, 0.0940f,-0.7904f,0.6053f, -0.8434f,0.1385f,-0.5190f, -0.8434f,0.1385f,-0.5190f, 
	-0.8434f,0.1385f,-0.5190f, -0.0084f,0.9999f,-0.0073f, 0.9499f,0.3082f,0.0518f, 0.8927f,-0.4413f,-0.0912f, 0.1890f,-0.9537f,-0.2338f, -0.9744f,0.1690f,0.1480f, -0.9744f,0.1690f,0.1480f, 0.0341f,0.9982f,-0.0490f, 0.9915f,0.0924f,-0.0921f, 0.1168f,-0.9931f,0.0019f, 0.3458f,0.7623f,0.5471f, 0.9657f,-0.2477f,0.0782f, 0.8642f,0.3698f,-0.3411f, 0.8562f,0.3648f,0.3658f, 0.8975f,-0.0172f,0.4407f, 
	0.6783f,-0.5839f,-0.4460f, 0.4099f,-0.4754f,-0.7784f, -0.3739f,-0.6497f,-0.6619f, -0.3941f,-0.7263f,-0.5632f, 0.2813f,0.7173f,0.6375f, 0.2037f,0.3354f,0.9198f, 0.4861f,-0.2653f,0.8327f, 0.5734f,0.6020f,0.5557f, 0.7607f,-0.1274f,0.6365f, 0.3278f,-0.4532f,0.8289f, 0.2102f,-0.1799f,0.9610f, 0.5924f,-0.4159f,0.6899f, 0.6783f,-0.5839f,-0.4460f, -0.3941f,-0.7263f,-0.5632f, 0.4205f,0.6164f,0.6658f, 
	0.4824f,-0.0359f,0.8752f, 0.4797f,0.6888f,0.5435f, 0.7868f,-0.1016f,0.6088f, 0.8222f,0.4741f,0.3150f, 0.8883f,-0.0942f,0.4495f, 0.5692f,0.7067f,0.4203f, 0.7146f,0.2383f,0.6578f, 0.9580f,-0.0855f,0.2737f, 0.9048f,0.4244f,-0.0351f, 0.3678f,0.6556f,0.6594f, 0.4137f,-0.1667f,0.8950f, 0.4137f,-0.1667f,0.8950f, 0.5926f,-0.7368f,0.3254f, 0.6096f,-0.6592f,0.4403f, 0.3572f,-0.8313f,0.4258f, 
	0.7357f,-0.5989f,-0.3162f, 0.7190f,-0.5998f,0.3510f, 0.9016f,0.3670f,-0.2290f, 0.6988f,0.1979f,0.6874f, 0.2896f,-0.2825f,0.9145f, 0.4793f,-0.3593f,0.8008f, 0.4861f,-0.2653f,0.8327f, -0.9749f,-0.1898f,-0.1161f, -0.9749f,-0.1898f,-0.1161f, -0.4197f,-0.8779f,-0.2304f, 0.0171f,-0.9256f,-0.3782f, 0.6172f,-0.6923f,-0.3739f, 0.9090f,-0.1742f,-0.3787f, 0.8737f,0.4090f,-0.2634f, 0.9011f,0.3601f,-0.2413f, 
	0.0547f,0.9525f,-0.2995f, -0.1867f,0.9384f,-0.2907f, 0.4793f,-0.3593f,0.8008f, -0.1867f,0.9384f,-0.2907f, -0.9749f,-0.1898f,-0.1161f, 0.4137f,-0.1667f,0.8950f, 0.5094f,0.0339f,0.8599f, 0.8493f,0.5145f,0.1186f, -0.0429f,0.9244f,-0.3791f, 0.4750f,0.4516f,0.7553f, 0.5383f,-0.5612f,0.6287f, 0.5654f,-0.2870f,0.7733f, 0.5691f,-0.4942f,0.6572f, -0.0429f,0.9244f,-0.3791f, -0.9116f,-0.4095f,-0.0362f, 
	-0.6788f,0.6202f,-0.3933f, -0.4401f,0.8629f,-0.2484f, -0.6788f,0.6202f,-0.3933f, -0.3287f,-0.0071f,0.9444f, -0.0936f,0.1318f,0.9868f, 0.6180f,0.4318f,0.6570f, 0.1854f,-0.1220f,0.9751f, -0.5930f,-0.4120f,0.6918f, 0.2794f,0.9116f,-0.3015f, 0.3407f,0.9086f,0.2417f, 0.8498f,0.2546f,0.4616f, 0.3600f,0.9179f,-0.1668f, 0.4211f,0.8450f,-0.3296f, 0.5455f,0.7792f,-0.3087f, 0.5739f,0.8104f,-0.1181f, 
	0.9614f,-0.2485f,-0.1177f, 0.8895f,0.1157f,-0.4420f, 0.1246f,-0.7327f,-0.6691f, -0.5116f,-0.6396f,-0.5738f, -0.3105f,-0.5688f,-0.7617f, -0.0622f,-0.5230f,-0.8500f, -0.4107f,-0.7074f,-0.5752f, -0.4852f,-0.5249f,-0.6993f, -0.4381f,-0.7492f,0.4968f, 0.0855f,-0.8749f,0.4768f, 0.1745f,-0.8007f,0.5731f, -0.3498f,-0.8975f,-0.2686f, -0.0260f,-0.9714f,0.2360f, 0.2416f,-0.9704f,-0.0067f, 0.4035f,-0.8051f,0.4347f, 
	-0.1718f,-0.9822f,0.0754f, -0.4717f,-0.7197f,0.5095f, -0.3314f,-0.9420f,-0.0524f, 0.1862f,-0.9329f,-0.3083f, 0.4719f,-0.8757f,-0.1019f, 0.5149f,-0.8467f,0.1337f, -0.3739f,-0.6497f,-0.6619f, -0.6490f,-0.7595f,0.0449f, 0.5791f,-0.6942f,0.4274f, -0.6490f,-0.7595f,0.0449f, 0.7577f,-0.6525f,0.0077f, 0.4035f,-0.8051f,0.4347f, 0.2416f,-0.9704f,-0.0067f, 0.7434f,-0.6622f,0.0941f, -0.0992f,-0.9950f,0.0101f, 
	0.2069f,-0.9595f,0.1914f, -0.0979f,-0.9820f,-0.1614f, 0.1158f,-0.9755f,0.1868f, -0.0979f,-0.9820f,-0.1614f, 0.3307f,-0.8936f,0.3034f, 0.9961f,-0.0580f,0.0659f, 0.8589f,-0.4258f,0.2847f, -0.4916f,-0.6494f,-0.5802f, -0.2763f,-0.8141f,-0.5107f, -0.3892f,-0.8490f,-0.3574f, -0.3945f,-0.9171f,-0.0565f, -0.4465f,-0.7346f,-0.5109f, -0.4471f,-0.7434f,-0.4975f, -0.0000f,-0.8644f,-0.5028f, -0.2279f,-0.7890f,-0.5706f, 
	-0.6393f,-0.3886f,-0.6635f, -0.6209f,-0.2472f,-0.7439f, -0.7689f,-0.6382f,-0.0384f, -0.7736f,-0.4668f,-0.4286f, -0.7762f,-0.6140f,-0.1435f, -0.7267f,-0.5598f,-0.3982f, -0.5027f,-0.2121f,-0.8380f, 0.2568f,-0.7892f,-0.5579f, -0.5019f,-0.7006f,-0.5072f, -0.0120f,-0.9986f,0.0522f, -0.4223f,-0.8250f,-0.3755f, -0.5798f,-0.6649f,-0.4710f, -0.1519f,-0.9870f,-0.0535f, -0.1186f,-0.9927f,-0.0229f, 0.0450f,-0.0128f,0.9989f, 
	-0.0617f,-0.9977f,-0.0296f, -0.0407f,-0.9983f,0.0418f, 0.0775f,-0.9854f,-0.1517f, 0.9144f,0.0161f,0.4044f, 0.9150f,0.0128f,0.4033f, 0.6874f,0.0078f,0.7262f, 0.3485f,0.0178f,-0.9371f, 0.6733f,0.5189f,0.5266f, 0.8448f,0.4778f,0.2409f, 0.8963f,-0.3541f,0.2668f, 0.6669f,0.7416f,0.0728f, 0.4127f,0.9103f,0.0323f, 0.6669f,0.7416f,0.0728f, 
_NULL_ }; /* End of skull6_Normals */

const unsigned short skull6_Faces[] = {
	0, 2, 1, 2, 0, 3, 4, 6, 5, 6, 8, 7, 4, 8, 6, 8, 10, 9, 4, 10, 8, 4, 11, 10, 4, 12, 11, 13, 15, 14, 
	15, 13, 16, 17, 19, 18, 19, 17, 20, 21, 23, 22, 23, 21, 24, 25, 27, 26, 27, 25, 28, 29, 31, 30, 31, 29, 32, 33, 35, 34, 
	35, 33, 36, 37, 39, 38, 39, 37, 40, 41, 43, 42, 43, 41, 44, 45, 47, 46, 47, 45, 48, 49, 51, 50, 51, 49, 52, 53, 55, 54, 
	56, 58, 57, 58, 56, 59, 60, 62, 61, 62, 60, 63, 64, 66, 65, 66, 64, 67, 68, 13, 69, 13, 68, 70, 71, 72, 2, 72, 71, 73, 
	47, 74, 46, 74, 47, 75, 51, 77, 76, 77, 51, 78, 56, 3, 59, 3, 56, 79, 80, 26, 81, 26, 80, 25, 82, 22, 83, 22, 82, 21, 
	66, 67, 84, 85, 87, 86, 87, 85, 44, 88, 52, 89, 52, 88, 51, 71, 3, 79, 3, 71, 2, 90, 62, 91, 62, 90, 61, 92, 94, 93, 
	94, 92, 95, 18, 97, 96, 97, 18, 19, 26, 27, 98, 99, 32, 100, 32, 99, 31, 33, 102, 101, 102, 33, 34, 103, 105, 104, 105, 103, 106, 
	107, 59, 108, 59, 107, 58, 109, 63, 110, 63, 109, 62, 2, 111, 1, 111, 2, 72, 105, 112, 104, 112, 105, 113, 108, 3, 0, 3, 108, 59, 
	26, 114, 81, 102, 63, 60, 63, 102, 34, 34, 110, 63, 110, 34, 35, 83, 66, 84, 66, 83, 22, 22, 65, 66, 65, 22, 23, 115, 70, 68, 
	70, 115, 39, 73, 32, 72, 32, 73, 100, 32, 111, 72, 111, 32, 29, 78, 64, 69, 78, 42, 64, 78, 41, 42, 69, 65, 68, 65, 69, 64, 
	68, 23, 115, 23, 68, 65, 115, 24, 116, 24, 115, 23, 117, 27, 28, 27, 117, 118, 119, 121, 120, 121, 119, 122, 69, 14, 78, 14, 69, 13, 
	116, 39, 115, 39, 116, 38, 16, 70, 123, 70, 16, 13, 14, 125, 124, 14, 53, 125, 14, 15, 53, 126, 122, 119, 122, 126, 127, 70, 40, 123, 
	40, 70, 39, 128, 129, 41, 129, 128, 130, 41, 131, 44, 131, 41, 129, 44, 132, 87, 132, 44, 131, 133, 130, 128, 130, 133, 134, 130, 135, 129, 
	135, 130, 136, 129, 137, 131, 137, 129, 135, 138, 131, 137, 138, 132, 131, 138, 134, 132, 134, 136, 130, 134, 139, 136, 134, 138, 139, 136, 124, 135, 
	124, 136, 140, 135, 125, 137, 125, 135, 124, 137, 141, 138, 141, 137, 125, 42, 67, 64, 67, 42, 43, 67, 143, 142, 143, 67, 43, 144, 146, 145, 
	146, 144, 147, 148, 150, 149, 150, 148, 151, 85, 43, 44, 43, 85, 143, 104, 150, 152, 150, 104, 112, 152, 151, 153, 151, 152, 150, 86, 144, 145, 
	144, 86, 87, 87, 134, 133, 134, 87, 132, 109, 155, 154, 155, 109, 110, 155, 35, 156, 35, 155, 110, 156, 36, 157, 36, 156, 35, 158, 90, 91, 
	90, 158, 159, 160, 155, 161, 155, 160, 154, 161, 156, 162, 156, 161, 155, 162, 157, 163, 157, 162, 156, 84, 67, 142, 164, 166, 165, 166, 164, 167, 
	165, 168, 154, 168, 165, 166, 154, 169, 109, 169, 154, 168, 169, 62, 109, 62, 169, 170, 91, 170, 171, 170, 91, 62, 91, 172, 158, 172, 91, 171, 
	112, 174, 173, 174, 112, 113, 112, 175, 150, 175, 112, 173, 150, 167, 164, 167, 150, 175, 167, 176, 166, 176, 167, 177, 166, 178, 168, 178, 166, 176, 
	168, 179, 169, 179, 168, 178, 169, 180, 170, 180, 169, 179, 170, 181, 171, 181, 170, 180, 171, 182, 172, 171, 183, 182, 171, 181, 183, 184, 182, 183, 
	184, 172, 182, 184, 174, 172, 184, 173, 174, 173, 185, 175, 185, 173, 184, 175, 177, 167, 177, 175, 185, 177, 5, 176, 5, 177, 4, 176, 6, 178, 
	6, 176, 5, 178, 7, 179, 7, 178, 6, 179, 8, 180, 8, 179, 7, 180, 9, 181, 9, 180, 8, 181, 10, 183, 10, 181, 9, 183, 11, 184, 
	11, 183, 10, 184, 12, 185, 12, 184, 11, 185, 4, 177, 4, 185, 12, 172, 113, 158, 113, 172, 174, 113, 46, 158, 46, 113, 105, 46, 106, 45, 
	106, 46, 105, 186, 74, 187, 74, 186, 188, 158, 189, 159, 189, 158, 190, 191, 193, 192, 193, 191, 194, 192, 196, 195, 196, 192, 193, 186, 198, 197, 
	198, 186, 187, 199, 201, 200, 202, 204, 203, 204, 202, 205, 206, 208, 207, 209, 211, 210, 211, 203, 212, 209, 203, 211, 209, 202, 203, 213, 207, 214, 
	207, 213, 206, 205, 190, 204, 190, 205, 189, 74, 158, 46, 158, 74, 188, 215, 75, 216, 75, 215, 74, 194, 208, 206, 208, 194, 191, 118, 20, 217, 
	20, 118, 19, 97, 118, 117, 118, 97, 19, 50, 218, 49, 218, 50, 219, 220, 222, 221, 222, 220, 223, 223, 224, 222, 224, 223, 225, 226, 54, 55, 
	54, 226, 227, 228, 230, 229, 230, 228, 231, 120, 232, 119, 232, 120, 233, 119, 234, 126, 234, 119, 232, 229, 235, 228, 235, 229, 236, 237, 225, 238, 
	225, 237, 224, 233, 240, 239, 240, 233, 120, 120, 241, 240, 241, 120, 121, 145, 146, 242, 146, 243, 242, 243, 146, 88, 88, 244, 243, 244, 88, 89, 
	230, 227, 226, 227, 230, 231, 93, 122, 127, 122, 93, 94, 53, 245, 125, 245, 53, 54, 245, 247, 246, 245, 227, 247, 245, 54, 227, 227, 248, 247, 
	248, 227, 231, 231, 249, 248, 249, 231, 228, 228, 250, 249, 250, 228, 235, 76, 219, 50, 219, 76, 77, 50, 51, 76, 238, 233, 239, 233, 238, 225, 
	225, 232, 233, 232, 225, 223, 223, 234, 232, 234, 223, 220, 236, 219, 235, 219, 236, 218, 235, 77, 250, 77, 235, 219, 78, 250, 77, 78, 249, 250, 
	78, 124, 249, 78, 14, 124, 41, 51, 147, 51, 41, 78, 146, 51, 88, 51, 146, 147, 216, 194, 206, 194, 216, 75, 193, 75, 47, 75, 193, 194, 
	48, 193, 47, 193, 48, 196, 187, 211, 198, 187, 201, 211, 187, 200, 201, 213, 210, 211, 210, 213, 214, 251, 45, 252, 45, 251, 48, 253, 49, 254, 
	49, 253, 52, 255, 52, 253, 52, 255, 89, 256, 103, 257, 103, 256, 106, 252, 106, 256, 106, 252, 45, 258, 196, 259, 196, 258, 195, 257, 89, 255, 
	89, 257, 244, 259, 48, 251, 48, 259, 196, 260, 262, 261, 262, 260, 263, 264, 254, 265, 254, 264, 253, 266, 268, 267, 268, 266, 269, 267, 263, 260, 
	263, 267, 268, 270, 272, 271, 261, 270, 271, 270, 261, 262, 264, 237, 273, 237, 264, 274, 275, 253, 264, 253, 275, 255, 273, 276, 264, 276, 273, 269, 
	277, 267, 256, 267, 278, 266, 277, 278, 267, 260, 256, 267, 256, 260, 252, 251, 260, 261, 260, 251, 252, 259, 261, 271, 261, 259, 251, 272, 259, 271, 
	259, 272, 258, 279, 94, 280, 94, 279, 122, 281, 122, 279, 122, 281, 121, 282, 284, 283, 284, 282, 95, 280, 285, 282, 285, 280, 94, 241, 287, 286, 
	287, 241, 121, 288, 280, 289, 280, 288, 279, 290, 279, 288, 279, 290, 281, 291, 281, 290, 281, 291, 286, 292, 283, 293, 283, 292, 282, 289, 282, 292, 
	282, 289, 280, 26, 294, 114, 294, 26, 98, 295, 294, 98, 294, 295, 296, 297, 98, 27, 98, 297, 295, 27, 217, 297, 217, 27, 118, 0, 299, 298, 
	299, 0, 1, 300, 302, 301, 300, 303, 302, 303, 305, 304, 300, 305, 303, 305, 307, 306, 300, 307, 305, 300, 308, 307, 309, 311, 310, 311, 309, 312, 
	313, 315, 314, 315, 313, 316, 317, 319, 318, 319, 317, 320, 25, 321, 28, 321, 25, 322, 29, 324, 323, 324, 29, 30, 325, 327, 326, 327, 325, 328, 
	329, 331, 330, 331, 329, 332, 333, 335, 334, 335, 333, 336, 337, 339, 338, 339, 337, 340, 341, 343, 342, 343, 341, 344, 345, 347, 346, 348, 350, 349, 
	350, 348, 351, 60, 353, 352, 353, 60, 61, 354, 356, 355, 356, 354, 357, 358, 309, 359, 309, 358, 360, 361, 363, 362, 363, 361, 299, 339, 365, 364, 
	365, 339, 340, 343, 367, 366, 367, 343, 368, 348, 298, 369, 298, 348, 349, 80, 322, 25, 322, 80, 370, 371, 373, 372, 373, 371, 374, 356, 375, 355, 
	376, 377, 334, 377, 376, 378, 379, 342, 343, 342, 379, 380, 361, 298, 299, 298, 361, 369, 61, 381, 353, 381, 61, 90, 382, 384, 383, 384, 382, 385, 
	316, 97, 315, 97, 316, 96, 322, 386, 321, 387, 323, 324, 323, 387, 388, 325, 102, 328, 102, 325, 101, 389, 391, 390, 391, 389, 392, 107, 349, 350, 
	349, 107, 108, 393, 352, 353, 352, 393, 394, 299, 111, 363, 111, 299, 1, 391, 396, 395, 396, 391, 392, 108, 298, 349, 298, 108, 0, 322, 370, 397, 
	102, 352, 328, 352, 102, 60, 328, 394, 327, 394, 328, 352, 374, 356, 373, 356, 374, 375, 320, 398, 319, 398, 320, 399, 400, 359, 331, 359, 400, 358, 
	362, 323, 388, 323, 362, 363, 323, 111, 29, 111, 323, 363, 366, 402, 401, 366, 354, 402, 366, 403, 354, 360, 398, 404, 398, 360, 358, 358, 319, 398, 
	319, 358, 400, 400, 318, 319, 318, 400, 405, 117, 321, 406, 321, 117, 28, 407, 409, 408, 409, 407, 410, 360, 312, 309, 312, 360, 411, 405, 331, 332, 
	331, 405, 400, 310, 359, 309, 359, 310, 412, 413, 312, 414, 312, 415, 311, 413, 415, 312, 416, 408, 417, 408, 416, 407, 359, 330, 331, 330, 359, 412, 
	418, 420, 419, 420, 418, 333, 333, 421, 420, 421, 333, 334, 334, 422, 421, 422, 334, 377, 423, 419, 424, 419, 423, 418, 419, 426, 425, 426, 419, 420, 
	420, 427, 426, 427, 420, 421, 421, 428, 427, 428, 422, 424, 421, 422, 428, 424, 429, 428, 424, 425, 429, 424, 419, 425, 425, 414, 430, 414, 425, 426, 
	426, 413, 414, 413, 426, 427, 427, 431, 413, 431, 427, 428, 336, 432, 335, 432, 336, 404, 432, 433, 335, 433, 432, 434, 435, 437, 436, 437, 435, 438, 
	439, 441, 440, 441, 439, 442, 376, 335, 433, 335, 376, 334, 443, 441, 444, 441, 443, 445, 445, 440, 441, 440, 445, 446, 378, 447, 377, 447, 378, 448, 
	377, 424, 422, 424, 377, 423, 393, 449, 394, 449, 393, 450, 449, 327, 394, 327, 449, 451, 451, 326, 327, 326, 451, 452, 90, 453, 381, 453, 90, 159, 
	454, 449, 450, 449, 454, 455, 455, 451, 449, 451, 455, 456, 456, 452, 451, 452, 456, 457, 458, 434, 432, 459, 461, 460, 461, 459, 462, 462, 463, 461, 
	463, 462, 450, 450, 464, 463, 464, 450, 393, 464, 353, 465, 353, 464, 393, 465, 381, 466, 381, 465, 353, 381, 467, 466, 467, 381, 453, 396, 468, 395, 
	468, 396, 469, 396, 470, 469, 470, 396, 471, 471, 460, 470, 460, 471, 459, 460, 473, 472, 473, 460, 461, 461, 474, 473, 474, 461, 463, 463, 475, 474, 
	475, 463, 464, 464, 476, 475, 476, 464, 465, 465, 477, 476, 477, 465, 466, 466, 478, 477, 466, 479, 478, 466, 467, 479, 480, 468, 469, 480, 467, 468, 
	480, 479, 467, 480, 478, 479, 469, 481, 480, 481, 469, 470, 482, 484, 483, 484, 482, 485, 472, 308, 300, 308, 472, 473, 473, 307, 308, 307, 473, 474, 
	474, 306, 307, 306, 474, 475, 475, 305, 306, 305, 475, 476, 476, 304, 305, 304, 476, 477, 477, 303, 304, 303, 477, 478, 478, 302, 303, 302, 478, 480, 
	480, 301, 302, 301, 480, 481, 481, 300, 301, 300, 481, 472, 467, 395, 468, 395, 467, 453, 395, 340, 391, 340, 395, 453, 340, 390, 391, 390, 340, 337, 
	486, 365, 487, 365, 486, 488, 453, 189, 489, 189, 453, 159, 191, 491, 490, 491, 191, 192, 192, 492, 491, 492, 192, 195, 486, 493, 488, 493, 486, 494, 
	495, 497, 496, 202, 498, 205, 498, 202, 499, 500, 207, 208, 501, 209, 210, 209, 499, 202, 501, 499, 209, 501, 502, 499, 503, 207, 500, 207, 503, 214, 
	205, 489, 189, 489, 205, 498, 365, 453, 487, 453, 365, 340, 504, 364, 365, 364, 504, 505, 490, 208, 191, 208, 490, 500, 506, 508, 507, 508, 506, 509, 
	97, 406, 315, 406, 97, 117, 344, 511, 510, 511, 344, 341, 512, 514, 513, 514, 512, 515, 513, 517, 516, 517, 513, 514, 518, 520, 519, 520, 518, 521, 
	522, 524, 523, 524, 522, 525, 410, 527, 526, 527, 410, 407, 407, 528, 527, 528, 407, 416, 525, 530, 529, 530, 525, 522, 237, 516, 517, 516, 237, 238, 
	526, 240, 410, 240, 526, 239, 410, 241, 409, 241, 410, 240, 448, 532, 531, 437, 533, 379, 533, 437, 534, 379, 535, 380, 535, 379, 533, 536, 519, 537, 
	519, 536, 518, 385, 408, 384, 408, 385, 417, 415, 538, 520, 538, 415, 413, 538, 519, 520, 538, 539, 519, 538, 540, 539, 519, 541, 537, 541, 519, 539, 
	523, 542, 522, 542, 523, 543, 522, 544, 530, 544, 522, 542, 368, 510, 367, 510, 368, 344, 344, 368, 343, 238, 526, 516, 526, 238, 239, 516, 527, 513, 
	527, 516, 526, 513, 528, 512, 528, 513, 527, 529, 510, 511, 510, 529, 530, 530, 367, 510, 367, 530, 544, 544, 366, 367, 366, 546, 545, 366, 542, 546, 
	544, 542, 366, 401, 343, 366, 343, 401, 436, 437, 343, 436, 343, 437, 379, 505, 490, 364, 490, 505, 500, 491, 364, 490, 364, 491, 339, 338, 491, 492, 
	491, 338, 339, 488, 496, 497, 488, 501, 496, 488, 493, 501, 503, 210, 214, 210, 503, 501, 547, 337, 338, 337, 547, 548, 549, 341, 342, 341, 549, 550, 
	551, 342, 380, 342, 551, 549, 552, 389, 390, 389, 552, 553, 548, 390, 337, 390, 548, 552, 258, 492, 195, 492, 258, 554, 553, 380, 535, 380, 553, 551, 
	554, 338, 492, 338, 554, 547, 555, 262, 263, 262, 555, 556, 557, 550, 549, 550, 557, 558, 559, 268, 269, 268, 559, 560, 560, 263, 268, 263, 560, 555, 
	270, 561, 272, 556, 270, 262, 270, 556, 561, 557, 237, 562, 237, 557, 273, 563, 549, 551, 549, 563, 557, 273, 564, 269, 564, 273, 557, 560, 565, 552, 
	560, 566, 565, 560, 559, 566, 555, 552, 548, 552, 555, 560, 547, 555, 548, 555, 547, 556, 554, 556, 547, 556, 554, 561, 272, 554, 258, 554, 272, 561, 
	567, 384, 408, 384, 567, 568, 569, 408, 409, 408, 569, 567, 570, 284, 383, 284, 570, 283, 568, 571, 384, 571, 568, 570, 241, 572, 409, 572, 241, 286, 
	573, 568, 567, 568, 573, 574, 575, 567, 569, 567, 575, 573, 291, 569, 286, 569, 291, 575, 576, 283, 570, 283, 576, 293, 574, 570, 568, 570, 574, 576, 
	322, 577, 386, 577, 322, 397, 578, 577, 579, 577, 578, 386, 580, 386, 578, 386, 580, 321, 581, 509, 506, 509, 581, 582, 
_NULL_ }; /* End of skull6_Faces */


/* MESH 4 */

#define jaw_NumVertex  175
#define jaw_NumFaces   346
#define jaw_NumStrips  0
#define jaw_Flags      0x00020006
#define jaw_Material   0

const float jaw_Vertices[] = {
	-46.6479f,-33.6945f,-28.6756f, -39.7569f,-22.9321f,-31.9807f, -56.1644f,-27.0467f,-35.9896f, -78.6009f,-24.5975f,-25.9143f, -74.4665f,-35.4749f,-22.1904f, 
	-45.5505f,-35.0125f,-13.7065f, -60.4122f,-23.1000f,-7.3561f, -61.3447f,-15.9862f,-17.0245f, -39.7569f,-27.3823f,-15.7703f, -78.6009f,-29.0477f,-9.7039f, 
	-74.4665f,-35.8917f,-10.5038f, -66.8560f,-69.8552f,-12.0099f, -48.3675f,-68.5723f,-16.6831f, -50.4169f,-48.8329f,-23.4187f, -68.4715f,-47.8135f,-23.4870f, 
	-61.2390f,-57.4184f,5.5363f, -62.4862f,-40.4376f,-16.6894f, -57.5192f,-45.8657f,1.5112f, -53.7935f,-63.2032f,5.2927f, -69.1443f,-44.7618f,1.1696f, 
	-68.2789f,-55.6508f,4.7502f, -73.1096f,-77.6942f,-17.4105f, -45.4974f,-84.7876f,-25.2379f, -62.7114f,-46.7203f,46.3294f, -64.3790f,-46.0231f,36.5108f, 
	-59.6807f,-46.1701f,37.0462f, -56.6884f,-47.6845f,44.8042f, -62.0718f,-81.4917f,18.1268f, -62.4082f,-76.3160f,1.7288f, -38.7935f,-76.0327f,8.4910f, 
	-52.4690f,-58.7225f,26.8112f, -61.3805f,-56.7465f,21.4166f, -45.8157f,-73.8112f,31.0629f, -39.2644f,-70.1253f,29.1259f, -30.2026f,-94.0008f,24.6850f, 
	-42.6452f,-93.0384f,32.0568f, -69.8357f,-61.4043f,14.5047f, -58.8512f,-67.0113f,27.9780f, -44.6665f,-64.3605f,27.9557f, -49.9856f,-67.4870f,41.0004f, 
	-48.7274f,-61.0672f,40.0122f, -69.7028f,-52.9091f,29.7541f, -60.8033f,-59.4890f,34.8303f, -56.3198f,-52.6540f,29.5573f, -63.3968f,-52.7889f,29.6614f, 
	-51.0058f,-58.5425f,36.8748f, -42.5010f,-102.4701f,-27.2277f, -67.4649f,-102.1496f,-27.1397f, -56.7965f,-114.5044f,0.3111f, -44.1939f,-114.3914f,-1.7533f, 
	-50.1149f,-97.6972f,2.7018f, -46.7970f,-104.0824f,21.4981f, -18.8161f,-113.6379f,52.5613f, -33.1598f,-115.0842f,57.8294f, -34.4743f,-102.6323f,45.1585f, 
	-24.6214f,-100.7087f,39.1498f, -26.5151f,-122.4225f,19.0081f, -36.7346f,-124.4641f,26.4448f, -19.9125f,-159.8369f,65.8686f, -19.1633f,-143.1575f,57.0965f, 
	-19.8423f,-154.3175f,70.5473f, -41.1596f,-120.1437f,35.7491f, -13.8504f,-116.4952f,75.2733f, -19.1915f,-129.6830f,82.8641f, 2.5181f,-170.3700f,65.1389f, 
	2.5181f,-159.4318f,53.3414f, 2.5181f,-128.0690f,80.4119f, 2.5181f,-131.6813f,92.7029f, -56.2112f,-53.5640f,53.3872f, -54.3013f,-49.5387f,54.1480f, 
	-60.9011f,-59.3665f,34.9440f, -69.3942f,-47.4560f,41.7303f, -66.2562f,-49.5928f,47.3270f, 2.5181f,-166.1059f,74.3906f, -60.4386f,-55.5896f,55.3790f, 
	-52.1191f,-65.9096f,39.7835f, -55.4546f,-64.8333f,38.9532f, -64.1307f,-55.1143f,48.9436f, -47.3908f,-74.0684f,33.0522f, -52.2363f,-75.2090f,38.2435f, 
	-43.7706f,-84.5013f,29.2924f, -48.6062f,-86.4956f,35.5572f, -37.1861f,-119.0000f,56.8648f, -43.1893f,-100.6884f,45.4365f, -37.4049f,-105.0786f,38.9792f, 
	-34.8144f,-122.5101f,55.8427f, -19.7370f,-137.1054f,78.5653f, -19.8101f,-149.5590f,69.3146f, 2.5181f,-142.5993f,76.7476f, 2.5181f,-148.1428f,85.8374f, 
	-51.7055f,-88.7644f,17.7543f, 51.6842f,-33.6945f,-28.6756f, 79.5027f,-35.4749f,-22.1904f, 83.6372f,-24.5975f,-25.9143f, 61.2006f,-27.0467f,-35.9896f, 
	44.7931f,-22.9321f,-31.9807f, 50.5867f,-35.0125f,-13.7065f, 44.7931f,-27.3823f,-15.7703f, 66.3809f,-15.9862f,-17.0245f, 65.4484f,-23.1000f,-7.3561f, 
	83.6372f,-29.0477f,-9.7039f, 79.5027f,-35.8917f,-10.5038f, 71.8922f,-69.8552f,-12.0099f, 73.5077f,-47.8135f,-23.4870f, 55.4531f,-48.8329f,-23.4187f, 
	53.4037f,-68.5723f,-16.6831f, 66.2752f,-57.4184f,5.5363f, 58.8297f,-63.2032f,5.2927f, 62.5554f,-45.8657f,1.5113f, 67.5224f,-40.4376f,-16.6894f, 
	73.3151f,-55.6508f,4.7502f, 74.1805f,-44.7618f,1.1696f, 50.5336f,-84.7876f,-25.2379f, 78.1458f,-77.6942f,-17.4105f, 67.7476f,-46.7203f,46.3294f, 
	61.7246f,-47.6845f,44.8043f, 64.7169f,-46.1701f,37.0462f, 69.4153f,-46.0231f,36.5108f, 67.1081f,-81.4917f,18.1268f, 67.4444f,-76.3160f,1.7288f, 
	43.8297f,-76.0327f,8.4910f, 66.4167f,-56.7465f,21.4166f, 57.5052f,-58.7226f,26.8112f, 50.8519f,-73.8112f,31.0629f, 47.6814f,-93.0385f,32.0568f, 
	35.2388f,-94.0008f,24.6850f, 44.3006f,-70.1253f,29.1259f, 63.8874f,-67.0113f,27.9780f, 74.8719f,-61.4043f,14.5047f, 49.7027f,-64.3605f,27.9557f, 
	53.7636f,-61.0672f,40.0122f, 55.0218f,-67.4870f,41.0004f, 65.8395f,-59.4890f,34.8303f, 74.7390f,-52.9091f,29.7542f, 68.4330f,-52.7889f,29.6614f, 
	61.3560f,-52.6540f,29.5573f, 56.0420f,-58.5425f,36.8748f, 47.5372f,-102.4701f,-27.2277f, 49.2301f,-114.3914f,-1.7533f, 61.8327f,-114.5044f,0.3111f, 
	72.5011f,-102.1496f,-27.1397f, 55.1511f,-97.6972f,2.7018f, 51.8332f,-104.0824f,21.4981f, 23.8523f,-113.6380f,52.5614f, 29.6576f,-100.7087f,39.1498f, 
	39.5105f,-102.6324f,45.1585f, 38.1960f,-115.0842f,57.8294f, 31.5513f,-122.4225f,19.0081f, 24.1995f,-143.1575f,57.0965f, 24.9487f,-159.8369f,65.8686f, 
	41.7708f,-124.4641f,26.4448f, 24.8785f,-154.3175f,70.5473f, 46.1958f,-120.1437f,35.7491f, 18.8866f,-116.4952f,75.2733f, 24.2277f,-129.6830f,82.8642f, 
	59.3375f,-49.5387f,54.1480f, 61.2474f,-53.5640f,53.3872f, 65.9373f,-59.3665f,34.9440f, 71.2924f,-49.5928f,47.3270f, 74.4304f,-47.4560f,41.7303f, 
	65.4748f,-55.5896f,55.3790f, 69.1669f,-55.1143f,48.9436f, 60.4908f,-64.8333f,38.9532f, 57.1553f,-65.9096f,39.7835f, 57.2725f,-75.2090f,38.2435f, 
	52.4270f,-74.0684f,33.0522f, 53.6424f,-86.4956f,35.5572f, 48.8068f,-84.5013f,29.2924f, 42.2223f,-119.0000f,56.8649f, 39.8506f,-122.5101f,55.8427f, 
	42.4412f,-105.0786f,38.9792f, 48.2256f,-100.6884f,45.4365f, 24.7732f,-137.1054f,78.5653f, 24.8463f,-149.5590f,69.3146f, 56.7417f,-88.7644f,17.7543f, 
	
_NULL_ }; /* End of jaw_Vertices */

const float jaw_UV[] = {
	0.8019f,0.3541f,0.8154f,0.3399f,0.8032f,0.3478f,0.8007f,0.3805f,0.7931f,0.3870f,0.8053f,0.3832f,0.8129f,0.4019f,0.8165f,0.3830f,0.8154f,0.3726f,0.8007f,0.4088f,0.7956f,0.4075f,0.7638f,0.4143f,0.7657f,0.3923f,0.7857f,0.3718f,0.7825f,0.3848f,
	0.7824f,0.4407f,0.7931f,0.3908f,0.7941f,0.4256f,0.7778f,0.4401f,0.7918f,0.4297f,0.7825f,0.4410f,0.7540f,0.4114f,0.7437f,0.3810f,0.8037f,0.5188f,0.8013f,0.4988f,0.8028f,0.4999f,0.8045f,0.5170f,0.7606f,0.4802f,0.7613f,0.4430f,0.7662f,0.4487f,
	0.7894f,0.4848f,0.7875f,0.4734f,0.7753f,0.5037f,0.7806f,0.4965f,0.7490f,0.5020f,0.7528f,0.5193f,0.7791f,0.4634f,0.7794f,0.4927f,0.7856f,0.4902f,0.7847f,0.5222f,0.7919f,0.5159f,0.7914f,0.4892f,0.7886f,0.5029f,0.7954f,0.4877f,0.7932f,0.4885f,
	0.7930f,0.5071f,0.7213f,0.3861f,0.7264f,0.4035f,0.7194f,0.4609f,0.7159f,0.4524f,0.7378f,0.4533f,0.7360f,0.5007f,0.7306f,0.5998f,0.7330f,0.6019f,0.7450f,0.5615f,0.7450f,0.5488f,0.7074f,0.5078f,0.7109f,0.5272f,0.6730f,0.6488f,0.6904f,0.6254f,
	0.6812f,0.6590f,0.7205f,0.5463f,0.7350f,0.6670f,0.7192f,0.6825f,0.6421f,0.6698f,0.6515f,0.6401f,0.7128f,0.7111f,0.7123f,0.7399f,0.8012f,0.5386f,0.8061f,0.5379f,0.7888f,0.5031f,0.7997f,0.5097f,0.8001f,0.5220f,0.6504f,0.6933f,0.7983f,0.5428f,
	0.7856f,0.5181f,0.7856f,0.5152f,0.7959f,0.5288f,0.7754f,0.5085f,0.7748f,0.5206f,0.7623f,0.5066f,0.7615f,0.5224f,0.7283f,0.5986f,0.7479f,0.5568f,0.7398f,0.5462f,0.7230f,0.5998f,0.7070f,0.6743f,0.6868f,0.6556f,0.6857f,0.7032f,0.6807f,0.7241f,
	0.7530f,0.4824f,0.9040f,0.2125f,0.9926f,0.1992f,1.0064f,0.2138f,0.9360f,0.1917f,0.9033f,0.2304f,0.9058f,0.2603f,0.9033f,0.2721f,0.9628f,0.2629f,0.9578f,0.2855f,1.0064f,0.2599f,0.9931f,0.2413f,0.8977f,0.1186f,0.9599f,0.1609f,0.8864f,0.1924f,
	0.8183f,0.1885f,0.9241f,0.2800f,0.8790f,0.2862f,0.9289f,0.2884f,0.9464f,0.2135f,0.9588f,0.2677f,0.9715f,0.2758f,0.7243f,0.1788f,0.8860f,0.0367f,0.9577f,0.5544f,0.9392f,0.5466f,0.9471f,0.4997f,0.9612f,0.4962f,0.8436f,0.3483f,0.8503f,0.1871f,
	0.8003f,0.3533f,0.9341f,0.3990f,0.9019f,0.4498f,0.8436f,0.5129f,0.7602f,0.5697f,0.7475f,0.5048f,0.8396f,0.4903f,0.9057f,0.4671f,0.9630f,0.3242f,0.8669f,0.4704f,0.8935f,0.5477f,0.8827f,0.5746f,0.9334f,0.5111f,0.9735f,0.4589f,0.9501f,0.4596f,
	0.9264f,0.4611f,0.9035f,0.5218f,0.6565f,0.2272f,0.6381f,0.3632f,0.6004f,0.3471f,0.5611f,0.1502f,0.6918f,0.3074f,0.6922f,0.5029f,0.7166f,0.6615f,0.7397f,0.5974f,0.7363f,0.6574f,0.7061f,0.7241f,0.6648f,0.5150f,0.6539f,0.6825f,0.6297f,0.7036f,
	0.6480f,0.5662f,0.6402f,0.7204f,0.6581f,0.6303f,0.7272f,0.7290f,0.6972f,0.7642f,0.9335f,0.5978f,0.9338f,0.6078f,0.9340f,0.5117f,0.9667f,0.5686f,0.9770f,0.5310f,0.9449f,0.6281f,0.9557f,0.5948f,0.9056f,0.5564f,0.8924f,0.5631f,0.8636f,0.5852f,
	0.8485f,0.5310f,0.8018f,0.5964f,0.7957f,0.5244f,0.6874f,0.7335f,0.6789f,0.7203f,0.7194f,0.6312f,0.7420f,0.6889f,0.6770f,0.7520f,0.6476f,0.7196f,0.7660f,0.4083f,
_NULL_ }; /* End of jaw_UV */

const float jaw_Normals[] = {
	0.3177f,-0.4583f,-0.8300f, 0.3177f,-0.4583f,-0.8300f, 0.3177f,-0.4583f,-0.8300f, -0.2820f,-0.8636f,-0.4180f, -0.1867f,-0.3810f,-0.9055f, 0.6714f,0.6264f,0.3961f, 0.6714f,0.6264f,0.3961f, 0.6714f,0.6264f,0.3961f, 0.0589f,0.2187f,0.9740f, -0.8567f,-0.5154f,-0.0184f, -0.8567f,-0.5154f,-0.0184f, -0.2090f,-0.3352f,-0.9187f, -0.2090f,-0.3352f,-0.9187f, -0.2090f,-0.3352f,-0.9187f, -0.0228f,-0.4630f,-0.8860f, 
	-0.8494f,0.3953f,0.3497f, -0.8494f,0.3953f,0.3497f, -0.8494f,0.3953f,0.3497f, 0.2281f,0.2540f,0.9399f, -0.9965f,-0.0819f,-0.0171f, -0.9964f,-0.0837f,-0.0137f, -0.2255f,0.6683f,-0.7089f, -0.1373f,0.4431f,-0.8859f, 0.0236f,0.9975f,0.0668f, 0.0236f,0.9975f,0.0668f, 0.0236f,0.9975f,0.0668f, 0.1862f,0.9753f,0.1186f, -0.9779f,-0.1931f,0.0807f, -0.4384f,-0.8597f,-0.2623f, 0.6527f,0.7572f,-0.0238f, 
	0.3321f,0.9192f,-0.2118f, 0.3321f,0.9192f,-0.2118f, 0.3128f,-0.0576f,0.9481f, 0.3128f,-0.0576f,0.9481f, 0.3128f,-0.0576f,0.9481f, 0.5128f,0.1284f,0.8488f, -0.8439f,-0.3922f,-0.3660f, -0.7987f,-0.2068f,0.5651f, 0.5891f,0.7590f,-0.2774f, 0.8908f,-0.1066f,0.4417f, 0.8908f,-0.1066f,0.4417f, -0.7239f,-0.6000f,0.3405f, -0.6825f,-0.5810f,0.4434f, 0.5071f,0.6012f,-0.6175f, -0.0236f,0.8990f,-0.4373f, 
	0.5924f,0.7994f,-0.1004f, -0.0132f,-0.9137f,-0.4061f, -0.0132f,-0.9137f,-0.4061f, -0.0132f,-0.9137f,-0.4061f, -0.0618f,-0.9024f,-0.4264f, -0.9074f,0.3224f,0.2697f, -0.9074f,0.3224f,0.2697f, 0.1781f,0.7110f,0.6802f, 0.1781f,0.7110f,0.6802f, 0.1781f,0.7110f,0.6802f, 0.2325f,0.7485f,0.6210f, -0.2666f,-0.7711f,-0.5781f, -0.2666f,-0.7711f,-0.5781f, -0.2666f,-0.7711f,-0.5781f, 0.9387f,-0.1926f,-0.2860f, 
	-0.9529f,-0.1889f,0.2371f, -0.7951f,-0.5982f,-0.1004f, 0.9747f,-0.0451f,-0.2188f, -0.5253f,0.5742f,0.6280f, -0.2366f,-0.4439f,-0.8643f, -0.5556f,-0.6097f,-0.5653f, 0.5733f,0.5354f,-0.6203f, -0.0394f,0.9587f,0.2818f, 0.5544f,-0.4009f,0.7293f, 0.5544f,-0.4009f,0.7293f, -0.6758f,-0.6641f,0.3198f, -0.6758f,-0.6641f,0.3198f, -0.7505f,-0.6365f,0.1778f, -0.3816f,-0.8395f,0.3869f, -0.3673f,-0.8538f,0.3690f, 
	-0.3673f,-0.8538f,0.3690f, -0.3673f,-0.8538f,0.3690f, -0.5660f,-0.7799f,0.2671f, 0.7387f,-0.1192f,0.6634f, 0.7387f,-0.1192f,0.6634f, 0.7832f,0.0484f,0.6199f, 0.7832f,0.0484f,0.6199f, 0.7879f,0.4906f,0.3722f, 0.7879f,0.4906f,0.3722f, 0.7879f,0.4906f,0.3722f, 0.8214f,0.4549f,0.3440f, -0.8504f,-0.3105f,0.4247f, -0.8504f,-0.3105f,0.4247f, -0.0813f,-0.5940f,0.8003f, -0.4023f,0.7816f,0.4767f, 
	-0.9539f,-0.2282f,0.1951f, 0.1867f,-0.3810f,-0.9055f, 0.1867f,-0.3810f,-0.9055f, 0.1867f,-0.3810f,-0.9055f, 0.2820f,-0.8636f,-0.4180f, -0.3177f,-0.4583f,-0.8300f, -0.0589f,0.2187f,0.9740f, -0.0589f,0.2187f,0.9740f, -0.0589f,0.2187f,0.9740f, -0.6714f,0.6264f,0.3961f, 0.9170f,-0.3847f,-0.1056f, 0.8567f,-0.5154f,-0.0184f, 0.0228f,-0.4630f,-0.8860f, 0.0228f,-0.4630f,-0.8860f, 0.0228f,-0.4630f,-0.8860f, 
	0.2090f,-0.3352f,-0.9187f, -0.2281f,0.2540f,0.9399f, -0.2281f,0.2540f,0.9399f, -0.2281f,0.2540f,0.9399f, 0.8494f,0.3953f,0.3497f, 0.9964f,-0.0837f,-0.0137f, 0.9964f,-0.0837f,-0.0137f, 0.1373f,0.4431f,-0.8859f, 0.1373f,0.4431f,-0.8859f, -0.1862f,0.9753f,0.1186f, -0.1862f,0.9753f,0.1186f, -0.1862f,0.9753f,0.1186f, -0.0236f,0.9975f,0.0668f, 0.9779f,-0.1931f,0.0807f, 0.4384f,-0.8597f,-0.2623f, 
	-0.9178f,0.2997f,-0.2602f, -0.6127f,0.7898f,-0.0280f, -0.3321f,0.9192f,-0.2118f, -0.5128f,0.1284f,0.8488f, -0.5128f,0.1284f,0.8488f, -0.5128f,0.1284f,0.8488f, -0.3128f,-0.0576f,0.9481f, 0.7987f,-0.2068f,0.5651f, 0.7987f,-0.2068f,0.5651f, -0.5891f,0.7590f,-0.2774f, -0.4707f,-0.4325f,0.7690f, -0.8908f,-0.1066f,0.4417f, 0.6825f,-0.5810f,0.4434f, 0.6825f,-0.5810f,0.4434f, 0.0236f,0.8990f,-0.4373f, 
	0.0236f,0.8990f,-0.4373f, -0.8102f,0.5720f,-0.1280f, 0.0618f,-0.9024f,-0.4264f, 0.0618f,-0.9024f,-0.4264f, 0.0618f,-0.9024f,-0.4264f, 0.0132f,-0.9137f,-0.4061f, 0.8488f,0.2730f,0.4528f, 0.9074f,0.3224f,0.2697f, -0.2325f,0.7485f,0.6210f, -0.2325f,0.7485f,0.6210f, -0.2325f,0.7485f,0.6210f, -0.1781f,0.7110f,0.6802f, -0.9387f,-0.1926f,-0.2860f, -0.9387f,-0.1926f,-0.2860f, -0.9387f,-0.1926f,-0.2860f, 
	0.2666f,-0.7711f,-0.5781f, 0.7951f,-0.5982f,-0.1004f, 0.7951f,-0.5982f,-0.1004f, -0.9747f,-0.0451f,-0.2188f, 0.5253f,0.5742f,0.6280f, -0.8920f,-0.1072f,0.4392f, -0.5544f,-0.4009f,0.7293f, 0.7505f,-0.6365f,0.1778f, 0.7505f,-0.6365f,0.1778f, 0.7505f,-0.6365f,0.1778f, 0.5660f,-0.7799f,0.2671f, 0.5660f,-0.7799f,0.2671f, 0.5660f,-0.7799f,0.2671f, 0.3673f,-0.8538f,0.3690f, 0.2850f,-0.1531f,0.9462f, 
	-0.7387f,-0.1192f,0.6634f, -0.7218f,0.0682f,0.6887f, -0.7832f,0.0484f,0.6199f, -0.8214f,0.4549f,0.3440f, -0.8214f,0.4549f,0.3440f, -0.8214f,0.4549f,0.3440f, -0.7879f,0.4906f,0.3722f, -0.7973f,0.5836f,-0.1542f, 0.8504f,-0.3105f,0.4247f, 0.5579f,-0.8055f,0.1998f, 
_NULL_ }; /* End of jaw_Normals */

const unsigned short jaw_Faces[] = {
	0, 2, 1, 0, 3, 2, 0, 4, 3, 5, 7, 6, 7, 5, 8, 9, 4, 10, 4, 9, 3, 2, 8, 1, 8, 2, 7, 5, 1, 8, 
	1, 5, 0, 11, 13, 12, 13, 11, 14, 15, 17, 16, 17, 15, 18, 11, 19, 14, 19, 11, 20, 12, 17, 18, 17, 12, 13, 12, 21, 11, 
	21, 12, 22, 23, 25, 24, 25, 23, 26, 11, 27, 20, 11, 28, 27, 21, 28, 11, 29, 12, 18, 12, 29, 22, 18, 31, 30, 31, 18, 15, 
	32, 34, 33, 34, 32, 35, 27, 36, 20, 36, 27, 37, 29, 30, 38, 30, 29, 18, 32, 40, 39, 40, 32, 33, 37, 41, 36, 41, 37, 42, 
	31, 43, 30, 43, 31, 44, 30, 45, 38, 45, 30, 43, 46, 48, 47, 48, 46, 49, 50, 48, 51, 48, 50, 47, 34, 49, 46, 52, 54, 53, 
	54, 52, 55, 56, 58, 57, 58, 56, 59, 60, 57, 58, 57, 60, 61, 52, 59, 56, 59, 52, 62, 53, 62, 52, 62, 53, 63, 59, 64, 58, 
	64, 59, 65, 62, 65, 59, 65, 62, 66, 66, 63, 67, 63, 66, 62, 39, 69, 68, 69, 39, 40, 70, 71, 41, 71, 70, 72, 25, 44, 24, 
	44, 25, 43, 25, 45, 43, 45, 25, 26, 73, 58, 64, 58, 73, 60, 0, 14, 4, 14, 0, 13, 6, 17, 5, 17, 6, 16, 14, 10, 4, 
	10, 14, 19, 5, 13, 0, 13, 5, 17, 74, 76, 75, 76, 74, 77, 75, 79, 78, 79, 75, 76, 78, 81, 80, 81, 78, 79, 82, 84, 83, 
	84, 82, 85, 86, 82, 87, 82, 86, 85, 87, 88, 86, 88, 87, 89, 81, 84, 80, 84, 81, 83, 35, 55, 34, 55, 35, 54, 72, 24, 71, 
	24, 72, 23, 24, 41, 71, 41, 24, 44, 41, 31, 36, 31, 41, 44, 36, 15, 20, 15, 36, 31, 20, 16, 19, 16, 20, 15, 16, 10, 19, 
	10, 16, 6, 10, 7, 9, 7, 10, 6, 7, 3, 9, 3, 7, 2, 42, 70, 41, 77, 70, 76, 70, 77, 72, 70, 42, 76, 76, 37, 79, 
	37, 76, 42, 79, 27, 81, 27, 79, 37, 50, 21, 47, 21, 50, 28, 47, 22, 46, 22, 47, 21, 22, 34, 46, 34, 22, 29, 29, 33, 34, 
	33, 29, 38, 38, 40, 33, 40, 38, 45, 26, 40, 45, 40, 26, 69, 26, 68, 69, 68, 26, 23, 74, 72, 77, 68, 72, 74, 23, 72, 68, 
	68, 75, 39, 75, 68, 74, 39, 78, 32, 78, 39, 75, 32, 80, 35, 80, 32, 78, 54, 80, 84, 80, 54, 35, 54, 85, 53, 85, 54, 84, 
	85, 63, 53, 63, 85, 86, 86, 67, 63, 67, 86, 88, 81, 90, 83, 90, 81, 27, 57, 51, 48, 51, 57, 61, 48, 56, 57, 56, 48, 49, 
	56, 55, 52, 56, 34, 55, 49, 34, 56, 28, 90, 27, 90, 28, 50, 50, 51, 90, 83, 61, 82, 90, 61, 83, 51, 61, 90, 87, 61, 60, 
	61, 87, 82, 87, 73, 89, 73, 87, 60, 91, 93, 92, 91, 94, 93, 91, 95, 94, 96, 98, 97, 98, 96, 99, 100, 92, 93, 92, 100, 101, 
	94, 97, 98, 97, 94, 95, 96, 95, 91, 95, 96, 97, 102, 104, 103, 104, 102, 105, 106, 108, 107, 108, 106, 109, 102, 111, 110, 111, 102, 103, 
	105, 108, 104, 108, 105, 107, 105, 113, 112, 113, 105, 102, 114, 116, 115, 116, 114, 117, 118, 102, 110, 119, 102, 118, 113, 102, 119, 120, 105, 112, 
	105, 120, 107, 107, 121, 106, 121, 107, 122, 123, 125, 124, 125, 123, 126, 118, 128, 127, 128, 118, 110, 120, 122, 107, 122, 120, 129, 123, 130, 126, 
	130, 123, 131, 127, 133, 132, 133, 127, 128, 121, 135, 134, 135, 121, 122, 122, 136, 135, 136, 122, 129, 137, 139, 138, 139, 137, 140, 141, 139, 140, 
	139, 141, 142, 125, 137, 138, 143, 145, 144, 145, 143, 146, 147, 149, 148, 149, 147, 150, 151, 150, 152, 150, 151, 149, 143, 148, 153, 148, 143, 147, 
	146, 153, 154, 153, 146, 143, 148, 64, 65, 64, 148, 149, 153, 65, 66, 65, 153, 148, 66, 154, 153, 154, 66, 67, 131, 155, 130, 155, 131, 156, 
	157, 159, 158, 159, 157, 133, 116, 134, 135, 134, 116, 117, 116, 136, 115, 136, 116, 135, 73, 149, 151, 149, 73, 64, 91, 103, 104, 103, 91, 92, 
	99, 108, 109, 108, 99, 96, 103, 101, 111, 101, 103, 92, 96, 104, 108, 104, 96, 91, 160, 162, 161, 162, 160, 163, 163, 164, 162, 164, 163, 165, 
	165, 166, 164, 166, 165, 167, 168, 170, 169, 170, 168, 171, 172, 168, 169, 168, 172, 173, 173, 88, 89, 88, 173, 172, 166, 170, 171, 170, 166, 167, 
	124, 144, 145, 144, 124, 125, 158, 117, 114, 117, 158, 159, 117, 133, 134, 133, 117, 159, 133, 121, 134, 121, 133, 128, 128, 106, 121, 106, 128, 110, 
	110, 109, 106, 109, 110, 111, 109, 101, 99, 101, 109, 111, 101, 98, 99, 98, 101, 100, 98, 93, 94, 93, 98, 100, 132, 133, 157, 161, 157, 158, 
	157, 161, 162, 157, 162, 132, 162, 127, 132, 127, 162, 164, 164, 118, 127, 118, 164, 166, 141, 113, 119, 113, 141, 140, 140, 112, 113, 112, 140, 137, 
	112, 125, 120, 125, 112, 137, 120, 126, 129, 126, 120, 125, 129, 130, 136, 130, 129, 126, 115, 130, 155, 130, 115, 136, 115, 156, 114, 156, 115, 155, 
	158, 160, 161, 158, 156, 160, 114, 156, 158, 156, 163, 160, 163, 156, 131, 131, 165, 163, 165, 131, 123, 123, 167, 165, 167, 123, 124, 145, 167, 124, 
	167, 145, 170, 145, 169, 170, 169, 145, 146, 169, 154, 172, 154, 169, 146, 172, 67, 88, 67, 172, 154, 166, 174, 118, 174, 166, 171, 150, 142, 152, 
	142, 150, 139, 139, 147, 138, 147, 139, 150, 144, 147, 143, 125, 147, 144, 138, 147, 125, 119, 174, 141, 174, 119, 118, 141, 174, 142, 152, 171, 168, 
	152, 174, 171, 142, 174, 152, 173, 152, 168, 152, 173, 151, 173, 73, 151, 73, 173, 89, 
_NULL_ }; /* End of jaw_Faces */



/**********************************************************
 * MESHES 
 **********************************************************/

const Struct_Mesh 
   Mesh[NUM_MESHES] = {

/* MESH 0 */
	/* NumVertex      */ skull5_NumVertex,
	/* NumFaces       */ skull5_NumFaces,
	/* NumStrips      */ skull5_NumStrips,
	/* Flags          */ skull5_Flags,
	/* Material       */ skull5_Material,
	/* Center         */  -1.318321f, -44.220169f, 54.464096f,
	/* Vertices       */ skull5_Vertices,
	/* UV             */ skull5_UV,
	/* Normals        */ skull5_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)skull5_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 1 */
	/* NumVertex      */ skull4_NumVertex,
	/* NumFaces       */ skull4_NumFaces,
	/* NumStrips      */ skull4_NumStrips,
	/* Flags          */ skull4_Flags,
	/* Material       */ skull4_Material,
	/* Center         */  -1.316769f, -44.220169f, 54.416954f,
	/* Vertices       */ skull4_Vertices,
	/* UV             */ skull4_UV,
	/* Normals        */ skull4_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)skull4_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 2 */
	/* NumVertex      */ skull3_NumVertex,
	/* NumFaces       */ skull3_NumFaces,
	/* NumStrips      */ skull3_NumStrips,
	/* Flags          */ skull3_Flags,
	/* Material       */ skull3_Material,
	/* Center         */  -1.318557f, -44.220169f, 54.463642f,
	/* Vertices       */ skull3_Vertices,
	/* UV             */ skull3_UV,
	/* Normals        */ skull3_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)skull3_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 3 */
	/* NumVertex      */ skull6_NumVertex,
	/* NumFaces       */ skull6_NumFaces,
	/* NumStrips      */ skull6_NumStrips,
	/* Flags          */ skull6_Flags,
	/* Material       */ skull6_Material,
	/* Center         */  -1.318891f, -44.220169f, 54.463768f,
	/* Vertices       */ skull6_Vertices,
	/* UV             */ skull6_UV,
	/* Normals        */ skull6_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)skull6_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 4 */
	/* NumVertex      */ jaw_NumVertex,
	/* NumFaces       */ jaw_NumFaces,
	/* NumStrips      */ jaw_NumStrips,
	/* Flags          */ jaw_Flags,
	/* Material       */ jaw_Material,
	/* Center         */  -0.092042f, -36.211487f, 29.102654f,
	/* Vertices       */ jaw_Vertices,
	/* UV             */ jaw_UV,
	/* Normals        */ jaw_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)jaw_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_

	}; /* End of Meshes */