/*
 * Flash block driver
 * Copyright (C) 1999-2000 Nicolas Pitre <nico@cam.org>
 *
 * This is a block device driver for Intel Flash memory.
 */


/* 
 * Partition definitions... 
 */
#if defined( CONFIG_SA1100_VICTOR )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x10000, 0x40000, 0x1a0000, 0x10000 };

#elif defined( CONFIG_SA1100_THINCLIENT ) || (CONFIG_SA1100_GRAPHICSCLIENT)

#define FLASH_PARTITIONS	3
// static int flash_length[FLASH_PARTITIONS] = { 0x80000, 0x780000, 0x800000 };
static int flash_length[FLASH_PARTITIONS] = { 0x100000, 0x300000, 0xc00000 };


#elif defined( CONFIG_VIPCI )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x10000, 0x80000, 0x730000, 0x40000 };

#elif defined( CONFIG_SA1100_ASSABET )

#define FLASH_PARTITIONS	4
/* 
 * Memory config with 28F160S3 FastFlash (As comes on Phase 4 Assabet)
 * Angel 1.2 <= 65 K
 * zImage 2.3.99-pre8 <= 768 K
 * ramdisk_img <= 2.5 M
 * bigdisk <= 28.6875 M
 */
static int flash_length_28F160S3[FLASH_PARTITIONS] = { 0x10000, 0xc0000, 0x280000, 0xb0000 };

/* 
 * Memory config with 28F128J3A StrataFlash
 * Angel 1.2 <= 65 K
 * zImage 2.3.99-pre8 <= 768 K
 * ramdisk_img <= 2.5 M
 * bigdisk <= 28.6875 M
 */
static int flash_length_28F128J3A[FLASH_PARTITIONS] = { 0x10000, 0xc0000, 0x280000, 0x1cb0000 };

static int flash_length[FLASH_PARTITIONS] = { 0, 0, 0, 0 };

#elif defined( CONFIG_SA1100_BITSY )

#define FLASH_PARTITIONS	6
static int flash_length[FLASH_PARTITIONS] = { 0x00040000, 0x00080000, 0x00040000, 0x00700000, 0x00800000, 0x01000000 };

#elif defined( CONFIG_ARCH_PERSONAL_SERVER )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x00020000, 0x000e0000, 0x00600000, 0x00200000 };
#else
#error Missing partition definition
#endif


/*
 *  Macros to toggle WP and VPP pins for programming flash
 */
#ifdef CONFIG_SA1100_VICTOR
#define GPIO_FLASH_WP	(GPIO_GPIO4|GPIO_GPIO5)
#define WP_VPP_ON()	GPSR = GPIO_FLASH_WP
#define WP_VPP_OFF()	GPCR = GPIO_FLASH_WP
#elif defined(CONFIG_SA1100_BITSY)
#define WP_VPP_ON()	set_bitsy_egpio(EGPIO_BITSY_VPP_ON)
#define WP_VPP_OFF()	clr_bitsy_egpio(EGPIO_BITSY_VPP_ON)
#else
#define WP_VPP_ON()
#define WP_VPP_OFF()
#endif

/* 
 * SECTSIZE_FROM_K() - is used to calculate the sector size by the number
 * of chips that compose the bus width, and the size in K of an erase
 * block on each chip.
 */
#define SECTSIZE_FROM_K(no_chips, no_k) ((no_chips) * (no_k) * 1024)

/* SECTSIZE_FROM_CFI() - is used to calculate the sector size based on
 * the number of chips that compose the bus width and the information
 * retrieved about the chips using the CFI commands
 */
#define SECTSIZE_FROM_CFI(no_chips, size_erase_blocks) \
	((no_chips) * (size_erase_blocks) * 256)

/*
 * Flash access methods
 * (FLASH_SECTSIZE benifits from autodetection and validation where CFI is 
 *  available)
 */
#if defined( CONFIG_SA1100_VICTOR )

#define	FLASH_CHIPS_PER_BUS	1
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 64 )
#define _CMD( x )  (x)

typedef unsigned short FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_SA1100_ASSABET )

/* two paralel 16-bit access */
#define	FLASH_CHIPS_PER_BUS	2
#if 1
/* 28F160S3 FastFlash has 64 K blocks */
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 64 )
#else
/* 28F128J3A StrataFlash has 128 K blocks */
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 128 )
#endif
#define _CMD( x )  ((x)|((x)<<16))
#define FLASH_HAS_CFI

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_SA1100_THINCLIENT ) || defined(CONFIG_SA1100_GRAPHICSCLIENT) || defined(CONFIG_SA1100_BITSY) || defined(CONFIG_ARCH_PERSONAL_SERVER)

/* two paralel 16-bit access */
#define	FLASH_CHIPS_PER_BUS	2
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 128 )
#define _CMD( x )  ((x)|((x)<<16))

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_VIPCI1 )

#define	FLASH_CHIPS_PER_BUS	1
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 64 )
#define _CMD( x )  (x)

typedef unsigned char FLASH_t;

#include <asm/dec21285.h>

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	*CSR_ROMWRITEREG = i;
	i &= ~(4-sizeof(FLASH_t));
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_VIPCI2 )

/* two paralel 16-bit access */
#define	FLASH_CHIPS_PER_BUS	2
#define FLASH_SECTSIZE		SECTSIZE_FROM_K( FLASH_CHIPS_PER_BUS, 64 )
#define _CMD( x )  ((x)|((x)<<16))

typedef unsigned int FLASH_t;

static inline FLASH_t *FLASH_PTR( char *base, unsigned long i)
{
	return (FLASH_t *)(base + i);
}

#elif defined( CONFIG_SA1100_BITSY )

#define FLASH_PARTITIONS	6
static int flash_length[FLASH_PARTITIONS] = { 0x00040000, 0x00080000, 0x00040000, 0x00700000, 0x00800000, 0x01000000 };

#elif defined( CONFIG_ARCH_PERSONAL_SERVER )

#define FLASH_PARTITIONS	4
static int flash_length[FLASH_PARTITIONS] = { 0x00020000, 0x000e0000, 0x00600000, 0x00200000 };
#else
#error Missing pointer access definition
#endif

#ifdef FLASH_HAS_CFI
struct flash_cfi_info {
	u8 manufacturer_code; /* 89 = Intel, D0 = Intel */
	u8 device_code;

	/* CFI Identification */
	char cfi_ident[4];
	u8 is_cfi_supported;
	
	u16 primary_vendor_command_code;
	u16 primary_extended_query_table;
	u16 alternate_vendor_command_code;
	u16 alternate_extended_query_table;
	
	/* CFI System Interface Info */
	u8 vcc_min_program_erase;
	u8 vcc_max_program_erase;
	u8 vpp_min_program_erase;
	u8 vpp_max_program_erase;
	u8 typ_single_word_timeout;
	u8 typ_max_buffer_write_timeout;
	u8 typ_block_erase_timeout;
	u8 typ_full_chip_erase_timeout;
	u8 max_word_program_timeout;
	u8 max_buffer_write_timeout;
	u8 max_block_erase_timeout;
	u8 max_chip_erase_timeout;

	/* Device Gemoetry Info */
	u8 device_size;  /* 0x27 2^n bytes */
	u8 x8_async_ifc; /* 0x28 x8 async flash ifc */
	u8 x16_async_ifc; /* 0x29 x16 async flash ifc */
	u8 max_write_buffer_size; /* 0x2A-0x2B 2^n max write buffer bytes */
	u8 num_erase_block_regions; /* 0x2C Erase block regions */
	u16 num_erase_blocks_r1; /* 0x2D-0x2E Number of Erase blocks */
	u16 size_erase_blocks_r1; /* 0x2F-0x30 Size of Erase blocks */

	char pri_ident[4];
	
	/* Intel-Specific Extended Query */
	u8 primary_extended_major_vers;
	u8 primary_extended_minor_vers;
	u8 optional_feature_and_command_support;
	u8 vcc_highest_perform_program_erase; /* P+0x0C */
	u8 vpp_highest_perform_program_erase; /* P+0x0D */

	/* Intel-Specific Extension - Burst Read Info */
	u8 page_mode_read; /* P+0x13 size of page mode reads in 2^n bytes */
};
#endif

