/*
 * linux/include/asm-arm/arch-sa1100/dma.h
 *
 * SA1100 DMA routines
 *
 * Copyright (C) 2000 Nicolas Pitre
 *
 * NOTE: only request_dma() and free_dma() calls to the generic API are 
 *       supported ATM.
 */

#ifndef __ASM_ARCH_DMA_H
#define __ASM_ARCH_DMA_H

/*
 * This is the maximum DMA address that can be DMAd to.
 */
#define MAX_DMA_ADDRESS		0xffffffff

/*
 * The SA1100 has six internal DMA channels.
 */
#define MAX_DMA_CHANNELS	6

/*
 * Maximum physical DMA buffer size
 */
#define MAX_DMA_SIZE		0x1fff
#define MAX_DMA_ORDER		12

/*
 * DMA control register structure
 */
typedef struct {
	volatile u_long DDAR;
	volatile u_long SetDCSR;
	volatile u_long ClrDCSR;
	volatile u_long RdDCSR;
	volatile void *DBSA;
	volatile u_long DBTA;
	volatile void *DBSB;
	volatile u_long DBTB;
} dma_regs_t;

/*
 * DMA buffer structure
 */
typedef struct {
	/* "public" members */
	char *data;			/* points to actual buffer data */
	dma_addr_t dma_handle;		/* data buffer in DMA's address space */
	int size;			/* buffer size */
	void *priv;			/* for use by caller */
	/* "private" members */
	dma_addr_t dma_ptr;		/* current DMA data position */
	int ref;			/* number of DMA references */
	struct dma_buf_t *next;		/* next buffer to process */
} dma_buf_t;


extern int sa1100_start_dma( dma_regs_t *DMA, void *dma_ptr, int size );

#endif /* _ASM_ARCH_DMA_H */
