/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * btflash.h - Flash erase and program routines for Compaq Personal Server Monitor
 *
 */

#ifndef BOOTLDR
#include <stdio.h>
typedef unsigned long dword;
#define putstr(x) fprintf(stderr, (x))
#define putLabeledWord(str, v) fprintf(stderr, "%s%08x\n", (str), (v))
#define get_param(name) NULL
#define FLASH_BASE 0x41000000
#else
/* bootldrd specific includes and defines here */
#include "bootldr.h"
#endif

/*
 * address of first word of flash given current MMU settings 
 * Must be uncached!
 */
extern volatile unsigned long *flashword; 
extern long flash_size;
extern long flash_address_mask;

enum LFR_FLAGS {
   LFR_SIZE_PREFIX = 1,		/* prefix data with 4-byte size */
   LFR_PATCH_BOOTLDR = 2,	/* patch bootloader's 0th instruction */
   LFR_KERNEL = 4		/* add BOOTIMG_MAGIC, imgsize and VKERNEL_BASE to head of programmed region (see bootldr.c) */
};

struct FlashRegion {
   const char *name;
   long base;
   long size;
   enum LFR_FLAGS flags;
};

typedef struct {
   int (*reset)(void);
   int (*programWord)(unsigned long flashAddress, unsigned long value);
   int (*programBlock)(unsigned long flashAddress, unsigned long *values, int nbytes);
   int (*eraseChip)(void);
   int (*eraseSector)(unsigned long sectorAddress);
   int (*eraseRange)(unsigned long start, unsigned long len);
   int (*protectRange)(unsigned long start, unsigned long len, int protect);
} FlashAlgorithm;

typedef struct FlashDescriptor {
   char *deviceName;
   int manufacturerID;
   int deviceID;
   FlashAlgorithm *algorithm;
   int nsectors;
   unsigned long *sectors;
   struct FlashRegion bootldr;
   struct FlashRegion params;
   struct FlashRegion kernel;
   struct FlashRegion ramdisk;
   struct FlashRegion usercode;
   struct FlashRegion altkernel;
   struct FlashRegion debugger;
} FlashDescriptor;

extern int nsectors;
extern FlashDescriptor *flashDescriptor;
extern unsigned long *flashSectors;


/*
 * btflash_init()
 *
 * Query flash to determine type and then initialize sector and region data structures appropriately.
 */
void btflash_init();

/**
 * reset the flash chip state machine
 */
int resetFlash(void);

enum FlashType {
   FT_Am29LV160BB,
   FT_Am29DL323CT
};
void setFlashType(enum FlashType);

/* returns 0 on success */
int programFlashWord(unsigned long flashAddress, unsigned long value);

/*
 * Programs block of values starting at flashAddress
 * Sectors must be erased before they can be programmed.
 */
int programFlashBlock(unsigned long flashAddress, unsigned long *values, int nbytes);

/*
 * returns 0 on success
*/
int eraseFlashChip (void);

/*
 * assumes sectorAddress is a valid start of sector address 
 * returns 0 on success
*/
int eraseFlashSector (unsigned long sectorAddress);

/*
 * erases a range of flash
 * returns 0 on success
 */
int eraseFlashRange(unsigned long start, unsigned long len);

/*
 * Puts flash in query mode, reads flashWordAddress, resets flash, and returns result.
 */
unsigned long queryFlash(unsigned long flashWordAddress);

/*
 * Puts flash in CFI ID mode, reads flashWordAddress, resets flash, and returns result.
 */
unsigned long queryFlashID(unsigned long flashWordAddress);

/*
 * Puts flash in security sector mode, reads flashWordAddress, resets flash, and returns result.
 */
unsigned long queryFlashSecurity(unsigned long flashWordAddress);

/*
 * Protects or unprotects flash range and returns non-zero on error
 */
int protectFlashRange(unsigned long flashWordAddress, unsigned long len, int protect);


void btflash_print_types(void);
void btflash_set_type(const char *devicename);

extern int btflash_verbose;
