/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

#include "bootldr.h"
#include "btflash.h"
#include "bootconfig.h"

  /*
   * We just set up a linear virtual -> physical mapping
   *   After evacuating the bootldr from Flash, we will use
   *   the fourth to last 1MB of DRAM to hold a cache-enabled image of the first 1MB Flash
   */

unsigned long *mmu_table = (unsigned long *) MMU_TABLE_START;

#define EVACUATE_TO_DRAM

extern void *_start;

void bootConfigureMMU(void)
{
  unsigned long pageoffset;
  unsigned long sectionNumber;

#ifdef EVACUATE_TO_DRAM
  putLabeledWord("&_start=", (long)&_start);
  putLabeledWord("FLASH_BASE=", (long)FLASH_BASE);
  if ((char*)&_start == (char*)FLASH_BASE) {
    /* copy ourselves out of flash into the 2nd-to-last megabyte of DRAM */
    putLabeledWord(" Evacuating 1MB of Flash to DRAM at: ", FLASH_IMG_START);
    memcpy((void *)FLASH_IMG_START, (void *)&_start, SZ_1M);
    putstr("done\r\n");
  }
#endif

  for (sectionNumber = 0x000; sectionNumber <= 0xfff; sectionNumber++) {
    pageoffset = (sectionNumber << 20);
    mmu_table[pageoffset >> 20] = pageoffset | MMU_SECDESC;
  }

  /* make dram cacheable */
  for (pageoffset = DRAM_BASE0; pageoffset < (DRAM_BASE0+DRAM_SIZE0); pageoffset += SZ_1M) {
    if (0) putLabeledWord("Make DRAM section cacheable: ", pageoffset);
    mmu_table[pageoffset >> 20] = pageoffset | MMU_SECDESC | MMU_CACHEABLE;
  }

  /* Make flash cacheable
   */
  for (pageoffset = 0; pageoffset < FLASH_REGION_SIZE; pageoffset += SZ_1M) {
    unsigned long cached_flash_addr = FLASH_BASE + pageoffset;
    unsigned long uncached_flash_addr = UNCACHED_FLASH_BASE + pageoffset;
    if (0) putLabeledWord("Make Flash section cacheable: ", pageoffset);
    mmu_table[cached_flash_addr >> 20] = cached_flash_addr | MMU_SECDESC | MMU_CACHEABLE;
    if (0) putLabeledWord("Uncached image of Flash: ", uncached_flash_addr);
    mmu_table[uncached_flash_addr >> 20] = cached_flash_addr | MMU_SECDESC;
  }

#ifdef EVACUATE_TO_DRAM
  putLabeledWord("Map Flash virtual section to DRAM at: ", FLASH_IMG_START);
  /* point first 1MB of flash virtual addresses to its cacheable image in DRAM */
  mmu_table[FLASH_BASE >> 20] = FLASH_IMG_START | MMU_SECDESC | MMU_CACHEABLE;
#endif

  flashword = (volatile unsigned long *)UNCACHED_FLASH_BASE;

  writeBackDcache(CACHE_FLUSH_BASE);
  flushTLB();
  
}
