/*
 * linux/include/asm-arm/arch-sa1100/irqs.h
 *
 * Copyright (C) 1996 Russell King
 * Copyright (C) 1998 Deborah Wallach (updates for SA1100/Brutus).
 * Copyright (C) 1999 Nicolas Pitre (full GPIO irq isolation)
 */

#include <linux/config.h>

#define SA1100_IRQ(x)		(0 + (x))

#define	IRQ_GPIO0		SA1100_IRQ(0)
#define	IRQ_GPIO1		SA1100_IRQ(1)
#define	IRQ_GPIO2		SA1100_IRQ(2)
#define	IRQ_GPIO3		SA1100_IRQ(3)
#define	IRQ_GPIO4		SA1100_IRQ(4)
#define	IRQ_GPIO5		SA1100_IRQ(5)
#define	IRQ_GPIO6		SA1100_IRQ(6)
#define	IRQ_GPIO7		SA1100_IRQ(7)
#define	IRQ_GPIO8		SA1100_IRQ(8)
#define	IRQ_GPIO9		SA1100_IRQ(9)
#define	IRQ_GPIO10		SA1100_IRQ(10)
#define	IRQ_GPIO11_27		SA1100_IRQ(11)
#define	IRQ_LCD  		SA1100_IRQ(12)	/* LCD controller           */
#define	IRQ_Ser0UDC		SA1100_IRQ(13)	/* Ser. port 0 UDC          */
#define	IRQ_Ser1SDLC		SA1100_IRQ(14)	/* Ser. port 1 SDLC         */
#define	IRQ_Ser1UART		SA1100_IRQ(15)	/* Ser. port 1 UART         */
#define	IRQ_Ser2ICP		SA1100_IRQ(16)	/* Ser. port 2 ICP          */
#define	IRQ_Ser3UART		SA1100_IRQ(17)	/* Ser. port 3 UART         */
#define	IRQ_Ser4MCP		SA1100_IRQ(18)	/* Ser. port 4 MCP          */
#define	IRQ_Ser4SSP		SA1100_IRQ(19)	/* Ser. port 4 SSP          */
#define	IRQ_DMA0 		SA1100_IRQ(20)	/* DMA controller channel 0 */
#define	IRQ_DMA1 		SA1100_IRQ(21)	/* DMA controller channel 1 */
#define	IRQ_DMA2 		SA1100_IRQ(22)	/* DMA controller channel 2 */
#define	IRQ_DMA3 		SA1100_IRQ(23)	/* DMA controller channel 3 */
#define	IRQ_DMA4 		SA1100_IRQ(24)	/* DMA controller channel 4 */
#define	IRQ_DMA5 		SA1100_IRQ(25)	/* DMA controller channel 5 */
#define	IRQ_OST0 		SA1100_IRQ(26)	/* OS Timer match 0         */
#define	IRQ_OST1 		SA1100_IRQ(27)	/* OS Timer match 1         */
#define	IRQ_OST2 		SA1100_IRQ(28)	/* OS Timer match 2         */
#define	IRQ_OST3 		SA1100_IRQ(29)	/* OS Timer match 3         */
#define	IRQ_RTC1Hz		SA1100_IRQ(30)	/* RTC 1 Hz clock           */
#define	IRQ_RTCAlrm		SA1100_IRQ(31)	/* RTC Alarm                */

#define	IRQ_GPIO_11_27(x)	(32 + (x) - 11)

#define	IRQ_GPIO11		IRQ_GPIO_11_27(11)
#define	IRQ_GPIO12		IRQ_GPIO_11_27(12)
#define	IRQ_GPIO13		IRQ_GPIO_11_27(13)
#define	IRQ_GPIO14		IRQ_GPIO_11_27(14)
#define	IRQ_GPIO15		IRQ_GPIO_11_27(15)
#define	IRQ_GPIO16		IRQ_GPIO_11_27(16)
#define	IRQ_GPIO17		IRQ_GPIO_11_27(17)
#define	IRQ_GPIO18		IRQ_GPIO_11_27(18)
#define	IRQ_GPIO19		IRQ_GPIO_11_27(19)
#define	IRQ_GPIO20		IRQ_GPIO_11_27(20)
#define	IRQ_GPIO21		IRQ_GPIO_11_27(21)
#define	IRQ_GPIO22		IRQ_GPIO_11_27(22)
#define	IRQ_GPIO23		IRQ_GPIO_11_27(23)
#define	IRQ_GPIO24		IRQ_GPIO_11_27(24)
#define	IRQ_GPIO25		IRQ_GPIO_11_27(25)
#define	IRQ_GPIO26		IRQ_GPIO_11_27(26)
#define	IRQ_GPIO27		IRQ_GPIO_11_27(27)

#define	NR_IRQS                 49

#define SA1100_GPIO_TO_IRQ(i) (((i)<11) ? SA1100_IRQ(i) : IRQ_GPIO_11_27(i))



#ifdef CONFIG_SA1101

#define SA1101_IRQ(x)	(49 + (x))

#define GPAIN0          SA1101_IRQ(0)
#define GPAIN1		SA1101_IRQ(1)
#define GPAIN2		SA1101_IRQ(2)
#define GPAIN3		SA1101_IRQ(3)
#define GPAIN4		SA1101_IRQ(4)
#define GPAIN5		SA1101_IRQ(5)
#define GPAIN6		SA1101_IRQ(6)
#define GPAIN7		SA1101_IRQ(7)
#define GPBIN0		SA1101_IRQ(8)
#define GPBIN1		SA1101_IRQ(9)
#define GPBIN2		SA1101_IRQ(10)
#define GPBIN3		SA1101_IRQ(11)
#define GPBIN4		SA1101_IRQ(12)
#define GPBIN5		SA1101_IRQ(13)
#define GPBIN6		SA1101_IRQ(14)
#define RESERVED	SA1101_IRQ(15)
#define KPXIN0		SA1101_IRQ(16)
#define KPXIN1		SA1101_IRQ(17)
#define KPXIN2		SA1101_IRQ(18)
#define KPXIN3		SA1101_IRQ(19)
#define KPXIN4		SA1101_IRQ(20)
#define KPXIN5		SA1101_IRQ(21)
#define KPXIN6		SA1101_IRQ(22)
#define KPXIN7		SA1101_IRQ(23)
#define KPYIN0		SA1101_IRQ(24)
#define KPYIN1		SA1101_IRQ(25)
#define KPYIN2		SA1101_IRQ(26)
#define KPYIN3		SA1101_IRQ(27)
#define KPYIN4		SA1101_IRQ(28)
#define KPYIN5		SA1101_IRQ(29)
#define KPYIN6		SA1101_IRQ(30)
#define KPYIN7		SA1101_IRQ(31)
#define KPYIN8		SA1101_IRQ(32)
#define KPYIN9		SA1101_IRQ(33)
#define KPYIN10		SA1101_IRQ(34)
#define KPYIN11		SA1101_IRQ(35)
#define KPYIN12		SA1101_IRQ(36)
#define KPYIN13		SA1101_IRQ(37)
#define KPYIN14		SA1101_IRQ(38)
#define KPYIN15		SA1101_IRQ(39)
#define MSTXINT		SA1101_IRQ(40)
#define MSRXINT		SA1101_IRQ(41)
#define TPTXINT		SA1101_IRQ(42)
#define TPRXINT		SA1101_IRQ(43)
#define INTREQTRC	SA1101_IRQ(44)
#define INTREQTIM	SA1101_IRQ(45)
#define INTREQRAV	SA1101_IRQ(46)
#define INTREQINT	SA1101_IRQ(47)
#define INTREQEMP	SA1101_IRQ(48)
#define INTREQDAT	SA1101_IRQ(49)
#define VIDEOINT	SA1101_IRQ(50)
#define FIFOINT		SA1101_IRQ(51)
#define NIRQHCIM	SA1101_IRQ(52)
#define IRQHCIBUFFACC	SA1101_IRQ(53)
#define IRQHCIRMTWKP	SA1101_IRQ(54)
#define NHCIMFCLIR	SA1101_IRQ(55)
#define USBERROR	SA1101_IRQ(56)
#define S0_READY_NIREQ	SA1101_IRQ(57)
#define S1_READY_NIREQ	SA1101_IRQ(58)
#define S0_CDVALID	SA1101_IRQ(59)
#define S1_CDVALID	SA1101_IRQ(60)
#define S0_BVD1_STSCHG	SA1101_IRQ(61)
#define S1_BVD1_STSCHG	SA1101_IRQ(62)
#define USB_PORT_RESUME	SA1101_IRQ(63)

#undef NR_IRQS
#define NR_IRQS		SA1101_IRQ(64)

#endif

