/*
 *  linux/arch/arm/mach-sa1100/uart.c
 *  
 *  Author: Nicolas Pitre
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This file contains default low level UART functions which are likely
 * to change from one machine to another.  It's up to each machine specific
 * code to override them when appropriate.
 * 
 * The bulk of the SA1100 UART driver is in drivers/char/serial_sa1100.c.
 *
 * NOTE: The uart?_idx members MUST be modified _early_ to be seen by 
 * 	 the serial console code.  Good places for such assignment on
 * 	 machines that need it could be the FIXUP() or the MAP_IO()
 * 	 provided functions.
 * 	 To specify a port as non available, assign it the idx -1.
 */

#include <linux/types.h>
#include <linux/termios.h>

#include <asm/hardware.h>
#include <asm/hardware/serial_sa1100.h>


static void default_uart_on(u_int base)
{
}

static void default_uart_off(u_int base)
{
}

static void default_enable_ms(u_int base)
{
}

static int default_get_mctrl(u_int base)
{
	return TIOCM_CTS | TIOCM_DSR | TIOCM_CAR;
}

static void default_set_mctrl(u_int base, u_int mctrl)
{
}


struct sa1100_mach_uart sa1100_mach_uart = {
	on:		default_uart_on,
	off:		default_uart_off,
	enable_ms:	default_enable_ms,
	get_mctrl:	default_get_mctrl,
	set_mctrl:	default_set_mctrl,
	uart1_idx:	0,
	uart2_idx:	1,
	uart3_idx:	2
};


/* 
 * Many boards are using GPIO 14/15 with UART1.
 */
void sa1100_uart1_altgpio(void)
{
	GAFR |= (GPIO_UART_TXD | GPIO_UART_RXD);
	GPDR |= GPIO_UART_TXD;
	GPDR &= ~GPIO_UART_RXD;
	PPAR |= PPAR_UPR;
}

