#
# mountall.sh	Mount all filesystems.
#
# Version:	@(#)mountall.sh  2.83  05-Oct-2001  miquels@cistron.nl
#
. /etc/default/rcS

#
# Mount local file systems in /etc/fstab.
#
[ "$VERBOSE" != no ] && echo "Mounting local filesystems..."
mount -a -t nonfs,nosmbfs,noncpfs

#
# We might have mounted something over /dev, see if /dev/initctl is there.
#
if [ ! -p /dev/initctl ]
then
	rm -f /dev/initctl
	mknod -m 600 /dev/initctl p
fi
kill -USR1 1

#
# Execute swapon command again, in case we want to swap to
# a file on a now mounted filesystem.
#
doswap=yes
case "`uname -r`" in
	2.[0123].*)
		if grep -qs resync /proc/mdstat
		then
			doswap=no
		fi
		;;
esac
if [ $doswap = yes ]
then
	swapon -a 2> /dev/null
fi

: exit 0

