#!/usr/bin/perl -w
# This file was preprocessed, do not edit directly.
package Debconf::Element::Gnome;
use strict;
use Gtk;
use Debconf::Gettext;
use base qw(Debconf::Element);
sub init {
	my $this=shift;
	$this->hbox(Gtk::HBox->new(0, 10));
	$this->hbox->show;
}
sub addwidget {
	my $this=shift;
	my $widget=shift;
	$this->hbox->pack_start($widget, 1, 1, 0);
}
sub adddescription {
	my $this=shift;
	my $label=Gtk::Label->new($this->question->description);
	$label->show;
	$this->hbox->pack_start($label, 0, 0, 0);
}
sub addbutton {
	my $this=shift;
	
	my $help=$this->question->extended_description;
	return unless length $help;
	my $button=Gtk::Button->new_with_label(gettext("Help"));
	$button->show;
	$button->signal_connect("clicked", sub {
		my $dialog = Gnome::Dialog->new(gettext("Help"), "Button_Ok");
		my $label = Gtk::Label->new($help);
		$label->set_line_wrap(1);
		$label->show;
		$dialog->vbox->add($label);
		$dialog->run;
		$dialog->close;
	});
	my $vbox = Gtk::VBox->new(0, 0);
	$vbox->show;
	$vbox->pack_start($button, 1, 0, 0);
	$this->hbox->pack_start($vbox, 0, 0, 0);
}
sub value {
	my $this=shift;
	return '';
}
1
