#!/usr/bin/perl -w
# This file was preprocessed, do not edit directly.
package Debconf::FrontEnd::Text;
use strict;
use Text::Wrap;
use Term::ReadLine;
use Debconf::Gettext;
use Debconf::Config;
use base qw(Debconf::FrontEnd::Tty);
local $|=1;
sub init {
	my $this=shift;
	$this->SUPER::init(@_);
	$Term::ReadLine::termcap_nowarn = 1; # Turn off stupid termcap warning.
	$this->readline(Term::ReadLine->new('debconf'));
	$this->readline->ornaments(1);
	if (Term::ReadLine->ReadLine =~ /::Gnu$/) {
		$this->readline->add_defun('previous-question',	
			sub {
				if ($this->capb_backup) {
					$this->_skip(1);
					$this->_direction(-1);
					$this->readline->stuff_char(ord "\n");
				}
				else {
					$this->readline->ding;
				}
			}, ord "\cu");
		$this->readline->add_defun('next-question',
			sub {
				if ($this->capb_backup) {
					$this->readline->stuff_char(ord "\n");
				}
			}, ord "\cv");
		$this->readline->parse_and_bind('"\e[5~": previous-question');
		$this->readline->parse_and_bind('"\e[6~": next-question');
		$this->capb('backup');
	}
	
	$this->interactive(1);
	$this->linecount(0);
	
	if (Term::ReadLine->ReadLine =~ /::Stub$/) {
		$this->promptdefault(1);
	}
}
sub go {
	my $this=shift;
	foreach my $element (grep ! $_->visible, @{$this->elements}) {
		my $value=$element->show;
		return if $this->backup && $this->capb_backup;
		$element->question->value($value);
	}
	my @elements=grep $_->visible, @{$this->elements};
	unless (@elements) {
		$this->_didbackup('');
		return 1;
	}
	my $current=$this->_didbackup ? $#elements : 0;
	$this->_direction(1);
	for (; $current > -1 && $current < @elements; $current += $this->_direction) {
		my $value=$elements[$current]->show;
	}
	if ($current < 0) {
		$this->_didbackup(1);
		return;
	}
	else {
		$this->_didbackup('');
		return 1;
	}
}
sub screenwidth {
	my $this=shift;
	
	$Text::Wrap::columns=$this->SUPER::screenwidth(@_);
}
sub display {
	my $this=shift;
	my $text=shift;
	
	$this->display_nowrap(wrap('','',$text));
}
sub display_nowrap {
	my $this=shift;
	my $text=shift;
	return if Debconf::Config->terse eq 'true';
	my @lines=split(/\n/, $text);
	push @lines, "" if $text=~/\n$/;
	
	my $title=$this->title;
	if (length $title) {
		unshift @lines, $title, ('-' x length $title), '';
		$this->title('');
	}
	foreach (@lines) {
		if ($this->linecount($this->linecount+1) > $this->screenheight - 2) {
			$this->prompt(
				prompt => '['.gettext("More").']',
				default => '',
				completions => [],
			);
		}
		print "$_\n";
	}
}
sub prompt {
	my $this=shift;
	my %params=@_;
	my $prompt=$params{prompt}." ";
	my $default=$params{default};
	my $noshowdefault=$params{noshowdefault};
	my $completions=$params{completions};
	if ($completions) {
		my @matches;
		$this->readline->Attribs->{completion_entry_function} = sub {
			my $text=shift;
			my $state=shift;
			
			if ($state == 0) {
				@matches=();
				foreach (@{$completions}) {
					push @matches, $_ if /^\Q$text\E/i;
				}
			}
			return pop @matches;
		};
	}
	else {
		$this->readline->Attribs->{completion_entry_function} = undef;
	}
	if (exists $params{completion_append_character}) {
		$this->readline->Attribs->{completion_append_character}=$params{completion_append_character};
	}
	else {
		$this->readline->Attribs->{completion_append_character}='';
	}
	
	$this->linecount(0);
	my $ret;
	$this->_skip('');
	if (! $noshowdefault && $this->promptdefault && $default ne '') {
		$ret=$this->readline->readline($prompt."[$default] ", $default);
	}
	elsif (! $noshowdefault) {
		$ret=$this->readline->readline($prompt, $default);
	}
	else {
		$ret=$this->readline->readline($prompt);
	}
	$this->display_nowrap("\n");
	return if $this->_skip;
	$this->_direction(1);
	$this->readline->addhistory($ret);
	if ($ret eq '' && $this->promptdefault) {
		return $default;
	}
	return $ret;
}
sub prompt_password {
	my $this=shift;
	my %params=@_;
	system('stty -echo');
	my $ret;
	if (Term::ReadLine->ReadLine =~ /::Perl$/) {
		local $|=1;
		print $params{prompt}." ";	
		$ret=<STDIN>;
		chomp $ret;
		print "\n";
	}
	else {
		$ret=$this->prompt(@_, noshowdefault => 1, completions => []);
	}
	system('stty sane');
	print "\n";
	return $ret;
}
1
