#! /bin/sh
set -e

. /etc/default/devpts

[ "$(uname -s)" = "Linux" ] || exit 0

make_devptmx()
{
    [ -c /dev/ptmx ] || mknod --mode=666 /dev/ptmx c 5 2
}

make_devpts()
{
    [ -d /dev/pts ] || mkdir --mode=755 /dev/pts
}

mount_devpts_fs()
{
    mount -t devpts devpts /dev/pts -ogid=${TTYGRP},mode=${TTYMODE}
}

devfs=$(grep -c '\<devfs' /proc/filesystems || true)
devpts=$(grep -c '\<devpts' /proc/filesystems || true)
devpts_mounted=$(mount | grep -c '/dev/pts' || true)

if [ $devfs -eq 1 ]; then
    solution=devfs
elif [ $devpts -eq 1 ]; then
    solution=devpts
else
    solution=none
fi

case $solution in
    devfs|none)
	:
    ;;
    devpts)
	make_devptmx
	make_devpts
	if [ $devpts_mounted -lt 1 ]
	then
	    mount_devpts_fs
	fi
    ;;
esac
