/*
 * ELF definitions for 32-bit CPUs
 */

#define ELF_EXEC_PAGESIZE	4096

#ifdef __KERNEL__

/* We can execute both 32-bit and 26-bit code. */
#define ELF_PROC_OK(x)		(1)

#if 1
/* Old NetWinder binaries were compiled in such a way that the iBCS
   heuristic always trips on them.  Until these systems become uncommon
   enough not to care, don't trust the `ibcs' flag here.
   @@ Could print a warning message to encourage users to upgrade.  */
#define SET_PERSONALITY(ex,ibcs2) \
	current->personality = (ex.e_flags & EF_ARM_APCS26) ? \
	PER_LINUX : PER_LINUX_32BIT
#else
#define SET_PERSONALITY(ex,ibcs2) \
	current->personality = PER_LINUX_32BIT
#endif

#endif
