#ifndef __ASMARM_ELF_H
#define __ASMARM_ELF_H

/*
 * ELF register definitions..
 */

#include <asm/ptrace.h>
#include <asm/proc/elf.h>
#include <asm/procinfo.h>

typedef unsigned long elf_greg_t;

#define EM_ARM	40
#define EF_ARM_APCS26 0x08

#define ELF_NGREG (sizeof (struct pt_regs) / sizeof(elf_greg_t))
typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef struct { void *null; } elf_fpregset_t;

/*
 * This is used to ensure we don't load something for the wrong architecture.
 */
#define elf_check_arch(x) ( ((x)->e_machine == EM_ARM) && (ELF_PROC_OK((x))) )

/*
 * These are used to set parameters in the core dumps.
 */
#define ELF_CLASS	ELFCLASS32
#define ELF_DATA	ELFDATA2LSB;
#define ELF_ARCH	EM_ARM

#define USE_ELF_CORE_DUMP

/* This is the location that an ET_DYN program is loaded if exec'ed.  Typical
   use of this is to invoke "./ld.so someprog" to test out a new version of
   the loader.  We need to make sure that it is out of the way of the program
   that it will "exec", and that there is sufficient room for the brk.  */

#define ELF_ET_DYN_BASE	(2 * TASK_SIZE / 3)

/* When the program starts, a1 contains a pointer to a function to be 
   registered with atexit, as per the SVR4 ABI.  A value of 0 means we 
   have no such handler.  */
#define ELF_PLAT_INIT(_r)	(_r)->ARM_r0 = 0

/* This yields a mask that user programs can use to figure out what
   instruction set this cpu supports. */

extern unsigned int elf_hwcap;
#define ELF_HWCAP	(elf_hwcap)

/* This yields a string that ld.so will use to load implementation
   specific libraries for optimization.  This is more specific in
   intent than poking at uname or /proc/cpuinfo. */

/* For now we just provide a fairly general string that describes the
   processor family.  This could be made more specific later if
   someone implemented optimisations that require it.  

   These now match the official ARM architecture numbers, with (in
   some cases) a trailing "l" or "b" to signal endianness.  So 26-bit
   CPUs give you "v2" for ARM2 (no SWP) and "v2a" for ARM250 or ARM3.
   ARM1 isn't supported but it would give "v1" if it was.  32-bit CPUs
   give you "v3[lb]" or "v4[lb]" as appropriate.  

   NB. On RiscPC platforms, even if the CPU is actually a StrongARM,
   we only supply "v3" here.  Otherwise user code might try to use
   halfword data transfer instructions and come to grief.  */

#define ELF_PLATFORM_SIZE 8
extern char elf_platform[];
#define ELF_PLATFORM	(elf_platform)

#endif
