# Default setting for scintilla's builtin lexers
# Generated from ./scintilla/../../scite/src/SciTEGlobal.properties

import sci_names

kDefaultKeywords = {
    sci_names.kHTMLDocument: "\\",
    sci_names.kPythonDocument: "and assert break class continue def del elif else except \\",
    sci_names.kXPIDLDocument: "attribute native noscript scriptable shared wstring inout",
    sci_names.kRCDocument: "\\",
    sci_names.kJavascriptDocument: "abstract boolean break byte case catch char class \\",
    sci_names.kJavaDocument: "abstract boolean break byte case catch char class const \\",
    sci_names.kMSIDLDocument: "handle",
    sci_names.kLuaDocument: "and do else elseif end function if local nil not or \\",
    sci_names.kPHPDocument: "\\",
    sci_names.kVBDocument: "and as attribute begin byref byval case call const \\",
    sci_names.kCppDocument: (
        "asm auto bool break case catch char class const const_cast continue \\"
      ),
    sci_names.kXPIDLDocument: "\\",

  }
kDefaultdiffStyles = {
    1: {
        "fore": "#007F00",

      },
    2: {
        "fore": "#7F7F00",

      },
    3: {
        "fore": "#7F0000",

      },
    32: {

      },
    0: {
        "fore": "#000000",

      },
    6: {
        "fore": "#00007F",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#7F007F",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    33: {
        "back": "#C0C0C0",

      },
    5: {
        "fore": "#007F7F",

      },

  }
kDefaulterrorlistStyles = {
    2: {
        "fore": "#800080",

      },
    3: {
        "fore": "#808000",

      },
    33: {
        "back": "#C0C0C0",

      },
    5: {
        "fore": "#B06000",

      },
    0: {
        "fore": "#000000",

      },
    6: {
        "fore": "#FF0000",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#0000FF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    1: {
        "fore": "#FF0000",

      },
    32: {
        "fore": "#B06000",

      },

  }
kDefaultcppStyles = {
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    13: {
        "fore": "#007F00",
        "back": "#E0FFE0",
        "eolfilled": 1,

      },
    12: {
        "fore": "#000000",
        "back": "#E0C0E0",
        "eolfilled": 1,

      },
    10: {
        "bold": 1,

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#804080",

      },
    7: {
        "fore": "#7F007F",

      },
    6: {
        "fore": "#7F007F",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#7F7F7F",

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#007F00",

      },
    0: {
        "fore": "#808080",

      },

  }
kDefaultsqlStyles = {
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    12: {
        "fore": "#000000",
        "back": "#E0C0E0",
        "eolfilled": 1,

      },
    10: {
        "bold": 1,

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#007F7F",

      },
    7: {
        "fore": "#7F007F",

      },
    6: {
        "fore": "#7F007F",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#7F7F7F",

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#007F00",

      },
    0: {
        "fore": "#808080",

      },

  }
kDefaultconfStyles = {
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    0: {
        "fore": "#808080",

      },
    9: {
        "fore": "#00007F",
        "bold": 1,

      },
    8: {
        "fore": "#007F7F",
        "bold": 1,

      },
    7: {
        "bold": 1,

      },
    6: {
        "fore": "#7F007F",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#000000",
        "back": "#FFE0FF",

      },
    3: {
        "fore": "#000000",
        "back": "#A0FFA0",

      },
    2: {
        "fore": "#007F7F",

      },
    1: {
        "fore": "#007F00",

      },
    5: {
        "fore": "#000000",
        "back": "#FFE0FF",

      },

  }
kDefaultpropsStyles = {
    2: {
        "fore": "#0000FF",

      },
    33: {
        "back": "#C0C0C0",

      },
    32: {

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#FF0000",

      },
    35: {
        "fore": "#FF0000",
        "notbold": 1,
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "notbold": 1,
        "bold": 1,

      },
    1: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#0000FF",

      },

  }
kDefaultpascalStyles = {
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    0: {
        "fore": "#000000",
        "": 1,

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#007F7F",

      },
    7: {
        "fore": "#7F007F",
        "italics": 1,

      },
    6: {
        "fore": "#7F007F",
        "italics": 1,

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#7F7F7F",

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#007F00",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },

  }
kDefaultluaStyles = {
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    12: {
        "fore": "#000000",
        "back": "#E0C0E0",
        "eolfilled": 1,

      },
    10: {
        "bold": 1,

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#007F7F",

      },
    7: {
        "fore": "#7F007F",

      },
    6: {
        "fore": "#7F007F",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#7F7F7F",

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#007F00",
        "italics": 1,

      },
    0: {
        "fore": "#808080",

      },

  }
kDefaultperlStyles = {
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    33: {
        "back": "#C0C0C0",

      },
    32: {

      },
    25: {
        "fore": "#7F007F",
        "back": "#DDD0DD",
        "italics": 1,
        "eolfilled": 1,

      },
    24: {
        "fore": "#7F007F",
        "back": "#DDD0DD",
        "bold": 1,
        "eolfilled": 1,

      },
    23: {
        "fore": "#7F007F",
        "back": "#DDD0DD",
        "notbold": 1,
        "eolfilled": 1,

      },
    22: {
        "fore": "#000000",
        "back": "#DDD0DD",

      },
    21: {
        "fore": "#600000",
        "back": "#FFF0D8",
        "eolfilled": 1,

      },
    20: {
        "fore": "#FFFF00",
        "back": "#A08080",

      },
    19: {
        "fore": "#FFFF00",
        "back": "#8080A0",

      },
    18: {
        "fore": "#000000",
        "back": "#F0E080",

      },
    17: {
        "fore": "#000000",
        "back": "#A0FFA0",

      },
    16: {
        "fore": "#000000",
        "back": "#E0FFFF",

      },
    15: {
        "fore": "#000000",
        "back": "#E0E0E0",

      },
    14: {
        "fore": "#000000",
        "back": "#FFE0FF",

      },
    13: {
        "fore": "#000000",
        "back": "#FFFFE0",

      },
    12: {
        "fore": "#000000",
        "back": "#FFE0E0",

      },
    11: {
        "fore": "#000000",

      },
    10: {
        "bold": 1,

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#007F7F",

      },
    7: {
        "fore": "#7F007F",

      },
    6: {
        "fore": "#7F007F",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#004000",
        "back": "#E0FFE0",
        "eolfilled": 1,

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#FF0000",

      },
    0: {
        "fore": "#808080",

      },

  }
kDefaultbatchStyles = {
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    33: {
        "back": "#C0C0C0",

      },
    32: {

      },
    0: {
        "fore": "#000000",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    2: {
        "fore": "#00007F",

      },
    1: {
        "fore": "#007F00",

      },
    3: {
        "fore": "#7F0000",

      },

  }
kDefaultmakefileStyles = {
    32: {

      },
    0: {
        "fore": "#000000",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "notbold": 1,
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "notbold": 1,
        "bold": 1,

      },
    33: {
        "back": "#C0C0C0",

      },
    1: {
        "fore": "#007F7F",

      },

  }
kDefaulthypertextStyles = {
    126: {
        "eolfilled": 1,
        "back": "#FFF8F8",

      },
    125: {
        "fore": "#666666",
        "back": "#FFF8F8",
        "italics": 1,

      },
    124: {
        "fore": "#999999",
        "back": "#FFF8F8",

      },
    123: {
        "fore": "#00007F",
        "back": "#FFF8F8",
        "italics": 1,

      },
    122: {
        "fore": "#CC9900",
        "back": "#FFF8F8",

      },
    121: {
        "fore": "#7F007F",
        "back": "#FFF8F8",
        "italics": 1,

      },
    120: {
        "fore": "#009F00",
        "back": "#FFF8F8",

      },
    119: {
        "fore": "#007F00",
        "back": "#FFF8F8",

      },
    118: {
        "fore": "#000033",
        "back": "#FFF8F8",
        "eolfilled": 1,

      },
    117: {
        "eolfilled": 1,
        "back": "#CFEFCF",

      },
    116: {
        "back": "#CFEFCF",
        "bold": 1,
        "eolfilled": 1,

      },
    115: {
        "fore": "#007F7F",
        "bold": 1,
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    114: {
        "fore": "#0000FF",
        "bold": 1,
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    113: {
        "fore": "#7F0000",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    112: {
        "fore": "#7F0000",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    111: {
        "fore": "#00007F",
        "bold": 1,
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    110: {
        "fore": "#7F007F",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    109: {
        "fore": "#7F007F",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    108: {
        "fore": "#007F7F",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    107: {
        "fore": "#007F00",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    106: {
        "fore": "#808080",
        "back": "#CFEFCF",
        "eolfilled": 1,

      },
    105: {
        "fore": "#808080",

      },
    102: {
        "eolfilled": 1,
        "back": "#EFFFEF",

      },
    101: {
        "back": "#EFFFEF",
        "bold": 1,
        "eolfilled": 1,

      },
    100: {
        "fore": "#007F7F",
        "bold": 1,
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    99: {
        "fore": "#0000FF",
        "bold": 1,
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    98: {
        "fore": "#7F0000",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    97: {
        "fore": "#7F0000",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    96: {
        "fore": "#00007F",
        "bold": 1,
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    95: {
        "fore": "#7F007F",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    94: {
        "fore": "#7F007F",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    93: {
        "fore": "#007F7F",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    92: {
        "fore": "#007F00",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    91: {
        "fore": "#808080",
        "back": "#EFFFEF",
        "eolfilled": 1,

      },
    90: {
        "fore": "#808080",

      },
    87: {
        "fore": "#000080",
        "back": "#7F7FBF",
        "eolfilled": 1,

      },
    86: {
        "fore": "#000080",
        "back": "#CFCFEF",
        "eolfilled": 1,

      },
    85: {
        "fore": "#800080",
        "back": "#CFCFEF",
        "eolfilled": 1,

      },
    84: {
        "fore": "#000080",
        "back": "#CFCFEF",
        "eolfilled": 1,
        "bold": 1,

      },
    83: {
        "fore": "#008080",
        "back": "#CFCFEF",
        "eolfilled": 1,

      },
    82: {
        "fore": "#008000",
        "back": "#CFCFEF",
        "eolfilled": 1,

      },
    81: {
        "fore": "#000000",
        "back": "#CFCFEF",
        "eolfilled": 1,

      },
    77: {
        "fore": "#000080",
        "back": "#7F7FFF",
        "eolfilled": 1,

      },
    76: {
        "fore": "#000080",
        "back": "#EFEFFF",
        "eolfilled": 1,

      },
    75: {
        "fore": "#800080",
        "back": "#EFEFFF",
        "eolfilled": 1,

      },
    74: {
        "fore": "#000080",
        "back": "#EFEFFF",
        "eolfilled": 1,
        "bold": 1,

      },
    73: {
        "fore": "#008080",
        "back": "#EFEFFF",
        "eolfilled": 1,

      },
    72: {
        "fore": "#008000",
        "back": "#EFEFFF",
        "eolfilled": 1,

      },
    71: {
        "fore": "#000000",
        "back": "#EFEFFF",
        "eolfilled": 1,

      },
    66: {
        "eolfilled": 1,
        "back": "#BFBBB0",

      },
    65: {
        "fore": "#000000",
        "bold": 1,
        "back": "#DFDF7F",

      },
    64: {
        "fore": "#7F007F",
        "back": "#DFDF7F",

      },
    63: {
        "fore": "#7F007F",
        "back": "#DFDF7F",

      },
    62: {
        "fore": "#00007F",
        "bold": 1,
        "back": "#DFDF7F",

      },
    61: {
        "fore": "#000000",
        "back": "#DFDF7F",

      },
    60: {
        "fore": "#007F7F",
        "back": "#DFDF7F",

      },
    59: {
        "fore": "#7F7F7F",
        "bold": 1,
        "back": "#DFDF7F",
        "eolfilled": 1,

      },
    58: {
        "fore": "#007F00",
        "back": "#DFDF7F",

      },
    57: {
        "fore": "#007F00",
        "back": "#DFDF7F",
        "eolfilled": 1,

      },
    56: {
        "fore": "#000000",
        "bold": 1,
        "back": "#DFDF7F",
        "eolfilled": 1,

      },
    55: {
        "fore": "#7F7F00",

      },
    51: {
        "eolfilled": 1,
        "back": "#BFBBB0",

      },
    50: {
        "fore": "#000000",
        "bold": 1,
        "back": "#FFFBF0",

      },
    49: {
        "fore": "#7F007F",
        "back": "#FFFBF0",

      },
    48: {
        "fore": "#7F007F",
        "back": "#FFFBF0",

      },
    47: {
        "fore": "#00007F",
        "bold": 1,
        "back": "#FFFBF0",

      },
    46: {
        "fore": "#000000",
        "back": "#FFFBF0",

      },
    45: {
        "fore": "#007F7F",
        "back": "#FFFBF0",

      },
    44: {
        "fore": "#7F7F7F",
        "bold": 1,
        "back": "#FFFBF0",
        "eolfilled": 1,

      },
    43: {
        "fore": "#007F00",
        "back": "#FFFBF0",

      },
    42: {
        "fore": "#007F00",
        "back": "#FFFBF0",
        "eolfilled": 1,

      },
    41: {
        "fore": "#000000",
        "bold": 1,
        "back": "#FFFBF0",
        "eolfilled": 1,

      },
    40: {
        "fore": "#7F7F00",

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,
        "notbold": 1,

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,
        "notbold": 1,

      },
    33: {
        "back": "#C0C0C0",

      },
    32: {

      },
    19: {
        "fore": "#FF00FF",
        "back": "#FFEFFF",

      },
    18: {
        "fore": "#0000FF",
        "back": "#FFEFBF",

      },
    17: {
        "back": "#FFDF00",

      },
    16: {
        "back": "#FFDF00",

      },
    15: {
        "back": "#FFFF00",

      },
    14: {
        "fore": "#000080",

      },
    13: {
        "fore": "#0000FF",

      },
    12: {
        "fore": "#0000FF",

      },
    11: {
        "fore": "#000080",

      },
    10: {
        "fore": "#800080",

      },
    9: {
        "fore": "#808000",

      },
    8: {
        "fore": "#800080",

      },
    7: {
        "fore": "#008000",

      },
    6: {
        "fore": "#008000",

      },
    5: {
        "fore": "#800080",

      },
    4: {
        "fore": "#FF0000",

      },
    3: {
        "fore": "#008080",

      },
    2: {
        "fore": "#FF0000",

      },
    1: {
        "fore": "#000080",

      },
    0: {
        "fore": "#000000",

      },

  }
kDefaultpythonStyles = {
    2: {
        "fore": "#007F7F",

      },
    0: {
        "fore": "#808080",

      },
    33: {
        "back": "#C0C0C0",

      },
    32: {

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    13: {
        "fore": "#000000",
        "back": "#E0C0E0",
        "eolfilled": 1,

      },
    12: {
        "fore": "#7F7F7F",

      },
    10: {
        "bold": 1,

      },
    9: {
        "fore": "#007F7F",
        "bold": 1,

      },
    8: {
        "fore": "#0000FF",
        "bold": 1,

      },
    7: {
        "fore": "#7F0000",

      },
    6: {
        "fore": "#7F0000",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },
    4: {
        "fore": "#7F007F",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    1: {
        "fore": "#007F00",

      },
    3: {
        "fore": "#7F007F",

      },

  }
kDefaultvbStyles = {
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    0: {
        "fore": "#000000",

      },
    9: {
        "fore": "#7F7F00",

      },
    8: {
        "fore": "#007F7F",

      },
    7: {
        "fore": "#7F007F",
        "italics": 1,

      },
    6: {
        "fore": "#7F007F",
        "italics": 1,

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#007F7F",

      },
    3: {
        "fore": "#7F7F7F",

      },
    2: {
        "fore": "#007F00",

      },
    1: {
        "fore": "#007F00",

      },
    5: {
        "fore": "#00007F",
        "bold": 1,

      },

  }
kDefaultlatexStyles = {
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    4: {
        "fore": "#00AA00",

      },
    3: {
        "fore": "#0000FF",

      },
    2: {
        "fore": "#880088",
        "bold": 1,

      },
    1: {
        "fore": "#AA0000",
        "bold": 1,

      },
    0: {
        "fore": "#000000",

      },

  }
kDefaultxmlStyles = {
    37: {
        "fore": "#C0C0C0",
        "back": "#FFFFFF",

      },
    35: {
        "fore": "#FF0000",
        "bold": 1,

      },
    32: {

      },
    33: {
        "back": "#C0C0C0",

      },
    34: {
        "fore": "#0000FF",
        "bold": 1,

      },
    19: {
        "fore": "#608060",

      },
    18: {
        "fore": "#800000",

      },
    17: {
        "fore": "#800000",
        "back": "#FFF0F0",
        "eolfilled": 1,

      },
    13: {
        "fore": "#800080",
        "bold": 1,

      },
    12: {
        "fore": "#800080",
        "bold": 1,

      },
    11: {
        "fore": "#000080",

      },
    10: {
        "fore": "#800080",

      },
    9: {
        "fore": "#808000",

      },
    8: {
        "fore": "#800080",

      },
    7: {
        "fore": "#008000",

      },
    6: {
        "fore": "#008000",

      },
    5: {
        "fore": "#800080",

      },
    4: {
        "fore": "#008080",

      },
    3: {
        "fore": "#008080",

      },
    2: {
        "fore": "#000080",

      },
    1: {
        "fore": "#000080",

      },
    0: {
        "fore": "#000000",

      },

  }
kDefStylesForLexer = {
    sci_names.SCLEX_BATCH: kDefaultbatchStyles,
    sci_names.SCLEX_VB: kDefaultvbStyles,
    sci_names.SCLEX_DIFF: kDefaultdiffStyles,
    sci_names.SCLEX_PERL: kDefaultperlStyles,
    sci_names.SCLEX_HTML: kDefaulthypertextStyles,
    sci_names.SCLEX_ERRORLIST: kDefaulterrorlistStyles,
    sci_names.SCLEX_MAKEFILE: kDefaultmakefileStyles,
    sci_names.SCLEX_PROPERTIES: kDefaultpropsStyles,
    sci_names.SCLEX_PYTHON: kDefaultpythonStyles,
    sci_names.SCLEX_CPP: kDefaultcppStyles,
    sci_names.SCLEX_LUA: kDefaultluaStyles,
    sci_names.SCLEX_LATEX: kDefaultlatexStyles,
    sci_names.SCLEX_SQL: kDefaultsqlStyles,
    sci_names.SCLEX_XML: kDefaultxmlStyles,

  }
