from gtk import *
from GTK import *

class Applet(GtkFrame):
    def __init__(self):
        GtkFrame.__init__(self)
        self.dirty = FALSE

    def show(self):
        self.dirty = TRUE
        GtkFrame.show(self)

    def save(self,msgbox=FALSE):
        self.dirty = FALSE
        if msgbox:
            MsgBox('Saved').show()

def delete_event(win, event=None):
	win.hide()
	# don't destroy window -- just leave it hidden
        # for now .. fix later
	return TRUE

class MsgBox(GtkDialog):
    def __init__(self,lbl_text='',type=1,functions=None):
        GtkDialog.__init__(self)
        self.connect("delete_event", delete_event)
        self.set_usize(180,160)
        self.set_uposition(20,80)
        lbl = GtkLabel(lbl_text)
        lbl.show()
        lbl.set_usize(160,100)
        lbl.set_justify(JUSTIFY_CENTER)
        lbl.set_line_wrap(TRUE)
        self.vbox.pack_start(lbl)
        if type == 1:
            self.okay = GtkButton('Okay')
            self.okay.show()
            self.action_area.pack_start(self.okay,expand=FALSE)
            if functions:
                self.okay.connect('clicked',functions[0])
            else:
                self.okay.connect('clicked',self.close_me)
        elif type == 2:
            self.okay = GtkButton('Okay')
            self.okay.show()
            self.close = GtkButton('Close')
            self.close.show()
            self.action_area.pack_start(self.okay,expand=FALSE)
            self.action_area.pack_start(self.close,expand=FALSE)
            if functions:
                if len(functions) == 1:
                    self.okay.connect('clicked',functions[0])
                    self.close.connect('clicked',self.close_me)
                elif len(functions) == 2:
                    self.okay.connect('clicked',functions[0])
                    self.close.connect('clicked',functions[1])
            else:
                self.okay.connect('clicked',self.close_me)
                self.close.connect('clicked',self.close_me)

        self.vbox.show()
        self.action_area.show()
        self.set_modal(TRUE)

    def close_me(self,btn):
        self.hide()
        del self
