require '_h2ph_pre.ph';

unless(defined(&_SYS_WAIT_H))
{
    die("Never require 'bits/waitstatus.ph' directly; require 'sys/wait.ph' instead.\n");
}
unless(defined(&__WEXITSTATUS))
{
    sub __WEXITSTATUS
    {
	local($status) = @_;
	eval q(((($status) & 0xff00) >> 8));
    }
}
unless(defined(&__WTERMSIG))
{
    sub __WTERMSIG
    {
	local($status) = @_;
	eval q((($status) & 0x7f));
    }
}
unless(defined(&__WSTOPSIG))
{
    sub __WSTOPSIG
    {
	local($status) = @_;
	eval q( &__WEXITSTATUS($status));
    }
}
unless(defined(&__WIFEXITED))
{
    sub __WIFEXITED
    {
	local($status) = @_;
	eval q(( &__WTERMSIG($status) == 0));
    }
}
if(defined(&__GNUC__))
{
    eval 'sub __WIFSIGNALED
	  {
              local($status) = @_;
	      eval q(( &__extension__ ({&__status = ($status); ! &__WIFSTOPPED( &__status)  && ! &__WIFEXITED( &__status); })));
          }' unless defined(&__WIFSIGNALED);
}
else
{
    eval 'sub __WIFSIGNALED
	  {
              local($status) = @_;
	      eval q((! &__WIFSTOPPED($status)  && ! &__WIFEXITED($status)));
          }' unless defined(&__WIFSIGNALED);
}
unless(defined(&__WIFSTOPPED))
{
    sub __WIFSTOPPED
    {
	local($status) = @_;
	eval q(((($status) & 0xff) == 0x7f));
    }
}
unless(defined(&__WCOREDUMP))
{
    sub __WCOREDUMP
    {
	local($status) = @_;
	eval q((($status) &  &__WCOREFLAG));
    }
}
unless(defined(&__W_EXITCODE))
{
    sub __W_EXITCODE
    {
	local($ret, $sig) = @_;
	eval q((($ret) << 8| ($sig)));
    }
}
unless(defined(&__W_STOPCODE))
{
    sub __W_STOPCODE
    {
	local($sig) = @_;
	eval q((($sig) << 8| 0x7f));
    }
}
unless(defined(&__WCOREFLAG))
{
    sub __WCOREFLAG () {0x80;}
}
1;
