#########################################################################
""" sci_names.py -- Definitions of constants for scintilla

Copyright (c) 1999-2000, Archaeopteryx Software, Inc.  All rights reserved.

Written by Stephan R.A. Deibel (sdeibel@archaeopteryx.com) and
John Ehresman (jpe@archaeopteryx.com)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

-------------
Modifications:

$Log: sci_names.py,v $
Revision 1.13  2000/11/20 00:18:11  sdeibel
Properly delete marks in deleted ranges of text

Revision 1.12  2000/11/10 00:20:15  sdeibel
Improved status display area's capabilities, added pref for setting
initial whitespace/eol visibility defaults, and save per-file any
changes to these or to user-selected document type.  Also fixed
typo bug in analysis use in project mgr, improved untitled project
naming, and a few other things.

Revision 1.11  2000/11/07 17:34:51  sdeibel
Fixed ability to reset lexers multiple times

Revision 1.10  2000/10/26 15:23:25  sdeibel
Additional tracking to Scintilla version 1.32+

Revision 1.9  2000/10/19 22:35:53  sdeibel
Better busy cursor framework

Revision 1.8  2000/07/20 20:04:06  sdeibel
Fixed bug in setting up HTML lexer (now also pass in the keywords
for embeddable languages) and updated generation of def_lexer_info
so it works with the current scintilla and automatically omits
font name and sizes, which we don't want by default.

Revision 1.7  2000/06/16 01:47:57  sdeibel
Added support for indicators

Revision 1.6  2000/06/15 22:08:08  sdeibel
Added support for scintilla underlining, charsets, and turning on/off
the horizontal scrollbar

Revision 1.5  2000/06/15 21:15:36  sdeibel
Updated to support all lexers in scintilla 1.26 and removed old colorizing
code and added some usage docs

Revision 1.4  2000/06/05 22:56:38  sdeibel
Start at a new variables display impl; currently packaged as a way
to expand whole structures or long strings

Revision 1.3  2000/04/19 22:38:02  jpe
Exposed autocompletion interface and add Python lex state constants

Revision 1.2  2000/03/30 17:58:12  sdeibel
Added support for new signals

Revision 1.1  2000/03/29 18:54:56  jpe
Implemented setting default keywords and styles for built-in lexers.  The
defaults are kept in def_lexer_info.py, which is generated from a SciTE
properties file.


"""
#########################################################################

#-----------------------------------------------------------------------

# Key modifier codes
NOTHING_PRESSED = 0
SHIFT_PRESSED = 1
CTRL_PRESSED = 2
ALT_PRESSED = 4

# End-of-line modes
EOL_CRLF = 0
EOL_CR = 1
EOL_LF = 2

# Cursor scrolling policies; Must match Scintilla.h
CURSOR_SLOP = 0x01      # Show within N lines of edge
CURSOR_CENTER = 0x02    # Center on screen
CURSOR_STRICT = 0x04    # And in to always position even when visible

# Maximum number of styles that can be defined with teh styling interface
# This must match the value defined in Scintilla.h
STYLE_MAX = 31

# Built-in styles for setting display style; Must match Scintilla.h
STYLE_DEFAULT = 32
STYLE_LINENUMBER = 33
STYLE_BRACELIGHT = 34
STYLE_BRACEBAD = 35
STYLE_CONTROLCHAR = 36
STYLE_INDENTGUIDE = 37
STYLE_MAX = 127

STYLE_FIRSTRESERVED=32
STYLE_LASTRESERVED=39

# Indicator styles
INDIC_PLAIN = 0
INDIC_SQUIGGLE = 1
INDIC_TT = 2
INDIC_DIAGONAL = 3
INDIC_STRIKE = 4
 
# Indicator style masks
INDIC0_MASK = 32
INDIC1_MASK = 64
INDIC2_MASK = 128
INDICS_MASK = INDIC0_MASK | INDIC1_MASK | INDIC2_MASK

# Maximum number of marker types you can define with define_marker_type().
# This must match the value defined in Scintilla.h
MARKER_MAX = 31

# Styles of markers; These must match the values defined in Scintilla.h
MARK_CIRCLE = 0
MARK_ROUNDRECT = 1
MARK_ARROW = 2
MARK_SMALLRECT = 3
MARK_SHORTARROW = 4
MARK_EMPTY = 5
MARK_ARROWDOWN = 6
MARK_MINUS = 7
MARK_PLUS = 8

# Sub-types of the 'notify' signal : Must match Scintilla.h
SCN_STYLENEEDED = 2000
SCN_CHARADDED = 2001
SCN_SAVEPOINTREACHED = 2002
SCN_SAVEPOINTLEFT = 2003
SCN_MODIFYATTEMPTRO = 2004
SCN_KEY = 2005
SCN_DOUBLECLICK = 2006
SCN_UPDATEUI = 2007
SCN_MODIFIED = 2008
SCN_MACRORECORD = 2009
SCN_MARGINCLICK = 2010
SCN_NEEDSHOWN = 2011

# Types of modification for the SCN_MODIFIED signal's type field.
# One bit is set from each of SC_MOD_* and SC_PERFORMED_*.
# Must match Scintilla.h
SC_MOD_INSERTTEXT = 0x1
SC_MOD_DELETETEXT = 0x2
SC_MOD_CHANGESTYLE = 0x4
SC_MOD_BEFOREINSERT = 0x400
SC_MOD_BEFOREDELETE = 0x800
SC_PERFORMED_USER = 0x10
SC_PERFORMED_UNDO = 0x20
SC_PERFORMED_REDO = 0x40
SC_LASTSTEPINUNDOREDO = 0x100
SC_MOD_CHANGEMARKER = 0x200
SC_MODEVENTMASKALL = 0x377

# Character sets for define_text_style() and set_builtin_style() calls
SC_CHARSET_ANSI = 0
SC_CHARSET_DEFAULT = 1
SC_CHARSET_BALTIC = 186
SC_CHARSET_CHINESEBIG5 = 136
SC_CHARSET_EASTEUROPE = 238
SC_CHARSET_GB2312 = 134
SC_CHARSET_GREEK = 161
SC_CHARSET_HANGUL = 129
SC_CHARSET_MAC = 77
SC_CHARSET_OEM = 255
SC_CHARSET_RUSSIAN = 204
SC_CHARSET_SHIFTJIS = 128
SC_CHARSET_SYMBOL = 2
SC_CHARSET_TURKISH = 162
SC_CHARSET_JOHAB = 130
SC_CHARSET_HEBREW = 177
SC_CHARSET_ARABIC = 178
SC_CHARSET_VIETNAMESE = 163
SC_CHARSET_THAI = 222

# Cursor shapes
SC_CURSORNORMAL = -1
SC_CURSORWAIT = 3

# Starting ID for scintilla command numbers: Must match Scintilla.h
SCI_START = 2000

# Scintilla commands available for binding to key combinations with
# the set_cmdkey() method.  Commands based on SCI_START must match 
# Scintilla.h; others must match the corresponding EM_ and WM_ 
# definitions in WinDefs.h.
SCI_REPLACESEL = 194
SCI_UNDO = 199
SCI_CLEAR = 771
SCI_COPY = 769
SCI_CUT = 768
SCI_PASTE = 770
SCI_UNDO = 772
SCI_HIDESELECTION = 1087
SCI_PASTESPECIAL = 1088
SCI_CLEARALL = SCI_START + 4
SCI_REDO = SCI_START + 11
SCI_SELECTALL = SCI_START + 13
SCI_SETANCHOR = SCI_START + 26
SCI_EDITTOGGLEOVERTYPE = SCI_START + 324
SCI_CANCEL = SCI_START + 325
SCI_DELETEBACK = SCI_START + 326
SCI_TAB = SCI_START + 327
SCI_BACKTAB = SCI_START + 328
SCI_NEWLINE = SCI_START + 329
SCI_FORMFEED = SCI_START + 330
SCI_ZOOMIN = SCI_START + 333
SCI_ZOOMOUT = SCI_START + 334
SCI_DELWORDLEFT = SCI_START + 335
SCI_DELWORDRIGHT = SCI_START + 336
SCI_BRACEMATCH = SCI_START + 353
SCI_SETCURSOR = SCI_START + 386
SCI_GETCURSOR = SCI_START + 387

# Types of cursor movement supported by the move_cursor() method.
# These are also available for binding to key combinations with
# the set_cmdkey() method.  Must match definitions in Scintilla.h
SCI_LINEDOWN = SCI_START + 300
SCI_LINEDOWNEXTEND = SCI_START + 301
SCI_LINEUP = SCI_START + 302
SCI_LINEUPEXTEND = SCI_START + 303
SCI_CHARLEFT = SCI_START + 304
SCI_CHARLEFTEXTEND = SCI_START + 305
SCI_CHARRIGHT = SCI_START + 306
SCI_CHARRIGHTEXTEND = SCI_START + 307
SCI_WORDLEFT = SCI_START + 308
SCI_WORDLEFTEXTEND = SCI_START + 309
SCI_WORDRIGHT = SCI_START + 310
SCI_WORDRIGHTEXTEND = SCI_START + 311
SCI_HOME = SCI_START + 312
SCI_HOMEEXTEND = SCI_START + 313
SCI_LINEEND = SCI_START + 314
SCI_LINEENDEXTEND = SCI_START + 315
SCI_DOCUMENTSTART = SCI_START + 316
SCI_DOCUMENTSTARTEXTEND = SCI_START + 317
SCI_DOCUMENTEND = SCI_START + 318
SCI_DOCUMENTENDEXTEND = SCI_START + 319
SCI_PAGEUP = SCI_START + 320
SCI_PAGEUPEXTEND = SCI_START + 321
SCI_PAGEDOWN = SCI_START + 322
SCI_PAGEDOWNEXTEND = SCI_START + 323
SCI_VCHOME = SCI_START + 331
SCI_VCHOMEEXTEND = SCI_START + 332

# Lexer types
SCLEX_CONTAINER = 0
SCLEX_NULL = 1
SCLEX_PYTHON = 2
SCLEX_CPP = 3
SCLEX_HTML = 4
SCLEX_XML = 5
SCLEX_PERL = 6
SCLEX_SQL = 7
SCLEX_VB = 8
SCLEX_PROPERTIES = 9
SCLEX_ERRORLIST = 10
SCLEX_MAKEFILE = 11
SCLEX_BATCH = 12
SCLEX_XCODE = 13
SCLEX_LATEX = 14
SCLEX_LUA = 15
SCLEX_DIFF = 16

# Python lexer state names
SCE_P_DEFAULT = 0
SCE_P_COMMENTLINE = 1
SCE_P_NUMBER = 2
SCE_P_STRING = 3
SCE_P_CHARACTER = 4
SCE_P_WORD = 5
SCE_P_TRIPLE = 6
SCE_P_TRIPLEDOUBLE = 7
SCE_P_CLASSNAME = 8
SCE_P_DEFNAME = 9
SCE_P_OPERATOR = 10
SCE_P_IDENTIFIER = 11
SCE_P_COMMENTBLOCK = 12
SCE_P_STRINGEOL = 13

# Document types
kCppDocument = 1
kJavaDocument = 2
kPythonDocument = 3
kMakefileDocument = 4
kDosBatchDocument = 5
kVBDocument = 6
kHTMLDocument = 7
kPropsDocument = 8
kErrlistDocument = 9
kMSIDLDocument = 10
kSQLDocument = 11
kXMLDocument = 12
kXCodeDocument = 13
kLatexDocument = 14
kLuaDocument = 15
kXPIDLDocument = 16
kJavascriptDocument = 17
kRCDocument = 18
kPLSQLDocument = 19
kPHPDocument = 20
kPerlDocument = 21
kDiffDocument = 22

# Doc type for given MIME types
kMimeToDocTypeMap = {
  "text/x-python": kPythonDocument,
  "text/html": kHTMLDocument, 
  "text/x-c-source": kCppDocument,
  "text/x-cpp-source": kCppDocument,
  "text/x-java-source": kJavaDocument,
  "text/x-vb-source": kVBDocument,
  "text/x-dos-batch": kDosBatchDocument,
  "text/x-properties": kPropsDocument,
  "text/x-makefile": kMakefileDocument,
  "text/x-errorlist": kErrlistDocument,
  "text/x-ms-idl": kMSIDLDocument,
  "text/x-sql": kSQLDocument,
  "text/x-xml": kXMLDocument,
  "application/x-tex": kLatexDocument,
  "text/x-lua-source": kLuaDocument,
  "text/x-idl": kXPIDLDocument,
  "text/x-javascript": kJavascriptDocument,
  "text/x-rc": kRCDocument,
  "text/x-pl-sql": kPLSQLDocument,
  "text/x-php-source": kPHPDocument,
  "text/x-perl": kPerlDocument,
  "text/x-diff": kDiffDocument,
}

# What lexer to use for which document type
kLexerForDocType = {
  kCppDocument: SCLEX_CPP,
  kJavaDocument: SCLEX_CPP,
  kPythonDocument: SCLEX_PYTHON,
  kMakefileDocument: SCLEX_MAKEFILE,
  kDosBatchDocument: SCLEX_BATCH,
  kVBDocument: SCLEX_VB,
  kHTMLDocument: SCLEX_HTML,
  kPropsDocument: SCLEX_PROPERTIES,
  kErrlistDocument: SCLEX_ERRORLIST,
  kMSIDLDocument: SCLEX_CPP,
  kSQLDocument: SCLEX_SQL,
  kXMLDocument: SCLEX_XML,
  kLatexDocument: SCLEX_LATEX,
  kLuaDocument: SCLEX_LUA,
  kXPIDLDocument: SCLEX_CPP,
  kJavascriptDocument: SCLEX_CPP,
  kRCDocument: SCLEX_CPP,
  kPLSQLDocument: SCLEX_SQL,
  kPHPDocument: SCLEX_CPP,
  kPerlDocument: SCLEX_PERL,
  kDiffDocument: SCLEX_DIFF,
  kXCodeDocument: SCLEX_XCODE,
}

# User-readable names for doc types
kNameForDocType = {
  kCppDocument: "C/C++",
  kJavaDocument: "Java",
  kPythonDocument: "Python",
  kMakefileDocument: "Makefile",
  kDosBatchDocument: "Dos Batch",
  kVBDocument: "Visual Basic",
  kHTMLDocument: "HTML",
  kPropsDocument: "Properties",
  kErrlistDocument: "Error List",
  kMSIDLDocument: "MS IDL",
  kSQLDocument: "SQL",
  kXMLDocument: "XML",
  kLatexDocument: "Latex",
  kLuaDocument: "Lua",
  kXPIDLDocument: "CORBA IDL",
  kJavascriptDocument: "Javascript",
  kRCDocument: "RC File",
  kPLSQLDocument: "SQL",
  kPHPDocument: "PHP",
  kPerlDocument: "Perl",
  kDiffDocument: "Diff/Patch",
  kXCodeDocument: "XCode",
  None: "Plain Text",
}

