# Simple script to test the py wrapping of scintilla

# This isn't a comprehensive test suite; just contains what I
# have needed while working on this

# Written by Stephan R.A. Deibel, sdeibel@archaeopteryx.com

import gtk
import scintilla
import sci_names

#-----------------------------------------------------------------------
# Callback to quit the app
def Quit(object, event):
  gtk.mainquit()

#-----------------------------------------------------------------------
# Callback for notification of commands
def ScintCmd(scint):
  print "Scintilla command"

#-----------------------------------------------------------------------
# Callback for change notification
def ScintNotify(scint, *args):
  global toplevel
  global calltippos

  notify_type = args[0]
  if notify_type == scintilla.SCN_STYLENEEDED:

    # Get position of start of line that needs styling
    end_styled = toplevel.styling_get_end()
    line_end_styled = toplevel.get_line_at_position(end_styled)
    end_styled = toplevel.get_lineposition(line_end_styled)

    # Foolishly apply an indicator style to everything
    print "Colorizing from", end_styled, "to", args[1]
    toplevel.styling_apply(int(args[1] - end_styled), sci_names.INDIC0_MASK)

  elif notify_type == scintilla.SCN_CHARADDED:
    print "Char added:", args[1]
    if args[1] == 97: # 'a'
      start, end = toplevel.get_selection()
      toplevel.show_calltip(start, "CalltipSample(x, y, z)")
    elif args[1] == 32:  # space
      toplevel.hide_calltip()
    elif toplevel.is_calltip_active():
      calltippos = calltippos + 1
      if calltippos > len("CalltipSample(x, y, z)") - 2:
        toplevel.hide_calltip()
      else:
        toplevel.set_calltip_hilite(calltippos, calltippos + 2)
  elif notify_type == scintilla.SCN_SAVEPOINTREACHED:
    print "Save point reached"
  elif notify_type == scintilla.SCN_SAVEPOINTLEFT:
    print "Save point left"
  elif notify_type == scintilla.SCN_MODIFYATTEMPTRO:
    print "Attempted modifying R/O document"
  elif notify_type == scintilla.SCN_DOUBLECLICK:
    print "Double click"
  elif notify_type == scintilla.SCN_KEY:
    print "Key pressed; key='", args[1], "' modifiers =", args[2]
#  elif notify_type == scintilla.SCN_MODIFIED:
#    print "Modified"
#  else:
#    print "Other SCN notify signal:", args


########################################################################
# Execution starts here

def gtk_test(doc = None):
  global calltippos
  global toplevel

  # Create main window
  print "Creating window"
  win = gtk.GtkWindow()
  win.connect("delete_event", Quit)
  print "Setting window title"
  win.set_title("Python Scintilla")
  win.set_usize(240, 278)
  win.set_uposition(0,0)

  # Read convenient test text
  me = open("scintilla.py")
  lines = me.readlines()
  itext = ""
  for line in lines:
    itext = itext + line

  # Create main window's top-level panel
  calltippos = 0
  toplevel = scintilla.Scintilla()
  toplevel.connect("command", ScintCmd)
  toplevel.connect("notify", ScintNotify)
  toplevel.set_lexer(scintilla.SCLEX_PYTHON)
  toplevel.set_indic_style(0, sci_names.INDIC_DIAGONAL)
  toplevel.styling_start(0, sci_names.INDICS_MASK)
  if doc != None:
    toplevel.set_document(doc)
    toplevel.set_document(None)
    toplevel.set_document(doc)
  else:
    # Read convenient test text
    me = open("scintilla.py")
    itext = me.read()
    itext = itext + line
    toplevel.set_text(itext)

  win.add(toplevel)
  toplevel.show()

  # Run window
  win.show()
  gtk.mainloop()
  del toplevel
  
def doc_test():
  class DocWatcher:
    def NotifyModified(self, *args):
      print args

    def NotifySavePoint(self, *args):
      print 'NotifySavePoint', args
      
  watcher = DocWatcher()
  watcher2 = DocWatcher()
  
  doc = scintilla.create_document()
  doc.AddWatcher(watcher)
  doc.AddWatcher(watcher2)
  msg = "hello world!"
  doc.InsertString(0, msg)
  content = doc.GetCharRange(0, len(msg))
  assert content == msg
  doc.RemoveWatcher(watcher)
  gtk_test(doc)

gtk_test()  
#doc_test()


