name = "Date\nTime"
desc = "Set Date & Time"

from gtk import *
from GTK import *

from utils import *

_date_file = '/etc/lastdate'

class applet(Applet):

    global _date_file
    
    def __init__(self):
        import time

        ctime = time.localtime(time.time())
        if ctime[0] < 2001:
            try:
                f = open(_date_file,'r')
                ctime = time.strptime(f.read(),"%a %b %d %H:%M:%S %Y")
                f.close()
            except:
                pass

        Applet.__init__(self)
        self.box = GtkVBox()
        self.add(self.box)
        self.box.show()

        lbl = GtkLabel('Date')
        self.box.pack_start(lbl,expand=FALSE)
        lbl.show()

        self.cal = GtkCalendar()
        self.box.pack_start(self.cal,expand=FALSE)
        self.cal.select_month(ctime[1]-1,ctime[0])
        self.cal.select_day(ctime[2])
        self.cal.show()

        lbl = GtkLabel('Time')
        self.box.pack_start(lbl,expand=FALSE)
        lbl.show()

        hb = GtkHBox()
        adj = GtkAdjustment(ctime[3],0,23,1,1,1)
        self.hour = GtkSpinButton(adj,1,0)
        lbl=GtkLabel('Hour:')
        hb.pack_start(lbl,expand=FALSE)
        lbl.show()
        hb.pack_end(self.hour,expand=FALSE)
        self.hour.show()
        self.box.pack_start(hb,expand=FALSE)
        hb.show()

        hb = GtkHBox()
        adj = GtkAdjustment(ctime[4],0,59,1,1,1)
        self.min = GtkSpinButton(adj,1,0)
        lbl=GtkLabel('Minute:')
        hb.pack_start(lbl,expand=FALSE)
        lbl.show()
        hb.pack_end(self.min,expand=FALSE)
        self.min.show()
        self.box.pack_start(hb,expand=FALSE)
        hb.show()

        hb = GtkHBox()
        adj = GtkAdjustment(ctime[5],0,59,1,1,1)
        self.sec = GtkSpinButton(adj,1,0)
        lbl=GtkLabel('Second:')
        hb.pack_start(lbl,expand=FALSE)
        lbl.show()
        hb.pack_end(self.sec,expand=FALSE)
        self.sec.show()
        self.box.pack_start(hb,expand=FALSE)
        hb.show()

    def save(self,msgbox=FALSE):
        import time
        import os
        year, mo, day  = self.cal.get_date()
        hour = self.hour.get_value_as_int()
        min = self.min

        weekday = time.strptime('%d %d %d' % (mo+1,day,year),'%m %d %Y')[6]

        ctime = (year, mo + 1, day, self.hour.get_value_as_int(), self.min.get_value_as_int(), self.sec.get_value_as_int(),weekday,0,0)

        ts = time.strftime("%a %b %d %H:%M:%S %Y",ctime)
        os.system('/bin/date -s "%s"' % ts)
        f = open(_date_file,'w')
        f.write(time.strftime("%a %b %d %H:%M:%S %Y",ctime))
        f.close()
        ret = Applet.save(self,msgbox)
                
applet_instance = applet()
