/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/

typedef unsigned long u32;

#include "bootldr.h"
#include "btflash.h"
#include "load_kernel/include/load_kernel.h"
#include "load_kernel/include/config.h"

extern struct kernel_loader cramfs_load;
extern struct kernel_loader zImage_load;
extern struct kernel_loader jffs2_load;

const struct kernel_loader *loader[] = {
	&zImage_load,
	&jffs2_load,
	&cramfs_load,
	NULL
};

void *fodder_ram_base = NULL;

int load_kernel(unsigned long *out, const char *partname, const char *kernel_filename)
{
  struct part_info part;
  int i;
  int size;
  const struct kernel_loader *the_loader = NULL;
  struct FlashRegion *flashRegion = btflash_get_partition(partname);
  if (!flashRegion) {
     putstr("could not find partition "); putstr(partname); putstr("\r\n");
     return -1;
  }
  part.size = flashRegion->size;
  /* for uniformly sized flash sectors */
  part.erasesize = flashDescriptor->sectors[1] - flashDescriptor->sectors[0];
  part.offset = ((char*)flashword) + flashRegion->base;

  if (!fodder_ram_base)
     fodder_ram_base = (void*)mmalloc(0x1000);

  for (i = 0; loader[i]; i++) {
    if (loader[i]->check_magic(&part)) {
      the_loader = loader[i];
      break;
    }
  }
  if (!the_loader) {
    putstr("no kernel found\r\n");
    return -1;
  }
  putstr("loading kernel from "); putstr(the_loader->name); putstr("\r\n"); 
  if ((size = loader[i]->load_kernel(out, &part, kernel_filename)) == 0) {
    putstr(" error loading kernel!\r\n");
    return 0;
  }
  putLabeledWord("loaded bytes=", size);
  return size;
}

inline void ldr_update_progress(void)
{
   putstr(".");
}

inline int ldr_strlen(const char *a)
{
   return strlen(a);
}

inline int ldr_strncmp(const char *a, const char *b, size_t n)
{
   return strncmp(a, b, n);
}

inline void *ldr_memcpy(void *dst, const void *src, size_t n)
{
   memcpy(dst, src, n);
   return dst;
}

inline void ldr_output_string(char *str)
{
   putstr(str);
}

inline void ldr_output_hex(u32 hex)
{
   putHexInt32(hex);
}

