/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*	;; boot.s
	;; Compaq Personal Server Monitor Boot Code
        ;;      
        ;; Copyright 1999 Compaq Computer Corporation
        ;; All Rights Reserved
	;;
        ;; 
        ;; 
	;; This code is a very minimalist loader -- it jumps straight to
	;; main() after initalizing SDRAM,PCI,and the UART.
	;; boot.s from the Digital StrongARM uHAL provided inspiration for
	;; this loader.
*/
	
#ifdef __QNXNTO__
#define __ASSEMBLY__
#define ASENTRY(x_) ENTRY(x_)
#define _C_FUNC(x_) /**/x_/**/
#define _C_LABEL(x_) /**/x_/**/
#define ENTRY(name) .globl name; \
                    name:
#else /* not QNX */
#ifdef __NetBSD__
#include <arm32/asm.h>
#else /* not NetBSD */
#define __ASSEMBLY__	
#include <linux/linkage.h>
#define ASENTRY(x_) ENTRY(x_)        
#define _C_FUNC(x_) /**/x_/**/
#define _C_LABEL(x_) /**/x_/**/
#endif /* NetBSD */
#endif /* QNX */	 
#include "architecture.h"
#include "bootconfig.h"
#if 0
#include <asm/arch-sa1100/hardware.h>
#endif
#include "sa1100.h"
#include "boot_flags.h"

	/*; *************************/
	/*; Start of executable code*/
	/*; *************************/
ENTRY(_start)	
ENTRY(ResetEntryPoint) /* 0x00:  */
	
	b	HiReset
	
/* 0x04:         */	
UndefEntryPoint:	
	b	HandleUndef
	
/* 0x08:         */	
SWIEntryPoint:	
	b	HandleSWI
	
/* 0x0c:         */	
PrefetchAbortEntryPoint:	
	b	HandlePrefetchAbort
	
/* 0x10:         */	
DataAbortEntryPoint:	
	b	HandleDataAbort
	
/* 0x14:         */	
NotUsedEntryPoint:      	
	b       HandleNotUsed
/* 0x18:         */	
IRQEntryPoint:	
	b	HandleIRQ
	
/* 0x1c:         */	
FIQEntryPoint:	
	b	HandleFIQ
	
/* 0x20:        */	
	.long   BOOTLDR_MAGIC       /* magic number so we can verify that we only put bootldr's into flash in the bootldr region */
/* 0x24:        */	
	.long   BOOTLDR_VERSION
/* 0x28:        */	
        .long   _C_LABEL(_start)              /* where this bootldr was linked, so we can put it in memory in the right place */
/* 0x2C:	*/
	.long	ARCHITECTURE_MAGIC  /* this contains the platform, cpu and machine id */
/* 0x30 */
	/*
	 * bootldr capabilities
	 */
	.long	BOOTLDR_CAPS

/* 0x34 */	
	/*
	 * bootldr sig
	 */
        .ascii	BL_SIG

HandleUndef:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_UNDEF
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	mrc	p15, 0, r0, c6, c0, 0 /* fault address */
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
HandleSWI:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_SWI
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	mrc	p15, 0, r0, c6, c0, 0 /* fault address */
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
HandlePrefetchAbort:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_PREFETCH_ABORT
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	mrc	p15, 0, r0, c6, c0, 0 /* fault address */
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
AbortStorage:
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
        .word 0
	
HandleDataAbort:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_DATA_ABORT
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	mrc	p15, 0, r0, c6, c0, 0 /* fault address */
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b

HandleIRQ:	
	b       HiReset
                
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_IRQ
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
HandleFIQ:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_FIQ
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
HandleNotUsed:	
        /* save all user registers */
        adr     r13, AbortStorage
        stm     r13, {r0-r12}
        mov     r12, r14
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#endif
	ldr	r0,STR_NOT_USED
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
	mov     r0, r12
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintHexWord
	
	mov     r14, r12
        /* restore registers */
        ldm     r13, {r0-r12}
        /* now loop */
1:      b 1b
	
ASENTRY(WaitForInput)
        ldr	r1,_C_LABEL(SerBase)
1:      	
	ldr	r2,[r1,#SA1100_UTSR1]
	tst	r2,#SA1100_UTSR1_RNE
        beq     1b     
	mov     pc, lr
	
ConsumeInput:	
	ldr	r1,_C_LABEL(SerBase)
	ldr	r2,[r1,#SA1100_UTDR]
	ldr	r0,[r1,#SA1100_UTSR1]
	tst	r0,#SA1100_UTSR1_RNE
	bne	ConsumeInput
	
HiReset:	
#if defined(CONFIG_BITSY_WINCE)
        ldr     r4, WINCE_PARAM1
        str     r0, [r4]
        str     r1, [r4, #4]
        cmp     r0, #0xCECODE

#endif
#if 0
	/* XXX delete */
	ldr	r0, =10f
	mov	pc, r0
	nop
	nop
10:
#endif
	
#ifdef	CONFIG_BITSY
	ldr	r0, boot_flags_init_val
	ldr	r1, Boot_flags_ptr
	str	r0, [r1]
#endif

ENTRY(SleepReset_Resume)
	/* disable all interrupts */
	ldr     r1, SA1100_ICMR_ADDRESS
	mov     r0, #0
        str     r0, [r1, #0]
	
#if defined(CONFIG_BITSY) || defined(CONFIG_ASSABET) || defined(CONFIG_NEPONSET) || defined(CONFIG_JORNADA720)
        /*;initialize the static memory timing */ 
	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
	ldr     r2, msc2_config
        str     r2, [r1, #SA1100_MSC2]
	ldr     r2, msc1_config
        str     r2, [r1, #SA1100_MSC1]

	/*
	 * We have two kinds of flash on bitsy.  One is 16bit wide, the
	 * other is 32.
	 * Since the ARM must be strapped to the correct boot memory width
	 * to boot correctly, and the state of the strap is reflected in
	 * config register, we'll leave that bit unchanged.
	 */
	ldr     r2, msc0_config
	ldr	r3, [r1, #SA1100_MSC0]
	/* save the current bit value */
	and	r3, r3, #MSC_RBW16
	/* make sure the bit is cleared in the new config word */
	bic	r2, r2, #MSC_RBW16
	/* propagate the bit into the new config value */
	orr	r2, r3, r2
        str     r2, [r1, #SA1100_MSC0]
	/*; disable synchronous rom because we have none */ 
	mov     r2, #0
        str     r2, [r1, #SA1100_SMCNFG]
        /*; configutre the expansion (PCMCIA) memory */	
	ldr     r2, mecr_config
        str     r2, [r1, #SA1100_MECR]
#endif	

#ifdef MODIFY_CPSR	
	# put us in the right frame of mind ...
	msr	cpsr_c, #(F_BIT | I_BIT | SVC_MODE)
#endif	
	/* set clock speed to 191.7MHz */
	ldr	r1, SA1100_PPCR_ADDRESS	
	mov	r0, #SA1100_PPCR_206MHZ
	str     r0, [r1, #0]

        /* make sure TX fifo is empty by printing a character */
	mov     r0, #0
	ldr     r1, _C_LABEL(SerBase)
        bl      _C_FUNC(PrintChar)

#ifdef	CONFIG_BITSY
	/* 
	 * look at the action button to see if serial squelch toggling 
	 * is requested 
	 */

	mov	r3, #0x1
button_loop:
	ldr	r1, =SA1100_GPIO_BASE
	ldr	r0, [r1, #SA1100_GPIO_GPLR_OFF]
	tst	r0, #(1<<18)	/* check the Action button down bit */
	beq	squelch_toggle	/* skip if button is down (bit is 0)  */
	
	subs	r3, r3, #1
	bne	button_loop
	b	squelch_as_is

squelch_toggle:
squelch_spin:		
	/* loop till the button is released. */
	ldr	r0, [r1, #SA1100_GPIO_GPLR_OFF]
	tst	r0, #(1<<18)	/* check the Action button down bit */
	beq	squelch_spin
	
	ldr     r0, Boot_flags_ptr
	ldr	r1, [r0]
	eor	r1, r1, #BF_SQUELCH_SERIAL
	str	r1, [r0]
	
squelch_as_is:
#endif
		
	/*; Initialize the UARTs */
	bl	InitUART1
	bl	InitUART3
#ifdef CONFIG_BITSY
        bl      EnableUart3Transceiver
#ifdef CONFIG_POWERMGR

#if 0
	/*
	 * XXX
	 * DEBUG, REMOVE vvvvv
	 */
	/*
	 * use the power button to tell us to skip looking 
	 * for a sleep reset.
	 */
	ldr	r1, =SA1100_GPIO_BASE
	ldr	r1, [r1, #SA1100_GPIO_GPLR_OFF]
	tst	r1, #(1<<0)
	beq	skip_sleep_reset_check
	/*
	 * XXX
	 * DEBUG, REMOVE ^^^^^
	 */
#endif
	
        ldr     r1, SA1100_RCSR_ADDRESS
        ldr     r0, [r1, #0]
        and     r0, r0, #(RCSR_HWR + RCSR_SWR + RCSR_WDR + RCSR_SMR)
        teq     r0, #RCSR_SMR
        beq     WakeupStart

	b	55f
skip_sleep_reset_check:
	ldr	r0,STR_WAKEUP_SKIP
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord
55:		
#endif
#endif
	mov     r0, #'\r'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	mov     r0, #'\n'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	mov     r0, #'@'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	
	mov     r0, pc
	ldr     r1, _C_LABEL(SerBase)
        bl      PrintHexWord

/* check to see if we're operating out of DRAM */
        bic     r4, pc, #0x000000FF
        bic     r4, r4, #0x0000FF00
        bic     r4, r4, #0x00FF0000
	
        cmp     r4, #DRAM_BASE0
	
	bne     RunningInFlash
	
RunningInDRAM:  
	mov     r0, #'D'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
#if 0	
	b       22f
#else
        b       21f	
#endif	
	
RunningInFlash: 	
	mov     r0, #'F'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	       
21:     	
/* otherwise, assume we're running in Flash and do a complete reset */

/*; Initialize SDRAM and Flash*/
	mov	r0, #1		/* tell routine to init reggies */
	bl	InitMem

	/* r0 contains DRAM size */
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintHexWord

/*; debug print*/
	mov	r0,#'\r'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	mov	r0,#'\n'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	mov	r0,#'*'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	
	ldr     r0, STR_MTST
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
	
TestDramBank0:       	
	/* some test code */
	mov	r5, #DRAM_BASE0
	mov	r6, #0x00000001
TestDramBank0Loop:
	mov     r0, r6
	str	r0, [r5, #48]
	ldr	r0, [r5, #48]
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintHexWord
	tst     r6, #0x80000000
	bne     TestDramBank0Done
	mov     r6, r6, lsl #1
        b       TestDramBank0Loop
TestDramBank0Done:
        
#ifdef CONFIG_DRAM_BANK2	
	ldr	r0, STR_MB2
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
	
	mov	r5, #DRAM_BASE1
	mov	r6, #0x00000001
TestDramBank1Loop:
#ifndef BOOT_SILENT
	mov     r0, r6
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintHexWord
#endif
	mov     r0, r6
	str	r0, [r5, #48]
	ldr	r0, [r5, #48]
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintHexWord
	tst     r6, #0x80000000
	bne     TestDramBank1Done
	mov     r6, r6, lsl #1
        b       TestDramBank1Loop
TestDramBank1Done:
#endif /* CONFIG_DRAM_BANK2 */

/*; debug print*/
DebugPrintAfterTestDram:        	
	ldr	r0, STR_ENDM
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord

#ifdef NOTDEF
memTest:                        

        /* Initial - fill memory */
        mov     r0,#DRAM_BASE0
        add     r1,r0,#DRAM_SIZE0
	ldr     r2,CRC32POLY
	mov     r3,#-1
        mov     r4,#1

10:     orrs    r3,r4,r3,lsl#1
        eorcs   r3,r3,r2
        str     r3,[r0], #4
        mov     r6,r0
	mov     r7,r1
	mov     r8,r2
	mov     r9,r3
	mov     r10,r4
	bl      PrintHexWord
	mov     r0,r6
	mov     r1,r7
	mov     r2,r8
	mov     r3,r9
	mov     r4,r10
        cmp     r0,r1
        bne     10b

        /* Phase two, check */
        mov     r0,#DRAM_BASE0
        mov     r3,#-1

20:     orrs    r3,r4,r3,lsl #1
        eorcs   r3,r3,r2
        ldr     r5,[r0],#4
        cmp     r5,r3
        bne     memError
        mov     r6,r0
	mov     r7,r1
	mov     r8,r2
	mov     r9,r3
	mov     r10,r4
	bl      PrintHexWord
	mov     r0,r6
	mov     r1,r7
	mov     r2,r8
	mov     r3,r9
	mov     r4,r10
        cmp     r0,r1
        bne     20b
	b	memNoError
	
memError:	
	ldr	r0, STR_MEM_ERROR
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
memError1:	
	b	memError1
	
memNoError:     	
#endif	
	
22:             	
/* execution also continues here from the RunningFromDRAM path */
EnableCaches:	
#ifdef CACHE_ENABLED
#warning CACHE_ENABLED is untested	-Jamey 11/21/2000
/*; debug print*/
	ldr     r0, STR_PRECACHE
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
 	
	/*; Enable the Icache*/
#ifdef ICACHE_ENABLED	
	mrc	p15, 0, r0, c1, c0, 0
	orr	r0, r0, #0x1000  /* bit 12 is ICACHE enable*/
	mcr	p15, 0, r0, c1, c0, 0
#endif

	/*; flush the I/D caches*/
        /*;  c7 == cache control operation register*/
        /*;  crm==c7 opc2==0 indicates Flush I+D Cache*/
        /*;  r0 is ignored*/
	mcr	p15, 0, r0, c7, c7, 0x00 
        /*; flush the I+D TLB*/
        /*;  c8 is TLB operation register*/
        /*;  crm=c7 opc2==0 indicates Flush I+D TLB*/
        /*;  r0 is ignored*/
	mcr	p15, 0, r0, c8, c7, 0x00 

	/*; Flush the data cache*/
	ldr	r0,DW_CACHE_FLUSH_REGION
	bl	_C_FUNC(writeBackDcache)

/*; debug print*/
	ldr	r0, STR_POSTCACHE
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
#endif	
	
#ifdef CACHE_ENABLED
	/*; Flush the data cache*/
	ldr	r0,DW_CACHE_FLUSH_REGION
	bl	_C_FUNC(writeBackDcache)
	
        ldr     r0, STR_POSTFLUSH
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintWord
#endif

	/*; Get ready to call C functions*/
	ldr	r0, STR_STACK
	bl	PrintWord
	ldr	r0, DW_STACK_START
	bl	PrintHexWord
	
setupStack:     	
	ldr	sp,DW_STACK_START
	mov	fp,#0		/* no previous frame, so fp=0*/

#ifdef CONFIG_RELOCATE_BOOTLDR	
        adr     r0, _C_LABEL(_start)
        ldr     r1, _C_LABEL(_start) + 0x28
        cmp     r0, r1
        beq     call_main       /* the bootldr is loaded where it's linked */

relocateBootldr:
#if 0	
	adr     r0, relocateBootldr
        bl      PrintHexWord
#endif	
	/* otherwise, copy it where it's linked */
#ifdef ASM_COPY	
        ldr     r0, _C_LABEL(_start) + 0x28      /* dest */
        adr     r1, _C_LABEL(_start)             /* source */
        add     r2, r1, #SZ_256K       /* end of source */
1:      
        ldmia   r1!, {r5, r6, r7, r8}
        stmia   r0!, {r5, r6, r7, r8}
        cmp     r1, r2
        bne     1b
#endif
        ldr     r0, _C_LABEL(_start) + 0x28      /* dest */
        adr     r1, _C_LABEL(_start)             /* source */
        mov     r2, #SZ_256K           /* length */
	bl      _C_FUNC(memcpy)

#if 0	
        ldr     r0, __start + 0x28
	add     r0, r0, #(call_main - __start)
        bl      PrintHexWord
	/* now branch to call_main adjusted to where the bootldr was linked (not PC relative) */
        ldr     r0, __start + 0x28
	add     r0, r0, #(call_main - __start)
	mov     pc, r0
#endif	
#endif /* CONFIG_RELOCATE_BOOTLDR */

call_main:      

#if 0
	adr     r0, call_main
        bl      PrintHexWord
#endif
	
	ldr	sp,DW_STACK_START
	mov	fp,#0		/* no previous frame, so fp=0*/

	mov	a2, #0		/* set argv to NUL*/

	/*
	 * check to see itf this is a sleep reset.
	 * if so, then we want to enter the bootmenu directly.
	 * otherwise, we want to proceed as before, allowing 
	 * a key or timeout to control the boot action
	 */	 		
	ldr     r2, Boot_flags_ptr
	ldr	r3, [r2]
	tst	r3, #BF_SLEEP_RESET
	movne	a1, #1
	moveq	a1, #0
	
	/* clear the sleep reset bit if it was set */
	bicne	r3, r3, #BF_SLEEP_RESET
	strne	r3, [r2]
		
	bl	_C_FUNC(main)	/* call main*/

	mov	pc, #FLASH_BASE	/* reboot */

#if defined(CONFIG_BITSY) && defined(CONFIG_POWERMGR)
WakeupStart:

	ldr	r0,STR_WAKEUP
	ldr     r1,_C_LABEL(SerBase)
	BL	PrintWord

	# clear sleep reset bit
        ldr     r1, SA1100_RCSR_ADDRESS
        mov     r0, #RCSR_SMR
	str	r0, [r1]
	# save sleep reset flag in our flags reggie
	ldr     r2, Boot_flags_ptr
	ldr	r3, [r2]
	orr	r3, r3, #BF_SLEEP_RESET
	str	r3, [r2]
	
        ldr     r1, SA1100_PSSR_ADDRESS
        mov     r0, #PSSR_PH
        str     r0, [r1, #0]

        ldr     r1, SA1100_PSSR_ADDRESS
        mov     r0, #PSSR_DH
        str     r0, [r1, #0]    /* Clearing DRAM hold */

	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
	ldr	r0, [r1, #SA1100_MDREFR]

	/*
	 *mask out all of the bits that are undefined after a reset
	 */
	ldr	r2, mdrefr_valid_bits_after_reset
	and	r0, r0, r2
        
	/* Disable auto power down */
        bic     r0, r0, #MDREFR_EAPD | MDREFR_KAPD
        
	/* Set KnRUN (from Self-refresh and Clock-stop to Self-refresh) */
        orr     r0, r0, #MDREFR_K1RUN
        str     r0, [r1, #SA1100_MDREFR]

        /* Clear SLFRSH (from Self-refresh to Power-down) */
        bic     r0, r0, #MDREFR_SLFRSH
        str     r0, [r1, #SA1100_MDREFR]

        /* Set E1PIN (from Power-down to PWRDNX) */
        orr     r0, r0, #MDREFR_E1PIN
        str     r0, [r1, #SA1100_MDREFR]

        ldr     r0, dram_cas0_waveform0
        str     r0, [r1, #SA1100_MDCAS00]

        ldr     r0, dram_cas0_waveform1
        str     r0, [r1, #SA1100_MDCAS01]

        ldr     r0, dram_cas0_waveform2
        str     r0, [r1, #SA1100_MDCAS02]

        ldr     r0, dram_mdrefr
        str     r0, [r1, #SA1100_MDREFR]

	/* 
	 * init the memory controller mode config register
	 */
	mov	r0, #0
	bl	InitMem

#if 0
	/* temp, remove VVVVVVVVVVVVVVVVVVVVVVV */
	ldr	r1, Boot_flags_ptr
	ldr	r2, [r1]
	bic	r2, r2, #BF_SQUELCH_SERIAL
	str	r2, [r1]
	/* r0 contains DRAM size */
	ldr     r1, _C_LABEL(SerBase)
	bl      PrintHexWord
	mov     r0, #'\r'
        bl      _C_FUNC(PrintChar)
	mov     r0, #'\n'
        bl      _C_FUNC(PrintChar)
12:
	/* let the uart drain */
	/* r1 has stat addr from print char */	
        ldr     r2,[r1,#SA1100_UTSR1]/* check status*/
	tst     r2,#SA1100_UTSR1_TBY /* TX busy ? */
        bne	12b
	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
	/* temp, remove ^^^^^^^^^^^^^^^^^^^^^^^ */
#endif
	
        ldr     r0, [r1, #SA1100_MDCNFG]
	bic	r0, r0, #MDCNFG_BANK0_ENABLE
        str     r0, [r1, #SA1100_MDCNFG]

        mov     r1, #0xC0000000
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4
        ldr     r0, [r1], #4

        mov     r1, #SA1100_DRAM_CONFIGURATION_BASE
        ldr     r0, [r1, #SA1100_MDCNFG]
	orr	r0, r0, #MDCNFG_BANK0_ENABLE
        str     r0, [r1, #SA1100_MDCNFG]

	@ Enable SDRAM auto power down
        ldr     r0, dram_mdrefr
	orr	r0, r0, #(MDREFR_EAPD + MDREFR_KAPD)
        str     r0, [r1, #SA1100_MDREFR]
   
WakeUp:
        ldr     r7, SA1100_PSPR_ADDRESS
        ldr     r6, [r7, #0]
	mov     pc, r6
#endif
	
        /**************************************************************/	
        /*       ResetWhileRunningInDRAM                              */
        /*          Bootldr is running from DRAM                      */
	/*          MMU may be enabled                                */
	/*          Disable MMU, then do standard configuration       */
        /**************************************************************/	
ResetWhileRunningInDRAM:
	mov     r11, lr
	mov	r0,#'^'
	ldr     r1, _C_LABEL(SerBase)
	bl      _C_FUNC(PrintChar)
	
#ifdef CONFIG_BITSY
        b       EnableCaches

/*      	
 * Enable Ser3 Transceiver
 *   r0: number of times to wiggle the enable bit
 *   modifies r0, r1, r2	
 */
EnableUart3Transceiver: 
        ldr     r1, EGPIOBase
	mov     r2, #EGPIO_BITSY_RS232_ON
        str     r2, [r1, #0]
        ldr     r2, [r1, #0]
        mov     pc, lr	
#endif
	/*
	;; ********************************************************************
	;; InitUART1 - Initialize Serial Communications
	;; ********************************************************************
	;; Following reset, the UART is disabled. So, we do the following:
	*/
InitUART1:
#if defined(CONFIG_ASSABET) || defined(CONFIG_NEPONSET)
	ldr	r1,BCRBase
	mov	r2, #BCR_RS232EN
	str	r2, [r1, #0]
#endif
	/* Now clear all 'sticky' bits in serial I registers, cf. [1] 11.11 */
	ldr	r1, SDLCBase
	mov	r2, #0x01
	str	r2, [r1]
        ldr	r1, _C_LABEL(Ser1Base)
	mov	r2, #0xFF
	str	r2, [r1, #SA1100_UTSR0]         /* UART1 Status Reg. 0        */
	
        /* disable the UART */
	mov	r2, #0x00
	str	r2, [r1, #SA1100_UTCR3]         /* UART1 Control Reg. 3        */
	/* Set the serial port to sensible defaults: no break, no interrupts, */
	/* no parity, 8 databits, 1 stopbit. */
	mov	r2, #SA1100_UTCR0_8BIT
	str	r2, [r1, #SA1100_UTCR0]         /* UART1 Control Reg. 0        */

#define UART_BRD ((3686400 / 16 / UART_BAUD_RATE) - 1)
	mov	r2, #((UART_BRD >> 16) & 0xF)
	str	r2, [r1, #SA1100_UTCR1]
	mov	r2, #(UART_BRD & 0xFF)
	str	r2, [r1, #SA1100_UTCR2]
        /* enable the UART TX and RX */
InitUart1Enable:

	mov	r2, #(SA1100_UTCR3_RXE|SA1100_UTCR3_TXE)
	str	r2, [r1, #SA1100_UTCR3]

	ldr     r2, Boot_flags_ptr
	ldr	r2, [r2]
	tst	r2, #BF_SQUELCH_SERIAL
	bne	10f
	
        /* transmit a character or two */
	mov	r2, #'U'
	str	r2, [r1, #SA1100_UTDR]
	mov	r2, #'1'
	str	r2, [r1, #SA1100_UTDR]
10:	
	mov	pc, lr		/* All done, return*/

	/*
	;; ********************************************************************
	;; InitUART3 - Initialize Serial Communications
	;; ********************************************************************
	;; Following reset, the UART is disabled. So, we do the following:
	*/
InitUART3:
        ldr	r1, _C_LABEL(Ser3Base)
        /* disable the UART */
	mov	r2, #0x00
	str	r2, [r1, #SA1100_UTCR3]         /* UART1 Control Reg. 3        */
	/* Now clear all 'sticky' bits in serial I registers, cf. [1] 11.11 */
	mov	r2, #0xFF
	str	r2, [r1, #SA1100_UTSR0]         /* UART1 Status Reg. 0        */
	
	/* Set the serial port to sensible defaults: no break, no interrupts, */
	/* no parity, 8 databits, 1 stopbit. */
	mov	r2, #SA1100_UTCR0_8BIT
	str	r2, [r1, #SA1100_UTCR0]         /* UART1 Control Reg. 0        */

	/* Set BRD to 1, for a baudrate of 115K2 ([1] 11.11.4.1) */
	/* Set BRD to 3, for a baudrate of 57k6 ([1] 11.11.4.1) */
	/* Set BRD to 5, for a baudrate of 38k4 ([1] 11.11.4.1) */
	/* Set BRD to 23, for a baudrate of 9k6 ([1] 11.11.4.1) */
	mov	r2, #0x00
	str	r2, [r1, #SA1100_UTCR1]
	mov	r2, #1
	str	r2, [r1, #SA1100_UTCR2]
        /* enable the UART TX and RX */
InitUart3Enable:
	
	mov	r2, #(SA1100_UTCR3_RXE|SA1100_UTCR3_TXE)
	str	r2, [r1, #SA1100_UTCR3]

	ldr     r2, Boot_flags_ptr
	ldr	r2, [r2]
	tst	r2, #BF_SQUELCH_SERIAL
	bne	10f
	
        /* transmit a character or two */
	mov	r2, #'U'
	str	r2, [r1, #SA1100_UTDR]
	mov	r2, #'3'
	str	r2, [r1, #SA1100_UTDR]
10:		
#ifdef CONFIG_BITSY
        /* set forceon bit, which is in EGPIO U7 */	
	ldr     r1, EGPIOBase
        mov     r2, #EGPIO_BITSY_RS232_ON
	str	r2, [r1, #0]
	ldr	r2, [r1, #0]
#endif

	mov	pc, lr		/* All done, return*/

	/*; *****************************************************************/
	/*; InitMem - initialize SDRAM*/
	/*; *****************************************************************/
ASENTRY(InitMem)

	cmp	r0, #0
	beq	20f
	
	/* Set up the DRAM in banks 0 and 1 [1] 10.3 */
	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
        ldr     r2, dram_cas0_waveform0
	str	r2, [r1, #SA1100_MDCAS00]

        ldr     r2, dram_cas0_waveform1
	str	r2, [r1, #SA1100_MDCAS01]	

        ldr     r2, dram_cas0_waveform2
	str	r2, [r1, #SA1100_MDCAS02]	
	
	ldr     r2, dram_mdrefr
	str	r2, [r1, #SA1100_MDREFR]

20:
memSizeTry64MB:
	/*
	 * davep: I moved the accesses to before the
	 * enable as per 10.7.1 #6
	 * i.e. access the memory while configured but
	 * disabled
	 */

	/* configure the memory */
	/*
	 * we need to keep DRAM enbabled during RAM testing
	 * preserve current enable bit 
	 */
	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
	ldr	r4, [r1, #SA1100_MDCNFG]
	ldr     r3, dram_mdcnfg_enable
	and	r3, r4, r3
	ldr	r4, dram_mdcnfg_64mb
	orr	r4, r4, r3
	str	r4, [r1, #SA1100_MDCNFG]

	/* wake up the memory... */
	mov     r2, #DRAM_BASE0
	
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */
	ldr     r3, [r2, #0]	/* read at 0xc0000000 */

	/* now, enable it. */
	ldr	r3, dram_mdcnfg_64mb
	ldr     r4, dram_mdcnfg_enable
	orr	r4, r4, r3
	str	r4, [r1, #SA1100_MDCNFG]
	nop
	nop

	/*
	 * save that which we will overwrite
	 * save value at offset 0
	 * Offset 0 will not move around like other
	 *  addresses like 16M, etc. will when we
	 *  reconfigure the memory size.
	 *  So we save it here, once.
	 */
	mov     r2, #DRAM_BASE0
	mov	r4, r2
	ldr	r5, [r4]

	/*
	 * check for 64M of memory.
	 * Write SZ_64M to offset 0   in DRAM_BANK0.
	 * Write SZ_16M to offset 16M in DRAM_BANK0.
	 * If we have < 64M of memory, then the write
	 *  to 16M will wrap and overwrite address 0.
	 * If we still see SZ_64M at 0, then there
	 *  was no wrap and we have 64M.
	 */

	/* create paddr of 16M into DRAM bank */
	mov     r1, #SZ_16M
	orr     r0, r2, r1

	/* 
	 * save addr and data being overwritten
	 * at offset 16M
	 * NOTE: if this machine is <64M, then
	 *  we are actually saving the value at
	 *  offset 0 due to wrap.
	 *  so we must save this value before we
	 *  write to 0 or we're hosed.
	 * 
	 */
	mov	r6, r0
	ldr	r7, [r6]
	
	mov     r1, #SZ_64M
        str     r1, [r2, #0]	/* 64MB signature at 0xc0000000 */

	mov     r1, #SZ_16M
        str     r1, [r0, #0]	/* 16MB signature at 0xc1000000 */
				/* (or 0xc00000000 if wrapping) */
	
	ldr     r1, [r2, #0]    /* look to see if 0xc0000000 changed... */
	mov     r3, #SZ_64M     /* ...implying 32MB or less */
        cmp     r1, r3

	/*
	 * a match means 64M at least.  We're done and
	 * we can restore values to offset 0 and 16M
	 */
        beq     memSizeDetected64M

	/*
	 * we do not have 64M of DRAM.
	 * We are about to change the DRAM config for
	 * 32M (and 16M).
	 * First, lets restore the values we saved from
	 * before.
	 * This way, we don't have to worry if 16M wraps
	 * to the same place on a 64M machine as it does
	 *  on other configurations.
	 * We also restore the value to offset 0 so
	 *  that if the next case wraps at 16M then
	 *  we'll save the correct value when we
	 *  read offset 16M
	 */
	str	r7, [r6]	/* restore offset 16M */

	/* restore 0 *after* 16M in case of wrap */
	str	r5, [r4]	/* restore offset 0 */

	/*
	 * Now we reconfigure the DRAM to 32M.
	 * The probing process is similar to 64M
	 * We write SZ_32M to offset 0 and
	 *  SZ_16M to offset 16M
	 * We then see if the write to 16M clobbers
	 *  the value at zero.
	 * If not clobbered, we have 32M.
	 * If clobbered, <32M and the only thing we 
	 * sell like that is 16M.
	 * 
	 */
        
memSizeTry32MB: 	
	mov	r1, #SA1100_DRAM_CONFIGURATION_BASE
	ldr     r2, dram_mdcnfg_32mb
	str	r2, [r1, #SA1100_MDCNFG]
	nop
	nop

	/* paddr of offset 0 */
	mov     r2, #DRAM_BASE0

	/* paddr of offset 16M */
        mov     r1, #SZ_16M
	orr     r0, r2, r1
	
	/* 
	 * save addr and data being overwritten
	 * at offset 16M
	 * as in 64M case, save this value before
	 *  we write to zero in the case of a
	 *  wrap.
	 */
	mov	r6, r0
	ldr	r7, [r6]
	
        ldr	r1, =SZ_32M
        str     r1, [r2, #0]		/* put SZ_32M at 0 */

        ldr	r1, =SZ_16M
        str     r1, [r0, #0]		/* put SZ_16M at 16M (or 0) */
	
        ldr     r1, [r2, #0]		/* see what is at 0 */
	
        mov     r3, #SZ_32M		
        cmp     r1, r3			/* is it 32M ??? */
        beq     memSizeDetected32M

	/*
	 * Q for jamey:	why return beef for 16M machines?
	 * Nothing really uses the return value, but still...
	 */
#if 0
        mov     r1, #SZ_16M
#else	
	orr     r1, r1, #0x000000ef
	orr     r1, r1, #0x0000be00
#endif	

/* 16MB uses same memory controller configuration as 32MB (same number of row bits, fewer column bits */
 
memSizeDetected64M:	
memSizeDetected32M:
#if 1
	str	r7, [r6]
#else
	/* test code */
	mov	r7, #0x03
	str	r7, [r6, #4]
	ldr	r7, [r6]
	str	r7, [r6, #8]
#endif	

	
#if 1
	str	r5, [r4]
#else	
	/* test code */
	mov	r5, #0x03
	str	r5, [r4, #4]
	ldr	r5, [r4]
	str	r5, [r4, #8]
#endif
	
	mov     r0, r1			/* move size to r0 */

        mov	pc, lr			/* All done, return*/

	/*
	;; ********************************************************************
	;; PrintHexNibble -- prints the least-significant nibble in R0 as a
	;; hex digit
        ;;   r0 contains nibble to write as Hex
        ;;   r1 contains base of serial port
        ;;   writes r0 with RXSTAT, modifies r0,r2 
	;;   Falls through to PrintChar
	;; ********************************************************************
	*/
PrintHexNibble:	
	adr	r2, _C_LABEL(HEX_TO_ASCII_TABLE)
	and	r0, r0, #0xF
	ldr	r0, [r2,r0]	/* convert to ascii */
	b       _C_FUNC(PrintChar)

	/*
	;; ********************************************************************
	;; PrintChar -- prints the character in R0
        ;;   r0 contains the character
        ;;   r1 contains base of serial port
        ;;   writes r0 with UTSR1, modifies r0,r1,r2
	;;********************************************************************
	*/

ENTRY(PrintChar)
	# see if printing is disabled
	ldr     r2, Boot_flags_ptr
	ldr	r2, [r2]
	tst	r2, #BF_SQUELCH_SERIAL
	movne	pc, lr		/* return if squelched */

TXBusy:	
        ldr     r2,[r1,#SA1100_UTSR1]/* check status*/
	tst     r2,#SA1100_UTSR1_TNF /* TX not full */
        beq     TXBusy
	str	r0,[r1,#SA1100_UTDR]
	ldr     r0,[r1,#SA1100_UTSR1]
        mov     pc, lr
	
	/*
        ;; ********************************************************************
	;; PrintWord -- prints the 4 characters in R0
        ;;   r0 contains the binary word
        ;;   r1 contains the base of the serial por
        ;;   writes r0 with RXSTAT, modifies r1,r2,r3,r4
	;; ********************************************************************
	*/
PrintWord:	
	mov	r3, r0
	mov     r4, lr
	bl      _C_FUNC(PrintChar)     
	
	mov     r0,r3,LSR #8    /* shift word right 8 bits*/
	bl      _C_FUNC(PrintChar)
	
	mov     r0,r3,LSR #16   /* shift word right 16 bits*/
	bl      _C_FUNC(PrintChar)
	
	mov     r0,r3,LSR #24   /* shift word right 24 bits*/
	bl      _C_FUNC(PrintChar)

	mov	r0, #'\r'
	bl	_C_FUNC(PrintChar)

	mov	r0, #'\n'
	bl	_C_FUNC(PrintChar)
	
        mov     pc, r4

	/*
        ;; ********************************************************************
	;; PrintHexWord -- prints the 4 bytes in R0 as 8 hex ascii characters
	;;   followed by a newline
        ;;   r0 contains the binary word
        ;;   r1 contains the base of the serial port
        ;;   Writes r0 with RXSTAT, modifies r1,r2,r3,r4
ENTRY(PrintHex)
	;; ********************************************************************
	*/
PrintHexWord:	
	mov     r4, lr
	mov	r3, r0
	mov	r0, r3,LSR #28
	bl      PrintHexNibble     
	mov	r0, r3,LSR #24
	bl      PrintHexNibble     
	mov	r0, r3,LSR #20
	bl      PrintHexNibble     
	mov	r0, r3,LSR #16
	bl      PrintHexNibble     
	mov	r0, r3,LSR #12
	bl      PrintHexNibble     
	mov	r0, r3,LSR #8
	bl      PrintHexNibble     
	mov	r0, r3,LSR #4
	bl      PrintHexNibble     
	mov	r0, r3
	bl      PrintHexNibble     

	mov	r0, #'\r'
	bl	_C_FUNC(PrintChar)

	mov	r0, #'\n'
	bl	_C_FUNC(PrintChar)

        mov     pc, r4

	/*
	;; ********************************************************************
	;; copy - copies are region from addr in r0 to r1. r2=stopping point
        ;;   r0 contains target region address
        ;;   r1 contains source region address
        ;;   r2 contains region length
	;; ********************************************************************
	*/
copy:	
	add     r2, r2, r1      /* end of source region in r2 */
1:      	
	cmp	r1,r2
	ldrlt	r3,[r0],#4
	strlt	r3,[r1],#4
	blt	1b
	mov	pc,lr

	/*
	;; ********************************************************************
	;; zi_init - initializes memory region
        ;;  r0 contains target region start address
        ;;  r1 contains target region size
        ;;  r2 contains value to write
	;; ********************************************************************
	*/
zi_init:	
	add     r1, r1, r0      /* put end address (exclusive) into r1 */
1:      
	cmp	r0,r1
	strlt	r2,[r0],#4
	blt	1b
	mov	pc,lr

	/*
	;; ********************************************************************
	;; enableMMU
	;; ********************************************************************
	*/
ENTRY(enableMMU)
	/*; r0 = translation table base*/
	ldr	r0,DW_MMU_TABLE
	mcr	p15, 0, r0, c2, c0, 0

	/*; r0 = domain access control*/
	ldr	r0,MMU_DOMCTRL
	mcr	p15, 0, r0, c3, c0, 0


	/*; enable the MMU*/
	mrc	p15, 0, r0, c1, c0, 0
	orr	r0, r0, #1      /* bit 0 of c1 is MMU enable*/
#ifdef CACHE_ENABLED	
	orr	r0, r0, #4      /* bit 2 of c1 is DCACHE enable*/
	orr	r0, r0, #8      /* bit 3 of c1 is WB enable*/
#endif	
	mcr	p15, 0, r0, c1, c0, 0

	/*
	;; flush the I/D caches
        ;;  c7 == cache control operation register
        ;;  crm==c7 opc2==0 indicates Flush I+D Cache
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c7, c7, 0x00
	/*
        ;; flush the I+D TLB
        ;;  c8 is TLB operation register
        ;;  crm=c7 opc2==0 indicates Flush I+D TLB
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c8, c7, 0x00 
	
	/*; return*/
	mov	pc,lr		

	/*
	;; ********************************************************************
	;; flushTLB
	;; ********************************************************************
	*/
ENTRY(flushTLB)
	/*
	;; flush the I/D caches
        ;;  c7 == cache control operation register
        ;;  crm==c7 opc2==0 indicates Flush I+D Cache
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c7, c7, 0x00
	/*
        ;; flush the I+D TLB
        ;;  c8 is TLB operation register
        ;;  crm=c7 opc2==0 indicates Flush I+D TLB
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c8, c7, 0x00 

	mcr	p15, 0, r0, c7, c5, 0
	mov	r0, r0
	mov	r0, r0	
/*;; return*/
	mov	pc,lr		
ENTRY(writeBackDcache)
	/*
	;; r0 points to the start of a 16384 byte region of readable 
	;; data used only for this cache flushingroutine. If this area 
	;; is to be used by other code, then 32K must be loaded and the
	;; flush mcr is not needed.
	/*

	/*; return:	 r0,r1,r2 trashed. data cache is clean*/
	add r1,r0,#32768
l1:	
	ldr r2,[r0],#32
	teq r1, r0
	bne l1
	mcr p15,0,r0,c7,c6,0
	mov pc,lr
	
ENTRY(readCPR1)
        mrc     p15,0,r0,c1,c0,0
        mov     pc,lr
	
ENTRY(readCPR3)
        mrc     p15,0,r0,c3,c0,0
        mov     pc,lr
	
	/*
	;; ********************************************************************
	;; boot - boots into another image. DOES NOT RETURN!
	;; r0 = pointer to bootinfo
	;; r1 = entry point of kernel
	;; ********************************************************************
	*/
ENTRY(boot)
	/*
        ;; flush the I+D TLB
        ;;  c8 is TLB operation register
        ;;  crm=c7 opc2==0 indicates Flush I+D TLB
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c8, c7, 0x00 /* flush I+D TLB */
        mcr     p15, 0, r0, c7, c10, 4 /* drain the write buffer*/

        /*; make sure the pipeline is emptied*/
        mov     r0,r0
        mov     r0,r0
        mov     r0,r0
        mov     r0,r0

	mov	pc,r1		/* jump to addr. bootloader is done*/

	/*
	;; ********************************************************************
	;; bootLinux - boots into another image. DOES NOT RETURN!
	;; r0 = must contain a zero or else the kernel loops
        ;; r1 = architecture type (6 for old kernels, 17 for new)
	;; r2 = entry point of kernel
	;; ********************************************************************
	*/
ENTRY(bootLinux)
	mov     r10, r1
	mov     r11, r2
	/*
        ;; flush the I+D TLB
        ;;  c8 is TLB operation register
        ;;  crm=c7 opc2==0 indicates Flush I+D TLB
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c8, c7, 0x00 /* flush I+D TLB */
        mcr     p15, 0, r0, c7, c10, 4 /* drain the write buffer*/

	mov     r3, #0x130
	mcr     p15, 0, r3, c1, c0, 0   /* disable the MMU */
        /*; make sure the pipeline is emptied*/
        mov     r0,#0
        mov     r0,r0
        mov     r0,r0
        mov     r0,r0

	adr     r2, _C_FUNC(delayedBreakpointPC)
	mov     r0, #0
        mov     r1, r10
	ldr     r2, [r2, #0]
	mov	pc, r11		/* jump to addr. bootloader is done*/

	.align 5
#ifdef HAS_REBOOT_COMMAND
	/* 
	 * remove reboot command until we make it *really* reboot
	 * things.  As it is, doesn't really work  or make much sense.
	 */
	/*
	;; ********************************************************************
	;; reboot - restarts the bootloader. DOES NOT RETURN!
	;; ********************************************************************
	*/
ENTRY(reboot)
       	/*; disable the instruction/data write buffer caches*/
	mrc	p15,0,r2,c1,c0,0
	mov	r3,#~4
	AND	r2,r2,r3
	mov	r3,#~8
	AND	r2,r2,r3
	mov	r3,#~0x1000
	AND	r2,r2,r3
	mcr	p15,0,r2,c1,c0,0

	/*
	;; flush the caches
	;; flush the I/D caches
        ;;  c7 == cache control operation register
        ;;  crm==c7 opc2==0 indicates Flush I+D Cache
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c7, c7, 0x00
	/*
        ;; flush the I+D TLB
        ;;  c8 is TLB operation register
        ;;  crm=c7 opc2==0 indicates Flush I+D TLB
        ;;  r0 is ignored
	*/
	mcr	p15, 0, r0, c8, c7, 0x00
        mcr     p15, 0, r0, c7, c10, 4 /* drain the write buffer*/

        /*; make sure the pipeline is emptied*/
        mov     r0,r0
        mov     r0,r0
        mov     r0,r0

	b	HiReset
#endif /* HAS_REBOOT_COMMAND */

	/*
	;; ********************************************************************
	;; Data Area
	;; ********************************************************************
	*/

	.align 2
CRC32POLY:	
	.word	0x04c11db7
	
	.align	2
addr_start:	
	.word	_C_FUNC(ResetEntryPoint)

	.align	2
/*ENTRY(HEX_TO_ASCII_TABLE)*/
	.globl _C_LABEL(HEX_TO_ASCII_TABLE)
_C_LABEL(HEX_TO_ASCII_TABLE):
	.ascii	"0123456789ABCDEF"

	.align	2
STR_STACK:	
	.ascii	"STKP"

	.align	2
DW_STACK_START:	
	.word	STACK_BASE+STACK_SIZE-4
	
	.align	2
DW_MMU_TABLE:	
	.word	MMU_TABLE_START

	.align	2
DW_CACHE_FLUSH_REGION:	
	.word	CACHE_FLUSH_BASE
	
	.align	2
MMU_DOMCTRL:	
	.word	0xFFFFFFFF

	.align	2
STR_MTST:	
        .ascii	"MTST"
	.align	2
STR_MB2:	
        .ascii	"MBK2"
	.align	2
STR_ENDM:	
        .ascii	"ENDM"
	.align	2
STR_PRECACHE:
        .ascii  "PRE$"	
	.align 2
STR_POSTCACHE:
        .ascii  "PST$"	
	.align 2
STR_PREZERO:
        .ascii  "PREZ"	
	.align 2
STR_POSTZERO:
        .ascii  "PSTZ"	
	.align 2
STR_POSTFLUSH:
        .ascii  "FLSH"	
	.align 2
STR_UNDEF:	
        .ascii	"UNDF"

	.align	2
STR_SWI:	
        .ascii  "SWI "

	.align	2
STR_PREFETCH_ABORT:	
        .ascii	"PABT"

	.align	2
STR_DATA_ABORT:	
        .ascii	"DABT"
	.word   0

	.align	2
STR_IRQ:	
        .ascii	"IRQ "

	.align	2
STR_FIQ:	
        .ascii	"FIQ"
	
	.align	2
STR_NOT_USED:	
        .ascii	"NUSD"

	.align	2
STR_MEM_ERROR:
	.ascii	"DRAM ERROR"

	.align	2
STR_WAKEUP:	
        .ascii	"WKUP"

	.align	2
STR_WAKEUP_SKIP:	
        .ascii	"SKWU"
		
	.globl _C_FUNC(delayedBreakpointPC)
_C_FUNC(delayedBreakpointPC):
        .long   0

	/*; ******************************************************************/
	

.align 4
dram_mdcnfg_enable:
	.long  MDCNFG_BANK0_ENABLE
.align 4	
dram_mdcnfg_64mb:     /* DRAM Configuration [1] 10.2 */
	/* Bitsy development board uses two banks? KM416S4030C, 12 row address bits, 8 col address bits */
	/* Bitsy uses two banks KM416S8030C, 12 row address bits, 9 col address bits */
        /* Have to set DRAC0 to 15 row bits or else you only get 9 col bits */
	/* read from the formfactor unit configuration registers:	 0xF3536257 */
	.long  (MDCNFG_DTIM0_SDRAM | MDCNFG_DWID0_32B \
                | MDCNFG_DRAC0(6) |  MDCNFG_TRP0(3) | MDCNFG_TDL0(3) | MDCNFG_TWR0(3))

.align 4	
dram_mdcnfg_64mbX:     /* DRAM Configuration [1] 10.2 */
	.long  (MDCNFG_BANK0_ENABLE| MDCNFG_DTIM0_SDRAM | MDCNFG_DWID0_32B \
                | MDCNFG_DRAC0(6) |  MDCNFG_TRP0(3) | MDCNFG_TDL0(3) | MDCNFG_TWR0(3))
		
dram_mdcnfg_32mb:     /* DRAM Configuration [1] 10.2 */
	/* Bitsy development board uses two banks? KM416S4030C, 12 row address bits, 8 col address bits */
	/* Bitsy uses two banks KM416S8030C, 12 row address bits, 9 col address bits */
        /* Have to set DRAC0 to 14 row bits or else you only get 8 col bits */
	/* read from the formfactor unit configuration registers:	 0xF3536257 */
#if defined(CONFIG_JORNADA720)
	.long  (MDCNFG_BANK0_ENABLE | MDCNFG_DTIM0_SDRAM | MDCNFG_DWID0_32B \
                | MDCNFG_DRAC0(5) |  MDCNFG_TRP0(2) | MDCNFG_TDL0(3) | MDCNFG_TWR0(1))
#else
	.long  (MDCNFG_BANK0_ENABLE | MDCNFG_DTIM0_SDRAM | MDCNFG_DWID0_32B \
                | MDCNFG_DRAC0(5) |  MDCNFG_TRP0(3) | MDCNFG_TDL0(3) | MDCNFG_TWR0(3))
#endif /* CONFIG_JORNADA720) */
	
dram_mdcnfg_16mb:     /* DRAM Configuration [1] 10.2 */
	/* Bitsy development board uses two banks? KM416S4030C, 12 row address bits, 8 col address bits */
	/* Bitsy uses two banks KM416S8030C, 12 row address bits, 9 col address bits */
	/* read from the formfactor unit configuration registers:	 0xF3536257 */
	.long  (MDCNFG_BANK0_ENABLE | MDCNFG_DTIM0_SDRAM | MDCNFG_DWID0_32B \
                | MDCNFG_DRAC0(4) |  MDCNFG_TRP0(3) | MDCNFG_TDL0(3) | MDCNFG_TWR0(3))
			
	/* MDCAS settings from [1] Table 10-3 (page 10-18) */
dram_cas0_waveform0:
#if defined(CONFIG_JORNADA720)
        .long 0x5555557f
#else
        .long 0xAAAAAAA7
#endif /* CONFIG_JORNADA720) */
dram_cas0_waveform1:
#if defined(CONFIG_JORNADA720)
        .long 0x55555555
#else
        .long 0xAAAAAAAA
#endif /* CONFIG_JORNADA720) */
dram_cas0_waveform2:
#if defined(CONFIG_JORNADA720)
        .long 0x55555555
#else
	.long 0xAAAAAAAA
#endif /* CONFIG_JORNADA720) */
dram_mdrefr:	
#if defined(CONFIG_JORNADA720)
	.long (MDREFR_TRASR(1) | MDREFR_DRI(42) | MDREFR_E1PIN | MDREFR_K1RUN | MDREFR_K1DB2 \
	| MDREFR_K0DB2 | MDREFR_EAPD | MDREFR_KAPD)
#else
	.long (MDREFR_TRASR(1) | MDREFR_DRI(512) | MDREFR_E1PIN | MDREFR_K1RUN)
#endif /* CONFIG_JORNADA720) */

#if defined(CONFIG_BITSY) || defined(CONFIG_ASSABET) || defined(CONFIG_NEPONSET)
msc0_config:    	
        .long ( ( (MSC_RT_ROMFLASH | MSC_RBW32 | MSC_RDF(14) | MSC_RDN(3) | MSC_RRR(2)) <<  0 )  /* MEMBNK0 150ns flash */ \
        |       ( (MSC_RT_ROMFLASH | MSC_RBW32 | MSC_RDF(31) | MSC_RDN(31) | MSC_RRR(7)) << 16 ) /* MEMBNK1 */ )
msc1_config:    
        .long ( ( (MSC_RT_ROMFLASH | MSC_RBW16 | MSC_RDF(31) | MSC_RDN(31) | MSC_RRR(7)) <<  0 ) /* MEMBNK2 */ \
        |       ( (MSC_RT_ROMFLASH | MSC_RBW16 | MSC_RDF(31) | MSC_RDN(31) | MSC_RRR(7)) << 16 )  /* MEMBNK3 */)
msc2_config:
        .long ( ( (MSC_RT_ROMFLASH | MSC_RBW16 | MSC_RDF(31) | MSC_RDN(31) | MSC_RRR(7)) <<  0 ) /* MEMBNK4 */ \
        |       ( (MSC_RT_BURST4 | MSC_RBW32 | MSC_RDF(3) | MSC_RDN(3) | MSC_RRR(2)) << 16 )  /* MEMBNK5: EGPIO */)
mecr_config:
        .long 0x994A994A /*; read from registers while WinCE was running */
#elif defined(CONFIG_JORNADA720)
msc0_config:    	
        .long 0xFFF04F78;
msc1_config:    
        .long 0xFFF8FFF0;
msc2_config:
        .long 0x201D2959;
mecr_config:
        .long 0x98C698C6;
#endif /* CONFIG_JORNADA720 */	 
.align 4
SDLCBase:	
	.long SA1100_SDLCBASE
	.globl _C_LABEL(Ser1Base)
_C_LABEL(Ser1Base):
	.long SA1100_UART1BASE
	.globl _C_LABEL(Ser3Base)
_C_LABEL(Ser3Base):       	
	.long SA1100_UART3BASE
	.globl _C_LABEL(SerBase)
_C_LABEL(SerBase):
#ifdef CONFIG_ASSABET
	.long SA1100_UART1BASE
#else
	.long SA1100_UART3BASE
#endif	
SA1100_PPCR_ADDRESS:
	.long SA1100_PPCR_REG
SA1100_ICMR_ADDRESS:
	.long SA1100_ICMR_REG
	
#ifdef CONFIG_POWERMGR
SA1100_RCSR_ADDRESS:
	.long SA1100_RCSR_REG
SA1100_PSSR_ADDRESS:
	.long SA1100_PSSR_REG
SA1100_PSPR_ADDRESS:
	.long SA1100_PSPR_REG
#endif	
	
#if defined(CONFIG_ASSABET) || defined(CONFIG_NEPONSET)
BCRBase:
	.long ASSABET_BCR
#endif
#if defined(CONFIG_BITSY)
EGPIOBase:
        .long BITSY_EGPIO

boot_flags_init_val:
	.long	BF_SQUELCH_SERIAL
	
	.globl _C_LABEL(Boot_flags_ptr)
_C_LABEL(Boot_flags_ptr):
	.long SA1100_PWER
#endif

mdrefr_valid_bits_after_reset:	
	.long MDREFR_SLFRSH|MDREFR_KAPD|MDREFR_EAPD|MDREFR_K2DB2|MDREFR_K1RUN|MDREFR_E1PIN|MDREFR_K0DB2
