#!/usr/bin/env python

"""
convert a gimp .h output file to binary, compress w/zlib then output
the compressed binary.
Also, compresses the color data to 4 bits/color, selecting the
high order bits. 

Output is suitable for input to bin2h.py for conversion to a C array.
"""

import sys, os, string, zlib

if len(sys.argv) > 1:
    infile = sys.argv[1]
    f = open(infile)
else:
    f = sys.stdin

w = -1
h = -1
depth_in_bytes = 3

ST_INIT = 1
ST_DIMS = 2

state = ST_INIT

def dprintf(fmt, *args):
    if args:
        fmt = fmt % args
    sys.stderr.write(fmt)

line_buf = []
line_buf_idx = 0
def getword(f):
    global line_buf
    global line_buf_idx

    while line_buf == []:
        dprintf("filling line\n")
        line = f.readline()
        if line[0] == '#':
            dprintf('discard comment>%s<\n', line)
            continue
        if not line:
            return line
        line_buf = string.split(line)

    dprintf("buf>%s<\n", line_buf)
    ret = line_buf.pop(0)
    dprintf("ret>%s<\n", ret)
    return (ret)
    
while 1:
    tok = getword(f)
    dprintf('tok>%s<\n', tok)
    
    if not tok:
        print >>sys.stderr, 'Cannot find start of data.'
        sys.exit(2)

    if state == ST_INIT:
        if tok == 'P3' or tok == 'P6':
            if tok == 'P3':
                type = 'ascii'
            else:
                type = 'binary'
            state = ST_DIMS
        else:
            print >>sys.stderr, "Bad format in pnm file, tok>%s<." % tok
            sys.exit(2)

    elif state == ST_DIMS:
        w = eval(tok)
        h = eval(getword(f))
        if w != 320 or h != 240:
            print >>sys.stderr, "Unsupported dimensions in pnm file."
            print >>sys.stderr, 'w: %d, h: %d' % (w, h)
            sys.exit(2)
        getword(f)                # read & discard the color depth
        break


def from_ascii(f):
    i = 0
    odata = []
    t = ''
    while 1:
        line = f.readline()
        if not line or line == '\n':
            break
        for n in string.split(line):
            t += chr(string.atoi(n))

        if len(t) > 256:
            odata.append(t)
            t = ''

        i += 4
        if i % 1000 == 0:
            print >>sys.stderr, '<',

    if t:
        odata.append(t)
        
    return string.join(odata, '')

def from_bin(f):
    print >>sys.stderr, '<',
    num = w * h * depth_in_bytes
    s = f.read(num)
    print >>sys.stderr, '<',
    return s

if type == 'binary':
    data = from_bin(f)
else:
    #print >>sys.stderr, 'ascii not supported yet.'
    #sys.exit(1)
    data = from_ascii(f)
    
i = 0
data_len = len(data)
odata = []
t = ''
while i < data_len:
    r = ord(data[i])
    g = ord(data[i+1])
    b = ord(data[i+2])

    bpix = ((r & 0xf0)<<4) | ((g & 0xf0)) | ((b & 0xf0)>>4)
    #print '0x%x 0x%x 0x%x==>%x' % (r, g, b, bpix)

    # little endian
    t += chr(bpix & 0x00ff) + chr((bpix>>8) & 0x00ff)
    
    # t += chr((bpix>>8) & 0x00ff) + chr(bpix & 0x00ff)
    if len(t) > 256:
        odata.append(t)
        t = ''

    i += 3
    if i % 1000 == 0:
        print >>sys.stderr, '>',

if t:
    odata.append(t)
data = string.join(odata, '')
    
zdata = zlib.compress(data, 9)

#of = open('bz', 'w')
#of.write(zdata)
#of.close()

sys.stdout.write(zdata)
print >>sys.stderr, 'len of zdata:', len(zdata)

sys.exit(0)

