/****************************************************************************/
/* Copyright 2000 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
	;; ********************************************************************
	;; Boot Loader Configuration
	;; Change this when the board configuration changes
        ;;      
        ;; Copyright 1999 Compaq Computer Corporation
        ;; All Rights Reserved
	;;
	;; ********************************************************************

; /* handy sizes */
SZ_1K				EQU	0x00000400
SZ_4K				EQU	0x00001000
SZ_16K				EQU	0x00004000
SZ_32K				EQU	0x00008000
SZ_48K				EQU	0x0000C000
SZ_64K				EQU	0x00010000
SZ_256K				EQU	0x00040000
SZ_512K				EQU	0x00080000

SZ_1M				EQU	0x00100000
SZ_2M				EQU	0x00200000
SZ_3M				EQU	0x00300000
SZ_4M				EQU	0x00400000
SZ_8M				EQU	0x00800000
SZ_16M				EQU	0x01000000
SZ_32M				EQU	0x02000000
SZ_64M				EQU	0x04000000
SZ_128M				EQU	0x08000000
SZ_256M				EQU	0x10000000
SZ_512M				EQU	0x20000000
SZ_1G				EQU	0x40000000
SZ_2G				EQU	0x80000000

PAGE_MASK                       EQU     (4096-1)

;;; Memory sizes
FLASH_BASE			EQU	0x41000000
FLASH_SIZE			EQU	SZ_4M	; amount of Flash onboard
DRAM_SIZE			EQU	SZ_16M	; amount of SDRAM onboard
;PCI_WINDOW_SIZE			EQU	0xFC0000; 16 MB
PCI_WINDOW_SIZE			EQU	0x3FC0000; 64 MB
BOOT_DATA_SIZE                  EQU     SZ_32K;  memory used for the RW data in bootldr
BOOT_DATA_START                 EQU     (DRAM_SIZE-BOOT_DATA_SIZE)
MMU_TABLE_SIZE			EQU	SZ_16K
MMU_TABLE_START			EQU	(BOOT_DATA_START-MMU_TABLE_SIZE)
STACK_SIZE			EQU	SZ_16K	; size of C stack
STACK_BASE			EQU	(MMU_TABLE_START-STACK_SIZE)
CACHE_FLUSH_SIZE		EQU	SZ_16K
CACHE_FLUSH_BASE		EQU	(STACK_BASE-CACHE_FLUSH_SIZE)
;; a place to put the bootldr when we're programming flash
FLASH_IMG_SIZE			EQU	SZ_1M ; this cannot change!!
FLASH_IMG_START			EQU	(DRAM_SIZE - SZ_3M)
HEAP_SIZE			EQU	SZ_4M
HEAP_START			EQU	(FLASH_IMG_START - HEAP_SIZE)
	
;;; PCI configuration space
PCI_CONFIGURATION_BASE		EQU	0x7bc00000
USB_CONFIGURATION_OFFSET	EQU	0x800
USB_CONFIGURATION_BASE		EQU	(PCI_CONFIGURATION_BASE+USB_CONFIGURATION_OFFSET)
	
;;; PCI memory space
;USB_MEMORY_BASE			EQU	SZ_64M; is this right?
USB_MEMORY_BASE			EQU	SZ_1M
CARDBUS_SOCKET1_MEMORY_BASE	EQU	(USB_MEMORY_BASE + 4096)
CARDBUS_SOCKET2_MEMORY_BASE	EQU	(CARDBUS_SOCKET1_MEMORY_BASE + 4096)


;;; SDRAM Mode Register Settings
SDRAM_MODE_WM			EQU	(0<<9)  ;  burst writes
;SDRAM_MODE_LTMODE		EQU	(2<<4)  ;  TCAS is 2 cycles
SDRAM_MODE_LTMODE		EQU	(3<<4)  ;  TCAS is 3 cycles
SDRAM_MODE_BT			EQU	(0<<3)  ;  sequential
SDRAM_MODE_BL			EQU     (2)     ; 4 cycle bursts

	
;;; SDRAM timings -- change if we use different memory chips between revs.
;;; See page 7-31/32 of the 21285 datasheet for details
SDRAM_TRP			EQU	0	; 0=1,1=2,2=3,3=4 cycles
SDRAM_TDAL			EQU	(0<<2)	; 0=2,1=3,2=4,3=5 cycles
SDRAM_TRCD			EQU	(2<<4)	; 2=2 cycles, 3=3 cycles
;SDRAM_TCAS			EQU	(2<<6)  ; 2=2 cycles, 3=3 cycles
SDRAM_TCAS			EQU	(3<<6)  ; 2=2 cycles, 3=3 cycles
SDRAM_TRC			EQU	(1<<8)	; 1=4 cycles
SDRAM_CMD_DRV_TIME		EQU	(0<<11)	; 0=same  cycle
SDRAM_PARITY_ENABLE		EQU	(0<<12)	; 0=no parity
SDRAM_SA110_PRIME		EQU	(0<<13)	; 0=don't drive parity info
SDRAM_TREF			EQU	(6<<16)	; wait 6 cycles before refresh

;;; SDRAM Address and Size Register Settings - change for diff. mem loadouts
;;; See page 7-33 of the 21285 datasheet for details
SDRAM_ARRAY0_ARRAYSIZE		EQU	5	; 16 MB
SDRAM_ARRAY0_ADDRMULTIPLEX	EQU	(4<<4)	; 16 MB (see Table 4-1)
SDRAM_ARRAY0_ARRAYBASE		EQU	0	; locate at 0x0000
SDRAM_ARRAY0_ADDRSIZE		EQU	(SDRAM_ARRAY0_ARRAYSIZE:OR:\
                                        SDRAM_ARRAY0_ADDRMULTIPLEX:OR:\
					SDRAM_ARRAY0_ARRAYBASE)
;SDRAM_ARRAY0_ADDRSIZE		EQU	0x045   ; 16MB, located @ 0
SDRAM_ARRAY1_ADDRSIZE		EQU	0	; array disabled
SDRAM_ARRAY2_ADDRSIZE		EQU	0	; array disabled
SDRAM_ARRAY3_ADDRSIZE		EQU	0	; array disabled

	;; Flash Timing
FLASH_ACCESS_TIME		EQU	3
FLASH_BURST_TIME		EQU	3
FLASH_TRISTATE_TIME		EQU	2
	
;UART_H_UBRLCR                   EQU     0x60	; no BRK,no parity,1 stop bit,
						; only use top entry in FIFO,
						; 8 data bits
UART_H_UBRLCR                   EQU     0x70	; no BRK,no parity,1 stop bit,
						; use all of FIFO,8 data bits
;UART_H_UBRLCR			EQU	0x78	; no BRK,no parity,2 stop bits,
						; use all of FIFO, 8 data bits
;UART_H_UBRLCR			EQU	0x7A	; 8 O 2, NO BRK, use all FIFO

	
RXSTAT_FRAME_ERROR		EQU	1	; bit zero set on frame error
RXSTAT_PARITY_ERROR		EQU	2	; bit one set on parity error
RXSTAT_OVERRUN_ERROR		EQU	4	; bit two set on FIFO overrun

UART_TX_BUSY                    EQU     (1<<3)  ; TX FIFO nonempty and UART enabled
UART_TX_FIFO_BUSY               EQU	(1<<5)	; TX FIFO busy flag
UART_RX_FIFO_EMPTY		EQU	(1<<4)	; 1 if no data
	END
	
