/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * hardware abstraction layer (hal)
 *
 */

#include "bootldr.h"
#include "commands.h"
#ifdef __linux__
#include <asm-arm/setup.h>
#include <asm/arch-sa1100/h3600_gpio.h>
#include <asm/arch-sa1100/h3600_asic.h>	
#endif
#include "sa1100.h"
#include "bsdsum.h"
#include "architecture.h"
#include "hal.h"

struct hal_ops *hal_ops;

static int h3600_get_version( struct hal_version * );
static int h3600_eeprom_read( unsigned short address, unsigned char *data, unsigned short len );
static int h3600_eeprom_write( unsigned short address, unsigned char *data, unsigned short len );
static int h3600_get_thermal_sensor( unsigned short * );
static int h3600_set_notify_led( unsigned char mode, unsigned char duration, 
                                 unsigned char ontime, unsigned char offtime );
static int h3600_spi_read( unsigned short address, unsigned char *data, unsigned short len );
static int h3600_get_option_detect( int *result )
{
        int opt_ndet = (SA1100_GPIO_GPLR_READ() & GPIO_H3600_OPT_DET);

	*result = opt_ndet ? 0 : 1;
	return 0;
}

static struct hal_ops h3600_hal_ops = {
  get_option_detect: h3600_get_option_detect,
};

static struct hal_ops h3100_hal_ops = {
  get_option_detect: h3600_get_option_detect,
};

static struct hal_ops h3800_hal_ops = {
  get_option_detect: NULL,
};

void hal_init(int mach_type) 
{
  hal_ops = 0;
  switch (mach_type) {
  case MACH_TYPE_H3100:
    hal_ops = &h3100_hal_ops;
    break;
  case MACH_TYPE_H3600:
    hal_ops = &h3600_hal_ops;
    break;
  case MACH_TYPE_H3800:
    hal_ops = &h3800_hal_ops;
    break;
  }
}

void
command_hal(
    int		argc,
    const char*	argv[])
{
  if (strcmp(argv[1], "init") == 0) {
    int mach_type = strtoul(argv[2], 0, NULL);
    hal_init(mach_type);
    putLabeledWord("hal_ops=", hal_ops);
  } else if (strcmp(argv[1], "detect") == 0) {
    int detect = 0;
    hal_get_option_detect(&detect);
    putLabeledWord("opt detect=", detect);
  } else {
     putstr(argv[1]); putstr("\r\n");
     putstr("usage: hal init\r\n");
     putstr("       hal detect\r\n");
  }
}
SUBCOMMAND(hal, init, command_hal, "hal init -- initialize hardware abstraction layer", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(hal, detect, command_hal, "hal detect -- detects hardware abstraction layer", BB_RUN_FROM_RAM, 0);
