#if defined(CONFIG_INFRARED)
#if defined(CONFIG_BITSY) || defined(CONFIG_SPOT) || defined(CONFIG_JORNADA720)  || defined(CONFIG_JORNADA56X) || defined(CONFIG_GATOR)

#include "commands.h"
#include "serial.h"
#include "sa1100.h"
/*
 * See p300- of the SA-1100 Developer's Manual, developer.intel.com/design/strong/manuals/278240.htm
 * IrLite specifications
 * http://www.hw-server.com/docs/irda/irda.html
 * TODO:
 * - fill out the code
 * - change serial.c and serial.h to have a cur_serial variable or something like that
 */

void irda_setup() {
  /* disable RXE and TXE */
  (*(volatile byte *) SA1100_UART2_UTCR3) = 0;
  /* no parity, 1 stop bit, 8 bits data */
  (*(volatile byte *) SA1100_UART2_UTCR0) = 8;
  /* 9600 baud */
  (*(volatile byte *) SA1100_UART2_UTCR1) = 0;
  (*(volatile byte *) SA1100_UART2_UTCR2) = 8;
  /* enable low power mode (p308 of SA-1100 DM) */
  (*(volatile byte *) SA1100_UART2_UTCR4) = 2; 
  /* ready to receive */
  (*(volatile byte *) SA1100_UART2_UTCR3) = 1;
}

int sa1100_ir_char_ready() {
  return ((*(volatile long *)SA1100_UART2_UTSR1) & SA1100_UTSR1_RNE);
}

unsigned char sa1100_ir_read_char() {
  return (*(volatile byte *)SA1100_UART2_UTDR);
}

unsigned int sa1100_ir_read_status() {
  return ((*(volatile byte *)SA1100_UART2_UTSR1) & SA1100_UTSR1_ERROR_MASK);
}

void sa1100_ir_write_char(struct serial_device *device, unsigned char c) {
  if (!device->enabled) return;
  while (!((*(volatile long *)SA1100_UART2_UTSR1) & SA1100_UTSR1_TNF)); /* wait until TX FIFO not full */
  *(byte *) SA1100_UART2_UTDR = c;
}

static struct serial_device irda = { sa1100_ir_char_ready, sa1100_ir_read_char, sa1100_ir_read_status, sa1100_ir_write_char, 0, 0, 0, 1 };

COMMAND(ir_con, command_ir_con, "ir_con -- starts an infrared terminal (secondary)", BB_RUN_FROM_RAM);
void command_ir_con(int argc, const char **argv) {
  byte b;
  putstr("This doesn't really do anything yet, except turn on IR (hopefully!). Setting up IR...\r\n");
  irda_setup();
  putstr("Part of your flash should blink when IR signals are received.\r\n");
  putstr("I _will_ go into an infinite loop, though.\r\n");
  while (1) {
	if (irda.char_ready()) {
	  lcd_invert_region(0, 0, 50, 50);
	  b = serial_getc(&irda);
	}
  }
}

#endif
#endif
