/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * drivers/pcmcia/h3600_generic
 *
 * PCMCIA implementation routines for H3600 iPAQ standards sleeves
 *
 */

#include "bootldr.h"
#ifdef __linux__
#include <asm-arm/setup.h>
#include <asm/arch-sa1100/h3600_gpio.h>
#include <asm/arch-sa1100/h3600_asic.h>	
#endif
#include "sa1100.h"
#include "bsdsum.h"
#include "architecture.h"
#include "hal.h"

#define __KERNEL__
#include "list.h"
#include <asm/arch/h3600-sleeve.h>
#include <asm/arch/linkup-l1110.h>
#include "pcmcia.h"

static struct linkup_l1110 *dual_pcmcia_sleeve[2]; 

/*************************************************************************************/
/*     
       Compact Flash sleeve 
*/
/*************************************************************************************/

static struct pcmcia_ops cf_pcmcia_ops = {
   name: "single cf",
};

static int cf_probe_sleeve(struct sleeve_dev *sleeve_dev, const struct sleeve_device_id *ent)
{
   putstr(__FUNCTION__ "\r\n");
   set_egpio(EGPIO_BITSY_OPT_ON);
   pcmcia_register_ops(&cf_pcmcia_ops);
   return 0;
}

static void cf_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
   putstr(__FUNCTION__ "\r\n");
   clr_egpio(EGPIO_BITSY_OPT_ON);
}

static struct sleeve_device_id cf_tbl[] = {
   { COMPAQ_VENDOR_ID, SINGLE_COMPACTFLASH_SLEEVE },
   { 0, }
};

static struct sleeve_driver cf_driver = {
   name:     "Compaq Compact Flash Sleeve",
   id_table: cf_tbl,
   probe:    cf_probe_sleeve,
   remove:   cf_remove_sleeve,
};


/*************************************************************************************/
/*     
       Single slot PCMCIA sleeve 
*/
/*************************************************************************************/

static struct pcmcia_ops single_pcmcia_ops = {
   name: "single pcmcia",
};

static int pcmcia_probe_sleeve(struct sleeve_dev *sleeve_dev, 
                               const struct sleeve_device_id *ent)
{
   putstr(__FUNCTION__ "\r\n");
   set_egpio(EGPIO_BITSY_OPT_ON);
   pcmcia_register_ops(&single_pcmcia_ops);
   return 0;
}

static void pcmcia_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
   putstr(__FUNCTION__ "\r\n");
}

static struct sleeve_device_id pcmcia_tbl[] = {
   { COMPAQ_VENDOR_ID, SINGLE_PCMCIA_SLEEVE },
   { 0, }
};

static struct sleeve_driver pcmcia_driver = {
   name:     "Compaq PC Card Sleeve",
   id_table: pcmcia_tbl,
   probe:    pcmcia_probe_sleeve,
   remove:   pcmcia_remove_sleeve,
};


/*************************************************************************************/
/*     
       Compaq Dual Sleeve
*/
/*************************************************************************************/


static struct pcmcia_ops dual_pcmcia_ops = {
   name: "dual pcmcia",
};

static int dual_pcmcia_probe_sleeve(struct sleeve_dev *sleeve_dev, 
                                    const struct sleeve_device_id *ent)
{
   putstr(__FUNCTION__ "\r\n");
   set_egpio(EGPIO_BITSY_OPT_ON);
   pcmcia_register_ops(&dual_pcmcia_ops);
   return 0;
}

static void dual_pcmcia_remove_sleeve(struct sleeve_dev *sleeve_dev)
{
   putstr(__FUNCTION__ "\r\n");
}

static struct sleeve_device_id dual_pcmcia_tbl[] = {
   { COMPAQ_VENDOR_ID, DUAL_PCMCIA_SLEEVE },
   { 0, }
};

static struct sleeve_driver dual_pcmcia_driver = {
   name:     "Compaq Dual PC Card Sleeve",
   id_table: dual_pcmcia_tbl,
   probe: dual_pcmcia_probe_sleeve,
   remove: dual_pcmcia_remove_sleeve,
};

/*************************************************************************************/

int h3600_generic_pcmcia_init_module(void)
{
   putstr(__FUNCTION__ ": registering sleeve drivers\r\n");
   h3600_sleeve_register_driver(&cf_driver);
   h3600_sleeve_register_driver(&pcmcia_driver);
   h3600_sleeve_register_driver(&dual_pcmcia_driver);
   return 0;
}

void h3600_generic_pcmcia_exit_module(void)
{
   putstr(__FUNCTION__ ": unregistering sleeve drivers\r\n");
   h3600_sleeve_unregister_driver(&cf_driver);
   h3600_sleeve_unregister_driver(&pcmcia_driver);
   h3600_sleeve_unregister_driver(&dual_pcmcia_driver);
} 

