/*
 *  July 5, 2000    Architecture defintions
 *
 *                   -- George France <france@crl.dec.com>
 */

/* ARM CPU Identifier Register */
#define ARM_ID_MASK		(0xfffffff0)
#define ARM_VERSION_MASK	(0x0000000f)
#define ARM_ID_SA110		(0x4401a100)
#define ARM_ID_SA1100		(0x4401a110)
#define ARM_ID_SA1110		(0x6901b110)

/* There can be 255 platforms       ( 8 bit)
   Each platform can have 255 cpus  ( 8 bit)
   Each cpu can have 65355 machines (16 bit) */

#define ARM_PLATFORM   1
   #define ARM_SA110_CPU   1
   #define ARM_SA1100_CPU  2
   #define ARM_SA1110_CPU  3

#define MIPS_PLATFORM  2

#define SKIFF_MACH      1
#define ITSY_MACH       2 
#define BITSY_MACH      3
#define ASSABET_MACH	4
#define SPOT_MACH       5
#define JORNADA720_MACH	6
#define GATOR_MACH	7
#define JORNADA56X_MACH 8

#define ASSABET_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | ASSABET_MACH)
#define BITSY_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | BITSY_MACH)
#define JORNADA720_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | JORNADA720_MACH)
#define SKIFF_ARCH ((ARM_PLATFORM << 24) | (ARM_SA110_CPU  << 16) | SKIFF_MACH )
#define SPOT_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | SPOT_MACH)
#define GATOR_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | GATOR_MACH)
#define JORNADA56X_ARCH ((ARM_PLATFORM << 24) | (ARM_SA1110_CPU << 16) | JORNADA56X_MACH)

#ifdef CONFIG_ASSABET
#define ARCHITECTURE_MAGIC ASSABET_ARCH
#endif
#ifdef CONFIG_BITSY
#define ARCHITECTURE_MAGIC BITSY_ARCH
#endif
#ifdef CONFIG_JORNADA720
#define ARCHITECTURE_MAGIC JORNADA720_ARCH
#endif
#ifdef CONFIG_JORNADA56X
#define ARCHITECTURE_MAGIC JORNADA56X_ARCH
#endif
#ifdef CONFIG_SKIFF
#define ARCHITECTURE_MAGIC SKIFF_ARCH
#endif
#ifdef CONFIG_SPOT
#define ARCHITECTURE_MAGIC SPOT_ARCH
#endif
#ifdef CONFIG_GATOR
#define ARCHITECTURE_MAGIC GATOR_ARCH
#endif
