/****************************************************************************/
/* Copyright 2002 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * support for booting linux
 *
 */

/*
 * Maintainer: Jamey Hicks (jamey@crl.dec.com)
 */

#include "commands.h"
#include "bootldr.h"
#include "btflash.h"
#include "bootlinux.h"
#include "heap.h"
#include "params.h"

#ifdef __linux__
#include <mtd-bootldr.h>
#include <asm-arm/setup.h>
#endif

#ifdef __linux__
void setup_ramdisk_from_flash(void)
{
  const char *initrd_partition_name = (const char *)param_initrd_partition.value;
  struct FlashRegion *initrd_partition = btflash_get_partition(initrd_partition_name);

  if (initrd_partition) {
    param_use_initrd.value = 1;
    param_copy_initrd.value = 1;
    param_initrd_start.value = initrd_partition->base + FLASH_BASE;
    param_initrd_size.value = initrd_partition->size;
  }
}

void setup_linux_params(long bootimg_dest, long memc_ctrl_reg, long dram_size, const char *cmdline)
{
   int rootdev = 0x00ff;
   struct tag *tag;
   int i;
   int npartitions = partition_table->npartitions;
   int newcmdlinelen = 0;
   char *newcmdline = NULL;

   // add the partition table to the commandline
   //  Format suggested by Nicolas Pitre: mtdpart=<name1>@<size1>:<offset1>[,<name2>@<size2>:<offset2>[,...]]
   newcmdlinelen = strlen(cmdline) + 9 + 64*npartitions;
   newcmdline = mmalloc(newcmdlinelen);
   memset(newcmdline, 0, newcmdlinelen);
   strcpy(newcmdline, "mtdpart=");
   for (i = 0; i < npartitions; i++) {
     if (i != 0)
       strcat(newcmdline, ",");
     strcat(newcmdline, partition_table->partition[i].name);
     strcat(newcmdline, "@0x"); 
     binarytohex(newcmdline+strlen(newcmdline), partition_table->partition[i].base, 4);
     strcat(newcmdline, ":0x"); 
     binarytohex(newcmdline+strlen(newcmdline), partition_table->partition[i].size, 4);
   }
   strcat(newcmdline, " ");
   strcat(newcmdline, cmdline);
   cmdline = newcmdline;

   // start with the core tag       
   tag = (struct tag *)(bootimg_dest + 0x100);
   
   putLabeledWord("Makeing core tag at ",(unsigned long) tag);
   
   tag->hdr.tag = ATAG_CORE;
   tag->hdr.size = tag_size(tag_core);
   tag->u.core.flags =0;
   tag->u.core.pagesize = LINUX_PAGE_SIZE;
   tag->u.core.rootdev = rootdev;
   tag = tag_next(tag);

   // now the cmdline tag
   putLabeledWord("Makeing cmdline tag at ",(unsigned long) tag);
   tag->hdr.tag = ATAG_CMDLINE;
   // must be at least +3!! 1 for the null and 2 for the ???
   tag->hdr.size = (strlen(cmdline) + 3 + sizeof(struct tag_header)) >> 2;
   //tag->hdr.size = (strlen(cmdline) + 10 + sizeof(struct tag_header)) >> 2;
   strcpy(tag->u.cmdline.cmdline,cmdline);
   tag = tag_next(tag);

   // now the mem32 tag
   putLabeledWord("Makeing mem32 tag at ",(unsigned long) tag);
   tag->hdr.tag = ATAG_MEM;
   tag->hdr.size = tag_size(tag_mem32);
   tag->u.mem.size = dram_size;
   tag->u.mem.start = 0xc0000000;
   tag = tag_next(tag);
       
   // and the ptable tag
   putLabeledWord("Makeing ptable tag at ",(unsigned long) tag);
   tag->hdr.tag = ATAG_PTABLE_COMPAT;
   tag->hdr.size = (sizeof(struct tag_ptable)
		    + sizeof(struct bootldr_flash_region) * partition_table->npartitions
		    + 3 + sizeof(struct tag_header)) >> 2;
   tag->u.ptable.magic = partition_table->magic;
   tag->u.ptable.npartitions = partition_table->npartitions;
   for (i=0; i < partition_table->npartitions;i++){
       strcpy(tag->u.ptable.partition[i].name,
	      partition_table->partition[i].name);
       tag->u.ptable.partition[i].base = partition_table->partition[i].base;
       tag->u.ptable.partition[i].size = partition_table->partition[i].size;
       tag->u.ptable.partition[i].flags = partition_table->partition[i].flags;
   }
   tag = tag_next(tag);
       
   /* and now the initrd tag */
   if (param_use_initrd.value) {
      putLabeledWord("Makeing initrd tag at ",(unsigned long) tag);
      putLabeledWord("  initrd.start=", param_initrd_start.value);
      putLabeledWord("  initrd.size=", param_initrd_size.value);
      tag->hdr.tag = ATAG_INITRD;
      tag->hdr.size = tag_size(tag_initrd);
      tag->u.initrd.start = param_initrd_start.value;
      tag->u.initrd.size = param_initrd_size.value;
      tag = tag_next(tag);
   }

   // now the NULL tag
   tag->hdr.tag = ATAG_NONE;
   tag->hdr.size = 0;
       
   
   putLabeledWord("dram_size=", dram_size);
   putstr("command line is: ");
   putstr(cmdline);
   putstr("\r\n");
}
#endif
