/****************************************************************************/
/* Copyright 2002 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * gpio.c - General Purpose IO Interface routines
 */

#include "bootldr.h"
#include "sa1100.h"
#include "params.h"

#ifdef CONFIG_BITSY
/* The EGPIO is a write only control register at physical address 0x49000000
 * See the hardware spec for more details.
 */

static int egpio = EGPIO_BITSY_RS232_ON;
void set_egpio(int mask)
{
    unsigned long mach_type = param_mach_type.value;
    switch (mach_type){
    case MACH_TYPE_H3100:
    case MACH_TYPE_H3600:
	egpio |= mask;
	*(volatile int *)BITSY_EGPIO = egpio;
	break;
    case MACH_TYPE_H3800:
    default:
	break;
    }

}
void clr_egpio(int mask)
{
    unsigned long mach_type = param_mach_type.value;

    switch (mach_type){
    case MACH_TYPE_H3100:
    case MACH_TYPE_H3600:
	egpio &= ~mask;
	*(volatile int *)BITSY_EGPIO = egpio;
	break;
    case MACH_TYPE_H3800:
    default:
	break;
    }
}
#endif
