/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * bootldr.h
 */
#ifndef _PARAMS_H_
#define _PARAMS_H_


#define PT_TYPE 0x7
typedef enum ParamType {
   PT_NONE = 0,
   PT_INT = 1,
   PT_STRING = 2,
   PT_READONLY = 8
} ParamType;
typedef enum ParamFormat {
   PF_DECIMAL,
   PF_HEX,
   PF_STRING,
   PF_LOGICAL
} ParamFormat;

struct bootblk_param {
   const char *name;
   ParamType   paramType;
   ParamFormat paramFormat;
   long        value;
   void        (*update)(struct bootblk_param *param);
};

#define __paramdata	__attribute__ ((__section__ (".data.param")))

#define PARAM(name_, pt_, pf_, init_, update_) \
  struct bootblk_param __paramdata param_ ## name_ = { #name_, pt_, pf_, init_, update_ } 

extern struct bootblk_param __params_begin;
extern struct bootblk_param __params_end;


struct bootblk_param *get_param(const char *name);
int get_param_value(const char *name, void *value_p);

void update_baudrate(struct bootblk_param *param);
void update_dcache_enabled(struct bootblk_param *param);
void update_icache_enabled(struct bootblk_param *param);
void update_os(struct bootblk_param *param);
void update_linux_entry_point(struct bootblk_param *param);
void update_unzip_kernels(struct bootblk_param *param);
void update_xmodem_block_size(struct bootblk_param *param);
void update_unzip_ramdisk(struct bootblk_param *param);
void set_serial_number(struct bootblk_param *param);
void set_system_rev(struct bootblk_param *param);



extern struct bootblk_param param_autoboot_kernel_part;
extern struct bootblk_param param_autoboot_timeout;
extern struct bootblk_param param_baudrate;
extern struct bootblk_param param_boot_file;
extern struct bootblk_param param_boot_type;
extern struct bootblk_param param_calb_cmd;
extern struct bootblk_param param_cmdex;
extern struct bootblk_param param_conb_cmd;
extern struct bootblk_param param_conf_file;
extern struct bootblk_param param_copy_ramdisk;
extern struct bootblk_param param_copy_initrd;
extern struct bootblk_param param_dcache_enabled;
extern struct bootblk_param param_dns1;
extern struct bootblk_param param_dns2;
extern struct bootblk_param param_domainname;
extern struct bootblk_param param_downb_cmd;
extern struct bootblk_param param_dram_size;
extern struct bootblk_param param_entry;
extern struct bootblk_param param_force_unzip;
extern struct bootblk_param param_gateway;
extern struct bootblk_param param_hostname;
extern struct bootblk_param param_icache_enabled;
extern struct bootblk_param param_initrd_partition;
extern struct bootblk_param param_initrd_size;
extern struct bootblk_param param_initrd_start;
extern struct bootblk_param param_ipaddr;
extern struct bootblk_param param_jffs2_sector_marker0;
extern struct bootblk_param param_jffs2_sector_marker1;
extern struct bootblk_param param_jffs2_sector_marker2;
extern struct bootblk_param param_kernel_filename;
extern struct bootblk_param param_kernel_in_ram;
extern struct bootblk_param param_kernel_partition;
extern struct bootblk_param param_leftb_cmd;
extern struct bootblk_param param_linuxargs;
extern struct bootblk_param param_linuxargs;
extern struct bootblk_param param_mach_type;
extern struct bootblk_param param_maclsbyte;
extern struct bootblk_param param_mem_fclk_21285;
extern struct bootblk_param param_memc_ctrl_reg;
extern struct bootblk_param param_netcfg;
extern struct bootblk_param param_netmask;
extern struct bootblk_param param_nfs_server_address;
extern struct bootblk_param param_nfsroot;
extern struct bootblk_param param_noerase;
extern struct bootblk_param param_os;
extern struct bootblk_param param_override;
extern struct bootblk_param param_ptable_addr;
extern struct bootblk_param param_qb_cmd;
extern struct bootblk_param param_ramdisk_addr;
extern struct bootblk_param param_recb_cmd;
extern struct bootblk_param param_rightb_cmd;
extern struct bootblk_param param_serial_number;
extern struct bootblk_param param_startb_cmd;
extern struct bootblk_param param_suppress_splash;
extern struct bootblk_param param_system_rev;
extern struct bootblk_param param_upb_cmd;
extern struct bootblk_param param_use_initrd;
extern struct bootblk_param param_use_new_commands;
extern struct bootblk_param param_verbose;
extern struct bootblk_param param_xmodem_initial_timeout;
extern struct bootblk_param param_xmodem_one_nak;
extern struct bootblk_param param_xmodem_timeout;
extern struct bootblk_param param_ymodem;

#endif // _PARAMS_H_
