/****************************************************************************/
/* Copyright 2001 Compaq Computer Corporation.                              */
/*                                           .                              */
/* Copying or modifying this code for any purpose is permitted,             */
/* provided that this copyright notice is preserved in its entirety         */
/* in all copies or modifications.  COMPAQ COMPUTER CORPORATION             */
/* MAKES NO WARRANTIES, EXPRESSED OR IMPLIED, AS TO THE USEFULNESS          */
/* OR CORRECTNESS OF THIS CODE OR ITS FITNESS FOR ANY PARTICULAR            */
/* PURPOSE.                                                                 */
/****************************************************************************/
/*
 * PCMCIA/CF card support
 *
 */

#include "bootldr.h"
#ifdef __linux__
#include <asm-arm/arch-sa1100/h3600_gpio.h>
#include <asm-arm/arch-sa1100/h3600_asic.h>	
#endif
#include "sa1100.h"
#include "bsdsum.h"
#include "commands.h"
#include "architecture.h"
#include "hal.h"
#include "ide.h"

#define __KERNEL__
#include "list.h"
#include <asm-arm/arch-sa1100/h3600-sleeve.h>
#include "pcmcia.h"

struct card_info card_info[2];

int generic_sa1100_pcmcia_map_mem(u8 socket, size_t len, int cis, char **mapping)
{
    if (mapping) {
        if (socket == 0)
            *mapping = (char*)0x28000000;
        else
            *mapping = (char*)0x38000000;
        if (cis == 0)
            *mapping += 0x04000000;
        return 0;
    } else {
        return -EINVAL;
    }
}

int generic_sa1100_pcmcia_map_io(u8 socket, size_t len, char **mapping)
{
    if (mapping) {
        *mapping = (char*)(socket ? 0x20000000 : 0x30000000 );
        return 0;
    } else {
        return -EINVAL;
    }
}

struct pcmcia_ops generic_pcmcia_ops_st = {
    name: "generic ops",
    map_mem: generic_sa1100_pcmcia_map_mem,
    map_io: generic_sa1100_pcmcia_map_io,
};

struct pcmcia_ops *generic_pcmcia_ops = &generic_pcmcia_ops_st;
struct pcmcia_ops *pcmcia_ops = NULL;

void pcmcia_init_module(void)
{
    putstr(__FUNCTION__ "\r\n");

}

void pcmcia_register_ops(struct pcmcia_ops *ops)
{
    putLabeledWord(__FUNCTION__ ": ops=", (unsigned long)ops);
    pcmcia_ops = ops;
}

int pcmcia_read_cis(int sock)
{
    volatile short *mapping = 0;
    int i = 0;
    memset(&card_info[sock].funcid, 0, sizeof(struct card_info));
    pcmcia_map_mem(sock, SZ_1M, 1, &mapping);
    putLabeledWord("cis mapping=", (long)mapping);
    putLabeledWord("cis[0] =", mapping[0]);
    while (i < 256) {
        short type = mapping[i++];
        short len = mapping[i++];
        int j;
        if (type == CIS_TUPLE_END || len == 0) {
            putstr("end\r\n"); 
            break;
        }
        putstr("  "); putHexInt8(type); putstr(" "); putHexInt8(len);
        for (j = 0; j < len; j++) {
            putstr(" "); putHexInt8(mapping[i+j]); 
        }
        putstr("\r\n");
        switch (type) {
        case CIS_TUPLE_MANFID:
            card_info[sock].manfid[0] = mapping[i];
            card_info[sock].manfid[1] = mapping[i+1];
            putLabeledWord("  manfid[0]=", card_info[sock].manfid[0]);
            putLabeledWord("  manfid[1]=", card_info[sock].manfid[1]);
            break;
        case CIS_TUPLE_FUNCID:
            putLabeledWord("  funcid=", mapping[i]);
            card_info[sock].funcid = mapping[i];
            if (mapping[i] == CIS_FUNCID_FIXED)
                putstr("    fixed disk\r\n");
            break;
        }
        i += len;
    }
    return 0;
}

int pcmcia_detect(u8 *detect)
{
  if (detect) {
    *detect = 0;
    if (!(SA1100_GPIO_GPLR_READ() & GPIO_H3600_PCMCIA_CD0))
      *detect |= 1;
    if (!(SA1100_GPIO_GPLR_READ() & GPIO_H3600_PCMCIA_CD1))
      *detect |= 2;
  } else {
    return -EINVAL;
  }
  return 0;
}

int pcmcia_insert(void)
{
    int sock;
    for (sock = 0; sock < 2; sock++) {
        pcmcia_card_insert(sock);
        delay_seconds(1);
        pcmcia_read_cis(sock); 
        if (card_info[sock].funcid == CIS_FUNCID_FIXED) {
            char *mapping = 0;
            pcmcia_map_mem(sock, SZ_1M, 0, &mapping);
            ide_attach((volatile char *)mapping);
            delay_seconds(1);
        }
    }
    return 0;
}

SUBCOMMAND(pcmcia, detect, command_pcmcia, "          -- detect presence of pcmcia/cf cards", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, cis,    command_pcmcia, "[slotno]  -- show card information services (CIS) data ", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, insert, command_pcmcia, "[slotno]  -- enable and bind driver to card(s)", BB_RUN_FROM_RAM, 0);
SUBCOMMAND(pcmcia, eject,  command_pcmcia, "[slotno]  -- disable card(s)", BB_RUN_FROM_RAM, 0);

void
command_pcmcia(
    int		argc,
    const char*	argv[])
{
    if (strcmp(argv[1], "init") == 0) {
        pcmcia_init_module();
    } else if (strcmp(argv[1], "detect") == 0) {
        u8 detect = 0;
        pcmcia_detect(&detect);
        putLabeledWord("pcmcia detect=", detect);
    } else if (strcmp(argv[1], "cis") == 0) {
        unsigned short *mapping;
        int i = 0;
        int sock = strtoul(argv[2], 0, 0);
        pcmcia_map_mem(sock, SZ_1M, 1, (char*)&mapping);
        putLabeledWord("cis mapping=", (long)mapping);
        while (i < 256) {
            short type = mapping[i++];
            short len = mapping[i++];
            int j;
            if (type == CIS_TUPLE_END || len == 0) {
                putstr("end\r\n"); 
                break;
            }
            putstr("  "); putHexInt8(type); putstr(" "); putHexInt8(len);
            for (j = 0; j < len; j++) {
                putstr(" "); putHexInt8(mapping[i+j]); 
            }
            putstr("\r\n");
            switch (type) {
            case CIS_TUPLE_FUNCID:
                putLabeledWord("  funcid=", mapping[i]);
                if (mapping[i] == CIS_FUNCID_FIXED)
                    putstr("    fixed disk\r\n");
                break;
            }
            i += len;
        } 
    } else if (strcmp(argv[1], "insert") == 0) {
        pcmcia_insert();
    } else if (strcmp(argv[1], "eject") == 0) {
        putstr("eject is currently a no-op\r\n");
    } else {
        putstr("usage: pcmcia detect|insert|cis <socknum>|eject [socketno]\r\n");
    }
}
