#ifndef __SERIAL_H__
#define __SERIAL_H__

/*
 * Serial device support
 */

struct serial_device {
   /* 
    * returns true if there is a character in the input fifo
    */
   int (*char_ready)(void);
   /* 
    * Reads a character from the input fifo
    */
   unsigned char (*read_char)(void);

   /*
    * Reads the UART status
    */
   unsigned int (*read_status)(void);

   /*
    * Writes a character to the output FIFO
    */
   void (*write_char)(struct serial_device *, unsigned char);

   /*
    * Sets the DCD, etc. modem control lines
    */
   void (*set_modem_control)(unsigned int mctrl);
   /*
    * Reads the status of the DCD, etc. modem control lines
    */
   int (*get_modem_control)();
   /*
    * Returns the serial base
	*/
   void * (*serbase)();
   unsigned short enabled;    /* opposite of squelched */
};

extern void serial_putc(struct serial_device *device, char c);
extern byte serial_do_getc(struct serial_device *device, vfuncp idler, unsigned long timeout, int* statp);
extern byte serial_do_getc_seconds(struct serial_device *device, vfuncp	    idler,
							unsigned long   timeout_seconds,
							int*	    statp);

extern byte serial_getc(struct serial_device *device);
extern byte serial_awaitkey(struct serial_device *device, unsigned long delay, int* error_p);
extern byte serial_awaitkey_seconds(struct serial_device *device, unsigned long delay_seconds, int* error_p);

/* Uses the default serial device just so that we don't have to rewrite all of the rest of the code */
extern void putc(char c);
extern byte awaitkey_seconds(unsigned long delay_seconds, int* error_p);
extern void do_putnstr(const char *s, int n);
extern void putnstr(const char *s, int n);
extern void putstr(const char *s);
extern void putstr_sync(const char* s);
extern void do_putnstr(const char* s, int n);

extern unsigned char getc();

extern int getc_verbose_errors;
extern int getc_errno;
extern int packetize_output;

static struct serial_device serial;
#endif
