#ifndef BOOT_FLAGS_H_INCLUDED
#define BOOT_FLAGS_H_INCLUDED

/*
 * these bits control the boot flow.
 * They are stored initially in the SA1100_PWER register.
 * Then, once RAM is running, they are stored in RAM
 * The current location is pointed to by Boot_flags_ptr.
 */

#define	BF_SQUELCH_SERIAL	(1<<0)
#define	BF_SLEEP_RESET		(1<<1)
#define	BF_NORMAL_BOOT		(1<<2)

#ifndef __ASSEMBLY__
extern unsigned long*	boot_flags_ptr;
#endif

#define	squelch_serial()	((*boot_flags_ptr) & BF_SQUELCH_SERIAL)
#define	clr_squelch_serial()    (*boot_flags_ptr &= ~BF_SQUELCH_SERIAL)
#define	set_squelch_serial()    (*boot_flags_ptr |=  BF_SQUELCH_SERIAL)

#define	tst_sleep_reset()	((*boot_flags_ptr) & BF_SLEEP_RESET)
#define	clr_sleep_reset()	(*boot_flags_ptr &= ~BF_SLEEP_RESET)
#define	set_sleep_reset()	(*boot_flags_ptr |=  BF_SLEEP_RESET)

#define	normal_boot()		((*boot_flags_ptr) & BF_NORMAL_BOOT)
#define	clr_normal_boot()	(*boot_flags_ptr &= ~BF_NORMAL_BOOT)
#define	set_normal_boot()	(*boot_flags_ptr |=  BF_NORMAL_BOOT)


#if defined(CONFIG_BITSY)
#define BL_SIG		"BTSY"
#elif defined(CONFIG_SKIFF)
#define BL_SIG		"SKIF"
#elif defined(CONFIG_ASSABET)
#define BL_SIG		"ASBT"
#elif defined(CONFIG_NEPONSET)
#define BL_SIG		"NEPO"
#elif defined(CONFIG_JORNADA720) || defined(CONFIG_JORNADA56X)
#define BL_SIG		"JRND"
#else
#define BL_SIG          "UNKN"
#endif

#define BL_SIG_OFFSET	0x34
#if defined(CONFIG_BITSY)
#define DO_SPLASH	1
#define CHECK_FOR_FUNC_BUTTONS	1
#elif defined(CONFIG_ASSABET)
#define DO_SPLASH	1
#define CHECK_FOR_FUNC_BUTTONS	0
#elif defined(CONFIG_SPOT) || defined(CONFIG_GATOR)
#define DO_SPLASH	0
#define CHECK_FOR_FUNC_BUTTONS	0
#elif defined(CONFIG_JORNADA720) || defined(CONFIG_JORNADA56X)
#define DO_SPLASH	0
#define CHECK_FOR_FUNC_BUTTONS	0
#endif

#endif
