H51110
s 00000/00001/00082
d D 1.9 03/04/03 08:37:30 vnuorval 10 9
c removed unused IPV6_TNL_STOLEN
cC
cK60298
cZ+03:00
e
s 00005/00000/00078
d D 1.8 03/02/18 12:46:02 vnuorval 9 8
c publish ipv6 tunnel init and cleanup functions
cC
cHdsl-hkigw1je9.dial.inet.fi
cK62266
cZ+02:00
e
s 00003/00003/00075
d D 1.7 02/08/09 14:09:15 ville 8 7
c corrected indentation with Lindent
cC
cK50948
e
s 00011/00001/00067
d D 1.6 02/08/09 12:05:11 ville 7 6
c fixed bugs in tunnel encapsulation limit sub-option and error handling
cK50366
e
s 00033/00037/00035
d D 1.5 02/08/02 12:31:56 ville 6 5
c general cleanup of tunnel code,
c updated comments,
c fixed MTU bug,
c fixed manual tunnel configuration routines
cK28341
e
s 00007/00001/00065
d D 1.4 02/05/14 16:59:57 ville 5 4
c ipv6_tunnel: removed old debug code and started using lists from list.h
c addrconf.c & mipv6: reverse tunneling works OK (at least without multi-access)
cK40042
e
s 00011/00001/00055
d D 1.3 02/02/25 15:40:38 ville 4 3
c added referece count to tunnels
c added cleanup code for scheduled tasks on exit
cK31493
e
s 00005/00001/00051
d D 1.2 02/01/15 12:04:34 ville 3 2
c dynamic tunnel generation
cK23540
e
s 00052/00000/00000
d D 1.1 01/11/07 14:14:44 ville 2 1
c - tunneling done by virtual tunnel devices
c - proxy protects against DAD
c - patches to IPv6 code included from kernel 2.4.13
cK60696
cZ-00:00
e
s 00000/00000/00000
d D 1.0 70/01/01 03:09:62 BK 1 0
c RCS to BitKeeper
cBtorvalds@athlon.transmeta.com|ChangeSet|20020205173056|16047|c1d11a41ed024864
cK00065
cPinclude/net/ipv6_tunnel.h
cO-rw-rw-r--
cRe6d57f224385772
cT 
cV4
cX0x23
e
u
U
f e 0
f x 0x23
t

T
I 2
/*
 * $Id$
 */

#ifndef _NET_IPV6_TUNNEL_H
#define _NET_IPV6_TUNNEL_H

#include <linux/ipv6.h>
#include <linux/netdevice.h>
#include <linux/ipv6_tunnel.h>
#include <linux/skbuff.h>
I 4
#include <asm/atomic.h>
E 4

D 6
#define IPV6_TUNNEL_MAX 128
E 6
I 6
#define IPV6_TNL_MAX 128
E 6

I 7
/* IPv6 tunnel */

E 7
D 6
struct ipv6_tunnel {
	struct ipv6_tunnel *next; /* next tunnel in current list */
D 3
	struct net_device *dev; /* virtual device associated with tunnel */
E 3
I 3
 	struct net_device *dev; /* virtual device associated with tunnel */
E 3
	struct net_device_stats stat; /* statistics for tunnel device */
D 4
	int recursion;      /* depth of hard_start_xmit recursion */
E 4
I 4
	int recursion; /* depth of hard_start_xmit recursion */
E 4
	struct ipv6_tunnel_parm parms; /* tunnel configuration paramters */
	struct flowi fl; /* flowi template for xmit */
I 4
	atomic_t refcnt; /* number of identical tunnels used by kernel */
E 6
I 6
struct ipv6_tnl {
	struct ipv6_tnl *next;	/* next tunnel in list */
	struct net_device *dev;	/* virtual device associated with tunnel */
	struct net_device_stats stat;	/* statistics for tunnel device */
	int recursion;		/* depth of hard_start_xmit recursion */
	struct ipv6_tnl_parm parms;	/* tunnel configuration paramters */
	struct flowi fl;	/* flowi template for xmit */
D 7
	atomic_t refcnt;	/* number of identical tunnels used by kernel */
E 7
I 7
	atomic_t refcnt;	/* nr of identical tunnels used by kernel */
E 7
E 6
E 4
};

D 6
#define IPV6_TUNNEL_PRE_ENCAP 0
#define IPV6_TUNNEL_PRE_DECAP 1
#define IPV6_TUNNEL_MAXHOOKS 2

#define IPV6_TUNNEL_DROP 0
#define IPV6_TUNNEL_ACCEPT 1
#define IPV6_TUNNEL_STOLEN 2

typedef int ipv6_tunnel_hookfn(struct ipv6_tunnel *t, 
			       struct sk_buff *skb, 
			       __u32 flags);
E 6
I 6
#define IPV6_TNL_PRE_ENCAP 0
#define IPV6_TNL_PRE_DECAP 1
#define IPV6_TNL_MAXHOOKS 2
E 6

D 6
struct ipv6_tunnel_hook_ops {
E 6
I 6
#define IPV6_TNL_DROP 0
#define IPV6_TNL_ACCEPT 1
D 10
#define IPV6_TNL_STOLEN 2
E 10

typedef int ipv6_tnl_hookfn(struct ipv6_tnl *t, struct sk_buff *skb);

struct ipv6_tnl_hook_ops {
E 6
D 5
	struct ipv6_tunnel_hook_ops *next;
E 5
I 5
	struct list_head list;
E 5
	unsigned int hooknum;
I 5
	int priority;
E 5
D 6
	ipv6_tunnel_hookfn *hook;
E 6
I 6
	ipv6_tnl_hookfn *hook;
E 6
I 5
};

D 6
enum ipv6_tunnel_hook_priorities {
	IPV6_TUNNEL_PRI_FIRST = INT_MIN,
	IPV6_TUNNEL_PRI_LAST = INT_MAX
E 6
I 6
enum ipv6_tnl_hook_priorities {
	IPV6_TNL_PRI_FIRST = INT_MIN,
	IPV6_TNL_PRI_LAST = INT_MAX
E 6
E 5
};
I 7

/* Tunnel encapsulation limit destination sub-option */

struct ipv6_tlv_tnl_enc_lim {
D 8
	__u8	type;			/* type-code for option 	*/
	__u8	length;			/* option length 		*/
	__u8	encap_limit;	       	/* tunnel encapsulation limit 	*/
E 8
I 8
	__u8 type;		/* type-code for option         */
	__u8 length;		/* option length                */
	__u8 encap_limit;	/* tunnel encapsulation limit   */
E 8
} __attribute__ ((packed));
E 7

#ifdef __KERNEL__
D 6
extern struct ipv6_tunnel *
ipv6_ipv6_tunnel_lookup(struct in6_addr *remote, struct in6_addr *local);
E 6
I 6
extern struct ipv6_tnl *ipv6_ipv6_tnl_lookup(struct in6_addr *remote,
					     struct in6_addr *local);
E 6
I 4

E 4
D 6
extern int ipv6_ipv6_kernel_tunnel_add(struct ipv6_tunnel_parm *p);
E 6
I 6
extern int ipv6_ipv6_kernel_tnl_add(struct ipv6_tnl_parm *p);
E 6
I 4

E 4
D 6
extern int ipv6_ipv6_kernel_tunnel_del(struct ipv6_tunnel *t);
E 6
I 6
extern int ipv6_ipv6_kernel_tnl_del(struct ipv6_tnl *t);
E 6
I 4

E 4
I 3
D 6
extern unsigned int ipv6_ipv6_tunnel_inc_max_kdev_count(unsigned int n);
E 6
I 6
extern unsigned int ipv6_ipv6_tnl_inc_max_kdev_count(unsigned int n);
E 6
I 4

E 4
D 6
extern unsigned int ipv6_ipv6_tunnel_dec_max_kdev_count(unsigned int n);
E 6
I 6
extern unsigned int ipv6_ipv6_tnl_dec_max_kdev_count(unsigned int n);
E 6
I 4

E 4
D 6
extern unsigned int ipv6_ipv6_tunnel_inc_min_kdev_count(unsigned int n);
E 6
I 6
extern unsigned int ipv6_ipv6_tnl_inc_min_kdev_count(unsigned int n);
E 6
I 4

E 4
D 6
extern unsigned int ipv6_ipv6_tunnel_dec_min_kdev_count(unsigned int n);
E 6
I 6
extern unsigned int ipv6_ipv6_tnl_dec_min_kdev_count(unsigned int n);
E 6
I 4

E 4
E 3
D 6
extern void 
ipv6_ipv6_tunnel_register_hook(struct ipv6_tunnel_hook_ops *reg);
E 6
I 6
extern void ipv6_ipv6_tnl_register_hook(struct ipv6_tnl_hook_ops *reg);
E 6
I 4

E 4
D 6
extern void 
ipv6_ipv6_tunnel_unregister_hook(struct ipv6_tunnel_hook_ops *reg);
E 6
I 6
extern void ipv6_ipv6_tnl_unregister_hook(struct ipv6_tnl_hook_ops *reg);
I 9

#ifdef CONFIG_IPV6_IPV6_TUNNEL
extern int __init ipv6_ipv6_tnl_init(void);
extern void __exit ipv6_ipv6_tnl_exit(void);
#endif
E 9
E 6
#endif
#endif
E 2
I 1
E 1
