Summary: The libraries needed to run the GNU Emacs text editor.
Name: emacs
%define	version	20.4
Version: %{version}
Release: 2_nw1
Copyright: GPL
Group: Applications/Editors
Source0: ftp://ftp.gnu.org/pub/gnu/emacs-%{version}.tar.gz
Source1: ftp://ftp.gnu.org/pub/gnu/leim-%{version}.tar.gz
Source2: emacs.wmconfig
Patch0: emacs-20.2-xaw3d.patch
Patch1: emacs-20.2-gctags.patch
Patch2: emacs-20.3-tmprace.patch
Patch3: emacs-20.3-linkscr.patch
Patch4: emacs-20.4-nmhlocation.patch
Patch5: emacs-armconfig.patch
Buildroot: /var/tmp/%{name}-root

%description
Emacs is a powerful, customizable, self-documenting, modeless text
editor. Emacs contains special code editing features, a scripting
language (elisp), and the capability to read mail, news and more without
leaving the editor.

This package includes the libraries you need to run the Emacs editor, so
you need to install this package if you intend to use Emacs.  You also
need to install the actual Emacs program package (emacs-nox or emacs-X11).
Install emacs-nox if you are not going to use the X Window System; install
emacs-X11 if you will be using X.

%package el
Summary: The sources for elisp programs included with Emacs.
Group: Applications/Editors
Requires: emacs

%description el
Emacs-el contains the emacs-elisp sources for many of the elisp
programs included with the main Emacs text editor package.

You need to install emacs-el only if you intend to modify any of the
Emacs packages or see some elisp examples.

%package leim
Summary: Emacs Lisp code for input methods for internationalization.
Group: Applications/Editors
Requires: emacs

%description leim
The Emacs Lisp code for input methods for various international
character scripts.

%package nox
Summary: The Emacs text editor without support for the X Window System.
Group: Applications/Editors
Requires: emacs

%description nox
Emacs-nox is the Emacs text editor program without support for
the X Window System.

You need to install this package only if you plan on exclusively using
Emacs without the X Window System (emacs-X11 will work both in X and out
of X, but emacs-nox will only work outside of X).  You'll also need to
install the emacs package in order to run Emacs.

%package X11
Summary: The Emacs text editor for the X Window System.
Group: Applications/Editors
Requires: emacs

%description X11
Emacs-X11 includes the Emacs text editor program for use with the X
Window System (it provides support for the mouse and other GUI
elements). Emacs-X11 will also run Emacs outside of X, but it has a
larger memory footprint than the 'non-X' Emacs package (emacs-nox).

Install emacs-X11 if you're going to use Emacs with the X Window
System.  You should also install emacs-X11 if you're going to run
Emacs both with and without X (it will work fine both ways). You'll
also need to install the emacs package in order to run Emacs.

%prep
%setup -q -b 1

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

# clean out remnants of patching
find . -name "*.orig" -exec rm -f {} \;

%build
PUREDEF=""
XPUREDEF=""
libtoolize --force --copy
CONFOPTS="--prefix=/usr --libexecdir=/usr/lib --sharedstatedir=/var --with-gcc --with-pop"

#Build binary without X support
[ -d build-nox ] && rm -rf build-nox
mkdir build-nox && cd build-nox
CFLAGS="$RPM_OPT_FLAGS $PUREDEF" LDFLAGS=-s \
  ../configure ${CONFOPTS} --with-x=no ${RPM_ARCH}-redhat-linux-gnu
make
cd ..

#Build binary with X support
[ -d build-withx ] && rm -rf build-withx
mkdir build-withx && cd build-withx
CFLAGS="$RPM_OPT_FLAGS $XPUREDEF" LDFLAGS=-s \
  ../configure ${CONFOPTS} --with-x-toolkit ${RPM_ARCH}-redhat-linux-gnu
make 
cd ..

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr

ARCHDIR=${RPM_ARCH}-redhat-linux-gnu
make install -C build-withx \
	prefix=$RPM_BUILD_ROOT/usr \
	libexecdir=$RPM_BUILD_ROOT/usr/lib \
	sharedstatedir=$RPM_BUILD_ROOT/var

rm -f $RPM_BUILD_ROOT/usr/info/dir
gzip -9nf $RPM_BUILD_ROOT/usr/info/*
install -m755 build-nox/src/emacs $RPM_BUILD_ROOT/usr/bin/emacs-nox

# For some reason, when emacs is stripped on the Alpha, it dumps core
# Lucky for us it started doing this on the Intel as well. Yeah.
#strip $RPM_BUILD_ROOT/usr/bin/* ||:
for I in cvtmail digest-doc emacsserver fakemail hexl movemail profile \
	sorted-doc yow; do
	strip $RPM_BUILD_ROOT/usr/lib/emacs/$RPM_PACKAGE_VERSION/$ARCHDIR/$I||:
done

mkdir -p $RPM_BUILD_ROOT/usr/lib/emacs/site-lisp

mv $RPM_BUILD_ROOT/usr/man/man1/ctags.1 $RPM_BUILD_ROOT/usr/man/man1/gctags.1
mv $RPM_BUILD_ROOT/usr/bin/ctags $RPM_BUILD_ROOT/usr/bin/gctags

# wmconfig file
mkdir -p $RPM_BUILD_ROOT/etc/X11/wmconfig
install -m 0644 $RPM_SOURCE_DIR/emacs.wmconfig $RPM_BUILD_ROOT/etc/X11/wmconfig/emacs

#
# create file lists
#

find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/lisp \
  -name '*.elc' -print | sed "s^$RPM_BUILD_ROOT^^" > core-filelist
find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/lisp \
  -type d -printf "%%%%dir %%p\n" | sed "s^$RPM_BUILD_ROOT^^" >> core-filelist
find $RPM_BUILD_ROOT/usr/lib/emacs/%{PACKAGE_VERSION} -type f | \
  sed "s^$RPM_BUILD_ROOT^^" | grep -v movemail >> core-filelist

# Include .el files which lack a corresponding byte compiled form
for I in `find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/lisp \
          -name '*.el'`; do
  if [ ! -e `dirname $I`/`basename $I .el`.elc ]; then 
    echo $I | sed "s^$RPM_BUILD_ROOT^^"
  fi
done >> core-filelist

# Include all non elisp files which emacs installs
find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/lisp -type f | \
  sed "s^$RPM_BUILD_ROOT^^" | grep -v "\.el\(c\)\?$" >> core-filelist


find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/leim \
  -name '*.elc' -print | sed "s^$RPM_BUILD_ROOT^^" > leim-filelist
find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/leim \
  -mindepth 1 -type d -printf "%%%%dir %%p\n" | \
  sed "s^$RPM_BUILD_ROOT^^" >> leim-filelist

#
# be sure to exclude some files which are needed in the core package
#
for I in `find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/lisp \
          -name '*.el'`; do
  if [ -e `dirname $I`/`basename $I .el`.elc ]; then 
    echo $I | sed "s^$RPM_BUILD_ROOT^^"
  fi
done >> el-filelist

find $RPM_BUILD_ROOT/usr/share/emacs/%{PACKAGE_VERSION}/leim \
  -name '*.el' -print | sed "s^$RPM_BUILD_ROOT^^" |\
  grep -v "leim\/leim-list.el" >> el-filelist

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf build-nox
rm -rf build-withx

%define info_files ccmode cl dired-x ediff emacs forms gnus info message mh-e reftex sc vip viper widget
%post
for f in %{info_files}; do
  /sbin/install-info /usr/info/$f.gz /usr/info/dir --section="GNU Emacs"
done

%preun
if [ "$1" = 0 ]; then
for f in %{info_files}; do
  /sbin/install-info --delete /usr/info/$f.gz /usr/info/dir \
    --section="GNU Emacs"
done
fi

%triggerin nox --
if [ -L /usr/bin/emacs ]; then
  rm /usr/bin/emacs
fi

%triggerun nox --
if [ ! -L /usr/bin/emacs ]; then
  ln -sf emacs-nox /usr/bin/emacs
fi

%postun nox
if [ -L /usr/bin/emacs ]; then
  rm /usr/bin/emacs
fi


%files -f core-filelist
%defattr(-,root,root)
%doc etc/NEWS BUGS README etc/FAQ
/usr/bin/b2m
/usr/bin/emacsclient
/usr/bin/etags
/usr/bin/gctags
/usr/bin/rcs-checkin
/usr/man/*/*
/usr/info/*

%dir /usr/lib/emacs
%dir /usr/lib/emacs/site-lisp
%dir /usr/lib/emacs/%{PACKAGE_VERSION}
%dir /usr/lib/emacs/%{PACKAGE_VERSION}/%{_target_cpu}-redhat-linux-gnu
%attr(2755,root,mail) /usr/lib/emacs/%{PACKAGE_VERSION}/%{_target_cpu}-redhat-linux-gnu/movemail

%dir /usr/share/emacs/site-lisp
%dir /usr/share/emacs/%{PACKAGE_VERSION}
%dir /usr/share/emacs/%{PACKAGE_VERSION}/site-lisp
%dir /usr/share/emacs/%{PACKAGE_VERSION}/leim
/usr/share/emacs/%{PACKAGE_VERSION}/etc

# handled by dynamically generated file lists
#/usr/share/emacs/%{PACKAGE_VERSION}/lisp/*.elc
#/usr/share/emacs/%{PACKAGE_VERSION}/lisp/*/*.elc
#/usr/share/emacs/%{PACKAGE_VERSION}/lisp/*.elc
#/usr/share/emacs/20.2/lisp/mail/*.elc

%files -f el-filelist el
%defattr(-,root,root)
# handled by dynamically generated file lists
#/usr/share/emacs/%{PACKAGE_VERSION}/lisp/*.el
#/usr/share/emacs/%{PACKAGE_VERSION}/lisp/*/*.el
#/usr/share/emacs/%{PACKAGE_VERSION}/leim/*.el
#/usr/share/emacs/%{PACKAGE_VERSION}/leim/*/*.el

%files -f leim-filelist leim
%defattr(-,root,root)
/usr/share/emacs/%{PACKAGE_VERSION}/leim/leim-list.el
# handled by dynamically generated file lists
#/usr/share/emacs/%{PACKAGE_VERSION}/leim/*.elc
#/usr/share/emacs/%{PACKAGE_VERSION}/leim/*/*.elc

%files nox
%defattr(-,root,root)
/usr/bin/emacs-nox

%files X11
%defattr(-,root,root)
/usr/bin/emacs
/usr/bin/emacs-%{version}
%config(missingok) /etc/X11/wmconfig/emacs

%changelog
* Wed Sep 01 1999 Preston Brown <pbrown@redhat.com>
- added trigger for making symlink to /usr/bin/emacs in emacs-nox package

* Thu Jul 22 1999 Paul Fisher <pnfisher@redhat.com>
- upgrade to 20.4
- cleaned up spec

* Fri Apr 16 1999 Owen Taylor <otaylor@redhat.com>
- replace bad xemacs compiled .elc file for mh-e with one compiled
  on emacs

* Thu Apr 15 1999 Bill Nottingham <notting@redhat.com>
- make sure movemail doesn't get %defattr()'d to root.root

* Wed Apr 14 1999 Cristian Gafton <gafton@redhat.com>
- patch to make it work with dxpc

* Wed Mar 31 1999 Preston Brown <pbrown@redhat.com>
- updated mh-utils emacs lisp file to match our nmh path locations

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 9)

* Fri Feb 26 1999 Cristian Gafton <gafton@redhat.com>
- linker scripts hack to make it build on the alpha

* Fri Jan  1 1999 Jeff Johnson <jbj@redhat.com>
- add leim package (thanks to Pavel.Janik@inet.cz).

* Fri Dec 18 1998 Cristian Gafton <gafton@redhat.com>
- build against glibc 2.1

* Wed Sep 30 1998 Cristian Gafton <gafton@redhat.com>
- backed up changes to uncompress.el (it seems that the one from 20.2 works
  much better)

* Mon Sep 28 1998 Jeff Johnson <jbj@redhat.com>
- eliminate /tmp race in rcs2log

* Wed Sep 09 1998 Cristian Gafton <gafton@redhat.com>
- upgrade to 20.3

* Tue Jun  9 1998 Jeff Johnson <jbj@redhat.com>
- add --with-pop to X11 compile.
- include contents of /usr/share/.../etc with main package.

* Mon Jun 01 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr

* Mon Jun 01 1998 David S. Miller <davem@dm.cobaltmicro.com>
- fix signals when linked with glibc on non-Intel architectures
  NOTE: This patch is not needed with emacs >20.2

* Thu May 07 1998 Prospector System <bugs@redhat.com>

- translations modified for de, fr, tr

* Thu May 07 1998 Cristian Gafton <gafton@redhat.com>
- added /usr/lib/emacs/20.2/*-redhat-linux directory in the filelist

* Thu Apr 09 1998 Cristian Gafton <gafton@redhat.com>
- alpha started to like emacs-nox again :-)

* Thu Nov  6 1997 Michael Fulbright <msf@redhat.com>
- alpha just doesnt like emacs-nox, taking it out for now

* Mon Nov  3 1997 Michael Fulbright <msf@redhat.com>
- added multibyte support back into emacs 20.2
- added wmconfig for X11 emacs
- fixed some errant buildroot references

* Thu Oct 23 1997 Michael Fulbright <msf@redhat.com>
- joy a new version of emacs! Of note - no lockdir any more.
- use post/preun sections to handle numerous GNU info files

* Mon Oct 06 1997 Erik Troan <ewt@redhat.com>
- stopped stripping it as it seems to break things

* Sun Sep 14 1997 Erik Troan <ewt@redhat.com>
- turned off ecoff support on the Alpha (which doesn't build anymore)

* Mon Jun 16 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Fri Feb 07 1997 Michael K. Johnson <johnsonm@redhat.com>
- Moved ctags to gctags to fit in the more powerful for C (but less
  general) exuberant ctags as the binary /usr/bin/ctags and the
  man page /usr/man/man1/ctags.1
