Summary: A file compression utility.
Name: bzip2
Version: 0.9.5d
Release: 2.Handhelds
Copyright: GPL
Group: Applications/File
Source: http://sourceware.cygnus.com/bzip2/bzip2-%{version}.tar.gz
URL: http://sourceware.cygnus.com/bzip2/
Patch0: bzip2-0.9.5c-shlib.patch
Distribution: Handhelds
Packager: George France <france@crl.dec.com>

Prefix: %{_prefix}
BuildRequires: libtool
BuildRoot: /var/tmp/%{name}-root

%description
Bzip2 is a freely available, patent-free, high quality data compressor.
Bzip2 compresses files to within 10 to 15 percent of the capabilities 
of the best techniques available.  However, bzip2 has the added benefit 
of being approximately two times faster at compression and six times 
faster at decompression than those techniques.  Bzip2 is not the 
fastest compression utility, but it does strike a balance between speed 
and compression capability.

Install bzip2 if you need a compression utility.

%prep
%setup -q
%patch0 -p1 -b .shlib

%build

make CFLAGS="$RPM_OPT_FLAGS" prefix=%{_prefix}

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR="$RPM_BUILD_ROOT" prefix=%{_prefix}

( cd $RPM_BUILD_ROOT
  strip .%{_prefix}/bin/* || :
  cat > .%{_prefix}/bin/bzless <<EOF
#!/bin/sh
%{_prefix}/bin/bunzip2 -c "\$@" | /usr/bin/less
EOF
  chmod 755 .%{_prefix}/bin/bzless
)

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc  README *.html
%{_prefix}/bin/*
%{_prefix}/man/man1/*
%{_prefix}/lib/libbz2.*
%{_prefix}/include/bzlib.h

%changelog
* Mon Feb  7 2000 Bill Nottingham <notting@redhat.com>
- handle compressed manpages

* Fri Dec 31 1999 Bernhard Rosenkrnzer <bero@redhat.com>
- 0.9.5d
- Update download URL, add URL: tag in header

* Tue Aug 10 1999 Jeff Johnson <jbj@redhat.com>
- upgrade to 0.9.5c.

* Mon Aug  9 1999 Bill Nottingham <notting@redhat.com>
- install actual bzip2 binary, not libtool cruft.

* Sun Aug  8 1999 Jeff Johnson <jbj@redhat.com>
- run ldconfig to get shared library.

* Mon Aug  2 1999 Jeff Johnson <jbj@redhat.com>
- create shared libbz1.so.* library.

* Sun Apr  4 1999 Jeff Johnson <jbj@redhat.com>
- update to bzip2-0.9.0c.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Thu Dec 17 1998 Cristian Gafton <gafton@redhat.com>
- build against glibc 2.1

* Wed Sep 30 1998 Cristian Gafton <gafton@redhat.com>
- force compilation with egcs to avoid gcc optimization bug (thank God 
  we haven't been beaten by it)

* Wed Sep 09 1998 Cristian Gafton <gafton@redhat.com>
- version 0.9.0b

* Tue Sep 08 1998 Cristian Gafton <gafton@redhat.com>
- updated to 0.9.0

* Thu Apr 09 1998 Cristian Gafton <gafton@redhat.com>
- first build for Manhattan
