Summary: The GNU versions of common file management utilities.
Name: fileutils
Version: 4.0
Release: 21.Handhelds
Copyright: GPL
Group: Applications/File
Packager: George France <france@crl.dec.com>
Distribution: Handhelds
Source0: ftp://alpha.gnu.org/gnu/fetish/fileutils-%{version}p.tar.bz2
Source1: DIR_COLORS
Source2: colorls.sh
Source3: colorls.csh
Patch1: fileutils-4.0-spacedir.patch
Patch3: fileutils-4.0m-dest.patch
Patch4: fileutils-4.0-samefile.patch
Patch5: fileutils-4.0-C.patch
Patch6: fileutils-4.0m-nodoors.patch
Patch7: fileutils-4.0p-strip.patch
Patch8: fileutils-install-specialbits.patch
Patch9: fileutils-cp-x.patch
Patch10: fileutils-4.0p-overwrite.patch
Patch11: fileutils-ls-dumbterm.patch
Buildroot: %{_tmppath}/%{name}-root
Prereq: /sbin/install-info

%description
The fileutils package includes a number of GNU versions of common and
popular file management utilities.  Fileutils includes the following
tools: chgrp (changes a file's group ownership), chown (changes a
file's ownership), chmod (changes a file's permissions), cp (copies
files), dd (copies and converts files), df (shows a filesystem's disk
usage), dir (gives a brief directory listing), dircolors (the setup
program for the color version of the ls command), du (shows disk
usage), install (copies files and sets permissions), ln (creates file
links), ls (lists directory contents), mkdir (creates directories),
mkfifo (creates FIFOs or named pipes), mknod (creates special files),
mv (renames files), rm (removes/deletes files), rmdir (removes empty
directories), sync (synchronizes memory and disk), touch (changes file
timestamps), and vdir (provides long directory listings).

You should install the fileutils package, because it includes many
file management utilities that you'll use frequently.

%prep
%setup -n %{name}-4.0p -q
%patch1 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
# %patch9 -p1
%patch10 -p1
%patch11 -p1

%build
unset LINGUAS || :
%ifos linux
%configure --exec-prefix=/
%else
%configure
%endif

make

%install
rm -rf $RPM_BUILD_ROOT

%ifos linux
make prefix=${RPM_BUILD_ROOT}%{_prefix} exec_prefix=${RPM_BUILD_ROOT}/ install
%else
make prefix=${RPM_BUILD_ROOT}%{_prefix} \
    localedir=${RPM_BUILD_ROOT}%{_prefix}/share/locale \
        install
%endif

( cd $RPM_BUILD_ROOT

%ifos linux
  mkdir -p .%{_prefix}/bin
  for i in dir dircolors du install mkfifo shred vdir
  do
    mv -f ./bin/$i .%{_prefix}/bin/$i
  done
  strip -R .comments ./bin/* || :
%endif

  strip .%{_prefix}/bin/* || :
  gzip -9nf .%{_prefix}/info/fileutils*

  mkdir -p ./etc/profile.d
  install -c -m 644 %SOURCE1 ./etc
  install -c -m 755 %SOURCE2 ./etc/profile.d
  install -c -m 755 %SOURCE3 ./etc/profile.d
)

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/install-info %{_prefix}/info/fileutils.info.gz %{_prefix}/info/dir

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_prefix}/info/fileutils.info.gz %{_prefix}/info/dir
fi

%files
%defattr(-,root,root)
%doc ABOUT-NLS AUTHORS COPYING ChangeLog NEWS README THANKS TODO
%config /etc/DIR_COLORS
%config /etc/profile.d/colorls.sh
%config /etc/profile.d/colorls.csh

%ifos linux
/bin/chgrp
/bin/chown
/bin/chmod
/bin/cp
/bin/dd
/bin/df
/bin/ln
/bin/ls
/bin/mkdir
/bin/mknod
/bin/mv
/bin/rm
/bin/rmdir
/bin/sync
/bin/touch

%{_prefix}/bin/dir
%{_prefix}/bin/dircolors
%{_prefix}/bin/du
%{_prefix}/bin/install
%{_prefix}/bin/mkfifo
%{_prefix}/bin/shred
%{_prefix}/bin/vdir

%{_prefix}/man/man1/chgrp.1*
%{_prefix}/man/man1/chown.1*
%{_prefix}/man/man1/chmod.1*
%{_prefix}/man/man1/cp.1*
%{_prefix}/man/man1/dd.1*
%{_prefix}/man/man1/df.1*
%{_prefix}/man/man1/dir.1*
%{_prefix}/man/man1/dircolors.1*
%{_prefix}/man/man1/du.1*
%{_prefix}/man/man1/install.1*
%{_prefix}/man/man1/ln.1*
%{_prefix}/man/man1/ls.1*
%{_prefix}/man/man1/mkdir.1*
%{_prefix}/man/man1/mkfifo.1*
%{_prefix}/man/man1/mknod.1*
%{_prefix}/man/man1/mv.1*
%{_prefix}/man/man1/rm.1*
%{_prefix}/man/man1/rmdir.1*
%{_prefix}/man/man1/shred.1*
%{_prefix}/man/man1/sync.1*
%{_prefix}/man/man1/touch.1*
%{_prefix}/man/man1/vdir.1*
%else
%{_prefix}/bin/*
%{_prefix}/man/man*/*
%endif

%{_prefix}/info/fileutils*

%{_prefix}/share/locale/*/*/*

%changelog
* Tue Mar 07 2000 Cristian Gafton <gafton@redhat.com>
- get rid of 'ls -C' crap. It breaks pipes

* Fri Mar  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Don't use color-ls on dumb terminals

* Thu Feb 17 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix up mv behavior when overwriting a write-protected file without -f
  (Bug #6246)

* Wed Feb 16 2000 Cristian Gafton <gafton@redhat.com>
- take out the default -F argument to ls (the extra chars are breaking
  scripts)

* Wed Feb  9 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Back out the cp -x fix, as it breaks cp -r.
  I'll look into really fixing it when I have the time; for now, -r
  is more important than -x.

* Mon Feb  7 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix up the cp -x option (Bug #8726)

* Sun Feb  6 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- don't produce a fatal error on -s when strip fails
- handle special bits with install -m (Bug #7080)

* Wed Feb  2 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 4.0p stuff: quote multibyte characters correctly.

* Tue Feb 01 2000 Cristian Gafton <gafton@redhat.com>
- add patch to disable st_size computation for devices (hjl)

* Fri Jan 28 2000 Nalin Dahyabhai <nalin@redhat.com>
- disable DOOR type, which makes tcsh unhappy
- gzipped man pages

* Wed Jan  5 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fixes from 4.0m

* Sun Dec 12 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix output of mkdir --verbose -p (Bug #7770)

* Thu Nov 18 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix a typo in colorls.sh
- Add the -C option to install for compatibility with *BSD
- unset LINGUAS in spec file to fix build on most 6.1 installations

* Wed Nov 17 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- Add colorls.sh/colorls.csh to /etc/profile.d
  (Newbies are likely to like them, professionals who don't will know
  how to remove them. Also, they're compatible with DLD)
- Modify /etc/DIR_COLORS:
  - recognize .bz2, .bz, .tz, .png, .sh, .csh, .rpm, .cpio, .tif
  - recognize color_xterm, dtterm, rxvt and cons25 as colorizable

* Fri Sep 24 1999 Cristian Gafton <gafton@redhat.com>
- don't apply the samefile patch anymore (breaks globbing). Patch still
  included in the src.rpm for a later day fix

* Mon Sep 13 1999 Cristian Gafton <gafton@redhat.com>
- fix my patch some more and use lstat instead

* Sat Sep 11 1999 Bill Nottingham <notting@redhat.com>
- fix gafton's patch ;)

* Fri Sep 10 1999 Cristian Gafton <gafton@redhat.com>
- patch to stop "mv b b" from creating a stupid b/b directory.

* Tue Aug 31 1999 Jeff Johnson <jbj@redhat.com>
- install -D should create DEST not SOURCE filename (#3339).

* Mon Aug 23 1999 Preston Brown <pbrown@redhat.com>
- fixed display of symlinked directories in ls (#4561)

* Wed Jul 28 1999 Cristian Gafton <gafton@redhat.com>
- correctly display mount points that have spaces in them (#3317)

* Tue Mar 23 1999 Cristian Gafton <gafton@redhat.com>
- version 4.0

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 12)

* Thu Aug 06 1998 Erik Troan <ewt@redhat.com>
- got install-info stuff working in %post/%pre

* Fri Apr 24 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Apr 09 1998 Cristian Gafton <gafton@redhat.com>
- manhattan rebuild
- added %clean

* Wed Oct 22 1997 Erik Troan <ewt@redhat.com>
- minor patch for glibc 2.1

* Mon Oct 20 1997 Erik Troan <ewt@redhat.com>
- install-info turned off, as it creates a prereq loop

* Fri Oct 17 1997 Donnie Barnes <djb@redhat.com>
- install-info turned on
- added BuildRoot

* Mon Sep 15 1997 Erik Troan <ewt@redhat.com>
- can't use install-info until %post -p allows argument passing

* Sun Sep 14 1997 Erik Troan <ewt@redhat.com>
- uses install-info

* Fri May 16 1997 Erik Troan <ewt@redhat.com>
- rebuilt for glibc.

* Tue Feb 25 1997 Erik Troan <ewt@redhat.com>
- Hacked at mktime() test to work on 64 bit machines w/ broken mktime(). I
  told Ulrich Drepper and Richard Henderson about this, so hopefully glibc
  will get fixed.

* Thu Feb 20 1997 Michael Fulbright <msf@redhat.com>
- Updated to version 3.16.
