#include <stdarg.h>
#include <bios/stdio.h>

static char buffer[1024];

extern void ser_msg(const char *);
extern int ser_getc(void);
extern int ser_ready(void);

void debug_printf(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	ser_msg(buffer);
}

int debug_ready(void)
{
	return ser_ready();
}

int debug_getc(void)
{
	return ser_getc();
}

void debug_init(void)
{
}
