/* ld script to make ARM BIOS
 */
OUTPUT_ARCH(arm)
ENTRY(_entry)
SECTIONS
{
  .text : {
    _text = .;			/* Text and read-only data      */
        *(.text)
        *(.fixup)
        *(.gnu.warning)
        *(.rodata)
	. = ALIGN(4);
    _etext = .;			/* End of text section          */
  }

  .data : {			/* Data                         */
    _data = .;
        *(.data)
    _edata = .;			/* End of data section          */
  }
  _data_sz = SIZEOF(.data);

  .bss : {
     _bss_start = .;		/* BSS                          */
        *(.bss)
     _end = . ;
   }
}
