#include <bios/stdio.h>
#include <bios/stdioint.h>
#include <bios/timer.h>
#include <stdarg.h>

extern void ser_write(const char *buf, int nr);
extern int  ser_read(char *buf, int nr);
extern int  ser_stat(void);

struct stdfn stdfn =
{
	ser_write,
	ser_read,
	ser_stat
};

int printf(const char *fmt, ...)
{
	char buffer[1024];
	va_list ap;
	int len;

	va_start(ap, fmt);
	len = vsprintf(buffer, fmt, ap);
	va_end(ap);

	if (stdfn.write)
		stdfn.write(buffer, len);

	return len;
}

int getc(void)
{
	char buffer[2];

	clear_timer(KEY_TIMER);

	return (stdfn.read(buffer, 1) == 1) ? buffer[0] : -1;
}

int getc_timed(int cs)
{
	char buffer[2];

	set_timer(KEY_TIMER, cs);

	return (stdfn.read(buffer, 1) == 1) ? buffer[0] : -1;
}

int gets(char *str, int maxlen)
{
	int c, idx = 0;

	do {
		c = getc();
		if (c == '\r' || c == '\n')
			break;
		if (c == 8 || c == 127) {
			if (idx >= 0) {
				idx -= 1;
				stdfn.write("\010 \010", 3);
			}
		}
		if (idx <= maxlen - 1) {
			str[idx++] = c;
			stdfn.write(&c, 1);
		} else
			stdfn.write("\006", 1);
	} while (1);

	str[idx] = '\0';

	return idx;
}
