#include <stdarg.h>
#include <bios/stdio.h>

static char buffer[1024];

extern void ser_write(const char *, int);
extern int  ser_read(char *, int);
extern int  ser_stat(void);

void debug_printf(char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	ser_write(buffer, 0);
}

int debug_ready(void)
{
	return ser_stat();
}

int debug_getc(void)
{
	char buf[2];
	return (ser_read(buf, 1) == 1) ? buf[0] : -1;
}

void debug_init(void)
{
}
