/* MPEG/WAVE Sound library

   (C) 1997 by Jung woo-jae */

// Mpegtable.cc
// It has tables for MPEG layer 1, 2 and a part of layer 3

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mpegsound.h"


#ifndef FIXED_POINT
#define X( x )  (x)
#else
#define X( x )  {FL2FIX( x, FIXED_POINT_FRACBITS )}
#endif



// For header

const int Mpegtoraw::frequencies[2][3] =
{
  {44100,48000,32000}, // MPEG 1
  {22050,24000,16000}  // MPEG 2
};

const int Mpegtoraw::bitrate[2][3][15] =
{
  // MPEG 1
  {{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
   {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
   {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}},

  // MPEG 2
  {{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
   {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
   {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}}
};



// Mpeg general table

const REAL Mpegtoraw::scalefactorstable[64] =
{
  X( 2.00000000000000), X( 1.58740105196820), X( 1.25992104989487), X( 1.00000000000000),
  X( 0.79370052598410), X( 0.62996052494744), X( 0.50000000000000), X( 0.39685026299205),
  X( 0.31498026247372), X( 0.25000000000000), X( 0.19842513149602), X( 0.15749013123686),
  X( 0.12500000000000), X( 0.09921256574801), X( 0.07874506561843), X( 0.06250000000000),
  X( 0.04960628287401), X( 0.03937253280921), X( 0.03125000000000), X( 0.02480314143700),
  X( 0.01968626640461), X( 0.01562500000000), X( 0.01240157071850), X( 0.00984313320230),
  X( 0.00781250000000), X( 0.00620078535925), X( 0.00492156660115), X( 0.00390625000000),
  X( 0.00310039267963), X( 0.00246078330058), X( 0.00195312500000), X( 0.00155019633981),
  X( 0.00123039165029), X( 0.00097656250000), X( 0.00077509816991), X( 0.00061519582514),
  X( 0.00048828125000), X( 0.00038754908495), X( 0.00030759791257), X( 0.00024414062500),
  X( 0.00019377454248), X( 0.00015379895629), X( 0.00012207031250), X( 0.00009688727124),
  X( 0.00007689947814), X( 0.00006103515625), X( 0.00004844363562), X( 0.00003844973907),
  X( 0.00003051757813), X( 0.00002422181781), X( 0.00001922486954), X( 0.00001525878906),
  X( 0.00001211090890), X( 0.00000961243477), X( 0.00000762939453), X( 0.00000605545445),
  X( 0.00000480621738), X( 0.00000381469727), X( 0.00000302772723), X( 0.00000240310869),
  X( 0.00000190734863), X( 0.00000151386361), X( 0.00000120155435), X( 0.00000000000000)
};



const REAL Mpegtoraw::filter[512] =
{
  X( 0.000000000), X(-0.000442505), X( 0.003250122), X(-0.007003784),
  X( 0.031082153), X(-0.078628540), X( 0.100311279), X(-0.572036743),
  X( 1.144989014), X( 0.572036743), X( 0.100311279), X( 0.078628540),
  X( 0.031082153), X( 0.007003784), X( 0.003250122), X( 0.000442505),
  X(-0.000015259), X(-0.000473022), X( 0.003326416), X(-0.007919312),
  X( 0.030517578), X(-0.084182739), X( 0.090927124), X(-0.600219727),
  X( 1.144287109), X( 0.543823242), X( 0.108856201), X( 0.073059082),
  X( 0.031478882), X( 0.006118774), X( 0.003173828), X( 0.000396729),
  X(-0.000015259), X(-0.000534058), X( 0.003387451), X(-0.008865356),
  X( 0.029785156), X(-0.089706421), X( 0.080688477), X(-0.628295898),
  X( 1.142211914), X( 0.515609741), X( 0.116577148), X( 0.067520142),
  X( 0.031738281), X( 0.005294800), X( 0.003082275), X( 0.000366211),
  X(-0.000015259), X(-0.000579834), X( 0.003433228), X(-0.009841919),
  X( 0.028884888), X(-0.095169067), X( 0.069595337), X(-0.656219482),
  X( 1.138763428), X( 0.487472534), X( 0.123474121), X( 0.061996460),
  X( 0.031845093), X( 0.004486084), X( 0.002990723), X( 0.000320435),
  X(-0.000015259), X(-0.000625610), X( 0.003463745), X(-0.010848999),
  X( 0.027801514), X(-0.100540161), X( 0.057617188), X(-0.683914185),
  X( 1.133926392), X( 0.459472656), X( 0.129577637), X( 0.056533813),
  X( 0.031814575), X( 0.003723145), X( 0.002899170), X( 0.000289917),
  X(-0.000015259), X(-0.000686646), X( 0.003479004), X(-0.011886597),
  X( 0.026535034), X(-0.105819702), X( 0.044784546), X(-0.711318970),
  X( 1.127746582), X( 0.431655884), X( 0.134887695), X( 0.051132202),
  X( 0.031661987), X( 0.003005981), X( 0.002792358), X( 0.000259399),
  X(-0.000015259), X(-0.000747681), X( 0.003479004), X(-0.012939453),
  X( 0.025085449), X(-0.110946655), X( 0.031082153), X(-0.738372803),
  X( 1.120223999), X( 0.404083252), X( 0.139450073), X( 0.045837402),
  X( 0.031387329), X( 0.002334595), X( 0.002685547), X( 0.000244141),
  X(-0.000030518), X(-0.000808716), X( 0.003463745), X(-0.014022827),
  X( 0.023422241), X(-0.115921021), X( 0.016510010), X(-0.765029907),
  X( 1.111373901), X( 0.376800537), X( 0.143264771), X( 0.040634155),
  X( 0.031005859), X( 0.001693726), X( 0.002578735), X( 0.000213623),
  X(-0.000030518), X(-0.000885010), X( 0.003417969), X(-0.015121460),
  X( 0.021575928), X(-0.120697021), X( 0.001068115), X(-0.791213989),
  X( 1.101211548), X( 0.349868774), X( 0.146362305), X( 0.035552979),
  X( 0.030532837), X( 0.001098633), X( 0.002456665), X( 0.000198364),
  X(-0.000030518), X(-0.000961304), X( 0.003372192), X(-0.016235352),
  X( 0.019531250), X(-0.125259399), X(-0.015228271), X(-0.816864014),
  X( 1.089782715), X( 0.323318481), X( 0.148773193), X( 0.030609131),
  X( 0.029937744), X( 0.000549316), X( 0.002349854), X( 0.000167847),
  X(-0.000030518), X(-0.001037598), X( 0.003280640), X(-0.017349243),
  X( 0.017257690), X(-0.129562378), X(-0.032379150), X(-0.841949463),
  X( 1.077117920), X( 0.297210693), X( 0.150497437), X( 0.025817871),
  X( 0.029281616), X( 0.000030518), X( 0.002243042), X( 0.000152588),
  X(-0.000045776), X(-0.001113892), X( 0.003173828), X(-0.018463135),
  X( 0.014801025), X(-0.133590698), X(-0.050354004), X(-0.866363525),
  X( 1.063217163), X( 0.271591187), X( 0.151596069), X( 0.021179199),
  X( 0.028533936), X(-0.000442505), X( 0.002120972), X( 0.000137329),
  X(-0.000045776), X(-0.001205444), X( 0.003051758), X(-0.019577026),
  X( 0.012115479), X(-0.137298584), X(-0.069168091), X(-0.890090942),
  X( 1.048156738), X( 0.246505737), X( 0.152069092), X( 0.016708374),
  X( 0.027725220), X(-0.000869751), X( 0.002014160), X( 0.000122070),
  X(-0.000061035), X(-0.001296997), X( 0.002883911), X(-0.020690918),
  X( 0.009231567), X(-0.140670776), X(-0.088775635), X(-0.913055420),
  X( 1.031936646), X( 0.221984863), X( 0.151962280), X( 0.012420654),
  X( 0.026840210), X(-0.001266479), X( 0.001907349), X( 0.000106812),
  X(-0.000061035), X(-0.001388550), X( 0.002700806), X(-0.021789551),
  X( 0.006134033), X(-0.143676758), X(-0.109161377), X(-0.935195923),
  X( 1.014617920), X( 0.198059082), X( 0.151306152), X( 0.008316040),
  X( 0.025909424), X(-0.001617432), X( 0.001785278), X( 0.000106812),
  X(-0.000076294), X(-0.001480103), X( 0.002487183), X(-0.022857666),
  X( 0.002822876), X(-0.146255493), X(-0.130310059), X(-0.956481934),
  X( 0.996246338), X( 0.174789429), X( 0.150115967), X( 0.004394531),
  X( 0.024932861), X(-0.001937866), X( 0.001693726), X( 0.000091553),
  X(-0.000076294), X(-0.001586914), X( 0.002227783), X(-0.023910522),
  X(-0.000686646), X(-0.148422241), X(-0.152206421), X(-0.976852417),
  X( 0.976852417), X( 0.152206421), X( 0.148422241), X( 0.000686646),
  X( 0.023910522), X(-0.002227783), X( 0.001586914), X( 0.000076294),
  X(-0.000091553), X(-0.001693726), X( 0.001937866), X(-0.024932861),
  X(-0.004394531), X(-0.150115967), X(-0.174789429), X(-0.996246338),
  X( 0.956481934), X( 0.130310059), X( 0.146255493), X(-0.002822876),
  X( 0.022857666), X(-0.002487183), X( 0.001480103), X( 0.000076294),
  X(-0.000106812), X(-0.001785278), X( 0.001617432), X(-0.025909424),
  X(-0.008316040), X(-0.151306152), X(-0.198059082), X(-1.014617920),
  X( 0.935195923), X( 0.109161377), X( 0.143676758), X(-0.006134033),
  X( 0.021789551), X(-0.002700806), X( 0.001388550), X( 0.000061035),
  X(-0.000106812), X(-0.001907349), X( 0.001266479), X(-0.026840210),
  X(-0.012420654), X(-0.151962280), X(-0.221984863), X(-1.031936646),
  X( 0.913055420), X( 0.088775635), X( 0.140670776), X(-0.009231567),
  X( 0.020690918), X(-0.002883911), X( 0.001296997), X( 0.000061035),
  X(-0.000122070), X(-0.002014160), X( 0.000869751), X(-0.027725220),
  X(-0.016708374), X(-0.152069092), X(-0.246505737), X(-1.048156738),
  X( 0.890090942), X( 0.069168091), X( 0.137298584), X(-0.012115479),
  X( 0.019577026), X(-0.003051758), X( 0.001205444), X( 0.000045776),
  X(-0.000137329), X(-0.002120972), X( 0.000442505), X(-0.028533936),
  X(-0.021179199), X(-0.151596069), X(-0.271591187), X(-1.063217163),
  X( 0.866363525), X( 0.050354004), X( 0.133590698), X(-0.014801025),
  X( 0.018463135), X(-0.003173828), X( 0.001113892), X( 0.000045776),
  X(-0.000152588), X(-0.002243042), X(-0.000030518), X(-0.029281616),
  X(-0.025817871), X(-0.150497437), X(-0.297210693), X(-1.077117920),
  X( 0.841949463), X( 0.032379150), X( 0.129562378), X(-0.017257690),
  X( 0.017349243), X(-0.003280640), X( 0.001037598), X( 0.000030518),
  X(-0.000167847), X(-0.002349854), X(-0.000549316), X(-0.029937744),
  X(-0.030609131), X(-0.148773193), X(-0.323318481), X(-1.089782715),
  X( 0.816864014), X( 0.015228271), X( 0.125259399), X(-0.019531250),
  X( 0.016235352), X(-0.003372192), X( 0.000961304), X( 0.000030518),
  X(-0.000198364), X(-0.002456665), X(-0.001098633), X(-0.030532837),
  X(-0.035552979), X(-0.146362305), X(-0.349868774), X(-1.101211548),
  X( 0.791213989), X(-0.001068115), X( 0.120697021), X(-0.021575928),
  X( 0.015121460), X(-0.003417969), X( 0.000885010), X( 0.000030518),
  X(-0.000213623), X(-0.002578735), X(-0.001693726), X(-0.031005859),
  X(-0.040634155), X(-0.143264771), X(-0.376800537), X(-1.111373901),
  X( 0.765029907), X(-0.016510010), X( 0.115921021), X(-0.023422241),
  X( 0.014022827), X(-0.003463745), X( 0.000808716), X( 0.000030518),
  X(-0.000244141), X(-0.002685547), X(-0.002334595), X(-0.031387329),
  X(-0.045837402), X(-0.139450073), X(-0.404083252), X(-1.120223999),
  X( 0.738372803), X(-0.031082153), X( 0.110946655), X(-0.025085449),
  X( 0.012939453), X(-0.003479004), X( 0.000747681), X( 0.000015259),
  X(-0.000259399), X(-0.002792358), X(-0.003005981), X(-0.031661987),
  X(-0.051132202), X(-0.134887695), X(-0.431655884), X(-1.127746582),
  X( 0.711318970), X(-0.044784546), X( 0.105819702), X(-0.026535034),
  X( 0.011886597), X(-0.003479004), X( 0.000686646), X( 0.000015259),
  X(-0.000289917), X(-0.002899170), X(-0.003723145), X(-0.031814575),
  X(-0.056533813), X(-0.129577637), X(-0.459472656), X(-1.133926392),
  X( 0.683914185), X(-0.057617188), X( 0.100540161), X(-0.027801514),
  X( 0.010848999), X(-0.003463745), X( 0.000625610), X( 0.000015259),
  X(-0.000320435), X(-0.002990723), X(-0.004486084), X(-0.031845093),
  X(-0.061996460), X(-0.123474121), X(-0.487472534), X(-1.138763428),
  X( 0.656219482), X(-0.069595337), X( 0.095169067), X(-0.028884888),
  X( 0.009841919), X(-0.003433228), X( 0.000579834), X( 0.000015259),
  X(-0.000366211), X(-0.003082275), X(-0.005294800), X(-0.031738281),
  X(-0.067520142), X(-0.116577148), X(-0.515609741), X(-1.142211914),
  X( 0.628295898), X(-0.080688477), X( 0.089706421), X(-0.029785156),
  X( 0.008865356), X(-0.003387451), X( 0.000534058), X( 0.000015259),
  X(-0.000396729), X(-0.003173828), X(-0.006118774), X(-0.031478882),
  X(-0.073059082), X(-0.108856201), X(-0.543823242), X(-1.144287109),
  X( 0.600219727), X(-0.090927124), X( 0.084182739), X(-0.030517578),
  X( 0.007919312), X(-0.003326416), X( 0.000473022), X( 0.000015259)
};



/* hcos_64[i] = 1.0 / (2.0*cos(PI*double(i*2+1)/64.0)) */
const REAL Mpegtoraw::hcos_64[16] =
{
  X( 0.500602998235196), X( 0.505470959897544), X( 0.515447309922625), X( 0.531042591089784),
  X( 0.553103896034445), X( 0.582934968206134), X( 0.622504123035665), X( 0.674808341455006),
  X( 0.744536271002298), X( 0.839349645415527), X( 0.972568237861961), X( 1.169439933432885),
  X( 1.484164616314166), X( 2.057781009953411), X( 3.407608418468719), X(10.190008123548033)
};

/* hcos_32[i] = 1.0 / (2.0*cos(PI*double(i*2+1)/32.0)) */
const REAL Mpegtoraw::hcos_32[ 8] =
{
  X( 0.502419286188156), X( 0.522498614939689), X( 0.566944034816358), X( 0.646821783359990),
  X( 0.788154623451250), X( 1.060677685990347), X( 1.722447098238334), X( 5.101148618689155)
};

/* hcos_16[i] = 1.0 / (2.0*cos(PI*double(i*2+1)/16.0)) */
const REAL Mpegtoraw::hcos_16[ 4] =
{
  X( 0.509795579104159), X( 0.601344886935045), X( 0.899976223136416), X( 2.562915447741505)
};

/* hcos_8 [i] = 1.0 / (2.0*cos(PI*double(i*2+1)/ 8.0)) */
const REAL Mpegtoraw::hcos_8 [ 2] =
{
  X( 0.541196100146197), X( 1.306562964876376)
};

/* hcos_4 = 1.0 / (2.0*cos(PI*1.0/4.0)) */
const REAL Mpegtoraw::hcos_4 = X( 0.707106781186547);

