#ifndef BL_PARTITIONS_H_INCLUDED
#define BL_PARTITIONS_H_INCLUDED

#define BOOTLDR_PREFIX	"bootldr:"
#define BOOTLDR_PREFIX_LEN  (sizeof(BOOTLDR_PREFIX)-1)
#define BOOTLDR_SET_CMD	"set"
#define BOOTLDR_SET_LEN	(sizeof(BOOTLDR_SET_CMD)-1)

typedef struct blp_part_s
{
    dl_item_t	links;

    FlashRegion	part;
}
blp_part_t;

#define	blp_new_pe_part(p) (p) = safe_zalloc(sizeof(blp_part_t), "new_pe_part")
#define PEP_TO_DLP(itemp)		(&((itemp)->links))
#define	DLP_TO_PEP(dlp)			((blp_part_t*)dlp)
#define	PEP_ADD_TO_LIST(listp, itemp)	dl_list_add(listp, PEP_TO_DLP(itemp))
#define	PEP_DEL_FROM_LIST(listp, itemp) dl_list_del(listp, PEP_TO_DLP(itemp))
#define	BLP_PART_NAME(pep)	(pep)->part.name
#define	BLP_PART_SIZE(pep)	(pep)->part.size
#define	BLP_PART_BASE(pep)	(pep)->part.base
#define	BLP_PART_FLAGS(pep)	(pep)->part.flags

typedef struct blp_var_s
{
    dl_item_t	links;

    char*	name;
    char*	val;
}
blp_var_t;

#define	blp_new_pe_var(p)   (p) = safe_zalloc(sizeof(blp_var_t), "new_pe_var")
#define PEV_TO_DLP(itemp)		(&((itemp)->links))
#define	DLP_TO_PEV(dlp)			((blp_var_t*)dlp)
#define	PEV_ADD_TO_LIST(listp, itemp)	dl_list_add(listp, PEV_TO_DLP(itemp))
#define	PEV_DEL_FROM_LIST(listp, itemp) dl_list_del(listp, PEV_TO_DLP(itemp))

typedef struct blp_params_s
{
    dl_list_t	partition_list;
    dl_list_t	variable_list;

    /* the size of the data when we write it out. */
    size_t	part_size;
    size_t	var_size;

    unsigned long   sec_size;
    char*	    sec_buf;
    unsigned	    num_parts;
    int		    dirty;
}
blp_params_t;

#define	BLP_PARAM_ADD_PART(pp, pep)	\
    dl_list_add(&((pp)->partition_list), PEP_TO_DLP(pep))

#define	BLP_PARAM_FIRST_PART(pp, ip)    \
    DLP_TO_PEP(dl_get_first(&((pp)->partition_list), ip))

#define	BLP_PARAM_NEXT_PART(ip) DLP_TO_PEP(dl_get_next(ip))

#define	BLP_PARAM_DEL_PART(pp, ip)	\
    dl_list_del(&((pp)->partition_list), PEP_TO_DLP(ip))


#define	BLP_PARAM_ADD_VAR(pp, pev)	\
    dl_list_add(&((pp)->variable_list), PEV_TO_DLP(pev))

#define	BLP_PARAM_FIRST_VAR(pp, ip)    \
    DLP_TO_PEV(dl_get_first(&((pp)->variable_list), ip))

#define	BLP_PARAM_NEXT_VAR(ip) DLP_TO_PEV(dl_get_next(ip))

#define	BLP_PARAM_DEL_VAR(pp, ip)					\
    {									\
	if ((ip)->name) safe_free((ip)->name, "PARAM_DEL_VAR, name");	\
	if ((ip)->val) safe_free((ip)->val, "PARAM_DEL_VAR, val");	\
	dl_list_del(&((pp)->variable_list), PEP_TO_DLP(ip));		\
    }

#define	new_params(p)	    (p) = safe_zalloc(sizeof(blp_params_t))

#define	BLP_PARAMS_MK_DIRTY(p)  ((p)->dirty = 1)
#define	BLP_PARAMS_IS_DIRTY(p)  ((p)->dirty != 0)


/* protos... */
extern char*
blp_write_part_tab(
    blp_params_t*   params);

extern char*
blp_write_var(
    blp_var_t*	var,
    char*	bufp);

extern void
blp_write_vars(
    blp_params_t*   params,
    char*	    bufp);

extern void
blp_write_params(
    blp_params_t*   params,
    char*	    outfile);

extern size_t
blp_sizeof_pe_var(
    blp_var_t*	var);

extern unsigned long
blp_flags_to_num(
    char*   flags);

extern void
blp_display_var(
    blp_var_t*	var);

extern void
blp_display_part(
    blp_part_t*	part);

extern void
blp_show_vars(
    blp_params_t*   params);

extern blp_var_t*
blp_find_var_by_name(
    blp_params_t*   params,
    char*	    name);

extern void
blp_show_var(
    blp_params_t*   params,
    char*	    name);

extern blp_part_t*
blp_find_part_by_name(
    blp_params_t*   params,
    char*	    name);

extern void
blp_show_parts(
    blp_params_t*   params);

extern void
blp_show_part(
    blp_params_t*   params,
    char*	    name);

extern void
blp_show_part_or_var(
    blp_params_t*   params,
    char*	    name);

extern blp_var_t*
blp_var_define(
    blp_params_t*   params,
    char*	    name,
    char*	    val);

extern void
blp_read_params_sector(
    char*	infile,
    blp_params_t*   params);

extern void
blp_set_sector_size_s(
    blp_params_t*   params,
    char*	s);

extern unsigned long
blp_get_sector_size(
    blp_params_t*   params);

extern void
blp_parse_partition_table(
    blp_params_t*   params);

extern void
blp_parse_params(
    blp_params_t*   params);

extern void
blp_free_parts(
    blp_params_t*   params);

extern void
blp_free_vars(
    blp_params_t*   params);

extern void
blp_free_all_but_parts(
    blp_params_t*   params);

extern void
blp_free_all(
    blp_params_t*   params);

extern blp_part_t*
blp_part_define(
    blp_params_t*   params,
    char*	    name,
    unsigned long   base,
    unsigned long   size,
    enum LFR_FLAGS flags);

extern void
blp_get_partition_table(
    char*	    infile,
    blp_params_t*   params);

#endif
