#ifndef CMDPROC_H_INCLUDED
#define CMDPROC_H_INCLUDED

#define	CMD_PROC_TOK_SIZE    (256)

#define	CMDPROC_CALL_FOR_HELP	    ((char*)0x1)
#define	CMDPROC_CURRENT_CMD_CHUNK   ((void*)0x1)

/* poor man's const int */
enum
{
    CMDPROC_MATCH_SUBSTRING = 1,
    CMDPROC_MATCH_EXACT = 0
};

typedef int (*cmdproc_fn)(int, char*[], char*, void*);

typedef struct cmdproc_entry_s
{
    char*	name;
    cmdproc_fn	func;
    char*	help;
    void*	private;
}
cmdproc_entry_t;

typedef struct cmdproc_cmd_chunk_s
{
    size_t		num_cmds;
    cmdproc_entry_t*	cmd_list;
}
cmdproc_cmd_chunk_t;

extern int
cmdproc_subcommand(
    int	    argc,
    char*   argv[],
    char*   help,
    void*   chunk);

extern int
cmdproc_exec(
    int			    argc,
    char*		    argv[],
    cmdproc_cmd_chunk_t*    subs);

extern void
cmdproc_parse(
    char*   cmdline,
    int*    argcp,
    char*   argv[],
    size_t  argv_size);

extern void
cmdproc_free(
    int	    argc,
    char*   argv[]);

extern int
cmdproc_help(
    int	    argc,
    char*   argv[],
    char*   help,
    void*   chunk);

#endif
