#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

#include "dpmacs.h"
#include "eprintf.h"
#include "dl_list.h"
#include "fs-helpers.h"
#include "cmdproc.h"

char*	progname;

int
cmd_echo(
    int	    argc,
    char*   argv[],
    char*   help,
    void*   private)
{
    int	    i;

    for (i = 0; i < argc; i++) {
	printf("argv[%d]>%s<\n", i, argv[i]);
    }

    return (0);
}

int
cmd_set(
    int	    argc,
    char*   argv[],
    char*   help,
    void*   private)
{
    if (argc != 3) {
	eprintf(0, 0, "Not enough args to set\nusage: %s\n",
		help);
	return (-1);
    }
    
    printf("set %s to %s\n", argv[1], argv[2]);

    return (0);
}

int
cmd_samiam(
    int	    argc,
    char*   argv[],
    char*   help,
    void*   private)
{
    int	    i;
    
    printf("%s called \n", argv[0]);
    for (i = 1; i < argc; i++)
	printf("%s ", argv[i]);
    if (i > 1)
	printf("\n");

    return (0);
}

cmdproc_entry_t	sub3_cmd_chunk[] =
{
    {"ascii", cmd_samiam, "\n  -- show params in ascii", NULL},
    {"hex", cmd_samiam, "\n  -- show params in hex", NULL}
};

cmdproc_cmd_chunk_t cmd_params_show_cmds =
{
    DIM(sub3_cmd_chunk),
    sub3_cmd_chunk
};

cmdproc_entry_t	sub_cmd_chunk[] =
{
    {"set", cmd_samiam, "var val\n  -- set var to val", NULL},
    {"save", cmd_samiam, "[arg...]\n  -- save params", NULL},
    {"show", cmdproc_subcommand, CMDPROC_CALL_FOR_HELP,
     (void*)&cmd_params_show_cmds},
};

cmdproc_cmd_chunk_t params_cmds =
{
    DIM(sub_cmd_chunk),
    sub_cmd_chunk
};

cmdproc_entry_t	commands[] =
{
    {"echo", cmd_echo, "[arg...]\n  -- echoes arguments", NULL},
    {"set", cmd_set, "var val\n -- sets var to val", NULL},
    {"params", cmdproc_subcommand, CMDPROC_CALL_FOR_HELP, (void*)&params_cmds},
    {"t|te|test", cmd_samiam, "\n -- test command for alternatives.", NULL},
    {"?", cmdproc_help, "help", CMDPROC_CURRENT_CMD_CHUNK}
};

cmdproc_cmd_chunk_t cmd_info =
{
    DIM(commands),
    commands
};

/*
************************************************************************
*
* 
* 
************************************************************************
*/
void
ctest(
    FILE*	cmd_stream,
    int		interactive)
{
    char*   argv[100];
    int	    argc;
    char    cmdline[256];
    size_t  len;

    if (interactive)
	printf("> ");
    
    while (fgets(cmdline, sizeof(cmdline)-1, cmd_stream)) {
	len = strlen(cmdline);
	if (len && cmdline[len-1] == '\n')
	    cmdline[len-1] = '\0';
	if (cmdline[0] == '\0' || cmdline[0] == '#')
	    goto loop;
	
	cmdproc_parse(cmdline, &argc, argv, DIM(argv));
	cmdproc_exec(argc, argv, &cmd_info);
	cmdproc_free(argc, argv);

      loop:
	if (interactive)
	    printf("> ");
    }
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
main(
    int	    argc,
    char*   argv[])
{
    char*	file;
    FILE*	fp;
    
    progname = basename(argv[0]);

    /* now, process arguments */
    if (optind >= argc) {
	/* no args, process stdin */
	ctest(stdin, isatty(fileno(stdin)));
    }
	
    while (optind < argc) {
	file = argv[optind++];
	if ((fp = fopen(file, "r")) == NULL)
	    eprintf(2, 0, "Cannot open input file >%s<\n", file);
	
	ctest(fp, 0);
	
	if (fclose(fp))
	    eprintf(2, 0, "Error closing input file >%s<\n", file);
    }

    return (0);
}
