#include <stdio.h>

#include "dl_list.h"

/*
************************************************************************
*
* 
* 
************************************************************************
*/
void
dl_list_init(
    dl_list_t*	list)
{
    list->head = list->tail = NULL;
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
void    
dl_list_add(
    dl_list_t*	list,
    dl_item_t*	item)
{
    if (list->head == NULL) {
	/* empty */
	item->flink = item->blink = NULL;
	list->head = list->tail = item;
    }
    else {
	item->flink = NULL;
	item->blink = list->tail;
	item->blink->flink = item;
	list->tail = item;
    }
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
void
dl_list_del(
    dl_list_t*	list,
    dl_item_t*	item)
{
    /* fix head 'n' tail */
    if (list->head == item)
	list->head = item->flink;
    if (list->tail == item)
	list->tail = item->blink;
    if (item->flink)
	item->flink->blink = item->blink;
    if (item->blink)
	item->blink->flink = item->flink;
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
dl_item_t*
dl_get_first(
    dl_list_t*	list,
    dl_iter_t*	iter)
{
    if (!list)
	return (NULL);
    
    iter->next = list->head;

    return (iter->next);
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
dl_item_t*
dl_get_next(
    dl_iter_t*	iter)
{
    if (iter->next)
	iter->next = iter->next->flink;

    return (iter->next);
}
