#ifndef DL_LIST_H_INCLUDED
#define DL_LIST_H_INCLUDED

typedef struct dl_item_s
{
    struct dl_item_s*	flink;
    struct dl_item_s*	blink;
}
dl_item_t;

typedef struct dl_list_s
{
    dl_item_t*	head;
    dl_item_t*	tail;
}
dl_list_t;

typedef struct dl_iter_s
{
    dl_item_t*	next;
}
dl_iter_t;


extern void
dl_list_init(
    dl_list_t*	list);

extern void    
dl_list_add(
    dl_list_t*	list,
    dl_item_t*	item);

extern void
dl_list_del(
    dl_list_t*	list,
    dl_item_t*	item);

extern dl_item_t*
dl_get_first(
    dl_list_t*	list,
    dl_iter_t*	iter);

extern dl_item_t*
dl_get_next(
    dl_iter_t*	iter);

#endif
