#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "eprintf.h"		/* fancy error messages */
#include "fs-helpers.h"		/* needed for basename() */
#include "dl_list.h"

char*	progname;		/* eprintf assumes you have this defined */

/*
************************************************************************
*
* our "derived" item type.
* there should be a links field before anything else.  This makes it
*  easy for generic pointers to be converted to the more specific
*  type.  Otherwise there would need to be a
*  generic_pointer_to_specific_pointer type of function or macro.
* 
************************************************************************
*/
typedef struct item_s
{
    dl_item_t	links;

    char	str[100];
}
item_t;

/*
 * hide the dl nature of the underlying implementation.
 * Only we know we're built out of generic dl list items.
 */
#define ITEM_TO_DLP(itemp)  (&((itemp)->links))
#define	DLP_TO_ITEM(dlp)    ((item_t*)dlp)
#define	ITEM_ADD_TO_LIST(listp, itemp)	dl_list_add(listp, ITEM_TO_DLP(itemp))
#define	ITEM_DEL_FROM_LIST(listp, itemp) dl_list_del(listp, ITEM_TO_DLP(itemp))

dl_list_t   list;
dl_list_t   list2;


/*
************************************************************************
*
* find an item in the list given a string.
* 
************************************************************************
*/
item_t*
find_item(
    dl_list_t*	list,
    char*	s)
{
    dl_iter_t	iter;
    item_t*	item;
    
    for (item = (item_t*)dl_get_first(list, &iter);
	 item;
	 item = (item_t*)dl_get_next(&iter)) {
	if (strcmp(s, item->str) == 0)
	    return(item);
    }
    
    eprintf(0, 0, "Canna find >%s<\n", s);
    
    return (NULL);
    
}


/*
************************************************************************
*
* add an item to the list.
* 
************************************************************************
*/
void
add_item(
    dl_list_t*	listp,
    char*	s)
{
    item_t* item;

    if ((item = (item_t*)malloc(sizeof(*item))) == NULL)
	eprintf(2, 0, "out o' mem.\n");

    memset((char*)item, 0x00, sizeof(*item));

    strcpy(item->str, s);

    ITEM_ADD_TO_LIST(listp, item);
}


/*
************************************************************************
*
* Dump the list.  Uses iterator.
* 
************************************************************************
*/
void
dumplist(
    dl_list_t*	list)
{
    item_t*	item;
    dl_iter_t	iter;
    
    for (item = DLP_TO_ITEM(dl_get_first(list, &iter));
	 item;
	 item = DLP_TO_ITEM(dl_get_next(&iter))) {
	printf("item->str>%s<\n", item->str);
    }
}


/*
************************************************************************
*
* main.
* add all args to a list.
* for each list item (arg) that begins with a ``/'', delete it
*  from the list.
* Simply exercises list creation, addition and deletion.
* 
************************************************************************
*/
int
main(
    int	    argc,
    char*   argv[])
{
    int		i;
    dl_iter_t	iter;
    item_t*	item;
    

    progname = basename(argv[0]);
    
    dl_list_init(&list);
    dl_list_init(&list2);

    for (i = 1; i < argc; i++) {
	add_item(&list, argv[i]);
	if (argv[i][0] == '/')
	    add_item(&list2, argv[i]);
    }

    dumplist(&list);
    
    /* now, delete all elements in list2 from list */
    
    for (item = (item_t*)dl_get_first(&list2, &iter);
	 item;
	 item = (item_t*)dl_get_next(&iter)) {
	
	item_t*	delitem;

	printf("deleting>%s<\n", item->str);
	delitem = find_item(&list, item->str);
	if (delitem)
	    ITEM_DEL_FROM_LIST(&list, delitem);
	else
	    eprintf(0, 0, "canna del NULL item for >%s<\n", item->str);
    }

    printf("after\n");
    dumplist(&list);
    
    return (0);
}
